/* SPDX-License-Identifier: GPL-2.0-only
 *
 * Copyright 2024 Utimaco IS GmbH
 * All Rights Reserved.
 *
 */
#ifndef __GDMA_H__
#define __GDMA_H__

#define GDMA_MAX_CHANNELS             32

#define GDMA_DESC_SIZE                16
#define GDMA_QUEUE_SIZE               64
#define GDMA_QUEUE_OFFSET             (GDMA_QUEUE_SIZE * GDMA_DESC_SIZE)

#define GDMA_SRC_Q_BASE               0
#define GDMA_SRC_Q_ADDR(idx)          (GDMA_SRC_Q_BASE + ((idx) << 4))  // * 16

#define GDMA_DST_Q_BASE               GDMA_QUEUE_OFFSET
#define GDMA_DST_Q_ADDR(idx)          (GDMA_DST_Q_BASE + ((idx) << 4))

#define GDMA_REG_BASE                 (2 * GDMA_QUEUE_OFFSET)   // 0x800

// Index_ptr
#define GDMA_SRC_Q_RD_IDX             (GDMA_REG_BASE     )
#define GDMA_SRC_Q_WR_IDX             (GDMA_REG_BASE + 1 )
#define GDMA_DST_Q_RD_IDX             (GDMA_REG_BASE + 2 )
#define GDMA_DST_Q_WR_IDX             (GDMA_REG_BASE + 3 )

// Irq
#define GDMA_IRQ_MASK                 (GDMA_REG_BASE + 8 )
#define GDMA_IRQ_ENABLE               (GDMA_REG_BASE + 9 )
#define GDMA_IRQ_STATUS               (GDMA_REG_BASE + 10)
#define GDMA_IRQ_TEST                 (GDMA_REG_BASE + 11)

#define GDMA_IRQ_DMA_TX               1
#define GDMA_IRQ_DMA_RX               2
#define GDMA_IRQ_MAILBOX              4

// Control
#define GDMA_CONTROL                  (GDMA_REG_BASE + 12)

#define GDMA_CONTROL_CHNL_RESET       1
#define GDMA_CONTROL_LOOPBACK         2
#define GDMA_CONTROL_SRIO_DISABLE     4       // host only
#define GDMA_CONTROL_BLOCK_RESET      0x100
#define GDMA_CONTROL_CPU_RESET        0x10000 // host only

// gmtime
#define GDMA_TIMESTAMP                (GDMA_REG_BASE + 16)

// version
#define GDMA_VERSION                  (GDMA_REG_BASE + 20)

// Mailbox
#define GDMA_MAILBOX_IN               (GDMA_REG_BASE + 24)
#define GDMA_MAILBOX_OUT              (GDMA_REG_BASE + 28)

//
#ifdef CSAR8_DEVICE
//
//#define GDMA_IRQ_QUEUE              (GDMA_REG_BASE + 32)  // removed

  // Echeck
  #define GDMA_ECHECK                 (GDMA_REG_BASE + 40)

  #define GDMA_ECHECK_LBPC_MASK       0x0000000F
  #define GDMA_ECHECK_LBPC_SHIFT      0
  #define GDMA_ECHECK_LTSM_MASK       0x00003F00
  #define GDMA_ECHECK_LTSM_SHIFT      8

  // Debug
  #define GDMA_DEBUG                  (GDMA_REG_BASE + 44)
#else
  // version
  #define GDMA_FPGA_VERSION           (GDMA_REG_BASE + 32)
  #define GDMA_HW_VERSION             (GDMA_REG_BASE + 36)

  // Debug
  #define GDMA_DEBUG                  (GDMA_REG_BASE + 40)

  // Error_counter
  #define GDMA_ERROR_COUNT            (GDMA_REG_BASE + 44)

  #define GDMA_ERROR_BITE_MASK        0x0000FFFF
  #define GDMA_ERROR_BITE_SHIFT       0
  #define GDMA_ERROR_DISP_MASK        0xFFFF0000
  #define GDMA_ERROR_DISP_SHIFT       16
#endif

// irq_queue (new)
#define GDMA_IRQ_QUEUE_SRC            (GDMA_REG_BASE + 48)
#define GDMA_IRQ_QUEUE_DST            (GDMA_REG_BASE + 56)
#define GDMA_IRQ_QUEUE_MAILBOX        (GDMA_REG_BASE + 64)

#define GDMA_IRQ_CHNU_MASK            0x0000001F
#define GDMA_IRQ_CHNU_SHIFT           0
#define GDMA_IRQ_IRNU_MASK            0x00000300
#define GDMA_IRQ_IRNU_SHIFT           8
#define GDMA_IRQ_QLEL_MASK            0x00FF0000
#define GDMA_IRQ_QLEL_SHIFT           16

//
#ifndef CSAR8_DEVICE
//
  // Core_Control (moved as of 7.3.2)
  #define GDMA_CORE_CONTROL           (GDMA_REG_BASE + 72)

  #define GDMA_CTL_MAXREAD_128_MASK   0x000F
  #define GDMA_CTL_MAXREAD_128_SHIFT  0
  #define GDMA_CTL_MAXREAD_256_MASK   0x00F0
  #define GDMA_CTL_MAXREAD_256_SHIFT  4
  #define GDMA_CTL_MAXREAD_512_MASK   0x0F00
  #define GDMA_CTL_MAXREAD_512_SHIFT  8
  #define GDMA_CTL_MAXREAD_1024_MASK  0xF000
  #define GDMA_CTL_MAXREAD_1024_SHIFT 12
  #define GDMA_CTL_ALWAYS_IRQ         0x10000

//#define GDMA_MSIX_VECTOR_TAB        (GDMA_REG_BASE + 0x280) // ???
#endif

// serial nummber
#define GDMA_SSN_LOW                  (GDMA_REG_BASE + 80)
#define GDMA_SSN_HIGH                 (GDMA_REG_BASE + 84)


// MSI-X Vector Table
#define GDMA_MSIX_IRQ_ADDR_SRC_LOW    (GDMA_REG_BASE + 0x80)
#define GDMA_MSIX_IRQ_ADDR_SRC_HIGH   (GDMA_REG_BASE + 0x84)
#define GDMA_MSIX_IRQ_DATA_SRC        (GDMA_REG_BASE + 0x88)
#define GDMA_MSIX_IRQ_MASK_SRC        (GDMA_REG_BASE + 0x8C)

#define GDMA_MSIX_IRQ_ADDR_DST_LOW    (GDMA_REG_BASE + 0x90)
#define GDMA_MSIX_IRQ_ADDR_DST_HIGH   (GDMA_REG_BASE + 0x94)
#define GDMA_MSIX_IRQ_DATA_DST        (GDMA_REG_BASE + 0x98)
#define GDMA_MSIX_IRQ_MASK_DST        (GDMA_REG_BASE + 0x9C)


#define GDMA_MSIX_IRQ_ADDR_MAIL_LOW   (GDMA_REG_BASE + 0xA0)
#define GDMA_MSIX_IRQ_ADDR_MAIL_HIGH  (GDMA_REG_BASE + 0xA4)
#define GDMA_MSIX_IRQ_DATA_MAIL       (GDMA_REG_BASE + 0xA8)
#define GDMA_MSIX_IRQ_MASK_MAIL       (GDMA_REG_BASE + 0xAC)



union packet_info_t
{
  // TODO: endianess
  struct
  {
    union
    {
      struct
      {
        u8  seq_cnt : 7;
        u8  last    : 1;
        u8  msg_idx;
        u8  addr;
        u8  rfu;
      };

      u32   user;
    };

    u16 wlen;
    u16 pid;
  };

  u64 value;
}
#ifndef _WIN64
__attribute__((__packed__))
#endif
;

struct q_desc_t
{
  u64                 phys_addr;
  union packet_info_t info;
}
#ifndef _WIN64
__attribute__((__packed__))
#endif
;

#endif
