
@echo off
IF NOT DEFINED SDK_PORT ( 
  set SDK_PORT=3001
)
set SDK_START_PORT=%SDK_PORT%

set SDK_BIN_PATH=%~dp0
set SDK_INSTANCE_PATH=%TEMP%\sim_instances

for /l %%n in (1, 1, %~1) do (
  mkdir "%SDK_INSTANCE_PATH%\%%n\bin" 2> NUL
  copy "%SDK_BIN_PATH%\bl_sim?.exe" /B "%SDK_INSTANCE_PATH%\%%n\bin\bl_sim_instance.exe" > NUL
  copy "%SDK_BIN_PATH%\cs_sim.ini" "%SDK_INSTANCE_PATH%\%%n\bin" > NUL
  copy "%SDK_BIN_PATH%\*.dll" /B "%SDK_INSTANCE_PATH%\%%n\bin" > NUL 2> NUL

  mkdir "%SDK_INSTANCE_PATH%\%%n\devices\SDRAM" 2> NUL
  @rem copy  /V "%SDK_BIN_PATH%\..\devices\*" /B "%SDK_INSTANCE_PATH%\%%n\devices" > NUL
  copy /V "%ProgramData%\Utimaco\Simulator\devices\*" "%SDK_INSTANCE_PATH%\%%n\devices" > NUL

  start %SDK_INSTANCE_PATH%\%%n\bin\bl_sim_instance.exe -h -o -d "%SDK_INSTANCE_PATH%\%%n\devices"

  set /a SDK_PORT=SDK_PORT+2
)


if %SDK_START_PORT%==%SDK_PORT% (
 echo.
 echo USAGE: %~n0 NumberOfInstances
 echo.
 echo Launches multiple independent temporary copies of the simulator at once
 EXIT /B 1
)

IF 3001==%SDK_START_PORT% (
  set SDK_PORT=
) ELSE (
  set SDK_PORT=%SDK_START_PORT%
)
set SDK_START_PORT=

echo.
echo %~n0: %~1 instances started
echo.
echo Press any key to terminate and remove all instances or CTRL-C to leave them running
echo.

pause

taskkill /F /IM bl_sim_instance.exe

timeout /T 1 /NOBREAK > NUL

rmdir /S /Q %SDK_INSTANCE_PATH%

set SDK_INSTANCE_PATH=
set SDK_BIN_PATH=

