package defaults;

import CryptoServerJCE.*;
import CryptoServerAPI.*;
import javax.crypto.*;
import javax.crypto.spec.*;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.*;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

/**
 * This program demonstrates the usage of the Utimaco's JCE Provider 
 * for the CryptoServer Hardware Security Module.
 * 
 * Test AES encryption / decryption with all keysizes and modes
 */
public class crypt_AES
{   


	public static void crypt_AES_CS_vs_CS(String[] args) throws Exception {
		System.out.println("\n--- Utimaco CryptoServer JCE - crypt_AES_cs_vs_cs ---\n");
		int sizes[] = { 128, 192, 256 };

		Algorithm modes[] = { 
				new Algorithm("AES/ECB/NOPADDING", null, null),
				new Algorithm("AES/ECB/PKCS5Padding", null, null),
				new Algorithm("AES/CBC/NOPADDING", new IvParameterSpec(getRandom(16)), null),
				new Algorithm("AES/CBC/PKCS5PADDING", new IvParameterSpec(getRandom(16)), null),
				new Algorithm("AES/ECB/ISO10126Padding", null, null),
				new Algorithm("AES/CBC/ISO10126PADDING", new IvParameterSpec(getRandom(16)), null),
				new Algorithm("AES/OFB/NOPADDING", new IvParameterSpec(getRandom(16)), null),
				new Algorithm("AES/OFB/PKCS5Padding", new IvParameterSpec(getRandom(16)), null),
				new Algorithm("AES/OFB/ISO10126PADDING", new IvParameterSpec(getRandom(16)), null),
				new Algorithm("AES/OFB128/NOPADDING", new IvParameterSpec(getRandom(16)), null),
				new Algorithm("AES/OFB128/PKCS5Padding", new IvParameterSpec(getRandom(16)), null),
				new Algorithm("AES/OFB128/ISO10126PADDING", new IvParameterSpec(getRandom(16)), null),
				new Algorithm("AES/GCM/NOPADDING", new GCMParameterSpec(64, getRandom(16)), null),
				new Algorithm("AES/GCM/NOPADDING", new CryptoServerGCMParameterSpec(64, getRandom(16), getRandom(16)), null),
				new Algorithm("AES/CCM/NOPADDING", null, null), // parameters needs total data length, calculated in test
		};

		CryptoServerProvider provider = null;

		try {
			// load provider
			provider = args.length > 0 ? new CryptoServerProvider( args[0]) : 
				new CryptoServerProvider(crypt_AES.class.getResourceAsStream("/CryptoServer.cfg"));
			
			// authenticate
			provider.loginPassword("JCE", "12345678");

			for (int keysize : sizes) {
				System.out.println("keysize: " + keysize);

				// Generate AES aesKey
				CryptoServerKeyGenParameterSpec aesParam = new CryptoServerKeyGenParameterSpec(keysize);
				aesParam.setPlainExportable(true);

				KeyGenerator kg = KeyGenerator.getInstance("AES", provider);
				kg.init(aesParam, null);
				SecretKey aesKey = kg.generateKey();

				// for all modes
				for (Algorithm mode : modes) {
					String algo = mode.algo;
					System.out.println("algo: " + algo);

					Cipher c = Cipher.getInstance(algo, provider);

					for (int len1 = 0; len1 < 1000; len1 += 177) {
						for (int len2 = 1; len2 < 30; len2 += 3) {
							for (int len3 = 0; len3 < 200; len3 += 19) {
								if (algo.indexOf("/OFB") < 0 && algo.indexOf("/GCM") < 0 && algo.indexOf("/CCM") < 0
										&& algo.indexOf("NOPADDING") >= 0) {
									int len = len1 + len2 + len3;
									if ((len = len % 16) != 0) {
										len2 += 16 - len; // add to 2nd block to ensure that 3rd can be empty!
									}
								}

								byte[] data1 = getRandom(len1);
								byte[] data2 = getRandom(len2);
								byte[] data3 = getRandom(len3);

								if (algo.indexOf("/CCM") > 0)
									mode.param = new CryptoServerCCMParameterSpec(getRandom(8), getRandom(16),
											len1 + len2 + len3, 8);

								// encrypt with CryptoServer
								if (mode.param == null)
									c.init(Cipher.ENCRYPT_MODE, aesKey);
								else
									c.init(Cipher.ENCRYPT_MODE, aesKey, mode.param);

								byte[] crypto = null;

								if (len1 != 0)
									crypto = cat(crypto, c.update(data1));
								if (len2 != 0)
									crypto = cat(crypto, c.update(data2));
								if (len3 != 0)
									crypto = cat(crypto, c.doFinal(data3));
								else
									crypto = cat(crypto, c.doFinal());

								// decrypt with CryptoServer
								if (mode.param == null)
									c.init(Cipher.DECRYPT_MODE, aesKey);
								else
									c.init(Cipher.DECRYPT_MODE, aesKey, mode.param);

								byte[] plain = null;
								len2 = crypto.length - len1 - len3;

								if (len1 != 0)
									plain = cat(plain, c.update(crypto, 0, len1));
								if (len2 != 0)
									plain = cat(plain, c.update(crypto, len1, len2));
								if (len3 != 0)
									plain = cat(plain, c.doFinal(crypto, len1 + len2, len3));
								else
									plain = cat(plain, c.doFinal());

								// compare data
								byte[] data = cat(cat(data1, data2), data3);

								if (!Arrays.equals(data, plain)) {
									System.out.println("Keysize=" + keysize + ", mode=" + mode.algo + ", len=" + len1
											+ "-" + len2 + "-" + len3);

									throw new Exception("En-/Decryption failed");
								}

							}
						}
					}
				}
			}

			System.out.println("NO ERRORS!!!!");
		} catch (Exception ex) {
			throw ex;
		} finally {
			// logoff
			if (provider != null)
			{
		    	  provider.close();
		    }
		}

		System.out.println("Done");
	}

	public static void crypt_AES_CS_vs_BOUNCY(String[] args) throws Exception {
		System.out.println("\n--- Utimaco CryptoServer JCE - crypt_AES_CS_vs_BOUNCY ---\n");
		if (Security.getProvider("BC") == null)
			Security.addProvider(new BouncyCastleProvider());

		String PROV_CIPHER = "BC";

		byte[] iv = getRandom(16);
		byte[] nonce_ccm = getRandom(8);
		byte[] aad = getRandom(16);
		Algorithm modes[] = { 
				new Algorithm("AES/ECB/NOPADDING", null, null),
				new Algorithm("AES/ECB/PKCS5Padding", null, null),
				new Algorithm("AES/CBC/NOPADDING", new IvParameterSpec(iv), new IvParameterSpec(iv)),
				new Algorithm("AES/CBC/PKCS5PADDING", new IvParameterSpec(iv), new IvParameterSpec(iv)),
				new Algorithm("AES/ECB/ISO10126Padding", null, null),
				new Algorithm("AES/CBC/ISO10126PADDING", new IvParameterSpec(iv), new IvParameterSpec(iv)),
				new Algorithm("AES/OFB/NOPADDING", new IvParameterSpec(iv), new IvParameterSpec(iv)),
				new Algorithm("AES/OFB/PKCS5Padding", new IvParameterSpec(iv), new IvParameterSpec(iv)),
				new Algorithm("AES/OFB/ISO10126PADDING", new IvParameterSpec(iv), new IvParameterSpec(iv)),
				new Algorithm("AES/OFB128/NOPADDING", new IvParameterSpec(iv), new IvParameterSpec(iv)),
				new Algorithm("AES/OFB128/PKCS5Padding", new IvParameterSpec(iv), new IvParameterSpec(iv)),
				new Algorithm("AES/OFB128/ISO10126PADDING", new IvParameterSpec(iv), new IvParameterSpec(iv)),
				new Algorithm("AES/GCM/NOPADDING", new GCMParameterSpec(64, iv), new GCMParameterSpec(64, iv)),
				new Algorithm("AES/GCM/NOPADDING", new CryptoServerGCMParameterSpec(64, iv, aad), new GCMParameterSpec(64, iv)),
				new Algorithm("AES/CCM/NOPADDING", null, new GCMParameterSpec(64, nonce_ccm)), // parameters needs total
																								// data length,
																								// calculated in test
		};

		CryptoServerProvider provider = null;

		try {
			// load provider
			provider = args.length > 0 ? new CryptoServerProvider( args[0]) : 
				new CryptoServerProvider(crypt_AES.class.getResourceAsStream("/CryptoServer.cfg"));

			// authenticate
			provider.loginPassword("JCE", "12345678");

			int[] sizes = {192, 256};
			
			for (int i = 0; i < sizes.length; i++) {
				int keysize = sizes[i];
				
				KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", PROV_CIPHER);
				keyGenerator.init(keysize);
				SecretKey bouncyKey = keyGenerator.generateKey();

				SecretKeySpec jceKey = new SecretKeySpec(bouncyKey.getEncoded(), "AES");

				System.out.println("keysize: " + keysize);

				// for all modes
				for (Algorithm mode : modes) {
					String algo = mode.algo;
					System.out.println("algo: " + algo);

					Cipher c = Cipher.getInstance(algo, provider);
					Cipher c2 = Cipher.getInstance(algo, PROV_CIPHER);

					for (int len1 = 0; len1 < 1000; len1 += 177) {
						for (int len2 = 0; len2 < 30; len2 += 3) {
							for (int len3 = 1; len3 < 200; len3 += 19) {
								if (algo.indexOf("/OFB") < 0 && algo.indexOf("/GCM") < 0 && algo.indexOf("/CCM") < 0
										&& algo.indexOf("NOPADDING") >= 0) {
									int len = len1 + len2 + len3;
									if ((len = len % 16) != 0) {
										len2 += 16 - len; // add to 2nd block to ensure that 3rd can be empty!
									}
								}

								byte[] data1 = getRandom(len1);
								byte[] data2 = getRandom(len2);
								byte[] data3 = getRandom(len3);

								if (algo.indexOf("/CCM") > 0)
									mode.param = new CryptoServerCCMParameterSpec(nonce_ccm, aad, len1 + len2 + len3, 8);

								// encrypt with CryptoServer
								if (mode.param == null)
									c.init(Cipher.ENCRYPT_MODE, jceKey);
								else
									c.init(Cipher.ENCRYPT_MODE, jceKey, mode.param);
								
								if (algo.indexOf("/GCM/") > 0 && mode.param instanceof GCMParameterSpec)
									c.updateAAD(aad);

								byte[] crypto = null;

								if (len1 != 0)
									crypto = cat(crypto, c.update(data1));
								if (len2 != 0)
									crypto = cat(crypto, c.update(data2));
								if (len3 != 0)
									crypto = cat(crypto, c.doFinal(data3));
								else
									crypto = cat(crypto, c.doFinal());
								
								
								// decrypt with Bouncy
								if (mode.paramBC == null)
									c2.init(Cipher.DECRYPT_MODE, bouncyKey);
								else
									c2.init(Cipher.DECRYPT_MODE, bouncyKey, mode.paramBC);

								if (algo.indexOf("/GCM/") > 0 || algo.indexOf("/CCM/") > 0)
									c2.updateAAD(aad);

								byte[] plain = c2.doFinal(crypto);

								// compare data
								byte[] data = cat(cat(data1, data2), data3);

								if (!Arrays.equals(data, plain)) {
									CryptoServerUtil.xtrace(plain);
									CryptoServerUtil.xtrace(data);
									System.out.println("Keysize=" + keysize + ", mode=" + mode.algo + ", len=" + len1 + "-"
											+ len2 + "-" + len3);

									throw new Exception("En-/Decryption failed");
								}
								
								c2 = Cipher.getInstance(algo, PROV_CIPHER);

								// encrypt with Bouncy
								if (mode.paramBC == null)
									c2.init(Cipher.ENCRYPT_MODE, bouncyKey);
								else
									c2.init(Cipher.ENCRYPT_MODE, bouncyKey, mode.paramBC);

								if (algo.indexOf("/GCM/") > 0 || algo.indexOf("/CCM/") > 0)
									c2.updateAAD(aad);

								crypto = c2.doFinal(plain);

								// decrypt with CryptoServer
								if (mode.param == null)
									c.init(Cipher.DECRYPT_MODE, jceKey);
								else
									c.init(Cipher.DECRYPT_MODE, jceKey, mode.param);
								
								if (algo.indexOf("/GCM/") > 0 && mode.param instanceof GCMParameterSpec)
									c.updateAAD(aad);

								plain = null;
								len3 = crypto.length - len1 - len2;

								if (len1 != 0)
									plain = cat(plain, c.update(crypto, 0, len1));
								if (len2 != 0)
									plain = cat(plain, c.update(crypto, len1, len2));
								if (len3 != 0)
									plain = cat(plain, c.doFinal(crypto, len1 + len2, len3));
								else
									plain = cat(plain, c.doFinal());

								// compare data
								data = cat(cat(data1, data2), data3);

								if (!Arrays.equals(data, plain)) {
									CryptoServerUtil.xtrace(plain);
									CryptoServerUtil.xtrace(data);
									System.out.println("Keysize=" + keysize + ", mode=" + mode.algo + ", len=" + len1 + "-"
											+ len2 + "-" + len3);

									throw new Exception("En-/Decryption failed");
								}
							}
						}
					}
				}
			}
			System.out.println("NO ERRORS!!!!");
		} catch (Exception ex) {
			throw ex;
		} finally {
			// logoff
			if (provider != null)
			{
				provider.close();
			}
		}

		System.out.println("Done");
	}

	public static void main(String[] args) throws Exception {
		crypt_AES_CS_vs_CS(args);
		System.out.println("###########################################################################");
		System.out.println("###########################################################################");
		crypt_AES_CS_vs_BOUNCY(args);
	}

	private static class Algorithm {
		String algo;
		AlgorithmParameterSpec param;
		AlgorithmParameterSpec paramBC;

		public Algorithm(String algo, AlgorithmParameterSpec param, AlgorithmParameterSpec paramBC) {
			this.algo = algo;
			this.param = param;
			this.paramBC = paramBC;
		}
	}

	private static byte[] getRandom(int length) {
		try {
			if (length == 0)
				return null;

			byte[] buf = new byte[length];
			SecureRandom rng = SecureRandom.getInstance("SHA1PRNG");
			rng.nextBytes(buf);
			return buf;
		} catch (Exception ex) {
			return null;
		}
	}

	private static byte[] cat(byte[] a, byte[] b) {
		if (a == null)
			return (b);
		if (b == null)
			return (a);

		byte[] res = new byte[a.length + b.length];
		System.arraycopy(a, 0, res, 0, a.length);
		System.arraycopy(b, 0, res, a.length, b.length);

		return (res);
	}

	public static byte[] hexStringToByteArray(String s) {
		int len = s.length();
		byte[] data = new byte[len / 2];
		for (int i = 0; i < len; i += 2) {
			data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
		}
		return data;
	}

	private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

	public static String bytesToHexString(byte[] bytes) {
		char[] hexChars = new char[bytes.length * 2];
		for (int j = 0; j < bytes.length; j++) {
			int v = bytes[j] & 0xFF;
			hexChars[j * 2] = HEX_ARRAY[v >>> 4];
			hexChars[j * 2 + 1] = HEX_ARRAY[v & 0x0F];
		}
		return new String(hexChars);
	}
	
}
