#ifndef __LOG_H__
#define __LOG_H__

#if defined __KERNEL__
  // Linux kernel
  #include <linux/module.h>
  #define log_print  printk

#elif defined AMD64
  // Windows Kernel
  #include <wdm.h>
  #define log_print  DbgPrint

#else
  // Linux/Windows Userspace
  #include <stdio.h>
  #define log_print  printf  
#endif

#define LOG_LEVEL_NONE      0
#define LOG_LEVEL_ERROR     1
#define LOG_LEVEL_WARNING   2
#define LOG_LEVEL_INFO      3
#define LOG_LEVEL_TRACE     4
#define LOG_LEVEL_XTRACE    5
#define LOG_LEVEL_DEBUG     6

extern unsigned int LogLevel;
extern void log_xprint(const char *txt, int ofs, const void *data, int len);

#define log_error(format,...)     { if (LogLevel >= 1) log_print("!%s: " format, __func__, ##__VA_ARGS__); }
#define log_warning(format,...)   { if (LogLevel >= 2) log_print("!%s: " format, __func__, ##__VA_ARGS__); }
#define log_info(format,...)      { if (LogLevel >= 3) log_print(":%s: " format, __func__, ##__VA_ARGS__); }
#define log_trace(format,...)     { if (LogLevel >= 4) log_print("~%s: " format, __func__, ##__VA_ARGS__); }
#ifdef DEBUG
#define log_debug(format,...)     { if (LogLevel >= 6) log_print("~%s: " format, __func__, ##__VA_ARGS__); }
#else
#define log_debug(format,...)
#endif

#define log_xerror(t,b,l)         { if (LogLevel >= 1) log_xprint((t),0,(b),(l)); }
#define log_xwarning(t,b,l)       { if (LogLevel >= 2) log_xprint((t),0,(b),(l)); }
#define log_xinfo(t,b,l)          { if (LogLevel >= 3) log_xprint((t),0,(b),(l)); }
#define log_xtrace(t,b,l)         { if (LogLevel >= 5) log_xprint((t),0,(b),(l)); }
#ifdef DEBUG
#define log_xdebug(t,b,l)         { if (LogLevel >= 6) log_xprint((t),0,(b),(l)); }
#else
#define log_xdebug(t,b,l)
#endif

#endif
