#include "log.h"

unsigned int LogLevel = LOG_LEVEL_INFO;

void log_xprint(const char *txt, int ofs, const void *data, int len)
{
  static char hex[]="0123456789abcdef";

  int   a;
  char  *x;
  char  *dt = (char *)data;
  char  buff1[40];
  char  buff2[20];

  if (txt != NULL)
  {
    if (*txt == '%')
      log_print("%s[%d]\n", txt+1, len);
    else
      log_print("%s\n", txt);
  }

  while (len > 0)
  {
    for(a=0, x=buff1; a<16 && a<len; a++)
    {
      *x++ = hex[(dt[a]>>4)&15];
      *x++ = hex[dt[a]&15];

      if ((a&3) == 3) *x++ = ' ';
    }
    *x=0;

    for(a=0, x=buff2; a<16 && a<len; a++)
    {
      *x++ = (dt[a]>' ' && dt[a]<0x7f) ? dt[a] : ' ';
    }
    *x=0;

    log_print("%4x | %-36s|%-16s|\n", ofs, buff1, buff2);

    len -= 16;
    ofs += 16;
    dt += 16;
  }
}
