/* SPDX-License-Identifier: GPL-2.0-only
 *
 * Copyright 2024 Utimaco IS GmbH
 * All Rights Reserved.
 *
 */

// control codes
#define CS2IOC_MAGIC        0x6b

#define CS2IOC_HRESET       0x6b01                // hardware reset
#define CS2IOC_GETREQ       0x6b02                // get request length
#define CS2IOC_SETTMOUT     0x6b03                // set timeout
#define CS2IOC_GETTMOUT     0x6b04                // get timeout
#define CS2IOC_CANCEL       0x6b05                // cancel request
#define CS2IOC_WAIT_RDY     0x6b06                // wait for CS2 ready
#define CS2IOC_SHUTDOWN     0x6b07                // shutdown CS2
#define CS2IOC_LOCK_WAIT    0x6b08                // wait for cs2 access and lock
#define CS2IOC_UNLOCK       0x6b09                // unlock cs2 access
#define CS2IOC_GETINFO      0x6b0a                // get info about cs2
#define CS2IOC_GETHWTYPE    0x6b0b                // get hardware type
// new as of 5.17.0
#define CS2IOC_GET_VERSION  0x6b0c                // get driver version

struct cs2_getreq
{
  int           timeout;
  unsigned int  req_size;
  int           req_id;
};

struct cs2_waitrdy
{
  int           timeout;
  unsigned int  state;
};

// new as of version 4.0.0
struct cs2_info
{
  unsigned int  count;        // actual byte count
  char          buf[2048];    // user buffer
};

// macros for state checking
#define CS2_BL_STATE(state)     ((state) & 0xE000)

#define CS2_ST_OLD_BL           0x0000
#define CS2_ST_BL_TEMP          0x2000
#define CS2_ST_BL_RDY           0x4000
#define CS2_ST_CMDS_RDY         0x8000

#define CS2_IS_PANIC(state)     (((state) & 0xFF00) == 0x5000)

#define MODEL_CS2               1
#define MODEL_CS3               2
#define MODEL_NQ3               3
#define MODEL_CS4               4
#define MODEL_CS5               5

// error codes
#define ECS2TOOMANY             0x700    // Too many cs2 devices found
#define ECS2TIMEOUT             0x701    // no response from Cryptoserver
#define ECS2BADLEN              0x702    // bad length
#define ECS2NACK                0x703    // command rejected by CS2
#define ECS2NOREQ               0x704    // no request pending
#define ECS2STATE               0x705    // unknown state
#define ECS2RESET               0x706    // interrupted by reset
#define ECS2TEMPALARM           0x707    // hight temperature
#define ECS2TXCRC               0x708    // transmit CRC error
#define ECS2RXCRC               0x709    // receive CRC error
#define ECS2DOWN                0x70A    // CS2 is down
#define ECS2PANIC               0x70B    // CS2 issued panic message
#define ECS2NOCRC               0x70C    // no CRC in CS answer
#define ECS2BADPLEN             0x70D    // bad packet length
#define ECS2BADSEQ              0x70E    // bad sequence number
#define ECS2BUFSIZE             0x70F    // buffer size too small
#define ECS2PCITX               0x710    // PCI error while transmit
#define ECS2PCIRX               0x720    // PCI error while receive
#define ECS2NORST               0x730    // reset failed

