/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerCXI;

import CryptoServerAPI.CryptoServerCluster;
import CryptoServerAPI.CryptoServerConfig;
import CryptoServerAPI.CryptoServerDatabase;
import CryptoServerAPI.CryptoServerException;
import CryptoServerAPI.CryptoServerLog;
import CryptoServerAPI.CryptoServerUtil;
import CryptoServerCXI.AsnBuffer;
import CryptoServerCXI.Item;
import CryptoServerCXI.Version;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoServerCXI
extends CryptoServerCluster {
    public static final String CXI_DATE = "2018/02/13";
    public static final String CXI_NAME = "CXI Interface for Utimaco CryptoServer";
    public static final double CXI_VERSION = Version.getVersionDouble();
    public static final int KEY_ALGO_RAW = 0;
    public static final int KEY_ALGO_DES = 1;
    public static final int KEY_ALGO_AES = 2;
    public static final int KEY_ALGO_RSA = 3;
    public static final int KEY_ALGO_ECDSA = 4;
    public static final int KEY_ALGO_DSA = 5;
    public static final int KEY_ALGO_ECDH = 6;
    public static final int KEY_ALGO_DH = 7;
    public static final int KEY_ALGO_DH_PKCS = 8;
    public static final int KEY_ALGO_X509 = 9;
    public static final int KEY_ALGO_X509_ATT = 10;
    public static final int KEY_EXPORT_ALLOW = 1;
    public static final int KEY_EXPORT_ALLOW_PLAIN = 2;
    public static final int KEY_EXPORT_DENY_BACKUP = 65536;
    public static final int KEY_USAGE_DECRYPT = 1;
    public static final int KEY_USAGE_SIGN = 2;
    public static final int KEY_USAGE_DERIVE = 4;
    public static final int KEY_USAGE_WRAP = 8;
    public static final int KEY_USAGE_ENCRYPT = 16;
    public static final int KEY_USAGE_VERIFY = 32;
    public static final int KEY_USAGE_UNWRAP = 128;
    public static final int KEY_USAGE_KEY_WRAP = 8;
    public static final int KEY_USAGE_AGREEMENT = 4;
    public static final int KEY_FIPS_USAGE_NO_SIGN = 0;
    public static final int KEY_FIPS_USAGE_RSA_PKCS = 1;
    public static final int KEY_FIPS_USAGE_RSA_PSS = 2;
    public static final int KEY_FIPS_USAGE_RSA_X_31 = 3;
    public static final int KEY_FIPS_USAGE_OTHER = -1;
    public static final int KEY_TYPE_PUBLIC = 1;
    public static final int KEY_TYPE_PRIVATE_ONLY = 2;
    public static final int KEY_TYPE_PRIVATE = 3;
    public static final int KEY_TYPE_PRIVATEF = 7;
    public static final int KEY_TYPE_SECRET = 8;
    public static final int KEY_TYPE_DATA = 32;
    public static final int KEY_TYPE_CERT = 33;
    public static final int KEY_TYPE_DOMAIN_PARAMETER = 34;
    public static final int KEY_TYPE_CONFIG = 48;
    public static final int KEY_TYPE_MASK = 255;
    public static final int KEY_BLOB_SIMPLE = 65536;
    public static final int KEY_BLOB_MS_BCRYPT = 131072;
    public static final int KEY_BLOB_MS_LEGACY = 196608;
    public static final int KEY_BLOB_MASK = 0xFF0000;
    public static final int MECH_KDF_ENC_DATA = 0x40000000;
    public static final int MECH_KDF_ECDH = 0x50000000;
    public static final int MECH_KDF_ECDH_COF = 0x60000000;
    public static final int MECH_KDF_DH = 0x70000000;
    public static final int MECH_KDF_XOR_BASE_AND_DATA = Integer.MIN_VALUE;
    public static final int MECH_KDF_CAT_BASE_AND_KEY = -1879048192;
    public static final int MECH_KDF_CAT_BASE_AND_DATA = -1610612736;
    public static final int MECH_KDF_CAT_DATA_AND_BASE = -1342177280;
    public static final int MECH_KDF_EXTRACT_KEY_FROM_KEY = -1073741824;
    public static final int MECH_MODE_HASH = 0;
    public static final int MECH_MODE_HMAC = 0x1000000;
    public static final int MECH_MODE_MAC1 = 0x5000000;
    public static final int MECH_MODE_ENCRYPT = 0x2000000;
    public static final int MECH_MODE_DECRYPT = 0x3000000;
    public static final int MECH_MODE_MASK = 0xF000000;
    public static final int MECH_CHAIN_ECB = 0;
    public static final int MECH_CHAIN_CBC = 0x100000;
    public static final int MECH_CHAIN_CBC_RETAIL = 0x200000;
    public static final int MECH_CHAIN_CMAC = 0x300000;
    public static final int MECH_CHAIN_CFB_RETAIL = 0x400000;
    public static final int MECH_CHAIN_CTR = 0x500000;
    public static final int MECH_CHAIN_GCM = 0x600000;
    public static final int MECH_CHAIN_OFB = 0x700000;
    public static final int MECH_CHAIN_CCM = 0x800000;
    public static final int MECH_CHAIN_KEY_WRAP = 0x900000;
    public static final int MECH_CHAIN_MASK = 0xF00000;
    public static final int MECH_PAD_NONE = 0;
    public static final int MECH_PAD_PKCS5 = 4096;
    public static final int MECH_PAD_RANDOM = 8192;
    public static final int MECH_PAD_ISO7816 = 12288;
    public static final int MECH_PAD_PKCS1 = 16384;
    public static final int MECH_PAD_OAEP = 20480;
    public static final int MECH_PAD_PSS = 24576;
    public static final int MECH_PAD_X9_31 = 28672;
    public static final int MECH_PAD_ZEROFILL = 32768;
    public static final int MECH_PAD_KWP = 36864;
    public static final int MECH_PAD_MASK = 61440;
    public static final int MECH_NIST_SP800_56A = 512;
    public static final int MECH_FORMAT_ASN1 = 1024;
    public static final int MECH_FORMAT_STRIP_LEAD_ZERO = 0;
    public static final int MECH_FORMAT_KEEP_LEAD_ZERO = 2048;
    public static final int MECH_FORMAT_X = 2048;
    public static final int MECH_FORMAT_MASK = 3072;
    public static final int MECH_HASH_ALGO_SHA1 = 16;
    public static final int MECH_HASH_ALGO_RMD160 = 32;
    public static final int MECH_HASH_ALGO_SHA224 = 48;
    public static final int MECH_HASH_ALGO_SHA256 = 64;
    public static final int MECH_HASH_ALGO_MD5 = 80;
    public static final int MECH_HASH_ALGO_SHA384 = 96;
    public static final int MECH_HASH_ALGO_SHA512 = 112;
    public static final int MECH_HASH_ALGO_SHA3_224 = 128;
    public static final int MECH_HASH_ALGO_SHA3_256 = 144;
    public static final int MECH_HASH_ALGO_SHA3_384 = 160;
    public static final int MECH_HASH_ALGO_SHA3_512 = 176;
    public static final int MECH_HASH_ALGO_MASK = 240;
    public static final int MECH_RND_REAL = 0;
    public static final int MECH_RND_PSEUDO = 1;
    public static final int MECH_RND_MASK = 1;
    public static final int MECH_KEYGEN_PROB_PRIME = 0;
    public static final int MECH_KEYGEN_PROV_PRIME = 2;
    public static final int MECH_DPGEN_DP_FIPS186_4 = 256;
    public static final int MECH_KEYGEN_ANSI_PRIME = 4;
    public static final int MECH_KEYGEN_FIPS186_4_PRIME = 6;
    public static final int MECH_KEYGEN_COMP = 2;
    public static final int MECH_KEYGEN_UNCOMP = 4;
    public static final int MECH_KEYGEN_HYBRID = 6;
    public static final int MECH_KEYGEN_MASK = 6;
    public static final int FLAG_OVERWRITE = 1;
    public static final int FLAG_EXTERNAL = 2;
    public static final int FLAG_VOLATILE = 4;
    public static final int FLAG_VERIFY_RECOVER = 16;
    public static final int FLAG_HASH_PART = 32;
    public static final int FLAG_HASH_DATA = 64;
    public static final int FLAG_ENCRYPT_SECRET = 128;
    public static final int FLAG_CRYPT_INIT = 256;
    public static final int FLAG_CRYPT_FINAL = 512;
    protected static final byte[] TAG_CF = new byte[]{67, 70};
    protected static final byte[] TAG_MO = new byte[]{77, 79};
    protected static final byte[] TAG_PE = new byte[]{80, 69};
    protected static final byte[] TAG_KC = new byte[]{75, 67};
    protected static final byte[] TAG_BH = new byte[]{66, 72};
    protected static final byte[] TAG_KH = new byte[]{75, 72};
    protected static final byte[] TAG_BB = new byte[]{66, 66};
    protected static final byte[] TAG_KB = new byte[]{75, 66};
    protected static final byte[] TAG_PL = new byte[]{80, 76};
    protected static final byte[] TAG_K = new byte[]{75, 32};
    protected static final byte[] TAG_MP = new byte[]{77, 80};
    protected static final byte[] TAG_IV = new byte[]{73, 86};
    protected static final byte[] TAG_DA = new byte[]{68, 65};
    protected static final byte[] TAG_PK = new byte[]{80, 75};
    protected static final byte[] TAG_HI = new byte[]{72, 73};
    protected static final byte[] TAG_AT = new byte[]{65, 84};
    protected static final byte[] TAG_DL = new byte[]{68, 76};
    protected static final byte[] TAG_AL = new byte[]{65, 76};
    protected static final byte[] TAG_IC = new byte[]{73, 67};
    protected static final byte[] TAG_II = new byte[]{73, 73};
    protected static final byte[] TAG_TD = new byte[]{84, 68};
    protected static final byte[] TAG_TK = new byte[]{84, 75};
    protected static final byte[] TAG_TI = new byte[]{84, 73};
    protected static final byte[] TAG_VT = new byte[]{86, 84};
    protected static final byte[] TAG_TV = new byte[]{84, 86};
    private static final int MAX_CMD_SIZE = 240000;
    public static CryptoServerLog CxiLog = new CryptoServerLog("cxi.log", CryptoServerLog.LogLevel.Warning, 0x100000);
    public static CryptoServerCluster.EventHandler eventHandler = new EventHandler();
    public static final int E_JCXI = 47489;
    public static final int E_JCXI_PARAM = -1182728192;
    public static final int E_JCXI_BAD_NAME = -1182728191;
    public static final int E_JCXI_NAME_REQ = -1182728190;
    public static final int E_JCXI_CHARSET = -1182728189;
    public static final int E_JCXI_BAD_KTOK = -1182728188;
    public static final int E_JCXI_BAD_ANSW = -1182728187;
    public static final int E_JCXI_KEY_ATTR = -1182728186;
    public static final int E_JCXI_BAD_ALGO = -1182728185;
    public static final int E_JCXI_USER_NAME = -1182728184;
    public static final int E_JCXI_NO_DEVICE = -1182728183;
    public static final int E_JCXI_NO_KEY_COMP = -1182728182;
    public static final int E_JCXI_NO_KEY = -1182728181;
    public static final int E_JCXI_CSA_VERSION = -1182728180;
    public static final int E_JCXI_NO_EC_PARAM = -1182728179;
    public static final int E_JCXI_NO_IV_OUT = -1182728178;
    public static final int E_JCXI_FW_VER = -1182728177;
    public static final int E_JCXI_ASN1_DECODE = -1182728176;
    public static final int E_JCXI_AES_DECRYPT = -1182728175;
    public static final int E_JCXI_ITEM_NOT_FOUND = -1182728174;
    public static final int E_JCXI_ECC_PARAM = -1182728160;
    public static final int E_JCXI_CONFIG = -1182728144;
    public static final int E_JCXI_DATA_LENGTH = -1182728128;
    public static final int E_JCXI_MECHS_LENGTH = -1182728112;
    private static final int E_VRSA_VERIFY_FAILED = -1333526511;
    private static final int E_DSA_VERIFY_FAILED = -1332936687;
    private static final int E_ECDSA_VERIFY_FAILED = -1331953657;
    private static final int E_DB_NOT_FOUND = -1333264380;
    private static final int E_CXI_CRYPT_SIGN_VERIFY = -1335361485;
    public static final int E_CXI_FIPS_USAGE_NOT_SET = -1335361264;
    private static final String CHARSET_NAME = "UTF-8";

    public static double getVersion() {
        return CXI_VERSION;
    }

    public CryptoServerCXI(String string) throws IOException, NumberFormatException, CryptoServerException {
        super(string);
    }

    public CryptoServerCXI(String string, int n) throws IOException, NumberFormatException, CryptoServerException {
        super(string, n);
    }

    public CryptoServerCXI(String[] stringArray, int n) throws IOException, CryptoServerException {
        super(stringArray, n);
        this.setEventHandler(eventHandler);
    }

    public CryptoServerCXI(CryptoServerConfig cryptoServerConfig) throws IOException, CryptoServerException {
        super(cryptoServerConfig);
        this.setEventHandler(eventHandler);
    }

    public int getFirmwareVersion() throws IOException, CryptoServerException {
        byte[] byArray = this.exec(134, 1, null);
        if (byArray.length < 16) {
            throw new CryptoServerException(-1182793725);
        }
        return CryptoServerUtil.load_int4(byArray, 4);
    }

    public Key generateKey(int n, KeyAttributes keyAttributes, int n2) throws IOException, CryptoServerException {
        if (keyAttributes.getSize() == 0) {
            keyAttributes.setSize(0);
        }
        byte[] byArray = new byte[4];
        CryptoServerUtil.store_int4(n, byArray, 0);
        byte[] byArray2 = null;
        if (n2 != -1) {
            byArray2 = new byte[4];
            CryptoServerUtil.store_int4(n2, byArray2, 0);
        }
        byte[] byArray3 = Item.mkItemList(TAG_CF, byArray, TAG_PL, keyAttributes.toByteArray(), TAG_MP, byArray2);
        byte[] byArray4 = this.exec(104, 11, byArray3);
        return new Key(byArray4);
    }

    public Key generateKey(int n, KeyAttributes keyAttributes) throws IOException, CryptoServerException {
        return this.generateKey(n, keyAttributes, -1);
    }

    public KeyAttributes generateDSADomainParam(int n, int n2, int n3) throws IOException, CryptoServerException {
        byte[] byArray;
        if (n3 != -1) {
            byArray = new byte[12];
            CryptoServerUtil.store_int4(n3, byArray, 8);
        } else {
            byArray = new byte[8];
        }
        CryptoServerUtil.store_int4(n, byArray, 0);
        CryptoServerUtil.store_int4(n2, byArray, 4);
        byte[] byArray2 = this.exec(104, 7, Item.mkItemList(TAG_MP, byArray));
        return new KeyAttributes(byArray2);
    }

    public byte[] generateDSAPQParam(int n, int n2, int n3, int n4, byte[] byArray, int n5) throws IOException, CryptoServerException {
        byte[] byArray2 = new byte[16 + (4 + byArray.length) + 4];
        CryptoServerUtil.store_int4(n, byArray2, 0);
        CryptoServerUtil.store_int4(n2, byArray2, 4);
        if (n3 != -1) {
            CryptoServerUtil.store_int4(n3, byArray2, 8);
        } else {
            CryptoServerUtil.store_int4(1, byArray2, 8);
        }
        CryptoServerUtil.store_int4(n4, byArray2, 12);
        CryptoServerUtil.store_int4(byArray.length, byArray2, 16);
        System.arraycopy(byArray, 0, byArray2, 20, byArray.length);
        CryptoServerUtil.store_int4(n5, byArray2, byArray2.length - 4);
        byte[] byArray3 = this.exec(104, 35, Item.mkItemList(TAG_MP, byArray2));
        return byArray3;
    }

    public KeyAttributes generateDSAGParam(byte[] byArray) throws IOException, CryptoServerException {
        byte[] byArray2 = this.exec(104, 36, byArray);
        byte[] byArray3 = Item.getItem(TAG_PL, byArray, 0);
        byte[] byArray4 = Item.getItem(TAG_PL, byArray2, 0);
        byte[] byArray5 = new byte[byArray3.length + byArray4.length];
        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
        System.arraycopy(byArray4, 0, byArray5, byArray3.length, byArray4.length);
        byte[] byArray6 = Item.mkItemList(TAG_PL, byArray5);
        KeyAttributes keyAttributes = new KeyAttributes(byArray6);
        keyAttributes.setAlgo(5);
        return keyAttributes;
    }

    public Key findKey(int n, KeyAttributes keyAttributes) throws IOException, CryptoServerException {
        byte[] byArray;
        byte[] byArray2 = new byte[4];
        CryptoServerUtil.store_int4(n, byArray2, 0);
        try {
            CryptoServerCluster.Error[] errorArray = new CryptoServerCluster.Error[]{new CryptoServerCluster.Error(-1, -1333264380)};
            byArray = this.exec(104, 12, Item.mkItemList(TAG_CF, byArray2, TAG_PL, keyAttributes.toByteArray()), errorArray);
        }
        catch (CryptoServerException cryptoServerException) {
            if (cryptoServerException.ErrorCode == -1333264380 || cryptoServerException.ErrorCode == -1182793693) {
                return null;
            }
            throw cryptoServerException;
        }
        return new Key(byArray);
    }

    public Key findKey(KeyAttributes keyAttributes) throws IOException, CryptoServerException {
        return this.findKey(0, keyAttributes);
    }

    public KeyAttributes getKeyAttributes(Key key, boolean bl) throws IOException, CryptoServerException {
        byte[] byArray = bl ? KeyAttributes.PROP_LIST2 : KeyAttributes.PROP_LIST1;
        byte[] byArray2 = this.exec(104, 14, Item.mkItemList(null, key.value, null, byArray));
        return new KeyAttributes(byArray2);
    }

    public Key setKeyAttributes(Key key, KeyAttributes keyAttributes) throws IOException, CryptoServerException {
        byte[] byArray = Item.mkItemList(null, key.value, TAG_PL, keyAttributes.toByteArray());
        byte[] byArray2 = this.exec(104, 15, byArray);
        return new Key(byArray2);
    }

    public KeyAttributes getKeyAttributes(Key key, int[] nArray) throws IOException, CryptoServerException {
        KeyAttributes keyAttributes = new KeyAttributes();
        for (int i = 0; i < nArray.length; ++i) {
            ((KeyAttributes)keyAttributes).attr[nArray[i]] = new byte[0];
        }
        byte[] byArray = this.exec(104, 14, Item.mkItemList(null, key.value, TAG_PL, keyAttributes.toByteArray()));
        return new KeyAttributes(byArray);
    }

    public KeyAttributes[] listKeys(KeyAttributes keyAttributes) throws IOException, CryptoServerException {
        boolean bl;
        byte[] byArray = new byte[16];
        ArrayList<KeyAttributes> arrayList = new ArrayList<KeyAttributes>();
        byte[] byArray2 = null;
        if (keyAttributes != null) {
            byArray2 = Item.mkItemList(TAG_PL, keyAttributes.toByteArray());
        }
        do {
            int n;
            byte[] byArray3 = this.exec(104, 10, Item.mkItemList(TAG_CF, byArray, null, byArray2));
            bl = false;
            for (int i = 0; i < byArray3.length; i += 6 + n) {
                if (byArray3.length - i < 6 || (n = CryptoServerUtil.load_int4(byArray3, i + 2)) > byArray3.length - i - 6) {
                    throw new CryptoServerException(-1182728186);
                }
                if (byArray3[i] == 80 && byArray3[i + 1] == 76) {
                    arrayList.add(new KeyAttributes(byArray3, i));
                    continue;
                }
                if (byArray3[i] == 67 && byArray3[i + 1] == 70) {
                    if (n != 16) {
                        throw new CryptoServerException(-1182728187, "invalid length: " + Integer.toString(n));
                    }
                    System.arraycopy(byArray3, i + 6, byArray, 0, 16);
                    bl = true;
                    continue;
                }
                throw new CryptoServerException(-1182728186);
            }
        } while (bl);
        return arrayList.toArray(new KeyAttributes[arrayList.size()]);
    }

    public KeyAttributes[] listKeys() throws IOException, CryptoServerException {
        return this.listKeys(null);
    }

    public Key backupKey(Key key) throws IOException, CryptoServerException {
        byte[] byArray = this.exec(104, 8, key.value);
        return new Key(byArray);
    }

    public Key restoreKey(int n, Key key, KeyAttributes keyAttributes) throws IOException, CryptoServerException {
        byte[] byArray = new byte[4];
        CryptoServerUtil.store_int4(n, byArray, 0);
        byte[] byArray2 = Item.mkItemList(TAG_CF, byArray, null, key.value);
        if (keyAttributes != null) {
            byArray2 = Item.mkItemList(null, byArray2, TAG_PL, keyAttributes.toByteArray());
        }
        byte[] byArray3 = this.exec(104, 9, byArray2);
        return new Key(byArray3);
    }

    public void deleteKey(Key key) throws IOException, CryptoServerException {
        this.exec(104, 13, key.value);
    }

    public byte[] exportKey(Key key, int n, Key key2, int n2) throws IOException, CryptoServerException {
        if ((n & 0xFF0000) == 0) {
            n |= 0x10000;
        }
        byte[] byArray = new byte[4];
        CryptoServerUtil.store_int4(n, byArray, 0);
        byte[] byArray2 = null;
        if (n2 != -1) {
            byArray2 = new byte[4];
            CryptoServerUtil.store_int4(n2, byArray2, 0);
        }
        byte[] byArray3 = Item.mkItemList(TAG_CF, byArray, null, key.value, TAG_MP, byArray2);
        if (key2 != null) {
            byArray3 = Item.mkItemList(null, byArray3, null, key2.value);
        }
        byte[] byArray4 = this.exec(104, 16, byArray3);
        Item.getItem(TAG_KB, byArray4, 0);
        return byArray4;
    }

    public byte[] exportKey(Key key, int n, Key key2) throws IOException, CryptoServerException {
        return this.exportKey(key, n, key2, -1);
    }

    public KeyAttAndComp exportClearKey(Key key, int n) throws IOException, CryptoServerException {
        byte[] byArray = this.exportKey(key, n, null);
        if (byArray[0] == 75 && byArray[1] == 66) {
            byArray = Item.getItem(TAG_KB, byArray, 0);
        }
        return new KeyAttAndComp(Item.getItem(TAG_BH, byArray, 0), Item.getItem(TAG_KC, byArray, 0));
    }

    public Key importKey(int n, int n2, KeyAttributes keyAttributes, byte[] byArray, Key key, int n3) throws IOException, CryptoServerException {
        if ((n2 & 0xFF0000) == 0) {
            n2 |= 0x10000;
        }
        byte[] byArray2 = new byte[8];
        CryptoServerUtil.store_int4(n, byArray2, 0);
        CryptoServerUtil.store_int4(n2, byArray2, 4);
        byte[] byArray3 = null;
        if (n3 != -1) {
            byArray3 = new byte[4];
            CryptoServerUtil.store_int4(n3, byArray3, 0);
        }
        if (keyAttributes == null) {
            keyAttributes = new KeyAttributes();
        }
        if (byArray[0] == 66 && byArray[1] == 72) {
            byArray = Item.mkItemList(TAG_KB, byArray);
        }
        byte[] byArray4 = Item.mkItemList(TAG_CF, byArray2, TAG_PL, keyAttributes.toByteArray(), null, byArray, TAG_MP, byArray3);
        if (key != null) {
            byArray4 = Item.mkItemList(null, byArray4, null, key.value);
        }
        byte[] byArray5 = this.exec(104, 17, byArray4);
        return new Key(byArray5);
    }

    public Key importKey(int n, int n2, KeyAttributes keyAttributes, byte[] byArray, Key key) throws IOException, CryptoServerException {
        return this.importKey(n, n2, keyAttributes, byArray, key, -1);
    }

    public Key importClearKey(int n, int n2, KeyAttributes keyAttributes, KeyComponents keyComponents) throws IOException, CryptoServerException {
        byte[] byArray;
        if (keyComponents == null) {
            byte[] byArray2;
            switch (keyAttributes.getAlgo()) {
                case 3: {
                    byArray2 = Item.mkItemList(TAG_MO, keyAttributes.getModulus(), TAG_PE, keyAttributes.getExponent());
                    keyAttributes = keyAttributes.clone(KeyAttributes.PROP_LIST_COPY_RSA);
                    break;
                }
                case 5: {
                    byArray2 = Item.mkItemList(TAG_PK, keyAttributes.getDSAPub());
                    keyAttributes = keyAttributes.clone(KeyAttributes.PROP_LIST_COPY_DSA);
                    break;
                }
                case 4: {
                    byArray2 = Item.mkItemList(TAG_PK, keyAttributes.getECPub());
                    keyAttributes = keyAttributes.clone(KeyAttributes.PROP_LIST_COPY_EC);
                    break;
                }
                default: {
                    throw new CryptoServerException(-1182728182);
                }
            }
            byArray = Item.mkItemList(TAG_BH, Item.mkItemList(TAG_PL, new byte[0]), TAG_KC, byArray2);
        } else {
            byArray = Item.mkItemList(TAG_BH, Item.mkItemList(TAG_PL, new byte[0]), TAG_KC, keyComponents.getList());
        }
        return this.importKey(n, n2, keyAttributes, byArray, null, -1);
    }

    public byte[] crypt(int n, Key key, int n2, byte[] byArray, byte[] byArray2, ByteArray byteArray, ByteArray byteArray2, byte[] byArray3) throws IOException, CryptoServerException {
        Object object;
        Object object2;
        Object object3;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray4 = null;
        int n6 = 0;
        int n7 = byArray2 == null ? 0 : byArray2.length;
        int n8 = 0;
        boolean bl = true;
        ByteArray byteArray3 = new ByteArray();
        ByteArray byteArray4 = new ByteArray();
        ByteArray byteArray5 = new ByteArray();
        ByteArray byteArray6 = new ByteArray();
        ByteArray byteArray7 = new ByteArray();
        ByteArray byteArray8 = new ByteArray();
        ByteArray byteArray9 = new ByteArray();
        ByteArray byteArray10 = new ByteArray();
        switch (n2 & 0xF00000) {
            case 0x600000: 
            case 0x800000: {
                if (byArray.length < 14) {
                    throw new CryptoServerException(-1182728192);
                }
                n3 = 11 + CryptoServerUtil.load_int2(byArray, 9);
                n4 = CryptoServerUtil.load_int2(byArray, n3);
                if (byteArray2 == null) {
                    if ((n & 0x200) == 0 || (n2 & 0xF000000) == 0x2000000) {
                        throw new CryptoServerException(-1182728192);
                    }
                } else {
                    byteArray4 = byteArray2;
                }
                if (byteArray == null) {
                    if ((n & 0x200) != 0) break;
                    throw new CryptoServerException(-1182728192);
                }
                object3 = new HashMap();
                object2 = new ByteArray();
                object = new ByteArray();
                ((HashMap)object3).put(TAG_DL, object2);
                ((HashMap)object3).put(TAG_AL, object);
                ((HashMap)object3).put(TAG_IC, byteArray5);
                ((HashMap)object3).put(TAG_IV, byteArray3);
                ((HashMap)object3).put(TAG_II, byteArray6);
                ((HashMap)object3).put(TAG_TD, byteArray7);
                ((HashMap)object3).put(TAG_TK, byteArray8);
                ((HashMap)object3).put(TAG_TI, byteArray9);
                for (Map.Entry entry : ((HashMap)object3).entrySet()) {
                    try {
                        ByteArray byteArray11 = (ByteArray)entry.getValue();
                        byteArray11.setBytes(Item.getItem((byte[])entry.getKey(), byteArray.getBytes(), 0));
                    }
                    catch (CryptoServerException cryptoServerException) {
                        if (cryptoServerException.ErrorCode == -1182728174) continue;
                        throw cryptoServerException;
                    }
                }
                n8 = n7;
                if (((ByteArray)object2).length() > 0) {
                    n8 += ((ByteArray)object2).getInt();
                }
                n5 = n4;
                if (object.length() <= 0) break;
                n5 += object.getInt();
                break;
            }
            default: {
                if (byteArray == null) break;
                byteArray3 = byteArray;
            }
        }
        object3 = null;
        if (byArray != null) {
            if (n3 > 0) {
                if (n4 > 0) {
                    byArray4 = Arrays.copyOfRange(byArray, n3 + 2, n3 + n4 + 2);
                }
            } else {
                n3 = byArray.length;
            }
            object3 = new byte[4 + n3];
            System.arraycopy(byArray, 0, object3, 4, n3);
        } else {
            object3 = new byte[4];
        }
        n3 = 0;
        do {
            Object object4;
            int n9;
            boolean bl2;
            Object object5;
            int n10;
            object2 = new ByteArray((byte[])object3);
            object = new byte[]{};
            int n11 = n4 - n3;
            int n12 = 0;
            HashMap<byte[], ByteArray> hashMap = new HashMap<byte[], ByteArray>();
            int n13 = n11 > 65520 ? 65520 : n11;
            int n14 = n10 = n11 > 65520 ? 0 : 240000 - n13;
            if ((n2 & 0xF00000) == 0x800000 && bl && (n & 0x100) != 0 && n11 > 65520) {
                n13 -= n4 < 65280 ? 2 : 6;
            }
            if ((n2 & 0xF00000) == 0x600000 || (n2 & 0xF00000) == 0x800000) {
                ((ByteArray)object2).appendInt2(n13);
                if (n13 > 0) {
                    ((ByteArray)object2).append(Arrays.copyOfRange(byArray4, n3, n3 + n13));
                    n3 += n13;
                }
                object5 = new byte[]{0};
                ((ByteArray)object2).append((byte[])object5);
            }
            if (bl) {
                bl = false;
            } else {
                n12 |= 0x100;
            }
            boolean bl3 = bl2 = n3 == n4 && n7 - n6 <= n10;
            if (bl2) {
                n9 = n7 - n6;
                if ((n2 & 0xF00000) == 0x600000 && (n & 0x200) != 0) {
                    object5 = ((ByteArray)object2).getBytes();
                    CryptoServerUtil.store_int4(n8, (byte[])object5, 4);
                    CryptoServerUtil.store_int4(n5, (byte[])object5, 8);
                }
                CryptoServerUtil.store_int4(n2, ((ByteArray)object2).getBytes(), 0);
            } else {
                n9 = n10 - n10 % 16;
                n12 |= 0x200;
                CryptoServerUtil.store_int4(n2 & 0xFFFF0FFF, ((ByteArray)object2).getBytes(), 0);
            }
            if (n9 > 0) {
                object = Arrays.copyOfRange(byArray2, n6, n6 + n9);
                n6 += n9;
            }
            object5 = new ArrayList(10);
            byte[] byArray5 = new byte[4];
            CryptoServerUtil.store_int4(n & ~n12, byArray5, 0);
            ((ArrayList)object5).add(new Item(TAG_CF, byArray5));
            ((ArrayList)object5).add(new Item(null, key.value));
            ((ArrayList)object5).add(new Item(TAG_MP, ((ByteArray)object2).getBytes()));
            ((ArrayList)object5).add(new Item(TAG_DA, (byte[])object));
            if (byteArray3.length() > 0) {
                ((ArrayList)object5).add(new Item(TAG_IV, byteArray3.getBytes()));
            }
            if (byteArray4.length() > 16 && byteArray4.getBytes()[0] == 83) {
                ((ArrayList)object5).add(new Item(TAG_AT, byteArray4.getBytes()));
            }
            if ((n2 & 0xF00000) == 0x600000 && (n & 0x200) != 0 && bl2 && byteArray5.length() > 0) {
                ((ArrayList)object5).add(new Item(TAG_IC, byteArray5.getBytes()));
            }
            if ((n2 & 0xF000000) == 0x3000000 && ((n2 & 0xF00000) == 0x600000 || (n2 & 0xF00000) == 0x800000)) {
                if (byArray3 != null && (n & 0x200) != 0 && bl2) {
                    ((ArrayList)object5).add(new Item(TAG_VT, byArray3));
                }
                if (byteArray8.length() > 0) {
                    ((ArrayList)object5).add(new Item(TAG_TK, byteArray8.getBytes()));
                }
                if (byteArray7.length() > 0) {
                    if (byteArray7.length() < 16) {
                        throw new CryptoServerException(-1182728187);
                    }
                    ((ArrayList)object5).add(new Item(TAG_TV, Arrays.copyOfRange(byteArray7.getBytes(), byteArray7.length() - 16, byteArray7.length())));
                } else if (byteArray9.length() > 0) {
                    ((ArrayList)object5).add(new Item(TAG_TV, byteArray9.getBytes()));
                }
            }
            byte[] byArray6 = Item.mkItemList(((ArrayList)object5).toArray(new Item[0]));
            byte[] byArray7 = new byte[]{0};
            try {
                byArray7 = this.exec(104, 20, byArray6);
            }
            catch (CryptoServerException cryptoServerException) {
                if (cryptoServerException.ErrorCode == -1333592052 && ((n2 & 0xF00000) == 0x600000 || (n2 & 0xF00000) == 0x800000)) {
                    byte[] byArray8 = Arrays.copyOfRange(((ByteArray)object2).getBytes(), 0, ((ByteArray)object2).length() - 1);
                    ((ArrayList)object5).set(2, new Item(TAG_MP, byArray8));
                    object4 = Item.mkItemList(((ArrayList)object5).toArray(new Item[0]));
                    byArray7 = this.exec(104, 20, (byte[])object4);
                }
                throw cryptoServerException;
            }
            if (!((n2 & 0xF000000) != 0x3000000 || bl2 && (n & 0x200) != 0 || (n2 & 0xF00000) != 0x600000 && (n2 & 0xF00000) != 0x800000)) {
                byteArray7.append(Item.getItem(TAG_DA, byArray7, 0));
            } else {
                byteArray10.append(Item.getItem(TAG_DA, byArray7, 0));
            }
            hashMap.put(TAG_IV, byteArray3);
            if ((n2 & 0xF00000) == 0x600000 || (n2 & 0xF00000) == 0x800000) {
                hashMap.put(TAG_AT, byteArray4);
                if ((n2 & 0xF00000) == 0x600000) {
                    hashMap.put(TAG_II, byteArray6);
                    hashMap.put(TAG_IC, byteArray5);
                }
                if ((n2 & 0xF000000) == 0x3000000) {
                    hashMap.put(TAG_TK, byteArray8);
                    hashMap.put(TAG_TI, byteArray9);
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                try {
                    object4 = (ByteArray)entry.getValue();
                    ((ByteArray)object4).setBytes(Item.getItem((byte[])entry.getKey(), byArray7, 0));
                }
                catch (CryptoServerException cryptoServerException) {
                    if (cryptoServerException.ErrorCode == -1182728174) continue;
                    throw cryptoServerException;
                }
            }
        } while (n3 < n4 || n6 < n7);
        switch (n2 & 0xF00000) {
            case 0x600000: 
            case 0x800000: {
                if (byteArray2 != null) {
                    byteArray2 = (n & 0x200) == 0 || (n2 & 0xF000000) == 0x2000000 || byArray3 == null ? byteArray4 : null;
                }
                if (byteArray != null) {
                    if ((n & 0x200) == 0) {
                        object2 = new ArrayList(8);
                        if ((n2 & 0xF00000) == 0x600000) {
                            object = new byte[4];
                            CryptoServerUtil.store_int4(n8, object, 0);
                            ((ArrayList)object2).add(new Item(TAG_DL, (byte[])object));
                        }
                        if ((n2 & 0xF00000) == 0x600000) {
                            object = new byte[4];
                            CryptoServerUtil.store_int4(n5, object, 0);
                            ((ArrayList)object2).add(new Item(TAG_AL, (byte[])object));
                        }
                        if (byteArray5.length() > 0) {
                            ((ArrayList)object2).add(new Item(TAG_IC, byteArray5.getBytes()));
                        }
                        if (byteArray3.length() > 0) {
                            ((ArrayList)object2).add(new Item(TAG_IV, byteArray3.getBytes()));
                        }
                        if (byteArray6.length() > 0) {
                            ((ArrayList)object2).add(new Item(TAG_II, byteArray6.getBytes()));
                        }
                        if (byteArray7.length() > 0) {
                            ((ArrayList)object2).add(new Item(TAG_TD, byteArray7.getBytes()));
                        }
                        if (byteArray8.length() > 0) {
                            ((ArrayList)object2).add(new Item(TAG_TK, byteArray8.getBytes()));
                        }
                        if (byteArray9.length() > 0) {
                            ((ArrayList)object2).add(new Item(TAG_TI, byteArray9.getBytes()));
                        }
                        byteArray.setBytes(Item.mkItemList(((ArrayList)object2).toArray(new Item[0])));
                    } else if ((n2 & 0xF000000) == 0x2000000) {
                        byteArray.setBytes(byteArray6.getBytes());
                    }
                }
                if ((n & 0x200) == 0 || (n2 & 0xF000000) != 0x3000000 || byteArray7.length() <= 0) break;
                try {
                    object2 = new SecretKeySpec(byteArray8.getBytes(), "AES");
                    object = Cipher.getInstance("AES/CBC/NoPadding");
                    object.init(2, (java.security.Key)object2, new IvParameterSpec(byteArray9.getBytes()));
                    byteArray7.setBytes(object.doFinal(byteArray7.getBytes()));
                }
                catch (Exception exception) {
                    throw new CryptoServerException(-1182728175);
                }
                byteArray7.append(byteArray10);
                byteArray10 = byteArray7;
                break;
            }
            default: {
                if (byteArray == null) break;
                byteArray.setBytes(byteArray3.getBytes());
            }
        }
        return byteArray10.getBytes();
    }

    public byte[] crypt(Key key, int n, byte[] byArray, byte[] byArray2, ByteArray byteArray) throws IOException, CryptoServerException {
        return this.crypt(512, key, n, byArray, byArray2, byteArray, null, null);
    }

    public byte[][] bulkCrypt(Key key, int n, byte[][] byArray) throws IOException, CryptoServerException {
        byte[] byArray2 = new byte[4];
        CryptoServerUtil.store_int4(n, byArray2, 0);
        byte[] byArray3 = Item.mkItemList(null, key.value, TAG_MP, byArray2);
        for (int i = 0; i < byArray.length; ++i) {
            byArray3 = Item.mkItemList(null, byArray3, TAG_DA, byArray[i]);
        }
        byte[] byArray4 = this.exec(104, 20, byArray3);
        byte[][] byArrayArray = new byte[byArray.length][];
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byArrayArray[i] = Item.getItem(TAG_DA, byArray4, n2);
            n2 += byArrayArray[i].length + 6;
            byArrayArray[i] = CryptoServerUtil.lstrip(byArrayArray[i], 0);
        }
        return byArrayArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] sign(int n, Key key, int n2, byte[] byArray, byte[] byArray2, ByteArray byteArray) throws IOException, CryptoServerException {
        Object object;
        int n3 = byArray2 == null ? 0 : byArray2.length;
        byte[] byArray3 = null;
        if (byteArray != null && byteArray.length() > 0) {
            if ((n2 & 0xF00000) == 0x600000) {
                n3 += CryptoServerUtil.load_int4(Item.getItem(TAG_DL, byteArray.getBytes(), 0), 0);
                byArray3 = Item.getItem(TAG_IV, byteArray.getBytes(), 0);
            } else {
                byArray3 = byteArray.getBytes();
            }
        }
        byte[] byArray4 = new byte[4];
        CryptoServerUtil.store_int4(n, byArray4, 0);
        byte[] byArray5 = null;
        if (byArray != null) {
            byArray5 = new byte[4 + byArray.length];
            System.arraycopy(byArray, 0, byArray5, 4, byArray.length);
            if ((n2 & 0xF00000) == 0x600000 && (n & 0x200) != 0) {
                if (byArray.length < 7) {
                    throw new CryptoServerException(-1182728192);
                }
                CryptoServerUtil.store_int4(n3, byArray5, 4);
            }
        } else {
            byArray5 = new byte[4];
        }
        CryptoServerUtil.store_int4(n2, byArray5, 0);
        byte[] byArray6 = Item.mkItemList(TAG_CF, byArray4, null, key.value, TAG_MP, byArray5, TAG_DA, byArray2);
        if (byArray3 != null) {
            byArray6 = Item.mkItemList(null, byArray6, TAG_IV, byArray3);
        }
        byte[] byArray7 = new byte[]{0};
        try {
            byArray7 = this.exec(104, 21, byArray6);
        }
        catch (CryptoServerException cryptoServerException) {
            if (cryptoServerException.ErrorCode != -1333592052 || (n2 & 0xF00000) != 0x600000 && (n2 & 0xF00000) != 0x800000) throw cryptoServerException;
            object = Arrays.copyOfRange(byArray5, 0, byArray5.length - 1);
            byte[] byArray8 = Item.mkItemList(TAG_CF, byArray4, null, key.value, TAG_MP, (byte[])object, TAG_DA, byArray2);
            if (byArray3 != null) {
                byArray8 = Item.mkItemList(null, byArray8, TAG_IV, byArray3);
            }
            byArray7 = this.exec(104, 21, byArray8);
        }
        byte[] byArray9 = Item.getItem(TAG_DA, byArray7, 0);
        if ((n2 & 0xF00000) == 0x600000) {
            if ((n & 0x200) != 0) {
                try {
                    object = new ByteArray(Item.getItem(TAG_II, byArray7, 0));
                    if (byteArray == null) {
                        throw new CryptoServerException(-1182728192);
                    }
                    byteArray.setBytes(((ByteArray)object).getBytes());
                    return byArray9;
                }
                catch (CryptoServerException cryptoServerException) {
                    if (cryptoServerException.ErrorCode == -1182728174) return byArray9;
                    throw cryptoServerException;
                }
            } else {
                if (byteArray == null) {
                    throw new CryptoServerException(-1182728192);
                }
                object = new byte[4];
                CryptoServerUtil.store_int4(n3, (byte[])object, 0);
                byArray9 = Item.mkItemList(TAG_DL, (byte[])object, TAG_IV, byArray9);
                byteArray.setBytes(byArray9);
            }
            return byArray9;
        } else {
            if (byteArray == null) return byArray9;
            byteArray.setBytes(byArray9);
        }
        return byArray9;
    }

    public byte[] sign(Key key, int n, byte[] byArray) throws IOException, CryptoServerException {
        return this.sign(512, key, n, null, byArray, null);
    }

    public byte[][] bulkSign(Key key, int n, byte[][] byArray) throws IOException, CryptoServerException {
        byte[] byArray2 = new byte[4];
        CryptoServerUtil.store_int4(n, byArray2, 0);
        byte[] byArray3 = Item.mkItemList(null, key.value, TAG_MP, byArray2);
        for (int i = 0; i < byArray.length; ++i) {
            byArray3 = Item.mkItemList(null, byArray3, TAG_DA, byArray[i]);
        }
        byte[] byArray4 = this.exec(104, 21, byArray3);
        byte[][] byArrayArray = new byte[byArray.length][];
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byArrayArray[i] = Item.getItem(TAG_DA, byArray4, n2);
            n2 += byArrayArray[i].length + 6;
        }
        return byArrayArray;
    }

    public boolean verify(int n, Key key, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, ByteArray byteArray) throws IOException, CryptoServerException {
        block24: {
            byte[] byArray4;
            int n3 = byArray2 == null ? 0 : byArray2.length;
            byte[] byArray5 = null;
            if (byteArray != null && byteArray.length() > 0) {
                if ((n2 & 0xF00000) == 0x600000) {
                    n3 += CryptoServerUtil.load_int4(Item.getItem(TAG_DL, byteArray.getBytes(), 0), 0);
                    byArray5 = Item.getItem(TAG_IV, byteArray.getBytes(), 0);
                } else {
                    byArray5 = byteArray.getBytes();
                }
            }
            byte[] byArray6 = new byte[4];
            CryptoServerUtil.store_int4(n, byArray6, 0);
            byte[] byArray7 = null;
            if (byArray != null) {
                byArray7 = new byte[4 + byArray.length];
                System.arraycopy(byArray, 0, byArray7, 4, byArray.length);
                if ((n2 & 0xF00000) == 0x600000 && (n & 0x200) != 0) {
                    if (byArray.length < 6) {
                        throw new CryptoServerException(-1182728192);
                    }
                    CryptoServerUtil.store_int4(n3, byArray7, 4);
                }
            } else {
                byArray7 = new byte[4];
            }
            CryptoServerUtil.store_int4(n2, byArray7, 0);
            byte[] byArray8 = Item.mkItemList(TAG_CF, byArray6, null, key.value, TAG_MP, byArray7, TAG_DA, byArray2);
            if (byArray3 != null) {
                byArray8 = Item.mkItemList(null, byArray8, TAG_DA, byArray3);
            }
            if (byArray5 != null) {
                byArray8 = Item.mkItemList(null, byArray8, TAG_IV, byArray5);
            }
            try {
                byArray4 = this.exec(104, 22, byArray8);
            }
            catch (CryptoServerException cryptoServerException) {
                if (cryptoServerException.ErrorCode == -1335361485 || cryptoServerException.ErrorCode == -1333526511 || cryptoServerException.ErrorCode == -1332936687 || cryptoServerException.ErrorCode == -1331953657) {
                    return false;
                }
                if (cryptoServerException.ErrorCode == -1333592052 && ((n2 & 0xF00000) == 0x600000 || (n2 & 0xF00000) == 0x800000)) {
                    byte[] byArray9 = Arrays.copyOfRange(byArray7, 0, byArray7.length - 1);
                    byte[] byArray10 = Item.mkItemList(TAG_CF, byArray6, null, key.value, TAG_MP, byArray9, TAG_DA, byArray2);
                    if (byArray3 != null) {
                        byArray10 = Item.mkItemList(null, byArray10, TAG_DA, byArray3);
                    }
                    if (byArray5 != null) {
                        byArray10 = Item.mkItemList(null, byArray10, TAG_IV, byArray5);
                    }
                    try {
                        byArray4 = this.exec(104, 22, byArray10);
                    }
                    catch (CryptoServerException cryptoServerException2) {
                        if (cryptoServerException2.ErrorCode == -1335361485) {
                            return false;
                        }
                        throw cryptoServerException2;
                    }
                }
                throw cryptoServerException;
            }
            try {
                byArray5 = Item.getItem(TAG_IV, byArray4, 0);
                if ((n2 & 0xF00000) == 0x600000 && (n & 0x200) == 0) {
                    if (byteArray == null) {
                        throw new CryptoServerException(-1182728192);
                    }
                    byte[] byArray11 = new byte[4];
                    CryptoServerUtil.store_int4(n3, byArray11, 0);
                    byteArray.setBytes(Item.mkItemList(TAG_DL, byArray11, TAG_IV, byArray5));
                } else if (byteArray != null) {
                    byteArray.setBytes(byArray5);
                }
            }
            catch (CryptoServerException cryptoServerException) {
                if (cryptoServerException.ErrorCode == -1182728174) break block24;
                throw cryptoServerException;
            }
        }
        return true;
    }

    public boolean verify(Key key, int n, byte[] byArray, byte[] byArray2) throws IOException, CryptoServerException {
        return this.verify(512, key, n, null, byArray, byArray2, null);
    }

    public byte[] generateRandom(int n, int n2) throws IOException, CryptoServerException {
        byte[] byArray;
        byte[] byArray2 = new byte[4];
        CryptoServerUtil.store_int4(n, byArray2, 0);
        byte[] byArray3 = null;
        if (n2 != -1) {
            byArray3 = new byte[4];
            CryptoServerUtil.store_int4(n2, byArray3, 0);
        }
        if ((byArray = Item.getItem(TAG_DA, this.exec(104, 23, Item.mkItemList(TAG_CF, byArray2, TAG_MP, byArray3)), 0)).length != n) {
            throw new CryptoServerException(-1182728187);
        }
        return byArray;
    }

    public byte[] computeHash(int n, int n2, byte[] byArray, byte[] byArray2, Key key) throws IOException, CryptoServerException {
        int n3;
        if (byArray == null || byArray.length <= 240000) {
            byte[] byArray3 = new byte[4];
            CryptoServerUtil.store_int4(n, byArray3, 0);
            byte[] byArray4 = null;
            if (n2 != -1) {
                byArray4 = new byte[4];
                CryptoServerUtil.store_int4(n2, byArray4, 0);
            }
            byte[] byArray5 = Item.mkItemList(TAG_CF, byArray3, TAG_MP, byArray4, TAG_DA, byArray, TAG_HI, byArray2);
            if (key != null) {
                byArray5 = Item.mkItemList(null, byArray5, null, key.getEncoded());
            }
            byte[] byArray6 = this.exec(104, 18, byArray5);
            byte[] byArray7 = null;
            try {
                byArray7 = Item.getItem(TAG_DA, byArray6, 0);
            }
            catch (CryptoServerException cryptoServerException) {
                byArray7 = Item.getItem(TAG_HI, byArray6, 0);
            }
            return byArray7;
        }
        int n4 = n;
        int n5 = 0;
        byte[] byArray8 = byArray2;
        n |= 0x20;
        for (int i = byArray.length; i > 0; i -= n3) {
            if (i > 240000) {
                n3 = 240000;
            } else {
                n3 = i;
                n = n4;
            }
            byte[] byArray9 = CryptoServerUtil.copyOf(byArray, n5, n3);
            byArray8 = this.computeHash(n, n2, byArray9, byArray8, key);
            n5 += n3;
        }
        return byArray8;
    }

    public byte[] agreeSecret(int n, Key key, Key key2, int n2, byte[] byArray) throws IOException, CryptoServerException {
        byte[] byArray2 = new byte[4];
        CryptoServerUtil.store_int4(n, byArray2, 0);
        byte[] byArray3 = null;
        if (byArray != null) {
            byArray3 = new byte[4 + byArray.length];
            System.arraycopy(byArray, 0, byArray3, 4, byArray.length);
        } else {
            byArray3 = new byte[4];
        }
        CryptoServerUtil.store_int4(n2, byArray3, 0);
        byte[] byArray4 = Item.mkItemList(TAG_CF, byArray2, null, key.value, null, key2.value, TAG_MP, byArray3);
        byte[] byArray5 = this.exec(104, 24, byArray4);
        return byArray5;
    }

    public Key deriveKey(int n, Key key, KeyAttributes keyAttributes, int n2, byte[] byArray) throws IOException, CryptoServerException {
        byte[] byArray2 = new byte[4];
        CryptoServerUtil.store_int4(n, byArray2, 0);
        ByteArray byteArray = new ByteArray();
        byteArray.appendInt4(n2);
        byteArray.append(byArray);
        byte[] byArray3 = Item.mkItemList(TAG_CF, byArray2, null, key.value, TAG_MP, byteArray.getBytes(), TAG_PL, keyAttributes.toByteArray());
        byte[] byArray4 = this.exec(104, 28, byArray3);
        return new Key(byArray4);
    }

    public Key setFIPSUsage(Key key, int n) throws CryptoServerException, IOException {
        KeyAttributes keyAttributes = new KeyAttributes();
        keyAttributes.setFIPSUsage(n);
        return this.setKeyAttributes(key, keyAttributes);
    }

    public static class ByteArray {
        private byte[] buf;

        public ByteArray() {
            this.buf = null;
        }

        public ByteArray(byte[] byArray) {
            this.setBytes(byArray);
        }

        public void setBytes(byte[] byArray) {
            this.buf = (byte[])byArray.clone();
        }

        public byte[] getBytes() {
            if (this.buf == null) {
                return new byte[0];
            }
            return this.buf;
        }

        public int length() {
            return this.buf == null ? 0 : this.buf.length;
        }

        public void setInt(int n) {
            if (this.buf == null || this.buf.length != 4) {
                this.buf = new byte[4];
            }
            CryptoServerUtil.store_int4(n, this.buf, 0);
        }

        public int getInt() {
            if (this.buf == null || this.buf.length != 4) {
                return 0;
            }
            return CryptoServerUtil.load_int4(this.buf, 0);
        }

        public void append(byte[] byArray) {
            if (this.buf == null) {
                this.buf = (byte[])byArray.clone();
            } else {
                int n = this.buf.length;
                this.buf = Arrays.copyOf(this.buf, n + byArray.length);
                System.arraycopy(byArray, 0, this.buf, n, byArray.length);
            }
        }

        public void append(ByteArray byteArray) {
            this.append(byteArray.getBytes());
        }

        public void appendInt2(int n) {
            byte[] byArray = new byte[2];
            CryptoServerUtil.store_int2(n, byArray, 0);
            this.append(byArray);
        }

        public void appendInt4(int n) {
            byte[] byArray = new byte[4];
            CryptoServerUtil.store_int4(n, byArray, 0);
            this.append(byArray);
        }

        public void clear() {
            this.buf = null;
        }
    }

    public static class KeyStore {
        public static final int MODE_EQUAL = 0;
        public static final int MODE_GTEQ = 1;
        public static final int MODE_GREATER = 2;
        private CryptoServerDatabase sdb;

        public KeyStore(String string, int n) throws IOException, CryptoServerException {
            this.sdb = new CryptoServerDatabase(string, n);
        }

        public KeyStore(CryptoServerConfig cryptoServerConfig, int n) throws IOException, CryptoServerException {
            String string = cryptoServerConfig.getString("KeyStore", null);
            if (string == null) {
                throw new CryptoServerException(-1182728144);
            }
            this.sdb = new CryptoServerDatabase(string, n);
        }

        public int getIndexLength() throws CryptoServerException {
            return this.sdb.getIndexLength();
        }

        public boolean findKey(byte[] byArray, int n, KeyAttributes keyAttributes) throws CryptoServerException {
            byte[] byArray2;
            while ((byArray2 = this.sdb.find(n, byArray)) != null) {
                if (keyAttributes == null) {
                    return true;
                }
                Key key = new Key(byArray2);
                KeyAttributes keyAttributes2 = key.getAttributes();
                int n2 = keyAttributes.length();
                while (--n2 > 0) {
                    byte[] byArray3;
                    byte[] byArray4 = keyAttributes.get(n2);
                    if (byArray4 == null || (byArray3 = keyAttributes2.get(n2)) != null && Arrays.equals(byArray4, byArray3)) continue;
                    if (n != 0) break;
                    return false;
                }
                if (n2 == 0) {
                    return true;
                }
                n = 2;
            }
            return false;
        }

        public Key getKey(byte[] byArray) throws CryptoServerException {
            byte[] byArray2 = this.sdb.find(0, byArray);
            if (byArray2 == null) {
                throw new CryptoServerException(-1182728181);
            }
            return new Key(byArray2);
        }

        private static void inc(byte[] byArray) {
            int n = byArray.length;
            while (--n >= 0) {
                int n2 = n;
                byArray[n2] = (byte)(byArray[n2] + 1);
                if (byArray[n2] == 0) continue;
                return;
            }
        }

        public byte[] insertKey(int n, byte[] byArray, Key key) throws CryptoServerException {
            if (byArray == null) {
                byArray = new byte[this.sdb.getIndexLength()];
                while (this.sdb.find(0, byArray) != null) {
                    KeyStore.inc(byArray);
                }
            }
            try {
                this.sdb.insert(byArray, key.getEncoded());
            }
            catch (CryptoServerException cryptoServerException) {
                if ((n & 1) != 0 && cryptoServerException.ErrorCode == -1190264828) {
                    this.sdb.update(byArray, key.getEncoded());
                }
                throw cryptoServerException;
            }
            return byArray;
        }

        public void deleteKey(byte[] byArray) throws CryptoServerException {
            this.sdb.delete(byArray);
        }
    }

    public static class ECParameter {
        private BigInteger p;
        private int m;
        private BigInteger rp;
        private BigInteger a;
        private BigInteger b;
        private BigInteger gx;
        private BigInteger gy;
        private BigInteger n;
        private int h;
        private final byte[] prime_field = new byte[]{42, -122, 72, -50, 61, 1, 1};
        private final byte[] char2_field = new byte[]{42, -122, 72, -50, 61, 1, 2};
        private final byte[] normal_basis = new byte[]{42, -122, 72, -50, 61, 1, 2, 3, 1};
        private final byte[] trinom_basis = new byte[]{42, -122, 72, -50, 61, 1, 2, 3, 2};
        private final byte[] pentan_basis = new byte[]{42, -122, 72, -50, 61, 1, 2, 3, 3};
        static Map<String, byte[]> ecParamPool;
        private static final String ECURVE_DIR = "/ecurves/";

        public ECParameter(ECParameterSpec eCParameterSpec) throws CryptoServerException {
            this.h = eCParameterSpec.getCofactor();
            this.n = eCParameterSpec.getOrder();
            this.gx = eCParameterSpec.getGenerator().getAffineX();
            this.gy = eCParameterSpec.getGenerator().getAffineY();
            this.a = eCParameterSpec.getCurve().getA();
            this.b = eCParameterSpec.getCurve().getB();
            ECField eCField = eCParameterSpec.getCurve().getField();
            if (eCField instanceof ECFieldFp) {
                ECFieldFp eCFieldFp = (ECFieldFp)eCField;
                this.p = eCFieldFp.getP();
                this.rp = null;
                return;
            }
            if (eCField instanceof ECFieldF2m) {
                ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
                this.rp = eCFieldF2m.getReductionPolynomial();
                this.m = eCFieldF2m.getM();
                this.p = null;
                if (this.rp != null) {
                    return;
                }
            }
            throw new CryptoServerException(-1182728160);
        }

        public ECParameter(byte[] byArray) throws CryptoServerException {
            Object[] objectArray;
            int n;
            AsnBuffer asnBuffer = new AsnBuffer(byArray);
            asnBuffer = asnBuffer.getSEQ();
            if (asnBuffer.getINT(2).compareTo(BigInteger.ONE) != 0) {
                throw new CryptoServerException(-1182728160);
            }
            AsnBuffer asnBuffer2 = asnBuffer.getSEQ();
            byte[] byArray2 = asnBuffer2.getOID();
            if (Arrays.equals(byArray2, this.prime_field)) {
                this.p = asnBuffer2.getINT(2);
                this.rp = null;
            } else if (Arrays.equals(byArray2, this.char2_field)) {
                ECFieldF2m eCFieldF2m;
                this.p = null;
                asnBuffer2 = asnBuffer2.getSEQ();
                this.m = asnBuffer2.getINT(2).intValue();
                byArray2 = asnBuffer2.getOID();
                n = byArray2[byArray2.length - 1];
                switch (n) {
                    case 1: {
                        eCFieldF2m = new ECFieldF2m(this.m);
                        break;
                    }
                    case 2: {
                        objectArray = new int[]{asnBuffer2.getINT(2).intValue()};
                        eCFieldF2m = new ECFieldF2m(this.m, (int[])objectArray);
                        break;
                    }
                    case 3: {
                        asnBuffer2 = asnBuffer2.getSEQ();
                        objectArray = new int[3];
                        objectArray[2] = asnBuffer2.getINT(2).intValue();
                        objectArray[1] = asnBuffer2.getINT(2).intValue();
                        objectArray[0] = asnBuffer2.getINT(2).intValue();
                        eCFieldF2m = new ECFieldF2m(this.m, (int[])objectArray);
                        break;
                    }
                    default: {
                        throw new CryptoServerException(-1182728160);
                    }
                }
                this.rp = eCFieldF2m.getReductionPolynomial();
                if (this.rp == null) {
                    throw new CryptoServerException(-1182728160);
                }
            } else {
                throw new CryptoServerException(-1182728160);
            }
            asnBuffer2 = asnBuffer.getSEQ();
            this.a = asnBuffer2.getINT(4);
            this.b = asnBuffer2.getINT(4);
            byte[] byArray3 = asnBuffer.getOCT();
            if (byArray3[0] != 4) {
                throw new CryptoServerException(-1182728160);
            }
            n = byArray3.length - 1;
            if ((n & 1) != 0) {
                throw new CryptoServerException(-1182728160);
            }
            objectArray = new byte[n /= 2];
            System.arraycopy(byArray3, 1, objectArray, 0, n);
            this.gx = new BigInteger(1, (byte[])objectArray);
            System.arraycopy(byArray3, 1 + n, objectArray, 0, n);
            this.gy = new BigInteger(1, (byte[])objectArray);
            this.n = asnBuffer.getINT(2);
            this.h = asnBuffer.getINT(2).intValue();
        }

        public ECParameterSpec getSpec() {
            EllipticCurve ellipticCurve;
            ECField eCField = this.p == null ? new ECFieldF2m(this.m, this.rp) : new ECFieldFp(this.p);
            try {
                ellipticCurve = new EllipticCurve(eCField, this.a, this.b);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.a.signum() == 0 || this.b.signum() == 0) {
                    System.out.println("Sorry, this seems to be a known JAVA bug! Try to update your JAVA version.");
                }
                throw illegalArgumentException;
            }
            ECPoint eCPoint = new ECPoint(this.gx, this.gy);
            return new ECParameterSpec(ellipticCurve, eCPoint, this.n, this.h);
        }

        public byte[] getEncoded() throws CryptoServerException {
            byte[] byArray;
            Object object;
            Object object2;
            byte[] byArray2 = new byte[]{1};
            AsnBuffer asnBuffer = new AsnBuffer();
            asnBuffer.addItem(2, byArray2);
            AsnBuffer asnBuffer2 = new AsnBuffer();
            if (this.p != null) {
                asnBuffer2.addItem(6, this.prime_field);
                asnBuffer2.addINT(2, this.p);
            } else {
                asnBuffer2.addItem(6, this.char2_field);
                object2 = new ECFieldF2m(this.m, this.rp);
                AsnBuffer asnBuffer3 = new AsnBuffer();
                asnBuffer3.addINT(2, BigInteger.valueOf(this.m));
                object = ((ECFieldF2m)object2).getMidTermsOfReductionPolynomial();
                if (object == null) {
                    asnBuffer3.addItem(6, this.normal_basis);
                } else if (((int[])object).length == 1) {
                    asnBuffer3.addItem(6, this.trinom_basis);
                    asnBuffer3.addINT(2, BigInteger.valueOf(object[0]));
                } else if (((int[])object).length == 3) {
                    asnBuffer3.addItem(6, this.pentan_basis);
                    AsnBuffer asnBuffer4 = new AsnBuffer();
                    asnBuffer4.addINT(2, BigInteger.valueOf(object[2]));
                    asnBuffer4.addINT(2, BigInteger.valueOf(object[1]));
                    asnBuffer4.addINT(2, BigInteger.valueOf(object[0]));
                    asnBuffer3.addSEQ(asnBuffer4);
                } else {
                    throw new CryptoServerException(-1182728160);
                }
                asnBuffer2.addSEQ(asnBuffer3);
            }
            asnBuffer.addSEQ(asnBuffer2);
            object2 = new AsnBuffer();
            ((AsnBuffer)object2).addINT(4, this.a);
            ((AsnBuffer)object2).addINT(4, this.b);
            asnBuffer.addSEQ((AsnBuffer)object2);
            byte[] byArray3 = this.gx.toByteArray();
            while (byArray3.length > 1 && byArray3[0] == 0) {
                byArray = new byte[byArray3.length - 1];
                System.arraycopy(byArray3, 1, byArray, 0, byArray.length);
                byArray3 = byArray;
            }
            byte[] byArray4 = this.gy.toByteArray();
            while (byArray4.length > 1 && byArray4[0] == 0) {
                byArray = new byte[byArray4.length - 1];
                System.arraycopy(byArray4, 1, byArray, 0, byArray.length);
                byArray4 = byArray;
            }
            int n = byArray3.length;
            if (n < byArray4.length) {
                n = byArray4.length;
            }
            byArray = new byte[2 * n + 1];
            Arrays.fill(byArray, (byte)0);
            System.arraycopy(byArray3, 0, byArray, 1 + n - byArray3.length, byArray3.length);
            System.arraycopy(byArray4, 0, byArray, 1 + 2 * n - byArray4.length, byArray4.length);
            byArray[0] = 4;
            asnBuffer.addItem(4, byArray);
            asnBuffer.addINT(2, this.n);
            asnBuffer.addINT(2, BigInteger.valueOf(this.h));
            object = new AsnBuffer();
            ((AsnBuffer)object).addSEQ(asnBuffer);
            return ((AsnBuffer)object).getData();
        }

        public static byte[] getEncoded(Object object, String string) throws IOException {
            InputStream inputStream;
            byte[] byArray;
            if (ecParamPool == null) {
                ecParamPool = new HashMap<String, byte[]>();
            }
            if ((byArray = ecParamPool.get(string)) == null && (inputStream = object.getClass().getResourceAsStream(ECURVE_DIR + string)) != null) {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[512];
                while ((n = inputStream.read(byArray2)) > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                inputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
                ecParamPool.put(string, byArray);
            }
            return byArray;
        }
    }

    public static class ECPublicKey {
        ECPoint w;
        ECParameterSpec params;

        public ECPublicKey(ECPublicKeySpec eCPublicKeySpec) {
            this.w = eCPublicKeySpec.getW();
            this.params = eCPublicKeySpec.getParams();
        }

        public ECParameterSpec getParams() {
            return this.params;
        }

        public ECPoint getW() {
            return this.w;
        }

        public byte[] getEncoded() throws CryptoServerException {
            byte[] byArray = this.w.getAffineX().toByteArray();
            byte[] byArray2 = this.w.getAffineY().toByteArray();
            int n = byArray[0] == 0 ? 1 : 0;
            int n2 = byArray2[0] == 0 ? 1 : 0;
            int n3 = byArray.length - n;
            int n4 = byArray2.length - n2;
            int n5 = this.params.getCurve().getField().getFieldSize();
            int n6 = (n5 + 7) / 8;
            if (n3 > n6 || n4 > n6) {
                throw new CryptoServerException(-1182728160);
            }
            byte[] byArray3 = new byte[1 + 2 * n6];
            Arrays.fill(byArray3, (byte)0);
            System.arraycopy(byArray, n, byArray3, 1 + n6 - n3, n3);
            System.arraycopy(byArray2, n2, byArray3, byArray3.length - n4, n4);
            byArray3[0] = 4;
            return byArray3;
        }
    }

    public static class KeyAttAndComp {
        public KeyAttributes keyAttributes;
        public KeyComponents keyComponents;

        public KeyAttAndComp() {
        }

        public KeyAttAndComp(byte[] byArray, byte[] byArray2) throws CryptoServerException {
            this.keyAttributes = new KeyAttributes(byArray);
            this.keyComponents = new KeyComponents(byArray2);
        }
    }

    public static class MechParamCCM {
        public byte[] nonce;
        public byte[] ad;
        public int dataLen;
        public int macLen;

        public MechParamCCM(byte[] byArray, byte[] byArray2, int n, int n2) {
            this.nonce = byArray;
            this.ad = byArray2;
            this.dataLen = n;
            this.macLen = n2;
        }

        public byte[] getEncoded() {
            MechanismParameter mechanismParameter = new MechanismParameter();
            mechanismParameter.setCCM(this.nonce, this.ad, this.dataLen, this.macLen);
            return mechanismParameter.getEncoded();
        }
    }

    public static class MechParamGMAC {
        public byte[] iv_init;

        public MechParamGMAC(byte[] byArray) {
            this.iv_init = byArray;
        }

        public byte[] getEncoded() {
            MechanismParameter mechanismParameter = new MechanismParameter();
            mechanismParameter.setGMAC(this.iv_init);
            return mechanismParameter.getEncoded();
        }
    }

    public static class MechParamGCM {
        public byte[] iv_init;
        public byte[] ad;
        public int tag_bits;

        public MechParamGCM(byte[] byArray, byte[] byArray2, int n) {
            this.iv_init = byArray;
            this.ad = byArray2;
            this.tag_bits = n;
        }

        public byte[] getEncoded() {
            MechanismParameter mechanismParameter = new MechanismParameter();
            mechanismParameter.setGCM(this.iv_init, this.ad, this.tag_bits);
            return mechanismParameter.getEncoded();
        }
    }

    public static class MechParamECIES {
        int hash_algo;
        int crypt_algo;
        int crypt_mech;
        int crypt_len;
        int mac_algo;
        int mac_mech;
        int mac_len;
        byte[] secret1;
        byte[] secret2;

        public MechParamECIES(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte[] byArray, byte[] byArray2) {
            this.hash_algo = n;
            this.crypt_algo = n2;
            this.crypt_mech = n3;
            this.crypt_len = n4;
            this.mac_algo = n5;
            this.mac_mech = n6;
            this.mac_len = n7;
            this.secret1 = byArray;
            this.secret2 = byArray2;
        }

        public byte[] getEncoded() {
            MechanismParameter mechanismParameter = new MechanismParameter();
            mechanismParameter.setECIES(this.hash_algo, this.crypt_algo, this.crypt_mech, this.crypt_len, this.mac_algo, this.mac_mech, this.mac_len, this.secret1, this.secret2);
            return mechanismParameter.getEncoded();
        }
    }

    public static class MechParamPSS {
        public int md_algo;
        public int mgf_algo;
        public int salt_len;

        public MechParamPSS(int n, int n2, int n3) {
            this.md_algo = n;
            this.mgf_algo = n2;
            this.salt_len = n3;
        }

        public byte[] getEncoded() {
            MechanismParameter mechanismParameter = new MechanismParameter();
            mechanismParameter.setPSS(this.md_algo, this.mgf_algo, this.salt_len);
            return mechanismParameter.getEncoded();
        }
    }

    public static class MechParamOAEP {
        public int md_algo;
        public int mgf_algo;
        byte[] label;

        public MechParamOAEP(int n, int n2, byte[] byArray) {
            this.md_algo = n;
            this.mgf_algo = n2;
            this.label = byArray;
        }

        public byte[] getEncoded() {
            MechanismParameter mechanismParameter = new MechanismParameter();
            mechanismParameter.setOAEP(this.md_algo, this.mgf_algo, this.label);
            return mechanismParameter.getEncoded();
        }
    }

    public static class MechanismParameter {
        byte[] mechParam = null;

        public void setOAEP(int n, int n2, byte[] byArray) {
            int n3 = 10;
            if (byArray != null) {
                n3 += byArray.length;
            }
            this.mechParam = new byte[n3];
            CryptoServerUtil.store_int4(n, this.mechParam, 0);
            CryptoServerUtil.store_int4(n2, this.mechParam, 4);
            if (byArray != null) {
                CryptoServerUtil.store_int2(byArray.length, this.mechParam, 8);
                System.arraycopy(byArray, 0, this.mechParam, 10, byArray.length);
            } else {
                CryptoServerUtil.store_int2(0, this.mechParam, 8);
            }
        }

        public void setPSS(int n, int n2, int n3) {
            this.mechParam = new byte[12];
            CryptoServerUtil.store_int4(n, this.mechParam, 0);
            CryptoServerUtil.store_int4(n2, this.mechParam, 4);
            CryptoServerUtil.store_int4(n3, this.mechParam, 8);
        }

        public void setECIES(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte[] byArray, byte[] byArray2) {
            int n8 = 32;
            if (byArray != null) {
                n8 += byArray.length;
            }
            if (byArray2 != null) {
                n8 += byArray2.length;
            }
            this.mechParam = new byte[n8];
            CryptoServerUtil.store_int4(n, this.mechParam, 0);
            CryptoServerUtil.store_int4(n2, this.mechParam, 4);
            CryptoServerUtil.store_int4(n3, this.mechParam, 8);
            CryptoServerUtil.store_int4(n4, this.mechParam, 12);
            CryptoServerUtil.store_int4(n5, this.mechParam, 16);
            CryptoServerUtil.store_int4(n6, this.mechParam, 20);
            CryptoServerUtil.store_int4(n7, this.mechParam, 24);
            int n9 = 28;
            if (byArray != null) {
                CryptoServerUtil.store_int2(byArray.length, this.mechParam, n9);
                System.arraycopy(byArray, 0, this.mechParam, n9 += 2, byArray.length);
                n9 += byArray.length;
            } else {
                CryptoServerUtil.store_int2(0, this.mechParam, n9);
                n9 += 2;
            }
            if (byArray2 != null) {
                CryptoServerUtil.store_int2(byArray2.length, this.mechParam, n9);
                System.arraycopy(byArray2, 0, this.mechParam, n9 += 2, byArray2.length);
                n9 += byArray2.length;
            } else {
                CryptoServerUtil.store_int2(0, this.mechParam, n9);
                n9 += 2;
            }
        }

        public void setGCM(byte[] byArray, byte[] byArray2, int n) {
            int n2 = 14;
            if (byArray != null && byArray.length != 0) {
                n2 += byArray.length;
            }
            if (byArray2 != null) {
                n2 += byArray2.length;
            }
            this.mechParam = new byte[n2];
            CryptoServerUtil.store_int4(0, this.mechParam, 0);
            CryptoServerUtil.store_int4(0, this.mechParam, 4);
            this.mechParam[8] = (byte)n;
            int n3 = 9;
            if (byArray != null) {
                CryptoServerUtil.store_int2(byArray.length, this.mechParam, n3);
                System.arraycopy(byArray, 0, this.mechParam, n3 += 2, byArray.length);
                n3 += byArray.length;
            } else {
                CryptoServerUtil.store_int2(0, this.mechParam, n3);
                n3 += 2;
            }
            if (byArray2 != null) {
                CryptoServerUtil.store_int2(byArray2.length, this.mechParam, n3);
                System.arraycopy(byArray2, 0, this.mechParam, n3 += 2, byArray2.length);
                n3 += byArray2.length;
            } else {
                CryptoServerUtil.store_int2(0, this.mechParam, n3);
                n3 += 2;
            }
            this.mechParam[n2 - 1] = 0;
        }

        public void setCCM(byte[] byArray, byte[] byArray2, int n, int n2) {
            int n3 = 14;
            if (byArray != null) {
                n3 += byArray.length;
            }
            if (byArray2 != null) {
                n3 += byArray2.length;
            }
            this.mechParam = new byte[n3];
            CryptoServerUtil.store_int4(n, this.mechParam, 0);
            CryptoServerUtil.store_int4(byArray2 == null ? 0 : byArray2.length, this.mechParam, 4);
            this.mechParam[8] = (byte)n2;
            int n4 = 9;
            if (byArray != null) {
                CryptoServerUtil.store_int2(byArray.length, this.mechParam, n4);
                System.arraycopy(byArray, 0, this.mechParam, n4 += 2, byArray.length);
                n4 += byArray.length;
            } else {
                CryptoServerUtil.store_int2(0, this.mechParam, n4);
                n4 += 2;
            }
            if (byArray2 != null) {
                CryptoServerUtil.store_int2(byArray2.length, this.mechParam, n4);
                System.arraycopy(byArray2, 0, this.mechParam, n4 += 2, byArray2.length);
            } else {
                CryptoServerUtil.store_int2(0, this.mechParam, n4);
            }
            this.mechParam[n3 - 1] = 0;
        }

        public void setGMAC(byte[] byArray) {
            int n = 7;
            if (byArray != null && byArray.length != 0) {
                n += byArray.length;
            }
            this.mechParam = new byte[n];
            CryptoServerUtil.store_int4(0, this.mechParam, 0);
            if (byArray != null) {
                CryptoServerUtil.store_int2(byArray.length, this.mechParam, 4);
                System.arraycopy(byArray, 0, this.mechParam, 6, byArray.length);
            } else {
                CryptoServerUtil.store_int2(0, this.mechParam, 4);
            }
            this.mechParam[n - 1] = 0;
        }

        public byte[] getEncoded() {
            return this.mechParam;
        }
    }

    public static class KeyComponents {
        public static final byte[] TYPE_P = new byte[]{80, 32};
        public static final byte[] TYPE_Q = new byte[]{81, 32};
        public static final byte[] TYPE_DP = new byte[]{68, 80};
        public static final byte[] TYPE_DQ = new byte[]{68, 81};
        public static final byte[] TYPE_U = new byte[]{85, 32};
        public static final byte[] TYPE_SEXP = new byte[]{83, 69};
        public static final byte[] TYPE_PEXP = new byte[]{80, 69};
        public static final byte[] TYPE_MOD = new byte[]{77, 79};
        public static final byte[] TYPE_SK = new byte[]{83, 75};
        public static final byte[] TYPE_PK = new byte[]{80, 75};
        private byte[] kc;

        public KeyComponents() {
        }

        public KeyComponents(byte[] byArray) {
            this.kc = byArray;
        }

        public void add(byte[] byArray, byte[] byArray2) {
            this.kc = Item.mkItemList(null, this.kc, byArray, byArray2);
        }

        public void add(byte[] byArray, BigInteger bigInteger) {
            byte[] byArray2 = bigInteger.toByteArray();
            while (byArray2.length > 1 && byArray2[0] == 0) {
                byte[] byArray3 = new byte[byArray2.length - 1];
                System.arraycopy(byArray2, 1, byArray3, 0, byArray3.length);
                byArray2 = byArray3;
            }
            this.kc = Item.mkItemList(null, this.kc, byArray, byArray2);
        }

        public byte[] getList() {
            return this.kc;
        }

        public byte[] getItem(byte[] byArray) throws CryptoServerException {
            try {
                return Item.getItem(byArray, this.kc, 0);
            }
            catch (CryptoServerException cryptoServerException) {
                throw new CryptoServerException(-1182728182);
            }
        }
    }

    public static class KeyAttributes {
        public static final int PROP_KEY_GROUP = 1;
        public static final int PROP_KEY_NAME = 2;
        public static final int PROP_KEY_ALGO = 3;
        public static final int PROP_KEY_SIZE = 4;
        public static final int PROP_KEY_EXPORT = 5;
        public static final int PROP_KEY_USAGE = 6;
        public static final int PROP_KEY_MECHS = 7;
        public static final int PROP_KEY_SPEC = 8;
        public static final int PROP_KEY_LABEL = 9;
        public static final int PROP_KEY_BLEN = 10;
        public static final int PROP_KEY_UNAME = 11;
        public static final int PROP_KEY_TYPE = 12;
        public static final int PROP_KEY_DATE_GEN = 13;
        public static final int PROP_KEY_CERT = 14;
        public static final int PROP_KEY_DATE_EXP = 15;
        public static final int PROP_KEY_RSA_MOD = 20;
        public static final int PROP_KEY_RSA_EXP = 21;
        public static final int PROP_KEY_DSA_P = 25;
        public static final int PROP_KEY_DSA_Q = 26;
        public static final int PROP_KEY_DSA_G = 27;
        public static final int PROP_KEY_DSA_PUBKEY = 28;
        public static final int PROP_KEY_EC_CURVE = 30;
        public static final int PROP_KEY_EC_PUBKEY = 31;
        public static final int PROP_CFG_ALLOW_GROUPS = 90;
        public static final int PROP_CFG_CHECK_VALIDITY_PERIOD = 91;
        public static final int PROP_CFG_AUTH_PLAIN = 92;
        public static final int PROP_CFG_WRAP_POLICY = 93;
        public static final int PROP_CFG_AUTH_KEYM = 94;
        public static final int PROP_CFG_AUTH_USER = 95;
        public static final int PROP_CFG_SECURE_DERIVATION = 96;
        public static final int PROP_CFG_SECURE_IMPORT = 97;
        public static final int PROP_CFG_SECURE_RSA_COMPONENTS = 98;
        public static final int PROP_CFG_P11R2_BACKWARDS_COMPATIBLE = 99;
        public static final int PROP_CFG_ENFORCE_BLINDING = 100;
        public static final int PROP_CFG_SECURE_GROUP_BACKUP = 101;
        public static final int PROP_CFG_GROUP_BACKUP_PASS_HASH = 102;
        public static final int PROP_FIPS_KEY_USAGE_PADDING = 109;
        public static final int PROP_KEY_MAX = 110;
        private static final byte[] PROP_LIST1 = new byte[]{80, 76, 0, 0, 0, 20, 0, 2, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 12, 0, 0, 0, 13, 0, 0, 0, 15, 0, 0};
        private static final byte[] PROP_LIST2 = new byte[]{80, 76, 0, 0, 0, 92, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 5, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 9, 0, 0, 0, 10, 0, 0, 0, 11, 0, 0, 0, 12, 0, 0, 0, 13, 0, 0, 0, 14, 0, 0, 0, 15, 0, 0, 0, 20, 0, 0, 0, 21, 0, 0, 0, 25, 0, 0, 0, 26, 0, 0, 0, 27, 0, 0, 0, 28, 0, 0, 0, 30, 0, 0, 0, 31, 0, 0};
        private static final int[] PROP_LIST_COPY_RSA = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 14, 15};
        private static final int[] PROP_LIST_COPY_DSA = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 14, 15, 25, 26, 27};
        private static final int[] PROP_LIST_COPY_EC = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 14, 15, 30};
        private byte[][] attr;

        public KeyAttributes() {
            this.attr = new byte[128][];
        }

        public KeyAttributes(byte[] byArray, int n) throws CryptoServerException {
            int n2;
            if (byArray.length - n < 6 || byArray[n++] != 80 || byArray[n++] != 76 || (n2 = CryptoServerUtil.load_int4(byArray, n)) > byArray.length - n - 4) {
                throw new CryptoServerException(-1182728186);
            }
            n += 4;
            this.attr = new byte[126][];
            while (n2 > 0) {
                if (n2 < 4) {
                    throw new CryptoServerException(-1182728186);
                }
                int n3 = CryptoServerUtil.load_int2(byArray, n);
                int n4 = CryptoServerUtil.load_int2(byArray, n += 2);
                n += 2;
                if (n2 < 4 + n4) {
                    throw new CryptoServerException(-1182728186, "invalid length: " + Integer.toString(n4));
                }
                if (n3 < 110) {
                    if (n4 == 0) {
                        this.attr[n3] = null;
                    } else {
                        this.attr[n3] = new byte[n4];
                        System.arraycopy(byArray, n, this.attr[n3], 0, n4);
                    }
                }
                n += n4;
                n2 -= 4 + n4;
            }
        }

        public KeyAttributes(byte[] byArray) throws CryptoServerException {
            this(byArray, 0);
        }

        public KeyAttributes clone() {
            KeyAttributes keyAttributes = new KeyAttributes();
            for (int i = 0; i < 110; ++i) {
                if (this.attr[i] == null) continue;
                keyAttributes.attr[i] = (byte[])this.attr[i].clone();
            }
            return keyAttributes;
        }

        private KeyAttributes clone(int[] nArray) {
            KeyAttributes keyAttributes = new KeyAttributes();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (this.attr[n] == null) continue;
                keyAttributes.attr[n] = (byte[])this.attr[n].clone();
            }
            return keyAttributes;
        }

        public byte[] toByteArray() throws CryptoServerException {
            int n;
            int n2 = 0;
            int n3 = 0;
            for (n = 1; n < 110; ++n) {
                if (this.attr[n] == null) continue;
                n2 += 4 + this.attr[n].length;
            }
            byte[] byArray = new byte[n2];
            for (n = 1; n < 110; ++n) {
                if (this.attr[n] == null) continue;
                byArray[n3] = 0;
                byArray[n3 + 1] = (byte)n;
                CryptoServerUtil.store_int2(this.attr[n].length, byArray, n3 + 2);
                System.arraycopy(this.attr[n], 0, byArray, n3 += 4, this.attr[n].length);
                n3 += this.attr[n].length;
            }
            return byArray;
        }

        public int length() {
            return this.attr.length;
        }

        public byte[] get(int n) {
            return this.attr[n];
        }

        public void setInt(int n, int n2) {
            this.attr[n] = new byte[4];
            CryptoServerUtil.store_int4(n2, this.attr[n], 0);
        }

        public int getInt(int n, int n2) {
            if (this.attr[n] == null || this.attr[n].length != 4) {
                return n2;
            }
            return CryptoServerUtil.load_int4(this.attr[n], 0);
        }

        public void setBool(int n, boolean bl) {
            this.attr[n] = new byte[1];
            this.attr[n][0] = !bl ? (byte)0 : 1;
        }

        public boolean getBool(int n, boolean bl) {
            if (this.attr[n] == null || this.attr[n].length != 1) {
                return bl;
            }
            return this.attr[n][0] != 0;
        }

        public void setString(int n, String string) throws CryptoServerException {
            try {
                this.attr[n] = (byte[])(string == null ? null : (string.startsWith("{U}") ? string.substring(3).concat("\u0000").getBytes("UTF-16LE") : (string.startsWith("{Z}") ? string.substring(3).concat("\u0000").getBytes(CryptoServerCXI.CHARSET_NAME) : string.getBytes(CryptoServerCXI.CHARSET_NAME))));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CryptoServerException(-1182728189);
            }
        }

        public String getString(int n, String string) throws CryptoServerException {
            try {
                if (this.attr[n] == null) {
                    return string;
                }
                if (this.attr[n].length == 0) {
                    return "";
                }
                byte[] byArray = this.attr[n];
                if (byArray.length <= 2 || byArray[byArray.length - 1] != 0) {
                    return new String(byArray, CryptoServerCXI.CHARSET_NAME);
                }
                if (byArray[byArray.length - 2] != 0) {
                    String string2 = "{Z}" + new String(byArray, CryptoServerCXI.CHARSET_NAME);
                    return string2.substring(0, string2.length() - 1);
                }
                String string3 = "{U}" + new String(byArray, "UTF-16LE");
                return string3.substring(0, string3.length() - 1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CryptoServerException(-1182728189);
            }
        }

        private void setBI(int n, BigInteger bigInteger) {
            int n2;
            if (bigInteger.signum() == 0) {
                this.attr[n] = null;
                return;
            }
            byte[] byArray = bigInteger.toByteArray();
            for (n2 = 0; n2 < byArray.length && byArray[n2] == 0; ++n2) {
            }
            if (n2 > 0) {
                this.attr[n] = new byte[byArray.length - n2];
                System.arraycopy(byArray, n2, this.attr[n], 0, byArray.length - n2);
            } else {
                this.attr[n] = byArray;
            }
        }

        public void setAlgo(int n) {
            this.setInt(3, n);
        }

        public int getAlgo() {
            return this.getInt(3, 0);
        }

        public void setType(int n) {
            this.setInt(12, n);
        }

        public int getType() {
            return this.getInt(12, 0);
        }

        public void setSize(int n) {
            this.setInt(4, n);
        }

        public int getSize() {
            return this.getInt(4, 0);
        }

        public void setExport(int n) {
            this.setInt(5, n);
        }

        public int getExport() {
            return this.getInt(5, 0);
        }

        public void setUsage(int n) {
            this.setInt(6, n);
        }

        public int getUsage() {
            return this.getInt(6, 0);
        }

        public void setLabel(String string) throws CryptoServerException {
            this.setString(9, string);
        }

        public String getLabel() throws CryptoServerException {
            return this.getString(9, null);
        }

        public void setExponent(byte[] byArray) {
            this.attr[21] = byArray;
        }

        public void setExponent(BigInteger bigInteger) {
            this.setBI(21, bigInteger);
        }

        public byte[] getExponent() {
            return this.attr[21];
        }

        public void setModulus(byte[] byArray) {
            this.attr[20] = byArray;
        }

        public void setModulus(BigInteger bigInteger) {
            this.setBI(20, bigInteger);
        }

        public byte[] getModulus() {
            return this.attr[20];
        }

        public void setParamP(byte[] byArray) {
            this.attr[25] = byArray;
        }

        public void setParamP(BigInteger bigInteger) {
            this.setBI(25, bigInteger);
        }

        public byte[] getParamP() {
            return this.attr[25];
        }

        public void setParamQ(byte[] byArray) {
            this.attr[26] = byArray;
        }

        public void setParamQ(BigInteger bigInteger) {
            this.setBI(26, bigInteger);
        }

        public byte[] getParamQ() {
            return this.attr[26];
        }

        public void setParamG(byte[] byArray) {
            this.attr[27] = byArray;
        }

        public void setParamG(BigInteger bigInteger) {
            this.setBI(27, bigInteger);
        }

        public byte[] getParamG() {
            return this.attr[27];
        }

        public void setDSAPub(byte[] byArray) {
            this.attr[28] = byArray;
        }

        public void setDSAPub(BigInteger bigInteger) {
            this.setBI(28, bigInteger);
        }

        public byte[] getDSAPub() {
            return this.attr[28];
        }

        public void setCurve(String string) throws CryptoServerException {
            this.setString(30, string);
        }

        public void setCurve(byte[] byArray) {
            this.attr[30] = byArray;
        }

        public void setCurve(ECParameterSpec eCParameterSpec) throws CryptoServerException {
            ECParameter eCParameter = new ECParameter(eCParameterSpec);
            this.attr[30] = eCParameter.getEncoded();
        }

        public byte[] getCurve() {
            return this.attr[30];
        }

        public byte[] getCurveEncoded() throws IOException, CryptoServerException {
            byte[] byArray = this.attr[30];
            if (byArray[0] == 48) {
                return byArray;
            }
            try {
                byArray = ECParameter.getEncoded(this, new String(byArray, CryptoServerCXI.CHARSET_NAME));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CryptoServerException(-1182728189);
            }
            if (byArray == null) {
                throw new CryptoServerException(-1182728179);
            }
            return byArray;
        }

        public void setECPub(byte[] byArray) {
            this.attr[31] = byArray;
        }

        public void setECPub(BigInteger bigInteger) {
            this.setBI(31, bigInteger);
        }

        public byte[] getECPub() {
            return this.attr[31];
        }

        public void setName(String string) throws CryptoServerException {
            if (string != null && string.length() == 0) {
                throw new CryptoServerException(-1182728191);
            }
            this.setString(2, string);
        }

        public String getName() throws CryptoServerException {
            return this.getString(2, null);
        }

        public void setGroup(String string) throws CryptoServerException {
            this.setString(1, string);
        }

        public String getGroup() throws CryptoServerException {
            return this.getString(1, null);
        }

        public void setSpecifier(int n) {
            if (n < 0) {
                return;
            }
            this.setInt(8, n);
        }

        public int getSpecifier() {
            if (this.attr[8] == null) {
                return -1;
            }
            return CryptoServerUtil.load_int4(this.attr[8], 0);
        }

        private void setDate(Date date, int n) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            gregorianCalendar.setTime(date);
            byte[] byArray = new byte[13];
            byArray[1] = (byte)(gregorianCalendar.get(1) % 100);
            byArray[3] = (byte)(gregorianCalendar.get(2) + 1);
            byArray[5] = (byte)gregorianCalendar.get(5);
            byArray[7] = (byte)gregorianCalendar.get(11);
            byArray[9] = (byte)gregorianCalendar.get(12);
            byArray[11] = (byte)gregorianCalendar.get(13);
            byArray[12] = 90;
            for (int i = 0; i < 12; i += 2) {
                byArray[i] = (byte)(byArray[i + 1] / 10 + 48);
                byArray[i + 1] = (byte)(byArray[i + 1] % 10 + 48);
            }
            this.attr[n] = byArray;
        }

        public void setGenerationDate(Date date) {
            this.setDate(date, 13);
        }

        public void setGenerationDate(byte[] byArray) {
            this.attr[13] = byArray;
        }

        public void setExpirationDate(Date date) {
            this.setDate(date, 15);
        }

        public void setExpirationDate(byte[] byArray) {
            this.attr[15] = byArray;
        }

        private Date getDate(int n) {
            byte[] byArray = this.attr[n];
            int[] nArray = new int[7];
            if (byArray == null || byArray.length != 13 && byArray.length != 15 || byArray[byArray.length - 1] != 90) {
                return null;
            }
            nArray[0] = 20;
            int n2 = 6;
            for (int i = byArray.length - 3; i >= 0; i -= 2) {
                if (byArray[i] < 48 || byArray[i] > 57 || byArray[i + 1] < 48 || byArray[i + 1] > 57) {
                    return null;
                }
                nArray[n2--] = byArray[i] % 16 * 10 + byArray[i + 1] % 16;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            gregorianCalendar.set(nArray[0] * 100 + nArray[1], nArray[2] - 1, nArray[3], nArray[4], nArray[5], nArray[6]);
            return gregorianCalendar.getTime();
        }

        public Date getGenerationDate() {
            return this.getDate(13);
        }

        public Date getExpirationDate() {
            return this.getDate(15);
        }

        public void setCertificate(byte[] byArray) {
            this.attr[14] = byArray;
        }

        public byte[] getCertificate() {
            return this.attr[14];
        }

        public void setMechs(int[] nArray) throws CryptoServerException, UnsupportedEncodingException {
            if (nArray == null) {
                return;
            }
            if (nArray.length > 255) {
                throw new CryptoServerException(-1182728112);
            }
            int n = 2 + nArray.length * 4;
            byte[] byArray = new byte[n];
            byArray[0] = 67;
            byArray[1] = (byte)nArray.length;
            for (int i = 0; i < nArray.length; ++i) {
                CryptoServerUtil.store_int4(nArray[i], byArray, 2 + i * 4);
            }
            this.attr[7] = byArray;
        }

        public byte[] getMechs() {
            return this.attr[7];
        }

        public void setFIPSUsage(int n) {
            this.setInt(109, n);
        }

        public int getFIPSUsage() {
            return this.getInt(109, 0);
        }
    }

    public static class KeyFile {
        private static final char Newline = '\n';
        private static final String RSATAG = "# RSA key";
        private static final String MOD = "MOD=";
        private static final String PEXP = "PEXP=";

        public static void write(KeyAttributes keyAttributes, String string) throws IOException {
            FileWriter fileWriter = new FileWriter(string);
            switch (keyAttributes.getAlgo()) {
                case 3: {
                    fileWriter.write(RSATAG);
                    fileWriter.write(10);
                    if (keyAttributes.getModulus().length > 0) {
                        fileWriter.write(MOD);
                        fileWriter.write(KeyFile.binToChar(keyAttributes.getModulus()));
                        fileWriter.write(10);
                    }
                    if (keyAttributes.getExponent().length <= 0) break;
                    fileWriter.write(PEXP);
                    fileWriter.write(KeyFile.binToChar(keyAttributes.getExponent()));
                    fileWriter.write(10);
                    break;
                }
                case 4: {
                    break;
                }
            }
            fileWriter.close();
        }

        private static char[] binToChar(byte[] byArray) {
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            char[] cArray2 = new char[2 * byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                cArray2[2 * i] = cArray[byArray[i] >> 4 & 0xF];
                cArray2[2 * i + 1] = cArray[byArray[i] & 0xF];
            }
            return cArray2;
        }
    }

    public static class Key {
        byte[] value;
        boolean handle;

        public Key(byte[] byArray) throws CryptoServerException {
            if (byArray.length < 8 || byArray[0] != 75 || byArray[1] != 32) {
                throw new CryptoServerException(-1182728188);
            }
            if (byArray[6] == 75 && byArray[7] == 72) {
                this.handle = true;
            } else if ((byArray[6] == 66 || byArray[6] == 75) && byArray[7] == 66) {
                this.handle = false;
            } else {
                throw new CryptoServerException(-1182728188);
            }
            this.value = byArray;
        }

        public boolean isHandle() {
            return this.handle;
        }

        public byte[] getEncoded() {
            return this.value;
        }

        public KeyAttributes getAttributes() throws CryptoServerException {
            byte[] byArray;
            if (this.handle) {
                throw new CryptoServerException(-1182728188);
            }
            byte[] byArray2 = Item.getItem(TAG_K, this.value, 0);
            try {
                byArray = Item.getItem(TAG_BB, byArray2, 0);
            }
            catch (CryptoServerException cryptoServerException) {
                if (cryptoServerException.ErrorCode == -1182728174) {
                    byArray = Item.getItem(TAG_KB, byArray2, 0);
                }
                throw cryptoServerException;
            }
            int n = Item.findItem(TAG_PL, byArray, 0);
            int n2 = CryptoServerUtil.load_int4(byArray, n + 2);
            byte[] byArray3 = new byte[6 + n2];
            System.arraycopy(byArray, n, byArray3, 0, 6 + n2);
            return new KeyAttributes(byArray3);
        }

        public byte[] getUName() throws NoSuchAlgorithmException, CryptoServerException {
            byte[] byArray;
            if (this.handle) {
                byte[] byArray2 = Item.getItem(TAG_K, this.value, 0);
                return Item.getItem(TAG_KH, byArray2, 0);
            }
            KeyAttributes keyAttributes = this.getAttributes();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray3 = keyAttributes.get(2);
            messageDigest.update(byArray3, 0, byArray3.length);
            byte[] byArray4 = keyAttributes.get(1);
            if (byArray4 != null) {
                messageDigest.update(byArray4, 0, byArray4.length);
            }
            if ((byArray = keyAttributes.get(8)) != null) {
                messageDigest.update(byArray, 0, byArray.length);
            }
            return messageDigest.digest();
        }
    }

    static class EventHandler
    implements CryptoServerCluster.EventHandler {
        EventHandler() {
        }

        public void stateChanged(String string, int n) {
            CxiLog.print("CryptoServer.EventHandler", "I: state of " + string + " changed to: " + (Object)((Object)CryptoServerCluster.DeviceState.valueOf(n)), new Object[0]);
        }

        public void errorOccurred(String string, int n, String string2, String string3) {
            CxiLog.print("CryptoServer.EventHandler", "E: error occurred on " + string + " at " + string2 + "\n\tcode: 0x" + Integer.toHexString(n) + "\n\tmessage: " + string3, new Object[0]);
        }
    }
}

