/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerAPI;

import CryptoServerAPI.CryptoServerConfig;
import CryptoServerAPI.CryptoServerUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;

public class CryptoServerLog {
    public static final int LOG_LEVEL_NONE = 0;
    public static final int LOG_LEVEL_ERROR = 1;
    public static final int LOG_LEVEL_WARNING = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_TRACE = 4;
    public static final int LOG_DEF_SIZE = 1000000;
    private String logfile;
    private int loglevel;
    private int logsize;

    public void init(String string, int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n > 4) {
            n = 4;
        }
        if (n2 < 0) {
            n2 = 1000000;
        }
        this.logfile = string;
        this.loglevel = n;
        this.logsize = n2;
    }

    public void init(String string, LogLevel logLevel, int n) {
        this.init(string, logLevel.intValue(), n);
    }

    public void init(CryptoServerConfig cryptoServerConfig) {
        this.init(cryptoServerConfig.getString("LogFile", "CryptoServer.log"), cryptoServerConfig.getInt("LogLevel", 2), cryptoServerConfig.getInt("LogSize", 1000000));
    }

    public CryptoServerLog() {
        this.init("./CryptoServer.log", 2, 1000000);
    }

    public CryptoServerLog(String string, int n, int n2) {
        this.init(string, n, n2);
    }

    public CryptoServerLog(String string, LogLevel logLevel, int n) {
        this.init(string, logLevel.intValue(), n);
    }

    public CryptoServerLog(CryptoServerConfig cryptoServerConfig) {
        this.init(cryptoServerConfig);
    }

    private File open() {
        File file = new File(this.logfile);
        if (this.logsize > 0 && file.length() >= (long)this.logsize) {
            file.renameTo(new File(file.getAbsolutePath() + ".bak"));
            file = new File(this.logfile);
        }
        return file;
    }

    public void print(String string, String string2, Object ... objectArray) {
        if (string2 != null) {
            switch (string2.charAt(0)) {
                case 'T': {
                    if (this.loglevel >= 4) break;
                    return;
                }
                case 'I': {
                    if (this.loglevel >= 3) break;
                    return;
                }
                case 'W': {
                    if (this.loglevel >= 2) break;
                    return;
                }
                case 'E': {
                    if (this.loglevel >= 1) break;
                    return;
                }
            }
        }
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        long l = Thread.currentThread().getId();
        try {
            File file = this.open();
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            String string3 = dateFormat.format(date);
            String string4 = String.format(string2, objectArray);
            String string5 = String.format("%-20s | [%016X] %-32s | %s\n", string3, l, string, string4);
            fileOutputStream.write(string5.getBytes());
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void xtrace(String string, String string2, byte[] byArray) {
        if (string2 != null) {
            switch (string2.charAt(0)) {
                case 'T': {
                    if (this.loglevel >= 4) break;
                    return;
                }
                case 'I': {
                    if (this.loglevel >= 3) break;
                    return;
                }
                case 'W': {
                    if (this.loglevel >= 2) break;
                    return;
                }
                case 'E': {
                    if (this.loglevel >= 1) break;
                    return;
                }
            }
        }
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        long l = Thread.currentThread().getId();
        try {
            File file = this.open();
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            String string3 = dateFormat.format(date);
            String string4 = String.format("%-20s | [%016X] %-32s | %s\n", string3, l, string, string2);
            fileOutputStream.write(string4.getBytes());
            if (byArray != null) {
                CryptoServerUtil.xtrace(new PrintStream(fileOutputStream), byArray);
            } else {
                fileOutputStream.write("null\n".getBytes());
            }
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogLevel {
        None(0),
        Error(1),
        Warning(2),
        Info(3),
        Trace(4);

        private int level;

        private LogLevel(int n2) {
            this.level = n2;
        }

        public int intValue() {
            return this.level;
        }

        public static LogLevel valueOf(int n) {
            return LogLevel.values()[n];
        }
    }
}

