/*
 * Decompiled with CFR 0.152.
 */
package cat;

import cat.CAT;
import cat.CSJApi;
import cat.ChooseTokenCore;
import cat.CloneWizard;
import cat.Global;
import cat.Tools;
import cat.ToolsThread;
import cat.UserLoginPwd;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class UserLogin
extends JDialog {
    Tools tools = new Tools();
    static ToolsThread tools_thread = new ToolsThread();
    static String strCSListUserReply = null;
    static String strCSLoginReply = null;
    int LoginStatus = 0;
    Object[] rowData = new Object[5];
    boolean b_first = true;
    boolean b_login_dlg_ok = true;
    boolean b_changeToken = false;
    CAT admin;
    String[] columnNames = new String[]{"Login Status", "User Name", "Permission", "Mechanism", "Attributes"};
    String strListLoginUser = "ListLoginUser";
    String strUserLogoff = "UserLogoff";
    String strIsDlgAlive = "IsDlgAlive";
    String str_user_name;
    String str_login_mech;
    String strHashAlgo;
    int log_mechanism = -1;
    String strLoggedIn = "LOGGED IN";
    String strNotLoggedIn = "-----";
    String strDlgTitleChangeUser = "Choose New User Token";
    String strNewUserTokenPwd = "";
    CloneWizard wiz = null;
    String strCSReply;
    String strCSReply2;
    String strCSReply3;
    String strUserToken;
    String strUserKeyfilePwd;
    boolean b_ChooseTokenCore_Cancel = true;
    String strPPInfo = "Information about PIN pad dialogs\r\n   1. insert user smartcard for authorization and press confirmation key\r\n   2. type in PIN  for user smartcard and press confirmation key\r\n   --- Ready ---\r\n\r\n   To cancel operation press abort key at PIN pad";
    String strPPInfoRSASC = "Information about PIN pad dialogs\r\n   Please connect the PIN pad direct to the CryptoServer port\r\n\r\n   1. insert user smartcard for authorization and press confirmation key\r\n   2. type in PIN  for user smartcard and press confirmation key\r\n   --- Ready ---\r\n\r\n   To cancel operation press abort key at PIN pad";
    String strRSASign = "RSA Sign";
    String strClearPwd = "Clear Password";
    String strSHA1Pwd = "SHA-1 Password";
    String strRSASC = "RSA Smartcard";
    String strHMAC = "HMAC Password";
    String strECDSA = "ECDSA Sign";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanelNorth = null;
    private JPanel jPanelSouth = null;
    private JPanel jPanelWest = null;
    private JPanel jPanelEast = null;
    private JPanel jPanelCenter = null;
    private JButton jBtClose = null;
    private JButton jBtLogoff = null;
    private JButton jBtLogin = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    DefaultTableModel model = new DefaultTableModel(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    DefaultTableCellRenderer cellren = new DefaultTableCellRenderer(){
        private static final long serialVersionUID = 1L;

        @Override
        public void setValue(Object object) {
            if (object instanceof Icon) {
                this.setIcon((Icon)object);
                this.setText("");
            } else {
                this.setIcon(null);
                super.setValue(object);
            }
        }
    };

    public UserLogin(CAT cAT) {
        super(cAT);
        this.setPreferredSize(new Dimension(430, 245));
        this.admin = cAT;
        this.initialize();
        this.listUser();
    }

    public UserLogin(CAT cAT, String string, CloneWizard cloneWizard) {
        super(cAT);
        this.admin = cAT;
        this.wiz = cloneWizard;
        this.initialize();
        this.listUser();
        this.setTitle(string);
    }

    private void initialize() {
        this.setSize(430, 250);
        this.setTitle("Login/Logoff User");
        this.setResizable(true);
        this.setContentPane(this.getJContentPane());
        this.jBtLogin.setVisible(true);
        this.jBtLogoff.setVisible(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setPreferredSize(new Dimension(430, 245));
            this.jContentPane.add((Component)this.getJPanelNorth(), "North");
            this.jContentPane.add((Component)this.getJPanelSouth(), "South");
            this.jContentPane.add((Component)this.getJPanelWest(), "West");
            this.jContentPane.add((Component)this.getJPanelEast(), "East");
            this.jContentPane.add((Component)this.getJPanelCenter(), "Center");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserLogin.this.setVisible(false);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.jContentPane.registerKeyboardAction(actionListener, keyStroke, 2);
            WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    UserLogin.this.dispose();
                }
            };
            this.addWindowListener(windowAdapter);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelNorth() {
        if (this.jPanelNorth == null) {
            this.jPanelNorth = new JPanel();
            this.jPanelNorth.setLayout(new FlowLayout());
            this.jPanelNorth.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelNorth;
    }

    private JPanel getJPanelSouth() {
        if (this.jPanelSouth == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanelSouth = new JPanel();
            this.jPanelSouth.setLayout(flowLayout);
            this.jPanelSouth.add((Component)this.getJBtLogin(), null);
            this.jPanelSouth.add((Component)this.getJBtLogoff(), null);
            this.jPanelSouth.add((Component)this.getJBtClose(), null);
        }
        return this.jPanelSouth;
    }

    private JPanel getJPanelWest() {
        if (this.jPanelWest == null) {
            this.jPanelWest = new JPanel();
            this.jPanelWest.setLayout(new FlowLayout());
            this.jPanelWest.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelWest;
    }

    private JPanel getJPanelEast() {
        if (this.jPanelEast == null) {
            this.jPanelEast = new JPanel();
            this.jPanelEast.setLayout(new FlowLayout());
            this.jPanelEast.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelEast;
    }

    private JPanel getJPanelCenter() {
        if (this.jPanelCenter == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.weightx = 1.0;
            this.jPanelCenter = new JPanel();
            this.jPanelCenter.setLayout(new GridBagLayout());
            this.jPanelCenter.setPreferredSize(new Dimension(450, 165));
            this.jPanelCenter.setFont(new Font("Dialog", 0, 11));
            this.jPanelCenter.add((Component)this.getJScrollPane(), gridBagConstraints);
        }
        return this.jPanelCenter;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(720, 165));
            this.jScrollPane.setFont(new Font("Dialog", 0, 11));
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JButton getJBtClose() {
        if (this.jBtClose == null) {
            this.jBtClose = new JButton();
            this.jBtClose.setText("Close");
            this.jBtClose.setToolTipText(null);
            this.jBtClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserLogin.this.dispose();
                }
            });
        }
        return this.jBtClose;
    }

    private JButton getJBtLogoff() {
        if (this.jBtLogoff == null) {
            this.jBtLogoff = new JButton();
            this.jBtLogoff.setText("Logoff All...");
            this.jBtLogoff.setToolTipText(null);
            this.jBtLogoff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "Do you want to logoff all user and end the session?";
                    int n = UserLogin.this.tools.DisplayYesNoMsg(UserLogin.this, string);
                    if (n != 0) {
                        return;
                    }
                    UserLogin.this.logoffUser();
                }
            });
        }
        return this.jBtLogoff;
    }

    private JButton getJBtLogin() {
        if (this.jBtLogin == null) {
            this.jBtLogin = new JButton();
            this.jBtLogin.setText("Login...");
            this.jBtLogin.setToolTipText(null);
            this.jBtLogin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserLogin.this.prepareLogin();
                }
            });
        }
        return this.jBtLogin;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable(this.model);
            this.jTable.setDefaultRenderer(Object.class, this.cellren);
            this.jTable.setRowHeight(19);
            this.jTable.setSize(new Dimension(720, 165));
            this.jTable.setFont(new Font("Dialog", 0, 11));
            this.jTable.setSelectionMode(0);
            this.jTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == 'l') {
                        UserLogin.this.prepareLogin();
                    }
                }
            });
            this.jTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() > 1) {
                        UserLogin.this.prepareLogin();
                    }
                }
            });
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
            this.jTable.getInputMap(1).put(keyStroke, "none");
            this.jTable.getTableHeader().setReorderingAllowed(false);
        }
        return this.jTable;
    }

    public void logoffUser() {
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            byte[] cs_reply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                UserLogin.this.strCSReply3 = CSJApi.CSSMLogoff();
                UserLogin.this.strCSReply2 = CSJApi.CSShowAuthState();
                this.cs_reply = CSJApi.CSListUser();
                UserLogin.this.strCSReply = UserLogin.this.tools.convertByteToString(this.cs_reply);
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                UserLogin.this.finalInit(UserLogin.this.strCSReply, UserLogin.this.strCSReply2, UserLogin.this.strCSReply3);
                tools_thread.setStatusBar();
            }
        };
        swingWorker.execute();
    }

    public void listUser() {
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            byte[] cs_reply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                UserLogin.this.strCSReply2 = CSJApi.CSShowAuthState();
                this.cs_reply = CSJApi.CSListUser();
                UserLogin.this.strCSReply = UserLogin.this.tools.convertByteToString(this.cs_reply);
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (UserLogin.this.strCSReply.indexOf("Error") == 0) {
                    if (UserLogin.this.strCSReply.contains("B90C0008")) {
                        CSJApi.CSClose();
                        CSJApi.CSOpen(Global.strCurrentCSAddr);
                    } else {
                        UserLogin.this.tools.DisplayErrorMsg(UserLogin.this, UserLogin.this.strCSReply);
                        return;
                    }
                }
                if (UserLogin.this.strCSReply2.indexOf("Error") == 0) {
                    UserLogin.this.tools.DisplayErrorMsg(UserLogin.this, UserLogin.this.strCSReply2);
                    return;
                }
                UserLogin.this.finalInit(UserLogin.this.strCSReply, UserLogin.this.strCSReply2, "");
                tools_thread.setStatusBar();
            }
        };
        swingWorker.execute();
    }

    public void showUser() {
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            byte[] cs_reply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                tools_thread.Sleep(200);
                UserLogin.this.strCSReply2 = CSJApi.CSShowAuthState();
                this.cs_reply = CSJApi.CSListUser();
                UserLogin.this.strCSReply = UserLogin.this.tools.convertByteToString(this.cs_reply);
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (UserLogin.this.strCSReply.indexOf("Error") == 0) {
                    UserLogin.this.tools.DisplayErrorMsg(UserLogin.this, UserLogin.this.strCSReply);
                } else {
                    UserLogin.this.finalInit(UserLogin.this.strCSReply, UserLogin.this.strCSReply2, "");
                    tools_thread.setStatusBar();
                }
            }
        };
        swingWorker.execute();
    }

    public void finalInit(String string, String string2, String string3) {
        String string4;
        if (this.tools.fipsErrorState(this, string, "User Login")) {
            this.dispose();
        }
        String string5 = string2.substring(8);
        this.cleanTable();
        if (this.b_first) {
            this.model.addColumn(this.columnNames[0]);
            this.model.addColumn(this.columnNames[1]);
            this.model.addColumn(this.columnNames[2]);
            this.model.addColumn(this.columnNames[3]);
            this.model.addColumn(this.columnNames[4]);
            this.b_first = false;
        }
        this.jTable.getColumn("Mechanism").setMinWidth(0);
        this.jTable.getColumn("Mechanism").setMaxWidth(0);
        this.jTable.getColumn("Attributes").setMinWidth(0);
        this.jTable.getColumn("Attributes").setMaxWidth(0);
        if (this.b_changeToken) {
            this.jTable.getColumn("Login Status").setMinWidth(0);
            this.jTable.getColumn("Login Status").setMaxWidth(0);
            this.jTable.getColumn("Permission").setMinWidth(0);
            this.jTable.getColumn("Permission").setMaxWidth(0);
            this.jTable.getColumn("User Name").setMinWidth(450);
        } else {
            this.jTable.getColumn("Login Status").setMinWidth(100);
            this.jTable.getColumn("Login Status").setMaxWidth(150);
            this.jTable.getColumn("User Name").setMinWidth(150);
            this.jTable.getColumn("Permission").setMinWidth(100);
            this.jTable.getColumn("Permission").setMaxWidth(150);
        }
        if (string == null) {
            this.dispose();
            return;
        }
        if (string3.indexOf("Error") == 0) {
            this.tools.DisplayErrorMsg(this, string3);
        }
        if (string.indexOf("Error") == 0) {
            this.dispose();
            return;
        }
        int n = 0;
        this.LoginStatus = 0;
        for (int i = string.length(); i != 0; i -= string4.length() + 2) {
            int n2 = string.indexOf(";;", n);
            if (n2 == -1) {
                return;
            }
            this.rowData[1] = string.substring(n, n2);
            n = n2 += 2;
            i -= this.rowData[1].toString().length() + 2;
            n2 = string.indexOf(";;", n);
            if (n2 == -1) {
                return;
            }
            this.rowData[2] = string.substring(n, n2).toUpperCase();
            n = n2 += 2;
            i -= this.rowData[2].toString().length() + 2;
            n2 = string.indexOf(";;", n);
            if (n2 == -1) {
                return;
            }
            if (this.checkLogin(string5, this.rowData[1].toString())) {
                this.rowData[0] = new ImageIcon(this.getClass().getResource("/ok.png"));
                ++this.LoginStatus;
            } else {
                this.rowData[0] = new ImageIcon(this.getClass().getResource("/cancel.png"));
            }
            string4 = string.substring(n, n2);
            this.rowData[3] = string4;
            n = n2 += 2;
            i -= string4.toString().length() + 2;
            n2 = string.indexOf(";;", n);
            if (n2 == -1) {
                return;
            }
            string4 = string.substring(n, n2);
            n = n2 += 2;
            i -= string4.length() + 2;
            n2 = string.indexOf(";;", n);
            if (n2 == -1) {
                return;
            }
            this.rowData[4] = string.substring(n, n2);
            string4 = string.substring(n, n2);
            n = n2 += 2;
            this.model.addRow(this.rowData);
        }
        this.jTable.setRowSelectionInterval(0, 0);
    }

    boolean loginRSASmartCard_step1(String string, int n) {
        ChooseTokenCore chooseTokenCore = new ChooseTokenCore(this.admin, this, "Choose User Token for Login", this.strPPInfoRSASC, string, false);
        chooseTokenCore.setLocationRelativeTo(this);
        chooseTokenCore.setModal(true);
        chooseTokenCore.pack();
        chooseTokenCore.setVisible(true);
        return !this.b_ChooseTokenCore_Cancel;
    }

    public void loginRSASmartCard_step2() {
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                this.strCSReply = CSJApi.CSSMLoginRSASC(UserLogin.this.str_user_name, 0);
                tools_thread.Sleep(200);
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (this.strCSReply.compareTo("") != 0) {
                    if (this.strCSReply.indexOf("B0860021") != -1) {
                        this.strCSReply = this.strCSReply + "\r\nPlease use the command -Setup CryptoServer- !";
                    }
                    UserLogin.this.tools.DisplayErrorMsg(UserLogin.this, this.strCSReply);
                }
                UserLogin.this.showUser();
            }
        };
        swingWorker.execute();
    }

    boolean loginRSASignECDSA_step1(String string, int n) {
        ChooseTokenCore chooseTokenCore = new ChooseTokenCore(this.admin, this, "Choose User Token for Login", this.strPPInfo, string, true);
        chooseTokenCore.setLocationRelativeTo(this);
        chooseTokenCore.setModal(true);
        chooseTokenCore.pack();
        chooseTokenCore.setVisible(true);
        return !this.b_ChooseTokenCore_Cancel;
    }

    public void loginRSASignECDSA_step2() {
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                tools_thread.Sleep(100);
                this.strCSReply = CSJApi.CSSMUserLoginEx(UserLogin.this.str_user_name, UserLogin.this.strUserToken, UserLogin.this.strUserKeyfilePwd, UserLogin.this.log_mechanism, 0);
                tools_thread.Sleep(200);
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (this.strCSReply.compareTo("") != 0) {
                    if (this.strCSReply.indexOf("B0860021") != -1) {
                        this.strCSReply = this.strCSReply + "\r\nPlease use the command -Setup CryptoServer- !";
                    }
                    UserLogin.this.tools.DisplayErrorMsg(UserLogin.this, this.strCSReply);
                }
                UserLogin.this.showUser();
            }
        };
        swingWorker.execute();
    }

    void loginPwd() {
        UserLoginPwd userLoginPwd = new UserLoginPwd(this, this.admin, this.str_user_name, this.str_login_mech);
        userLoginPwd.setLocationRelativeTo(this);
        userLoginPwd.setModal(true);
        userLoginPwd.pack();
        userLoginPwd.setVisible(true);
    }

    private void prepareLogin() {
        boolean bl;
        ListSelectionModel listSelectionModel = this.jTable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n == -1) {
            this.tools.DisplayInfoMsg(this.admin, "No user selected!");
            return;
        }
        this.str_user_name = this.jTable.getValueAt(n, 1).toString();
        this.str_login_mech = this.jTable.getValueAt(n, 3).toString();
        String string = this.jTable.getValueAt(n, 0).toString();
        if (string.indexOf("ok.png") != -1) {
            this.tools.DisplayInfoMsg(this, "The user -" + this.str_user_name + "- is already logged in.");
            return;
        }
        this.log_mechanism = this.getLoginMechanism(this.str_login_mech);
        this.strHashAlgo = this.getHashAlgo(n, 4);
        if (this.str_login_mech.indexOf(this.strRSASC) == 0 && (bl = this.loginRSASmartCard_step1(this.str_user_name, this.log_mechanism))) {
            this.loginRSASmartCard_step2();
        }
        if (this.str_login_mech.indexOf(this.strRSASign) == 0 || this.str_login_mech.indexOf(this.strECDSA) == 0) {
            bl = this.loginRSASignECDSA_step1(this.str_user_name, this.log_mechanism);
            if (bl) {
                this.loginRSASignECDSA_step2();
            }
        } else if (this.str_login_mech.indexOf(this.strClearPwd) == 0 || this.str_login_mech.indexOf(this.strSHA1Pwd) == 0 || this.str_login_mech.indexOf(this.strHMAC) == 0) {
            this.loginPwd();
        }
    }

    private boolean checkLogin(String string, String string2) {
        int n = 0;
        string = string.replaceAll("\r", "");
        string = string.replaceAll("\n", "");
        while (string.length() > 2) {
            int n2 = string.indexOf(";;");
            if (n2 == -1) {
                return false;
            }
            String string3 = string.substring(n, n2);
            if (string3.compareTo(string2) == 0) {
                return true;
            }
            string = string.substring(n2 + 2);
        }
        return false;
    }

    private void cleanTable() {
        for (int i = this.model.getRowCount(); i > 0; --i) {
            this.model.removeRow(i - 1);
        }
    }

    protected int getLoginMechanism(String string) {
        if (this.str_login_mech.compareTo(this.strRSASign) == 0) {
            return 0;
        }
        if (this.str_login_mech.compareTo(this.strClearPwd) == 0) {
            return 1;
        }
        if (this.str_login_mech.compareTo(this.strSHA1Pwd) == 0) {
            return 2;
        }
        if (this.str_login_mech.compareTo(this.strRSASC) == 0) {
            return 3;
        }
        if (this.str_login_mech.compareTo(this.strHMAC) == 0) {
            return 4;
        }
        if (this.str_login_mech.compareTo(this.strECDSA) == 0) {
            return 5;
        }
        return 0;
    }

    protected String getHashAlgo(int n, int n2) {
        String string = this.jTable.getValueAt(n, n2).toString();
        int n3 = string.indexOf("H[");
        if (n3 == -1) {
            return "";
        }
        string = string.substring(n3 + 2);
        n3 = string.indexOf("]");
        String string2 = string.substring(0, n3);
        return string2;
    }
}

