/*
 * Decompiled with CFR 0.152.
 */
package cat;

import cat.CAT;
import cat.CSJApi;
import cat.Global;
import cat.IniSettings;
import cat.StatusNew;
import cat.Tools;
import cat.ToolsThread;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class Settings
extends JDialog {
    Tools tools = new Tools();
    static ToolsThread tools_thread = new ToolsThread();
    static StatusNew status = new StatusNew();
    IniSettings ini = new IniSettings();
    int WORK_TIMEOUT = 25000;
    CAT admin;
    String strPPTypeAuto = "Autodetection";
    String strPPTypeSafepad = "Ingenico Safepad";
    String strPPTypeCP8 = "Bull CP8";
    String strPPTypeXiring = "XIRING CP8";
    String strPPTypeReinerSCT = "REINER SCT cyberJack";
    String strPPTypeUtimacoCybOne = "Utimaco cyberJack One";
    String strPPTypeNoPP = "no PIN pad";
    String strPort;
    String strSetPINPad = "SetCSPPType";
    String strKeyTokenSC = "Smartcard";
    String strKeyTokenFile = "Keyfile";
    String strOldCSDev = "";
    String strPrevCSDev = "";
    String strSettingsAddr = "SettingsAddr";
    String strCSAddr = null;
    static String strCSReply;
    boolean b_first = true;
    Object[] rowData = new Object[21];
    String[] columnNames = new String[]{"Devices"};
    boolean b_show_PIN_and_Time_tab;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanelNorth = null;
    private JPanel jPanelSouth = null;
    private JPanel jPanelWest = null;
    private JPanel jPanelEast = null;
    private JPanel jPanelCenter = null;
    private JButton jBtAction = null;
    private JButton jBtCancel = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelPINPad = null;
    private JPanel jPanelDevices = null;
    private JPanel jPanelTimeout = null;
    private JPanel jPanelMsgPP = null;
    private JTextArea jTxtAreaPP = null;
    private JComboBox jCombType = null;
    private JComboBox jComboPort = null;
    private JPanel jPanelMsgDev = null;
    private JTextArea jTxtAreaDev = null;
    private JLabel jLabel4 = null;
    private JTextField jTxtNewDev = null;
    private JButton jBtTestCurDev = null;
    private JLabel jLabel5 = null;
    private JPanel jPanelDevBox = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JPanel jPanelMsgTimeOut = null;
    private JTextArea jTxtAreaTimeOut = null;
    private JLabel jLabel6 = null;
    private JTextField jTxtTimeOut = null;
    private JRadioButton jRdCOMPort = null;
    private JRadioButton jRdUSBPort = null;
    private JRadioButton jRdPPD = null;
    private JTextField jTxtFieldPPDHost = null;
    private JLabel jLabelDummy2 = null;
    private JButton btnAdd;
    private JButton jBtDelDevice;
    private JPanel panel;
    DefaultTableModel model = new DefaultTableModel(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };

    public Settings() {
        this.initialize();
    }

    public Settings(CAT cAT, boolean bl) {
        super(cAT);
        this.admin = cAT;
        this.initialize();
        this.fillTableNew();
        this.FormatCol();
        this.b_show_PIN_and_Time_tab = bl;
        if (!bl) {
            this.jTabbedPane.remove(1);
            this.jTabbedPane.remove(1);
            this.setTitle("CryptoServer Devices");
        } else {
            this.jTabbedPane.remove(0);
            this.setTitle("Settings");
        }
    }

    private void initialize() {
        this.setSize(505, 480);
        this.setTitle("Settings");
        this.strPort = this.tools.WindowsOS() ? "COM" : "/dev/ttyS";
        this.setContentPane(this.getJContentPane());
        String string = this.ini.GetCOMPort();
        if (string != null) {
            this.setPortIndex(string);
        }
        if ((string = this.ini.GetPPType()) != null) {
            this.setPPTypeIndex(string);
        }
        this.model.setRowCount(30);
        this.model.setColumnCount(0);
        this.model.setNumRows(30);
        int n = this.ini.GetConnectionTimeout();
        this.jTxtTimeOut.setText(Integer.toString(n));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setPreferredSize(new Dimension(510, 400));
            this.jContentPane.add((Component)this.getJPanelNorth(), "North");
            this.jContentPane.add((Component)this.getJPanelSouth(), "South");
            this.jContentPane.add((Component)this.getJPanelWest(), "West");
            this.jContentPane.add((Component)this.getJPanelCenter(), "Center");
            this.jContentPane.add((Component)this.getJPanelEast(), "East");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Settings.this.setVisible(false);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.jContentPane.registerKeyboardAction(actionListener, keyStroke, 2);
            WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    Settings.this.dispose();
                }
            };
            this.addWindowListener(windowAdapter);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelNorth() {
        if (this.jPanelNorth == null) {
            this.jPanelNorth = new JPanel();
            this.jPanelNorth.setLayout(new GridBagLayout());
            this.jPanelNorth.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelNorth;
    }

    private JPanel getJPanelSouth() {
        if (this.jPanelSouth == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanelSouth = new JPanel();
            this.jPanelSouth.setLayout(flowLayout);
            this.jPanelSouth.setPreferredSize(new Dimension(10, 43));
            this.jPanelSouth.add((Component)this.getJBtActionOK(), null);
            this.jPanelSouth.add((Component)this.getJBtCancel(), null);
        }
        return this.jPanelSouth;
    }

    private JPanel getJPanelWest() {
        if (this.jPanelWest == null) {
            this.jPanelWest = new JPanel();
            this.jPanelWest.setLayout(new GridBagLayout());
            this.jPanelWest.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelWest;
    }

    private JPanel getJPanelEast() {
        if (this.jPanelEast == null) {
            this.jPanelEast = new JPanel();
            this.jPanelEast.setLayout(new GridBagLayout());
            this.jPanelEast.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelEast;
    }

    private JPanel getJPanelCenter() {
        if (this.jPanelCenter == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            this.jPanelCenter = new JPanel();
            this.jPanelCenter.setLayout(new GridBagLayout());
            this.jPanelCenter.add((Component)this.getJTabbedPane(), gridBagConstraints);
        }
        return this.jPanelCenter;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setFont(new Font("Dialog", 0, 11));
            this.jTabbedPane.addTab("Devices", null, this.getJPanelDevices(), null);
            this.jTabbedPane.addTab("PIN Pad", null, this.getJPanelPINPad(), null);
            this.jTabbedPane.addTab("Timeout", null, this.getJPanelTimeout(), null);
        }
        return this.jTabbedPane;
    }

    private JButton getJBtActionOK() {
        if (this.jBtAction == null) {
            this.jBtAction = new JButton();
            this.jBtAction.setText("OK");
            this.jBtAction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Settings.this.b_show_PIN_and_Time_tab) {
                        Settings.this.ckeckTimeoutAndPort();
                        Settings.this.setPPSettingsToIni();
                        Settings.this.ini.SetConnectionTimeout(Settings.this.jTxtTimeOut.getText());
                        Settings.this.dispose();
                        return;
                    }
                    Settings.this.saveCSDevices();
                    Settings.this.strCSAddr = Settings.this.getSelectedDevice();
                    if (Settings.this.getSelectedDevice().length() == 0) {
                        Settings.this.dispose();
                    }
                    if (!Settings.this.checkStrCSAddr()) {
                        Settings.this.dispose();
                        return;
                    }
                    Global.b_showMessage = false;
                    SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
                        boolean b_open = false;

                        @Override
                        protected Boolean doInBackground() throws Exception {
                            this.publish(1);
                            this.b_open = Settings.this.openCSConnection();
                            Settings.this.admin.simple_cmd.CSGetStateConnection();
                            this.publish(0);
                            return this.b_open;
                        }

                        @Override
                        protected void process(List<Integer> list) {
                            Integer n = list.get(list.size() - 1);
                            tools_thread.start_stop_ProgBar(n);
                        }

                        @Override
                        protected void done() {
                            try {
                                if (!((Boolean)this.get()).booleanValue()) {
                                    Settings.this.tools.DisplayErrorMsg(Settings.this.admin, "Can't get connection to specified CryptoServer (" + Settings.this.strCSAddr + "): " + strCSReply);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            catch (ExecutionException executionException) {
                                executionException.printStackTrace();
                            }
                            tools_thread.setStatusBar();
                            Settings.this.dispose();
                        }
                    };
                    swingWorker.execute();
                    Settings.this.dispose();
                }
            });
        }
        return this.jBtAction;
    }

    private JButton getJBtCancel() {
        if (this.jBtCancel == null) {
            this.jBtCancel = new JButton();
            this.jBtCancel.setText("Cancel");
            this.jBtCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Settings.this.jTxtNewDev.getText();
                    if (Settings.this.strPrevCSDev.compareTo(string) != 0) {
                        Settings.this.strCSAddr = Settings.this.strPrevCSDev;
                        Settings.this.jTxtNewDev.setText(Settings.this.strPrevCSDev);
                        Settings.this.openCSConnection();
                    }
                    Settings.this.dispose();
                }
            });
        }
        return this.jBtCancel;
    }

    private JPanel getJPanelPINPad() {
        if (this.jPanelPINPad == null) {
            this.jPanelPINPad = new JPanel();
            this.jPanelPINPad.setPreferredSize(new Dimension(0, 0));
            this.jPanelPINPad.setLayout(new GridBagLayout());
            this.addPINPadComponent(0, 0, this.getJPanelMsgPP(), 4, 2);
            this.addPINPadComponent(0, 1, new JLabel("PIN Pad"), 2, 0);
            this.addPINPadComponent(1, 3, new JLabel("Type"), 1, 0);
            this.addPINPadComponent(2, 3, this.getJCombType(), 2, 2);
            this.addPINPadComponent(1, 5, new JLabel("Port"), 1, 0);
            this.addPINPadComponent(2, 5, this.getJRdUSBPort(), 1, 0);
            this.addPINPadComponent(2, 6, this.getJRdCOMPort(), 1, 0);
            this.addPINPadComponent(3, 6, this.getJComboPort(), 1, 2);
            this.addPINPadComponent(2, 7, this.getJRdPPD(), 1, 0);
            this.addPINPadComponent(3, 7, this.getJTxtFieldPPDHost(), 1, 2);
            this.addPINPadComponent(0, 8, null, 1, 0);
            this.addPINPadSyntaxHint(3, 8);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.jRdUSBPort);
            buttonGroup.add(this.jRdCOMPort);
            buttonGroup.add(this.jRdPPD);
        }
        return this.jPanelPINPad;
    }

    private void addPINPadComponent(int n, int n2, Component component, int n3, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.insets = new Insets(15, 8, 0, 8);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = n4;
        gridBagConstraints.weightx = n4 == 2 ? 1.0 : 0.0;
        double d = gridBagConstraints.weighty = component == null ? 1.0 : 0.0;
        if (component == null) {
            this.jPanelPINPad.add((Component)new JLabel(""), gridBagConstraints);
        } else {
            this.jPanelPINPad.add(component, gridBagConstraints);
        }
    }

    private void addPINPadSyntaxHint(int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelPINPad.add((Component)new JLabel("Syntax: [port@]ip_or_hostname[/password]"), gridBagConstraints);
    }

    private JRadioButton getJRdCOMPort() {
        if (this.jRdCOMPort == null) {
            this.jRdCOMPort = new JRadioButton();
            this.jRdCOMPort.setText("COM Port");
            this.jRdCOMPort.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (Settings.this.jRdCOMPort.isSelected()) {
                        Settings.this.jComboPort.setEnabled(true);
                        Settings.this.jTxtFieldPPDHost.setEnabled(false);
                    }
                }
            });
        }
        return this.jRdCOMPort;
    }

    private JRadioButton getJRdUSBPort() {
        if (this.jRdUSBPort == null) {
            this.jRdUSBPort = new JRadioButton();
            this.jRdUSBPort.setText("USB Port");
            this.jRdUSBPort.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (Settings.this.jRdUSBPort.isSelected()) {
                        Settings.this.jComboPort.setEnabled(false);
                        Settings.this.jTxtFieldPPDHost.setEnabled(false);
                    }
                }
            });
        }
        return this.jRdUSBPort;
    }

    private JRadioButton getJRdPPD() {
        if (this.jRdPPD == null) {
            this.jRdPPD = new JRadioButton();
            this.jRdPPD.setText("PPD");
            this.jRdPPD.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (Settings.this.jRdPPD.isSelected()) {
                        Settings.this.jComboPort.setEnabled(false);
                        Settings.this.jTxtFieldPPDHost.setEnabled(true);
                    }
                }
            });
        }
        return this.jRdPPD;
    }

    private JTextField getJTxtFieldPPDHost() {
        if (this.jTxtFieldPPDHost == null) {
            this.jTxtFieldPPDHost = new JTextField();
            this.jTxtFieldPPDHost.setMargin(new Insets(4, 4, 4, 4));
            this.jTxtFieldPPDHost.setEditable(true);
            this.jTxtFieldPPDHost.setText(this.ini.GetPPDParam());
            this.jTxtFieldPPDHost.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }
        return this.jTxtFieldPPDHost;
    }

    private JPanel getJPanelMsgPP() {
        if (this.jPanelMsgPP == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.weightx = 1.0;
            this.jPanelMsgPP = new JPanel();
            this.jPanelMsgPP.setLayout(new GridBagLayout());
            this.jPanelMsgPP.setBorder(BorderFactory.createEtchedBorder(1));
            this.jPanelMsgPP.add((Component)this.getJTxtAreaPP(), gridBagConstraints);
        }
        return this.jPanelMsgPP;
    }

    private JTextArea getJTxtAreaPP() {
        if (this.jTxtAreaPP == null) {
            this.jTxtAreaPP = new JTextArea();
            this.jTxtAreaPP.setEditable(false);
            this.jTxtAreaPP.setText("Select the type of PIN pad and the port to which the PIN pad is connected to the client computer.");
            this.jTxtAreaPP.setFont(new Font("Dialog", 0, 11));
            this.jTxtAreaPP.setWrapStyleWord(true);
            this.jTxtAreaPP.setOpaque(false);
            this.jTxtAreaPP.setFont(new Font("Dialog", 0, 11));
            this.jTxtAreaPP.setLineWrap(true);
        }
        return this.jTxtAreaPP;
    }

    private JComboBox getJCombType() {
        if (this.jCombType == null) {
            this.jCombType = new JComboBox();
            this.jCombType.addItem(this.makeObj(this.strPPTypeUtimacoCybOne));
            this.jCombType.addItem(this.makeObj(this.strPPTypeReinerSCT));
            this.jCombType.addItem(this.makeObj(this.strPPTypeAuto));
        }
        return this.jCombType;
    }

    private JComboBox getJComboPort() {
        if (this.jComboPort == null) {
            this.jComboPort = new JComboBox();
            this.jComboPort.setSelectedIndex(-1);
            this.jComboPort.setEditable(true);
            for (int i = this.tools.WindowsOS() ? 1 : 0; i < 16; ++i) {
                String string = this.strPort + Integer.toString(i);
                this.jComboPort.addItem(this.makeObj(string));
            }
        }
        return this.jComboPort;
    }

    private JPanel getJPanelDevices() {
        if (this.jPanelDevices == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(15, 8, 8, 8);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(15, 8, 0, 5);
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridheight = 2;
            gridBagConstraints2.gridy = 2;
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("Device List");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(15, 8, 5, 8);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(15, 8, 5, 5);
            gridBagConstraints4.gridy = 1;
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("New Device");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(8, 8, 5, 8);
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridwidth = 3;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridy = 0;
            this.jPanelDevices = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            gridBagLayout.columnWidths = new int[]{0, 290, 77};
            gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0};
            gridBagLayout.rowHeights = new int[]{0, 40, 135, 0};
            this.jPanelDevices.setLayout(gridBagLayout);
            this.jPanelDevices.add((Component)this.getJPanelMsgDev(), gridBagConstraints5);
            this.jPanelDevices.add((Component)this.jLabel4, gridBagConstraints4);
            this.jPanelDevices.add((Component)this.getJTxtNewDev(), gridBagConstraints3);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 14;
            gridBagConstraints6.insets = new Insets(0, 0, 5, 8);
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.gridy = 1;
            this.jPanelDevices.add((Component)this.getBtnAdd(), gridBagConstraints6);
            this.jPanelDevices.add((Component)this.jLabel5, gridBagConstraints2);
            this.jPanelDevices.add((Component)this.getJPanelDevBox(), gridBagConstraints);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 11;
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.insets = new Insets(0, 8, 0, 8);
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 3;
            this.jPanelDevices.add((Component)this.getPanel(), gridBagConstraints7);
        }
        return this.jPanelDevices;
    }

    private JPanel getJPanelMsgDev() {
        if (this.jPanelMsgDev == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.weightx = 1.0;
            this.jPanelMsgDev = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWeights = new double[]{0.0};
            this.jPanelMsgDev.setLayout(gridBagLayout);
            this.jPanelMsgDev.setBorder(BorderFactory.createEtchedBorder(1));
            this.jPanelMsgDev.setFont(new Font("Dialog", 0, 11));
            this.jPanelMsgDev.setPreferredSize(new Dimension(456, 68));
            this.jPanelMsgDev.add((Component)this.getJTxtAreaDev(), gridBagConstraints);
        }
        return this.jPanelMsgDev;
    }

    private JTextArea getJTxtAreaDev() {
        if (this.jTxtAreaDev == null) {
            this.jTxtAreaDev = new JTextArea();
            this.jTxtAreaDev.setEditable(false);
            this.jTxtAreaDev.setLineWrap(true);
            this.jTxtAreaDev.setText("Examples for CryptoServer Devices: 192.168.4.188 (CSLAN), PCI:0 (PCI card, Windows), /dev/cs2.0 (PCI card, Linux), 3001@127.0.0.1 (Simulator)");
            this.jTxtAreaDev.setOpaque(false);
            this.jTxtAreaDev.setFont(new Font("Dialog", 0, 11));
            this.jTxtAreaDev.setWrapStyleWord(true);
        }
        return this.jTxtAreaDev;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            FlowLayout flowLayout = (FlowLayout)this.panel.getLayout();
            flowLayout.setAlignment(2);
            this.panel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.panel.add(this.getJBtDelDevice());
            this.panel.add(this.getJBtTestCurDev());
        }
        return this.panel;
    }

    private JPanel getJPanelDevBox() {
        if (this.jPanelDevBox == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            this.jPanelDevBox = new JPanel();
            this.jPanelDevBox.setLayout(new GridBagLayout());
            this.jPanelDevBox.add((Component)this.getJScrollPane(), gridBagConstraints);
        }
        return this.jPanelDevBox;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setSelectionMode(0);
            this.jTable.setModel(this.model);
            this.jTable.setRowHeight(25);
            this.jTable.getTableHeader().setReorderingAllowed(false);
        }
        return this.jTable;
    }

    private void cleanTable() {
        for (int i = this.model.getRowCount(); i > 0; --i) {
            this.model.removeRow(i - 1);
        }
    }

    public void fillTableNew() {
        int n = 0;
        this.cleanTable();
        if (this.b_first) {
            this.model.addColumn(this.columnNames[0]);
        }
        String string = this.ini.GetCSCurrentDevice();
        String string2 = this.ini.GetCSDeviceList();
        if (string2.length() == 0) {
            return;
        }
        if (string2.indexOf(string) == -1) {
            string2 = string2 + string + ";;";
        }
        Object[] objectArray = string2.split(";;");
        n = objectArray.length;
        Arrays.sort(objectArray);
        for (int i = 0; i < n; ++i) {
            this.rowData[0] = objectArray[i];
            this.model.addRow(this.rowData);
        }
        this.MarkCurrentDeviceInTable();
    }

    private String getSelectedDevice() {
        ListSelectionModel listSelectionModel = this.jTable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n == -1) {
            return "";
        }
        this.strCSAddr = this.jTable.getValueAt(n, 0).toString();
        return this.strCSAddr;
    }

    private void MarkCurrentDeviceInTable() {
        ListSelectionModel listSelectionModel = this.jTable.getSelectionModel();
        this.jTable.setSelectionMode(0);
        String string = this.ini.GetCSCurrentDevice();
        if (string == null) {
            this.ini.SetCSCurrentDevice("");
            return;
        }
        int n = this.jTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.jTable.getValueAt(i, 0).toString();
            if (string2.compareTo(string) != 0) continue;
            listSelectionModel.setSelectionInterval(i, i);
            break;
        }
    }

    private int getSelectedCSAddress() {
        ListSelectionModel listSelectionModel = this.jTable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n == -1) {
            return -1;
        }
        this.strCSAddr = this.jTable.getValueAt(n, 0).toString();
        return 0;
    }

    private JTextField getJTxtNewDev() {
        if (this.jTxtNewDev == null) {
            this.jTxtNewDev = new JTextField();
            this.jTxtNewDev.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\n') {
                        Settings.this.addtoDeviceList();
                    }
                }
            });
        }
        return this.jTxtNewDev;
    }

    private JButton getJBtTestCurDev() {
        if (this.jBtTestCurDev == null) {
            this.jBtTestCurDev = new JButton();
            this.jBtTestCurDev.setText("Test");
            this.jBtTestCurDev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
                        boolean b_open = false;

                        @Override
                        protected Boolean doInBackground() throws Exception {
                            Settings.this.saveCSDevices();
                            Settings.this.getSelectedCSAddress();
                            if (Settings.this.strCSAddr.isEmpty()) {
                                Settings.this.checkStrCSAddr();
                                return this.b_open;
                            }
                            this.publish(1);
                            this.b_open = Settings.this.openCSConnection();
                            this.publish(0);
                            return this.b_open;
                        }

                        @Override
                        protected void process(List<Integer> list) {
                            Integer n = list.get(list.size() - 1);
                            tools_thread.start_stop_ProgBar(n);
                        }

                        @Override
                        protected void done() {
                            if (Settings.this.strCSAddr.isEmpty()) {
                                return;
                            }
                            try {
                                if (((Boolean)this.get()).booleanValue()) {
                                    Settings.this.tools.DisplayInfoMsg(Settings.this.admin, "Specified CryptoServer (" + Settings.this.strCSAddr + ") connected");
                                } else {
                                    Settings.this.tools.DisplayErrorMsg(Settings.this.admin, "Can't get connection to specified CryptoServer (" + Settings.this.strCSAddr + "): " + strCSReply);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            catch (ExecutionException executionException) {
                                executionException.printStackTrace();
                            }
                            tools_thread.setStatusBar();
                        }
                    };
                    swingWorker.execute();
                    Settings.this.strOldCSDev = Settings.this.strCSAddr;
                }
            });
        }
        return this.jBtTestCurDev;
    }

    private int checkDeviceSelection() {
        ListSelectionModel listSelectionModel = this.jTable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n == -1) {
            return -1;
        }
        this.strCSAddr = this.jTable.getValueAt(n, 0).toString();
        return 0;
    }

    private String readDeviceTableList() {
        String string = "";
        int n = this.jTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.jTable.getValueAt(i, 0).toString() + ";;";
            string = string + string2;
        }
        return string;
    }

    private void SetCSDevListToCATCombo() {
        String string = this.ini.GetCSDeviceList();
        String[] stringArray = string.split(";;");
        int n = stringArray.length;
        if (n == 0) {
            return;
        }
        String string2 = "Device: " + this.ini.GetCSCurrentDevice();
        Global.b_UpdateCBCSAddr = string2.length() != 0;
        this.admin.jCbStatCSAddr.removeAllItems();
        String string3 = "Device: " + this.ini.GetCSCurrentDevice();
        this.admin.jCbStatCSAddr.addItem(this.makeObj(string3));
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null || (string2 = "Device: " + stringArray[i]).compareTo(string3) == 0) continue;
            this.admin.jCbStatCSAddr.addItem(this.makeObj(string2));
        }
        Global.b_UpdateCBCSAddr = false;
    }

    private void saveCSDevices() {
        int n = this.checkDeviceSelection();
        if (n == 1) {
            return;
        }
        if (n == -1) {
            this.strCSAddr = "";
        }
        String string = this.readDeviceTableList();
        this.ini.SetCSDeviceList(string);
        this.ini.SetCSCurrentDevice(this.strCSAddr);
        this.SetCSDevListToCATCombo();
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton("Add to List");
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Settings.this.addtoDeviceList();
                }
            });
        }
        return this.btnAdd;
    }

    private JButton getJBtDelDevice() {
        if (this.jBtDelDevice == null) {
            this.jBtDelDevice = new JButton("Delete");
            this.jBtDelDevice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ListSelectionModel listSelectionModel = Settings.this.jTable.getSelectionModel();
                    int n = listSelectionModel.getMinSelectionIndex();
                    if (n == -1) {
                        Settings.this.tools.DisplayInfoMsg(Settings.this.admin, "No CryptoServer device selected!");
                        return;
                    }
                    String string = "Do you really want to delete the selected device?";
                    int n2 = Settings.this.tools.DisplayYesNoMsg(Settings.this, string);
                    if (n2 != 0) {
                        Settings.this.jBtTestCurDev.requestFocus();
                        return;
                    }
                    Settings.this.model.removeRow(n);
                    if (Settings.this.jTable.getRowCount() >= 1) {
                        Settings.this.jTable.getSelectionModel().setSelectionInterval(0, 0);
                        Settings.this.jTable.scrollRectToVisible(Settings.this.jTable.getCellRect(0, -1, true));
                    }
                    Settings.this.jTxtNewDev.requestFocus();
                }
            });
        }
        return this.jBtDelDevice;
    }

    private void addtoDeviceList() {
        int n;
        int n2 = 0;
        String string = this.jTxtNewDev.getText();
        this.jTxtNewDev.setText("");
        if (string.length() == 0) {
            this.tools.DisplayInfoMsg(this, "There is no entry for a new CryptoServer device.");
            this.jBtTestCurDev.requestFocus();
            return;
        }
        if (string.indexOf(";;") != -1) {
            this.tools.DisplayInfoMsg(this, "The string ;; is not allowed as a part of a CryptoServer device.");
            this.jBtTestCurDev.requestFocus();
            return;
        }
        int n3 = this.jTable.getRowCount();
        Object[] objectArray = new String[n3 + 1];
        for (n = 0; n < n3; ++n) {
            objectArray[n] = this.jTable.getValueAt(n, 0).toString();
            if (((String)objectArray[n]).compareTo(string) != 0) continue;
            this.tools.DisplayInfoMsg(this, "The new entry -" + string + "- already exists.");
            this.jBtTestCurDev.requestFocus();
            return;
        }
        objectArray[n3] = string;
        this.cleanTable();
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            this.rowData[0] = objectArray[n];
            this.model.addRow(this.rowData);
            if (((String)objectArray[n]).compareTo(string) != 0) continue;
            n2 = n;
        }
        this.jTable.getSelectionModel().setSelectionInterval(n2, n2);
        this.jTable.scrollRectToVisible(this.jTable.getCellRect(n2, -1, true));
        this.jBtTestCurDev.requestFocus();
    }

    void FormatCol() {
        for (int i = 0; i < this.jTable.getColumnCount(); ++i) {
            TableColumn tableColumn = this.jTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(300);
                }
            }
        }
    }

    private JPanel getJPanelTimeout() {
        if (this.jPanelTimeout == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 2;
            this.jLabelDummy2 = new JLabel();
            this.jLabelDummy2.setText("");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(15, 8, 180, 8);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(15, 8, 180, 0);
            gridBagConstraints3.gridy = 1;
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("Connection Timeout (msec)");
            this.jLabel6.setToolTipText(null);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(8, 8, 0, 8);
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridwidth = 0;
            gridBagConstraints4.gridy = 0;
            this.jPanelTimeout = new JPanel();
            this.jPanelTimeout.setLayout(new GridBagLayout());
            this.jPanelTimeout.add((Component)this.getJPanelMsgTimeOut(), gridBagConstraints4);
            this.jPanelTimeout.add((Component)this.jLabel6, gridBagConstraints3);
            this.jPanelTimeout.add((Component)this.getJTxtTimeOut(), gridBagConstraints2);
            this.jPanelTimeout.add((Component)this.jLabelDummy2, gridBagConstraints);
        }
        return this.jPanelTimeout;
    }

    private JPanel getJPanelMsgTimeOut() {
        if (this.jPanelMsgTimeOut == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.weightx = 1.0;
            this.jPanelMsgTimeOut = new JPanel();
            this.jPanelMsgTimeOut.setLayout(new GridBagLayout());
            this.jPanelMsgTimeOut.setBorder(BorderFactory.createEtchedBorder(1));
            this.jPanelMsgTimeOut.add((Component)this.getJTxtAreaTimeOut(), gridBagConstraints);
        }
        return this.jPanelMsgTimeOut;
    }

    private JTextArea getJTxtAreaTimeOut() {
        if (this.jTxtAreaTimeOut == null) {
            this.jTxtAreaTimeOut = new JTextArea();
            this.jTxtAreaTimeOut.setEditable(false);
            this.jTxtAreaTimeOut.setLineWrap(true);
            this.jTxtAreaTimeOut.setOpaque(false);
            this.jTxtAreaTimeOut.setText("The Connection Timeout value sets the time in which the CAT tries to get a connection to  the referenced current CryptoServer device. If this value is exceeded the CAT answers with a connection timeout error. A common timeout value in milliseconds is 5000.");
            this.jTxtAreaTimeOut.setFont(new Font("Dialog", 0, 11));
            this.jTxtAreaTimeOut.setWrapStyleWord(true);
        }
        return this.jTxtAreaTimeOut;
    }

    private JTextField getJTxtTimeOut() {
        if (this.jTxtTimeOut == null) {
            this.jTxtTimeOut = new JTextField();
            this.jTxtTimeOut.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    int n = 7;
                    if (keyEvent.getKeyChar() == '\b') {
                        return;
                    }
                    if (!Settings.this.tools.TestDezString(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                    if (Settings.this.jTxtTimeOut.getText().length() > n - 1) {
                        keyEvent.consume();
                    }
                }
            });
        }
        return this.jTxtTimeOut;
    }

    private boolean checkStrCSAddr() {
        if (this.strCSAddr == null) {
            this.tools.DisplayInfoMsg(this.admin, "No CryptoServer device selected");
            return false;
        }
        if (this.strCSAddr.length() == 0) {
            this.tools.DisplayInfoMsg(this.admin, "No CryptoServer device selected");
            return false;
        }
        return true;
    }

    private void setPPSettingsToIni() {
        if (this.jRdUSBPort.isSelected()) {
            this.ini.SetCOMPort("USB0");
        } else if (this.jRdPPD.isSelected()) {
            this.ini.SetPPDParam(this.jTxtFieldPPDHost.getText());
        } else {
            this.ini.SetCOMPort(this.jComboPort.getSelectedItem().toString());
        }
        this.ini.SetPPType(this.jCombType.getSelectedItem().toString());
    }

    private void ckeckTimeoutAndPort() {
        if (this.jTxtTimeOut.getText().length() == 0) {
            this.tools.DisplayInfoMsg(this, "Please remember to set a Connection Timeout.");
        }
        if (this.jComboPort.getSelectedItem().toString().compareTo(this.strPPTypeNoPP) == 0) {
            this.tools.DisplayInfoMsg(this, "Please remember to select a PIN pad port.");
        }
    }

    private void setPortIndex(String string) {
        int n = 0;
        String string2 = this.ini.GetCOMPort();
        if (string2.compareTo("USB0") == 0) {
            this.jRdCOMPort.setSelected(false);
            this.jRdUSBPort.setSelected(true);
            this.jRdPPD.setSelected(false);
        } else if (string2.startsWith("COM")) {
            this.jRdCOMPort.setSelected(true);
            this.jRdUSBPort.setSelected(false);
            this.jRdPPD.setSelected(false);
        } else {
            this.jRdCOMPort.setSelected(false);
            this.jRdUSBPort.setSelected(false);
            this.jRdPPD.setSelected(true);
            String string3 = string2;
            if (string2.startsWith("USB0@")) {
                string3 = string2.substring(5);
            }
            this.jTxtFieldPPDHost.setText(string3);
        }
        int n2 = this.tools.WindowsOS() ? 1 : 0;
        while (n < 16) {
            String string4 = this.strPort + Integer.toString(n + n2);
            if (string.compareTo(string4) == 0) {
                this.jComboPort.setSelectedIndex(n);
            }
            ++n;
        }
    }

    private void setPPTypeIndex(String string) {
        if (string.compareToIgnoreCase(this.strPPTypeUtimacoCybOne) == 0) {
            this.jCombType.setSelectedIndex(0);
        } else if (string.compareToIgnoreCase(this.strPPTypeReinerSCT) == 0) {
            this.jCombType.setSelectedIndex(1);
        } else if (string.compareToIgnoreCase(this.strPPTypeAuto) == 0) {
            this.jCombType.setSelectedIndex(2);
        } else {
            this.jCombType.setSelectedIndex(2);
        }
    }

    private Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    private boolean openCSConnection() {
        if (Global.cs_opened) {
            CSJApi.CSClose();
        }
        CSJApi.SetTimeout(this.ini.GetConnectionTimeout());
        strCSReply = CSJApi.CSOpen(this.strCSAddr);
        if (strCSReply.indexOf("Error") == 0 || this.strCSAddr.length() == 0) {
            Global.strCurrentCSAddr = "";
            Global.cs_opened = false;
            return false;
        }
        CSJApi.SetTimeout(this.WORK_TIMEOUT);
        Global.cs_model = CSJApi.CSGetModel();
        if (Global.cs_model < 2) {
            this.tools.DisplayErrorMsg(this.admin, "CAT versions 2.1.0.0 and higher do not support this model of CryptoServer.");
            CSJApi.SetTimeout(this.ini.GetConnectionTimeout());
            Global.strCurrentCSAddr = "";
            Global.cs_opened = false;
            return false;
        }
        Global.strCurrentCSAddr = this.strCSAddr;
        Global.cs_opened = true;
        return true;
    }
}

