/*
 * Decompiled with CFR 0.152.
 */
package cat;

import cat.CAT;
import cat.CSJApi;
import cat.IniSettings;
import cat.Tools;
import cat.ToolsThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class Diagnostics
extends JDialog {
    Tools tools = new Tools();
    static ToolsThread tools_thread = new ToolsThread();
    IniSettings ini = new IniSettings();
    JTextArea jtxtArea;
    CAT admin;
    String strCSReply;
    final int waittime = 150;
    private static final long serialVersionUID = 1L;
    private final JPanel jContentPane = new JPanel();

    public Diagnostics(CAT cAT) {
        super(cAT);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        if (dimension.width > 950 && dimension.height > 800) {
            this.setPreferredSize(new Dimension(950, 800));
        } else {
            this.setPreferredSize(new Dimension(dimension.width, dimension.height - 60));
        }
        this.admin = cAT;
        this.setTitle("Save Diagnostics");
        this.setBounds(100, 100, 948, 794);
        this.getContentPane().setLayout(new BorderLayout());
        this.jContentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.jContentPane, "Center");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.jContentPane.setLayout(gridBagLayout);
        Object object = new JLabel("Diagnostic Information:");
        Serializable serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).insets = new Insets(8, 8, 5, 0);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        this.jContentPane.add((Component)object, serializable);
        object = new JScrollPane();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        this.jContentPane.add((Component)object, serializable);
        this.jtxtArea = new JTextArea();
        ((JScrollPane)object).setViewportView(this.jtxtArea);
        this.jtxtArea.setFont(new Font("Monospaced", 0, 14));
        this.jtxtArea.setEditable(false);
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)object, "South");
        serializable = new JButton("Save...");
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = Diagnostics.this.jtxtArea.getText();
                String string2 = Diagnostics.this.tools.ShowSaveDlgExt(Diagnostics.this, "CryptoServer Diagnostic File", Diagnostics.this.ini.GetDiagFilePath(), Diagnostics.this.ini.GetCSCurrentDevice(), ".txt", "Diagnostic File (*.txt)");
                if (string2 == "") {
                    return;
                }
                if (Diagnostics.this.tools.FileOverwrite(Diagnostics.this, string2)) {
                    Diagnostics.this.ini.SetDiagFilePath(string2);
                    string = string.replaceAll("\r", "");
                    string = string.replaceAll("\n", "\r\n");
                    Diagnostics.this.tools.WriteBackupEntry(string2, string);
                }
            }
        });
        ((AbstractButton)serializable).setActionCommand("OK");
        ((Container)object).add((Component)serializable);
        this.getRootPane().setDefaultButton((JButton)serializable);
        serializable = new JButton("Cancel");
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Diagnostics.this.dispose();
            }
        });
        ((AbstractButton)serializable).setActionCommand("Cancel");
        ((Container)object).add((Component)serializable);
        object = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Diagnostics.this.setVisible(false);
            }
        };
        serializable = KeyStroke.getKeyStroke(27, 0);
        this.jContentPane.registerKeyboardAction((ActionListener)object, (KeyStroke)serializable, 2);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Diagnostics.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
        this.setInformation();
    }

    private void setInformation() {
        this.getSystemDateTime();
        this.getCATVersion();
        this.getCurrentDevice();
        this.getState();
        tools_thread.Sleep(150);
        this.getBootLog();
        tools_thread.Sleep(150);
        this.getGetInfo();
        tools_thread.Sleep(150);
        this.getGetBatteryState();
        tools_thread.Sleep(150);
        this.getListFiles();
        tools_thread.Sleep(150);
        this.getListModules();
        tools_thread.Sleep(150);
        this.getListUsers();
        tools_thread.Sleep(150);
        this.getGetTime();
        tools_thread.Sleep(150);
        this.getMBKInfo();
    }

    private void getSystemDateTime() {
        this.jtxtArea.append(this.tools.GetDateTime() + "\r\n\r\n");
    }

    private void getCurrentDevice() {
        this.jtxtArea.append("CryptoServer: " + this.ini.GetCSCurrentDevice() + "\r\n\r\n");
    }

    private void getCATVersion() {
        this.jtxtArea.append("CAT Version: " + this.admin.strGUISerialNo + "\r\n\r\n");
    }

    private void getState() {
        tools_thread.SetMethodForThread(this, "getCSGetState");
    }

    public void getCSGetState() {
        this.jtxtArea.append("\r\n--- Get State ---\r\n");
        this.strCSReply = CSJApi.CSGetState();
        this.jtxtArea.append(this.strCSReply);
    }

    public void getBootLog() {
        tools_thread.SetMethodForThread(this, "getCSGetBootLog");
    }

    public void getCSGetBootLog() {
        this.jtxtArea.append("\r\n\r\n--- Get Boot Log ---");
        this.strCSReply = CSJApi.CSGetBootLog();
        this.jtxtArea.append(this.strCSReply);
    }

    public void getGetInfo() {
        tools_thread.SetMethodForThread(this, "getCSGetInfo");
    }

    public void getCSGetInfo() {
        this.jtxtArea.append("\r\n\r\n--- Get Info ---\r\n");
        this.strCSReply = CSJApi.CSGetInfo();
        this.jtxtArea.append(this.strCSReply);
    }

    public void getGetBatteryState() {
        tools_thread.SetMethodForThread(this, "getCSGetBatteryState");
    }

    public void getCSGetBatteryState() {
        this.jtxtArea.append("\r\n\r\n--- CryptoServer Battery State ---\r\n");
        this.strCSReply = CSJApi.CSGetBattStateEx();
        if (this.strCSReply.indexOf("Error") != -1) {
            this.strCSReply = "Battery State unknown";
        }
        this.jtxtArea.append(this.strCSReply);
    }

    public void getListFiles() {
        tools_thread.SetMethodForThread(this, "getCSListFiles");
    }

    public void getCSListFiles() {
        this.jtxtArea.append("\r\n\r\n--- List All Files ---\r\n");
        this.strCSReply = CSJApi.CSListFiles();
        this.jtxtArea.append(this.strCSReply);
    }

    public void getListModules() {
        tools_thread.SetMethodForThread(this, "getCSListModules");
    }

    public void getCSListModules() {
        this.jtxtArea.append("\r\n--- List Modules ---\r\n");
        this.strCSReply = CSJApi.CSListModulesActive();
        this.jtxtArea.append(this.strCSReply);
    }

    public void getListUsers() {
        tools_thread.SetMethodForThread(this, "getCSListUsers");
    }

    public void getCSListUsers() {
        this.jtxtArea.append("\r\n\r\n--- List Users ---\r\n");
        byte[] byArray = CSJApi.CSListUser();
        this.strCSReply = this.tools.convertByteToString(byArray);
        this.strCSReply = this.formatListUser(this.strCSReply);
        this.jtxtArea.append(this.strCSReply);
    }

    public void getGetAlarmLog() {
        tools_thread.SetMethodForThread(this, "getCSGetAlarmLog");
    }

    public void getGetTime() {
        tools_thread.SetMethodForThread(this, "getCSGetTime");
    }

    public void getCSGetTime() {
        this.jtxtArea.append("\r\n\r\n--- CryptoServer Date/Time ---\r\n");
        this.strCSReply = CSJApi.CSGetTime();
        this.jtxtArea.append(this.strCSReply);
    }

    private void getMBKInfo() {
        tools_thread.SetMethodForThread(this, "getCSMBKInfo");
    }

    public void getCSMBKInfo() {
        this.strCSReply = CSJApi.CSMBKListKeys();
        if (this.strCSReply.indexOf("Error") == 0) {
            return;
        }
        this.jtxtArea.append("\r\n\r\n--- MBK Info ---");
        String string = this.formatMBKInfo(this.strCSReply);
        this.jtxtArea.append(string);
    }

    private String formatMBKInfo(String string) {
        String[] stringArray = string.split(";;");
        String string2 = "";
        for (int i = 0; i < stringArray.length / 8; ++i) {
            string2 = string2 + "\r\nSlot: " + stringArray[8 * i + 0] + "\r\nName: " + stringArray[8 * i + 1] + "\r\nLength: " + stringArray[8 * i + 2] + "\r\nAlgorithm: " + stringArray[8 * i + 3] + "\r\nType: " + stringArray[8 * i + 4] + "\r\nK: " + stringArray[8 * i + 5] + "\r\nGeneration Date: " + stringArray[8 * i + 6] + "\r\nKeyCheck Value: " + stringArray[8 * i + 7] + "\r\n";
        }
        return string2;
    }

    private String formatListUser(String string) {
        String[] stringArray = string.split(";;");
        String string2 = "";
        for (int i = 0; i < stringArray.length / 5; ++i) {
            string2 = string2 + String.format("%-35s", stringArray[5 * i]) + String.format("%-14s", stringArray[5 * i + 1]) + String.format("%-22s", stringArray[5 * i + 2]) + String.format("%-30s", stringArray[5 * i + 4]) + "\r\n";
        }
        return string2;
    }
}

