/*
 * Decompiled with CFR 0.152.
 */
package cat;

import cat.AuditEntry;
import cat.AuditRowFilter;
import cat.AuditTable;
import cat.AuditTableModel;
import cat.CAT;
import cat.CSJApi;
import cat.Global;
import cat.IniSettings;
import cat.Tools;
import cat.ToolsThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class AuditLog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanelNorth = null;
    private JPanel jPanelWest = null;
    private JPanel jPanelEast = null;
    private JPanel jPanelSouth = null;
    private JPanel jPanelCenter = null;
    private JButton jBtClose = null;
    private JButton jBtClear = null;
    private JLabel jLabel = null;
    private JComboBox jCbUserSel = null;
    private JLabel jLabel1 = null;
    private JComboBox jCbCmdState = null;
    private JPanel jPanelSel = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JButton jBtSave = null;
    private JPanel jPanelEvents;
    private JTextPane jtxtEvents;
    private AuditTableModel model;
    private TableRowSorter<AuditTableModel> sorter;
    private AuditRowFilter auditRowFilter;
    CAT admin;
    String strCSReply;
    Tools tools = new Tools();
    static ToolsThread tools_thread = new ToolsThread();
    IniSettings ini = new IniSettings();
    Object[] rowData = new Object[4];
    boolean b_first = true;
    boolean b_start = true;
    int comma_counter = 0;
    String[] strCommands = new String[]{"All", "Error", "No Error", "Set Time", "Reset Alarm", "Add User", "Delete User", "Load File", "Clear", "Alarm"};
    String strAuditLogPath;

    public AuditLog(CAT cAT, boolean bl) {
        super(cAT);
        this.admin = cAT;
        this.strAuditLogPath = Global.strAuditLogFileName;
        this.jScrollPane = new JScrollPane();
        this.model = new AuditTableModel();
        this.sorter = new TableRowSorter<AuditTableModel>(this.model);
        this.auditRowFilter = new AuditRowFilter(this.model);
        this.jTable = new AuditTable(this.model);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        this.jTable.setRowSorter(this.sorter);
        this.jScrollPane.setViewportView(this.jTable);
        this.initialize();
        this.CSGetAuditLog();
        this.FormatCol();
        this.jBtClear.setVisible(bl);
    }

    private void initialize() {
        this.setSize(1000, 600);
        this.setPreferredSize(new Dimension(800, 627));
        this.setTitle("CryptoServer Audit Log");
        this.setContentPane(this.getJContentPane());
        if (Global.b_Group7_Level2 || Global.b_Group6_Level2) {
            this.jBtClear.setEnabled(true);
        } else {
            this.jBtClear.setEnabled(false);
        }
    }

    private String formatEvent(String string, String string2) {
        string2 = string2 + string;
        ++this.comma_counter;
        string2 = this.comma_counter == 5 ? string2 + ",\n" : string2 + ", ";
        return string2;
    }

    public void ShowAuditLogConfig(String string) {
        int n;
        String string2 = "";
        String string3 = "Firmware Management";
        String string4 = "User Management";
        String string5 = "Date/Time Management";
        String string6 = "Startup Messages";
        String string7 = "Audit Log Management";
        String string8 = "MBK Management";
        String string9 = "Key Management";
        String string10 = "All Login Attempts";
        String string11 = "Failed Login Attempts";
        String string12 = "Backup/Restore";
        String string13 = "Operating system events";
        String string14 = "Action Needed";
        if (string.indexOf("Error") != -1) {
            this.jtxtEvents.setText("---");
            return;
        }
        if (string.indexOf(string3) != -1) {
            string2 = this.formatEvent(string3, string2);
        }
        if (string.indexOf(string4) != -1) {
            string2 = this.formatEvent(string4, string2);
        }
        if (string.indexOf(string5) != -1) {
            string2 = this.formatEvent("Date/Time Management", string2);
        }
        if (string.indexOf(string6) != -1) {
            string2 = this.formatEvent(string6, string2);
        }
        if (string.indexOf(string7) != -1) {
            string2 = this.formatEvent(string7, string2);
        }
        if (string.indexOf(string8) != -1) {
            string2 = this.formatEvent(string8, string2);
        }
        if (string.indexOf(string9) != -1) {
            string2 = this.formatEvent(string9, string2);
        }
        if (string.indexOf(string10) != -1) {
            string2 = this.formatEvent(string10, string2);
        }
        if (string.indexOf(string11) != -1) {
            string2 = this.formatEvent(string11, string2);
        }
        if (string.indexOf(string12) != -1) {
            string2 = this.formatEvent(string12, string2);
        }
        if (string.indexOf(string13) != -1) {
            string2 = this.formatEvent(string13, string2);
        }
        if (string.indexOf(string14) != -1) {
            string2 = this.formatEvent(string14, string2);
        }
        if (string2.substring((n = string2.length()) - 2, n - 1).compareTo(",") == 0) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        this.jtxtEvents.setText(string2);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanelNorth(), "North");
            this.jContentPane.add((Component)this.getJPanelWest(), "West");
            this.jContentPane.add((Component)this.getJPanelEast(), "East");
            this.jContentPane.add((Component)this.getJPanelSouth(), "South");
            this.jContentPane.add((Component)this.getJPanelCenter(), "Center");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AuditLog.this.setVisible(false);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.jContentPane.registerKeyboardAction(actionListener, keyStroke, 2);
            WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    AuditLog.this.dispose();
                }

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                    AuditLog.this.b_start = false;
                }
            };
            this.addWindowListener(windowAdapter);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelNorth() {
        if (this.jPanelNorth == null) {
            this.jPanelNorth = new JPanel();
            this.jPanelNorth.setLayout(new GridBagLayout());
            this.jPanelNorth.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelNorth;
    }

    private JPanel getJPanelWest() {
        if (this.jPanelWest == null) {
            this.jPanelWest = new JPanel();
            this.jPanelWest.setLayout(new GridBagLayout());
            this.jPanelWest.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelWest;
    }

    private JPanel getJPanelEast() {
        if (this.jPanelEast == null) {
            this.jPanelEast = new JPanel();
            this.jPanelEast.setLayout(new GridBagLayout());
            this.jPanelEast.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelEast;
    }

    private JPanel getJPanelSouth() {
        if (this.jPanelSouth == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanelSouth = new JPanel();
            this.jPanelSouth.setLayout(flowLayout);
            this.jPanelSouth.setPreferredSize(new Dimension(10, 43));
            this.jPanelSouth.add((Component)this.getJBtSave(), null);
            this.jPanelSouth.add((Component)this.getJBtClear(), null);
            this.jPanelSouth.add((Component)this.getJBtClose(), null);
        }
        return this.jPanelSouth;
    }

    private JPanel getJPanelCenter() {
        if (this.jPanelCenter == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(8, 8, 20, 8);
            gridBagConstraints2.gridy = 1;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Command/Return Value");
            this.jLabel = new JLabel();
            this.jLabel.setText("User");
            this.jPanelCenter = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.rowHeights = new int[]{84, 0, 0};
            gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            gridBagLayout.columnWeights = new double[]{1.0};
            this.jPanelCenter.setLayout(gridBagLayout);
            this.jPanelCenter.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "", 0, 0, null, null));
            this.jPanelCenter.setPreferredSize(new Dimension(780, 550));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(8, 8, 10, 8);
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            this.jPanelCenter.add((Component)this.getJPanelEvents(), gridBagConstraints3);
            this.jPanelCenter.add((Component)this.getJPanelSel(), gridBagConstraints2);
            this.jPanelCenter.add((Component)this.jScrollPane, gridBagConstraints);
        }
        return this.jPanelCenter;
    }

    private JButton getJBtClose() {
        if (this.jBtClose == null) {
            this.jBtClose = new JButton();
            this.jBtClose.setText("Close");
            this.jBtClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AuditLog.this.dispose();
                }
            });
        }
        return this.jBtClose;
    }

    private JButton getJBtClear() {
        if (this.jBtClear == null) {
            this.jBtClear = new JButton();
            this.jBtClear.setText("Clear Log...");
            this.jBtClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "Do you really want to delete all audit log entries?";
                    int n = AuditLog.this.tools.DisplayYesNoMsg(AuditLog.this, string);
                    if (n != 0) {
                        return;
                    }
                    AuditLog.this.CleanTable();
                    AuditLog.this.CSClearAuditLog();
                }
            });
        }
        return this.jBtClear;
    }

    public void CSClearAuditLog() {
        tools_thread.setInfoField(this.tools.PrepareText("", "Clear Audit Log"));
        tools_thread.waitStart();
        String string = CSJApi.CSClearAuditLog();
        if (string.length() != 0) {
            this.tools.DisplayErrorMsg(this, string);
        }
        tools_thread.waitEnd();
        tools_thread.setInfoField(string);
        this.CSGetAuditLog();
    }

    private JComboBox getJCbUserSel() {
        if (this.jCbUserSel == null) {
            this.jCbUserSel = new JComboBox();
            this.jCbUserSel.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1 && !AuditLog.this.b_start) {
                        AuditLog.this.auditRowFilter.setUserFilter(AuditLog.this.jCbUserSel.getSelectedItem().toString());
                        AuditLog.this.sorter.setRowFilter(AuditLog.this.auditRowFilter);
                    }
                }
            });
            this.jCbUserSel.addItem("All Users");
        }
        return this.jCbUserSel;
    }

    private JComboBox getJCbCmdState() {
        if (this.jCbCmdState == null) {
            this.jCbCmdState = new JComboBox();
            this.jCbCmdState.setEditable(true);
            this.jCbCmdState.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1 && !AuditLog.this.b_start) {
                        if (AuditLog.this.jCbCmdState.getSelectedItem().toString().equals(AuditLog.this.strCommands[1])) {
                            AuditLog.this.auditRowFilter.setErrorFilter(true);
                        } else {
                            AuditLog.this.auditRowFilter.setErrorFilter(false);
                        }
                        if (AuditLog.this.jCbCmdState.getSelectedItem().toString().equals(AuditLog.this.strCommands[2])) {
                            AuditLog.this.auditRowFilter.setNoErrorFilter(true);
                        } else {
                            AuditLog.this.auditRowFilter.setNoErrorFilter(false);
                        }
                        AuditLog.this.auditRowFilter.setCmdFilter(AuditLog.this.jCbCmdState.getSelectedItem().toString());
                        AuditLog.this.sorter.setRowFilter(AuditLog.this.auditRowFilter);
                    }
                }
            });
            for (int i = 0; i < this.strCommands.length; ++i) {
                this.jCbCmdState.addItem(this.strCommands[i]);
            }
        }
        return this.jCbCmdState;
    }

    private JPanel getJPanelSel() {
        if (this.jPanelSel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 0, 10, 8);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(10, 30, 10, 5);
            gridBagConstraints2.gridy = -1;
            gridBagConstraints2.gridx = -1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = -1;
            gridBagConstraints3.gridy = -1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(10, 0, 10, 0);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(10, 8, 10, 5);
            gridBagConstraints4.gridy = -1;
            gridBagConstraints4.gridx = -1;
            this.jPanelSel = new JPanel();
            this.jPanelSel.setLayout(new GridBagLayout());
            this.jPanelSel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Audit Log Filters", 0, 0, null, null));
            this.jPanelSel.add((Component)this.jLabel, gridBagConstraints4);
            this.jPanelSel.add((Component)this.getJCbUserSel(), gridBagConstraints3);
            this.jPanelSel.add((Component)this.jLabel1, gridBagConstraints2);
            this.jPanelSel.add((Component)this.getJCbCmdState(), gridBagConstraints);
        }
        return this.jPanelSel;
    }

    private void CleanTable() {
        for (int i = this.model.getRowCount(); i > 0; --i) {
            this.model.DelRow(i - 1);
        }
    }

    void FormatCol() {
        block6: for (int i = 0; i < this.jTable.getColumnCount(); ++i) {
            TableColumn tableColumn = this.jTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(110);
                    continue block6;
                }
                case 1: {
                    tableColumn.setPreferredWidth(170);
                    continue block6;
                }
                case 2: {
                    tableColumn.setPreferredWidth(400);
                    continue block6;
                }
                case 3: {
                    tableColumn.setPreferredWidth(90);
                }
            }
        }
    }

    public void CSGetAuditLog() {
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;
            String strCSReply2;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                this.strCSReply = CSJApi.CSGetAuditLog(Global.strAuditLogFileName);
                this.strCSReply2 = CSJApi.CSGetAuditConfig();
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (this.strCSReply.length() == 0) {
                    AuditLog.this.ShowAuditLog();
                }
                AuditLog.this.ShowAuditLogConfig(this.strCSReply2);
                tools_thread.setStatusBar();
            }
        };
        swingWorker.execute();
    }

    public void ShowAuditLog() {
        boolean bl = false;
        if (this.strAuditLogPath == null) {
            this.dispose();
            return;
        }
        try {
            String string;
            FileReader fileReader = new FileReader(this.strAuditLogPath);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.length() == 0) continue;
                AuditEntry auditEntry = new AuditEntry();
                auditEntry.setDate(simpleDateFormat.parse(string, new ParsePosition(0)));
                int n2 = string.indexOf("[");
                int n3 = string.indexOf("]");
                bl = n2 != -1;
                if (n2 != -1 && n3 != -1 && n2 == 18) {
                    auditEntry.setUser(" " + string.substring(n2 + 1, n3));
                } else {
                    auditEntry.setUser(" ---");
                    n2 = -1;
                    n3 = -1;
                }
                String string2 = auditEntry.getUser().replaceAll(" ", "");
                this.AddUserToCombo(string2);
                if (n3 == -1) {
                    n2 = 0;
                    n3 = 0;
                    n = 17;
                } else {
                    n = n3 + 1;
                }
                int n4 = string.substring(n3 + 2).lastIndexOf(91) + n3 + 2;
                int n5 = string.substring(n4).lastIndexOf(93);
                if (n4 != -1 && n5 != -1 && bl) {
                    if (n4 == (n5 += n4)) {
                        auditEntry.setReturnvalue(" ---");
                    } else {
                        auditEntry.setReturnvalue(" " + string.substring(n4 + 1, n5));
                        if (auditEntry.getReturnvalue().length() < 8) {
                            auditEntry.setErrorFlag(false);
                        } else {
                            auditEntry.setErrorFlag(true);
                        }
                    }
                } else {
                    auditEntry.setReturnvalue(" ---");
                    auditEntry.setErrorFlag(false);
                }
                if (!bl) {
                    auditEntry.setCmd(" " + string.substring(n + 1));
                } else if (n4 == n) {
                    auditEntry.setCmd(" " + string.substring(n + 1));
                } else {
                    auditEntry.setCmd(" " + string.substring(n + 1, n4));
                }
                this.model.addEntry(auditEntry);
                this.model.fireTableRowsInserted(this.model.getRowCount() - 1, this.model.getRowCount() - 1);
            }
            fileReader.close();
            this.jTable.scrollRectToVisible(this.jTable.getCellRect(this.jTable.getRowCount() - 1, -1, true));
        }
        catch (IOException iOException) {
            this.tools.DisplayErrorMsg(this.admin, "Read error: \r\r" + iOException.getMessage());
        }
    }

    private void AddUserToCombo(String string) {
        boolean bl = true;
        int n = this.jCbUserSel.getItemCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.jCbUserSel.getItemAt(i).toString();
            if (string2.compareTo(string) == 0) {
                bl = false;
                break;
            }
            bl = true;
        }
        if (bl) {
            this.jCbUserSel.addItem(string);
        }
    }

    private JButton getJBtSave() {
        if (this.jBtSave == null) {
            this.jBtSave = new JButton();
            this.jBtSave.setText("Save Log...");
            this.jBtSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = AuditLog.this.tools.ShowSaveDlg(AuditLog.this, "CryptoServer Audit Log File", AuditLog.this.ini.GetAuditLogFilePath(), ".log", "Log File (*.log)");
                    if (string == "") {
                        return;
                    }
                    AuditLog.this.ini.SetAuditLogFilePath(string);
                    String string2 = AuditLog.this.tools.ReadStrFile(Global.strAuditLogFileName);
                    AuditLog.this.tools.WriteBackupEntry(string, string2);
                }
            });
        }
        return this.jBtSave;
    }

    private JPanel getJPanelEvents() {
        if (this.jPanelEvents == null) {
            this.jPanelEvents = new JPanel();
            this.jPanelEvents.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Logged Events", 4, 2, null, null));
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWidths = new int[]{477, 6, 0};
            gridBagLayout.rowHeights = new int[]{39, 0};
            gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
            gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
            this.jPanelEvents.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 8, 5, 8);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.jPanelEvents.add((Component)this.getJtxtEvents(), gridBagConstraints);
        }
        return this.jPanelEvents;
    }

    private JTextPane getJtxtEvents() {
        if (this.jtxtEvents == null) {
            this.jtxtEvents = new JTextPane();
            this.jtxtEvents.setEditable(false);
        }
        return this.jtxtEvents;
    }
}

