/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.slotMng;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import p11cat.LayoutHelper;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.controller.CommandAction;
import p11cat.controller.task.InitPinTask;
import p11cat.view.CommandNodePanel;
import p11cat.view.ListenerButton;
import p11cat.view.slotMng.SlotMngPanel;

class InitPinPanel
extends CommandNodePanel {
    private static final long serialVersionUID = 2336427565796885697L;
    private StatusInfo statusInfo;
    private SlotMngPanel parent;
    private JPasswordField userPinField;
    private JPasswordField confirmUserPinField;
    private ListenerButton button;

    public InitPinPanel(StatusInfo statusInfo, SlotMngPanel slotMngPanel) {
        this.statusInfo = statusInfo;
        this.parent = slotMngPanel;
        this.userPinField = new JPasswordField(20);
        this.userPinField.setText("");
        JLabel jLabel = new JLabel(Messages.getString("P11CAT.SlotMng.InitPin.LabelPin"));
        jLabel.setLabelFor(this.userPinField);
        this.confirmUserPinField = new JPasswordField(20);
        this.confirmUserPinField.setText("");
        JLabel jLabel2 = new JLabel(Messages.getString("P11CAT.SlotMng.InitPin.LabelConfirmPin"));
        jLabel2.setLabelFor(this.confirmUserPinField);
        JTextField[] jTextFieldArray = new JTextField[]{this.userPinField, this.confirmUserPinField};
        this.button = new ListenerButton(new CommandAction(Messages.getString("P11CAT.SlotMng.InitPin.ButtonText"), this), jTextFieldArray);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.add(jLabel);
        this.add(this.userPinField);
        this.add(jLabel2);
        this.add(this.confirmUserPinField);
        this.add(this.button);
        int[][] nArrayArray = new int[][]{{0, 1}, {2, 3}, {-1, 4}};
        int[] nArray = new int[]{5, 5, 5};
        int[] nArray2 = new int[]{5, 5, 5, 5};
        LayoutHelper.makeSpringGrid(this, nArrayArray, nArray, nArray2);
    }

    @Override
    public void init() {
        this.userPinField.setText("");
        this.confirmUserPinField.setText("");
        this.button.setEnabled(false);
    }

    @Override
    public void executeCommand(ActionEvent actionEvent) {
        if (!Arrays.equals(this.userPinField.getPassword(), this.confirmUserPinField.getPassword())) {
            long l = this.statusInfo.getActiveSlotId();
            this.statusInfo.printError(Messages.getString("P11CAT.Error.InitPin.PinNotMatched"), l);
            this.init();
            return;
        }
        new InitPinTask(this.statusInfo, this.parent, new String(this.userPinField.getPassword())).execute();
    }
}

