/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.objMng;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import p11cat.Messages;
import p11cat.P11;
import p11cat.StatusInfo;
import p11cat.controller.EnableAction;
import p11cat.controller.ObjectTableMouseListener;
import p11cat.controller.RestartAction;
import p11cat.model.AuthState;
import p11cat.model.ObjectTableModel;
import p11cat.model.P11Object;
import p11cat.view.Card;
import p11cat.view.objMng.ObjectMngPanel;
import p11cat.view.objMng.ObjectTable;

public class ObjectTablePanel
extends Card
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = -5151133935814753075L;
    private JToolBar toolbar;
    private ObjectTable objectTable;
    private StatusInfo statusInfo;
    private Vector<EnableAction> actions = new Vector();
    private JToolBar progressToolBar;
    private JProgressBar progressBar;
    private JButton button;
    private ObjectTableTask objectTableTask;
    private long[] hObjects = null;
    private int index = 0;
    private RestartAction restartAction;

    private void executeObjectTableTask() {
        this.objectTableTask = new ObjectTableTask();
        this.objectTableTask.addPropertyChangeListener(this);
        this.progressToolBar.setVisible(true);
        this.switchButton(true);
        this.restartAction.setIsObjectTableTaskRunning(true);
        this.objectTableTask.execute();
    }

    private void switchButton(boolean bl) {
        if (bl) {
            this.button.setIcon(new ImageIcon(this.getClass().getResource("/player_pause.png")));
            this.button.setToolTipText(Messages.getString("P11CAT.ButtonToolTip.Pause"));
        } else {
            this.button.setIcon(new ImageIcon(this.getClass().getResource("/player_play.png")));
            this.button.setToolTipText(Messages.getString("P11CAT.ButtonToolTip.Resume"));
        }
    }

    public ObjectTablePanel(StatusInfo statusInfo, ObjectMngPanel objectMngPanel, RestartAction restartAction) {
        super(Messages.getString("P11CAT.ObjMng.ObjTable"), 0);
        this.statusInfo = statusInfo;
        this.restartAction = restartAction;
        this.toolbar = new JToolBar();
        this.add((Component)this.toolbar, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.progressToolBar = new JToolBar();
        this.progressToolBar.setFloatable(false);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.button = new JButton();
        this.button.addActionListener(this);
        this.switchButton(true);
        this.progressToolBar.add(this.progressBar);
        this.progressToolBar.add(this.button);
        this.objectTable = new ObjectTable(statusInfo);
        this.objectTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ObjectTablePanel.this.updateToolBar();
                }
            }
        });
        this.objectTable.addMouseListener(new ObjectTableMouseListener(objectMngPanel));
        JScrollPane jScrollPane = new JScrollPane(this.objectTable);
        jPanel.add((Component)this.progressToolBar, "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Center");
    }

    public void addToolBarButton(EnableAction enableAction, String string) {
        if (this.toolbar.getComponentCount() != 0) {
            this.toolbar.addSeparator();
        }
        JButton jButton = new JButton(enableAction);
        if (string != null) {
            jButton.setIcon(new ImageIcon(this.getClass().getResource(string)));
        }
        this.toolbar.add(jButton);
    }

    public void registerAction(EnableAction enableAction) {
        this.actions.addElement(enableAction);
    }

    public void fillObjectTable() {
        this.hObjects = null;
        this.index = 0;
        this.progressBar.setValue(0);
        this.progressToolBar.setVisible(false);
        this.objectTable.clear();
        this.executeObjectTableTask();
    }

    @Override
    public void init() {
        this.updateToolBar();
        this.objectTable.updateSelectedObjects();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("progress")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.progressBar.setValue(n);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.objectTableTask.isDone()) {
            this.executeObjectTableTask();
            this.switchButton(true);
        } else {
            this.objectTableTask.cancel(true);
            this.switchButton(false);
        }
    }

    public void updateToolBar() {
        for (int i = 0; i < this.actions.size(); ++i) {
            this.actions.elementAt(i).setEnabled(this.objectTable);
        }
    }

    public void addCreatedObjectsToTable(P11Object[] p11ObjectArray) {
        this.objectTable.addAndSelectObjects(p11ObjectArray);
    }

    public long getSelectedObjectHandle() {
        int n = this.objectTable.getSelectedRow();
        if (n >= 0) {
            ObjectTableModel objectTableModel = (ObjectTableModel)this.objectTable.getModel();
            int n2 = this.objectTable.convertRowIndexToModel(n);
            return objectTableModel.getObjectHandle(n2);
        }
        return 0L;
    }

    public ObjectTable getObjectTable() {
        return this.objectTable;
    }

    static /* synthetic */ long[] access$102(ObjectTablePanel objectTablePanel, long[] lArray) {
        objectTablePanel.hObjects = lArray;
        return lArray;
    }

    class ObjectTableTask
    extends SwingWorker<Void, Object> {
        private boolean noLogin;
        private long slotId;

        public ObjectTableTask() {
            AuthState authState = new AuthState(ObjectTablePanel.this.statusInfo.getLoginStatus());
            this.noLogin = authState.isZero();
            this.slotId = ObjectTablePanel.this.statusInfo.getActiveSlotId();
        }

        @Override
        protected Void doInBackground() {
            this.setProgress(0);
            if (ObjectTablePanel.this.hObjects == null) {
                try {
                    if (this.noLogin) {
                        P11.openSession(this.slotId);
                    }
                    ObjectTablePanel.access$102(ObjectTablePanel.this, P11.getObjectHandles());
                }
                catch (Exception exception) {
                    this.publish(exception);
                }
            }
            if (ObjectTablePanel.this.hObjects != null) {
                while (ObjectTablePanel.this.index < ObjectTablePanel.this.hObjects.length && !this.isCancelled()) {
                    try {
                        P11Object p11Object = new P11Object(ObjectTablePanel.this.hObjects[ObjectTablePanel.this.index]);
                        this.publish(p11Object);
                    }
                    catch (Exception exception) {
                        this.publish(exception);
                    }
                    ObjectTablePanel.this.index++;
                    this.setProgress(ObjectTablePanel.this.index * 100 / ObjectTablePanel.this.hObjects.length);
                }
            }
            if (this.noLogin) {
                P11.closeSession();
            }
            return null;
        }

        @Override
        protected void process(List<Object> list) {
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                if (object instanceof P11Object) {
                    ObjectTablePanel.this.objectTable.addObject((P11Object)object);
                    continue;
                }
                if (!(object instanceof Exception)) continue;
                ObjectTablePanel.this.statusInfo.printException((Exception)object, ObjectTablePanel.this.statusInfo.getActiveSlotId());
            }
        }

        @Override
        public void done() {
            if (!this.isCancelled()) {
                ObjectTablePanel.this.progressToolBar.setVisible(false);
            }
            ObjectTablePanel.this.restartAction.setIsObjectTableTaskRunning(false);
        }
    }
}

