/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.objMng;

import java.awt.Point;
import java.awt.event.MouseEvent;
import p11cat.StatusInfo;
import p11cat.model.ObjectTableModel;
import p11cat.model.P11Object;
import p11cat.view.Table;

public class ObjectTable
extends Table {
    private static final long serialVersionUID = 4633837933282831760L;
    private ObjectTableModel objectTableModel = null;
    private StatusInfo statusInfo;

    public ObjectTable(StatusInfo statusInfo) {
        this.statusInfo = statusInfo;
        this.setAutoCreateRowSorter(true);
        this.objectTableModel = new ObjectTableModel();
        this.setModel(this.objectTableModel);
    }

    public int addObject(P11Object p11Object) {
        return this.objectTableModel.addObject(p11Object);
    }

    public void addAndSelectObjects(P11Object[] p11ObjectArray) {
        this.clearSelection();
        boolean bl = true;
        for (int i = 0; i < p11ObjectArray.length; ++i) {
            P11Object p11Object = p11ObjectArray[i];
            int n = this.addObject(p11Object);
            int n2 = this.convertRowIndexToView(n);
            if (bl) {
                this.getSelectionModel().setSelectionInterval(n2, n2);
                bl = false;
                continue;
            }
            this.getSelectionModel().addSelectionInterval(n2, n2);
        }
        this.scrollToSelectedRow();
    }

    public void clear() {
        this.objectTableModel.clear();
        this.setAutoCreateRowSorter(true);
    }

    public void updateSelectedObjects() {
        if (this.getSelectedRowCount() > 0) {
            int[] nArray = this.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n = this.convertRowIndexToModel(nArray[i]);
                this.objectTableModel.updateObject(n, this.statusInfo);
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        Point point = mouseEvent.getPoint();
        int n2 = this.rowAtPoint(point);
        String string = this.getValueAt(n2, n = this.columnAtPoint(point)).toString();
        if (string.startsWith("0x")) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 2; i < string.length() - 1; i += 2) {
                String string2 = string.substring(i, i + 2);
                int n3 = Integer.parseInt(string2, 16);
                stringBuilder.append((char)n3);
            }
            string = string + "  (" + stringBuilder.toString() + ")";
        }
        return string;
    }
}

