/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.objMng;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.controller.DeleteObjectsAction;
import p11cat.controller.EnableAction;
import p11cat.controller.ExportCertAction;
import p11cat.controller.OpenCard2Action;
import p11cat.controller.OpenCardAction;
import p11cat.controller.RestartAction;
import p11cat.view.Card;
import p11cat.view.CardPanel;
import p11cat.view.ToolBar;
import p11cat.view.objMng.GeneratePanel;
import p11cat.view.objMng.ImportPanel;
import p11cat.view.objMng.ListAttrPanel;
import p11cat.view.objMng.ObjectTablePanel;

public class ObjectMngPanel
extends Card {
    private static final long serialVersionUID = 915926678896404548L;
    private CardPanel cardPanel;
    private ObjectTablePanel objectTablePanel;
    private ListAttrPanel listAttrPanel;
    private StatusInfo statusInfo;
    private ObjectMngPanelListener listener;

    public ObjectMngPanel(JMenuBar jMenuBar, ToolBar toolBar, StatusInfo statusInfo, RestartAction restartAction) {
        super(Messages.getString("P11CAT.ObjMng"));
        this.addTitlePanel();
        OpenCardAction openCardAction = new OpenCardAction(this, EnableAction.EnableCondition.ST_LOGIN_USER_OR_KEYM);
        statusInfo.registerActionAtSlotTable(openCardAction);
        toolBar.addButton(openCardAction, "/password.png");
        JMenu jMenu = new JMenu(openCardAction);
        jMenuBar.add(jMenu);
        this.cardPanel = new CardPanel();
        this.objectTablePanel = new ObjectTablePanel(statusInfo, this, restartAction);
        this.cardPanel.addCard(this.objectTablePanel);
        OpenCard2Action openCard2Action = new OpenCard2Action(openCardAction, this.objectTablePanel, openCardAction.getEnableCondition());
        statusInfo.registerActionAtSlotTable(openCard2Action);
        jMenu.add(openCard2Action);
        jMenu.addSeparator();
        GeneratePanel generatePanel = new GeneratePanel(jMenu, statusInfo, this.objectTablePanel, openCardAction);
        this.cardPanel.addCard(generatePanel);
        jMenu.addSeparator();
        ImportPanel importPanel = new ImportPanel(jMenu, statusInfo, this.objectTablePanel, openCardAction);
        this.cardPanel.addCard(importPanel);
        this.objectTablePanel.addToolBarButton(new ExportCertAction(statusInfo, this.objectTablePanel), "/filesave.png");
        this.objectTablePanel.addToolBarButton(new DeleteObjectsAction(statusInfo, this.objectTablePanel), "/editdelete.png");
        this.listAttrPanel = new ListAttrPanel(statusInfo, this.objectTablePanel);
        this.cardPanel.addCard(this.listAttrPanel);
        this.add((Component)this.cardPanel, "Center");
        this.statusInfo = statusInfo;
        this.listener = new ObjectMngPanelListener();
        this.addComponentListener(this.listener);
    }

    @Override
    public void init() {
        this.objectTablePanel.fillObjectTable();
        this.cardPanel.showCard(this.objectTablePanel);
    }

    public void showListAttrPanel() {
        this.cardPanel.showCard(this.listAttrPanel);
    }

    private class ObjectMngPanelListener
    implements ComponentListener {
        private ObjectMngPanelListener() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            ObjectMngPanel.this.statusInfo.softlockSlotTable(false);
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            ObjectMngPanel.this.statusInfo.softlockSlotTable(true);
        }
    }
}

