/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.objMng;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import p11cat.Messages;
import p11cat.P11;
import p11cat.StatusInfo;
import p11cat.controller.EnableAction;
import p11cat.controller.OpenCardAction;
import p11cat.model.AttributeTableModel;
import p11cat.view.AttributeTable;
import p11cat.view.Card;
import p11cat.view.objMng.ObjectTablePanel;

class ListAttrPanel
extends Card {
    private static final long serialVersionUID = 5444454316719776512L;
    private StatusInfo statusInfo;
    private ObjectTablePanel objectTablePanel;
    private AttributeTable table;

    public ListAttrPanel(StatusInfo statusInfo, ObjectTablePanel objectTablePanel) {
        super(Messages.getString("P11CAT.ObjMng.ListAttr"));
        this.addBackButtonPanel(objectTablePanel, Messages.getString("P11CAT.ButtonText.BackObjTable"));
        OpenCardAction openCardAction = new OpenCardAction(this, EnableAction.EnableCondition.OT_ONE_OBJECT_SELECTED);
        objectTablePanel.registerAction(openCardAction);
        objectTablePanel.addToolBarButton(openCardAction, "/forward.png");
        JLabel jLabel = new JLabel(Messages.getString("P11CAT.ObjMng.ListAttr.Label"));
        Font font = jLabel.getFont();
        if (font != null) {
            jLabel.setFont(font.deriveFont(font.getStyle() | 1));
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jLabel);
        this.table = new AttributeTable();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "Center");
        this.statusInfo = statusInfo;
        this.objectTablePanel = objectTablePanel;
    }

    @Override
    public void init() {
        long l = this.objectTablePanel.getSelectedObjectHandle();
        String string = null;
        try {
            string = P11.getAttributeValueList(l);
        }
        catch (Exception exception) {
            this.statusInfo.printException(exception, this.statusInfo.getActiveSlotId());
        }
        this.table.init(new AttributeTableModel(l, string, this.statusInfo));
    }
}

