/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.objMng;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import p11cat.Constants;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.controller.CommandAction;
import p11cat.controller.task.GenKeyTask;
import p11cat.view.CommandNodePanel;
import p11cat.view.objMng.ObjectTablePanel;
import p11cat.view.objMng.OverwriteAttrPanel;

class GenKeyPanel
extends CommandNodePanel
implements ActionListener {
    private static final long serialVersionUID = -8112655574224684904L;
    private static final String[] mechStr = new String[]{Messages.getString("P11CAT.ObjMng.Gen.Key.AES"), Messages.getString("P11CAT.ObjMng.Gen.Key.DES"), Messages.getString("P11CAT.ObjMng.Gen.Key.DES2"), Messages.getString("P11CAT.ObjMng.Gen.Key.DES3")};
    private static final long[] mech = new long[]{4224L, 288L, 304L, 305L};
    private static final Constants.Attr[][] keyAttr = new Constants.Attr[][]{Constants.GEN_AES_KEY_ATTR_LIST, Constants.GEN_DESX_KEY_ATTR_LIST, Constants.GEN_DESX_KEY_ATTR_LIST, Constants.GEN_DESX_KEY_ATTR_LIST};
    private StatusInfo statusInfo;
    private ObjectTablePanel objectTablePanel;
    private JComboBox mechComboBox;
    private OverwriteAttrPanel keyAttrPanel;

    public GenKeyPanel(StatusInfo statusInfo, ObjectTablePanel objectTablePanel) {
        this.statusInfo = statusInfo;
        this.objectTablePanel = objectTablePanel;
        this.mechComboBox = new JComboBox<String>(mechStr);
        this.mechComboBox.setSelectedItem(mechStr[0]);
        this.mechComboBox.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(new JLabel(Messages.getString("P11CAT.ObjMng.Gen.Key.LabelMech")));
        jPanel.add(this.mechComboBox);
        this.keyAttrPanel = new OverwriteAttrPanel(statusInfo, Messages.getString("P11CAT.AttributeList.LabelKey"));
        this.keyAttrPanel.setAttrArray(keyAttr[0]);
        this.keyAttrPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("P11CAT.AttributeList.BorderTitle")));
        JButton jButton = new JButton(new CommandAction(Messages.getString("P11CAT.ObjMng.Gen"), this));
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.keyAttrPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(jButton);
    }

    @Override
    public void init() {
        this.keyAttrPanel.init();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        if (jComboBox != null) {
            int n = jComboBox.getSelectedIndex();
            this.keyAttrPanel.setAttrArray(keyAttr[n]);
        }
    }

    @Override
    public void executeCommand(ActionEvent actionEvent) {
        int n = this.mechComboBox.getSelectedIndex();
        new GenKeyTask(this.statusInfo, this.objectTablePanel, mech[n], mechStr[n], this.keyAttrPanel.getAttributeList()).execute();
    }
}

