/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.login;

import java.awt.event.ActionEvent;
import p11cat.Messages;
import p11cat.P11;
import p11cat.StatusInfo;
import p11cat.controller.OpenCardAction;
import p11cat.view.CommandNodePanel;
import p11cat.view.login.LoginLogoutButton;

abstract class LoginNodePanel
extends CommandNodePanel {
    private static final long serialVersionUID = 5570193023176083078L;
    private OpenCardAction openDefaultCardAction;
    private LoginLogoutButton loginLogoutButton;
    protected StatusInfo statusInfo;

    public LoginNodePanel(StatusInfo statusInfo, OpenCardAction openCardAction, LoginLogoutButton loginLogoutButton) {
        this.statusInfo = statusInfo;
        this.openDefaultCardAction = openCardAction;
        this.loginLogoutButton = loginLogoutButton;
    }

    public abstract long login() throws Exception;

    @Override
    public void executeCommand(ActionEvent actionEvent) {
        long l = this.statusInfo.getSelectedSlotId();
        try {
            P11.openSession(l);
            this.statusInfo.printInfo(Messages.getString("P11CAT.Message.SessionOpened"), l);
            long l2 = this.login();
            this.statusInfo.setLoginStatus(l2);
            this.loginLogoutButton.getLoginAction().actionPerformed(actionEvent);
        }
        catch (Exception exception) {
            this.statusInfo.printException(exception, l);
            P11.closeSession();
            this.statusInfo.printInfo(Messages.getString("P11CAT.Message.SessionClosed"), l);
        }
    }
}

