/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import p11cat.Constants;
import p11cat.model.Attribute;

public class AttributeTableCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -1072225586721025867L;
    private Attribute currentAttribute;
    private DefaultCellEditor booleanCellEditor;
    private JComboBox booleanComboBox;
    private DefaultCellEditor ObjClassCellEditor;
    private JComboBox objClassComboBox;
    private DefaultCellEditor certTypeCellEditor;
    private JComboBox certTypeComboBox;
    private DefaultCellEditor keyTypeCellEditor;
    private JComboBox keyTypeComboBox;
    private DefaultCellEditor mechTypeCellEditor;
    private JComboBox mechTypeComboBox;
    private DefaultCellEditor hwFeatureCellEditor;
    private JComboBox hwFeatureComboBox;

    private void addToComboBox(JComboBox jComboBox, Object object) {
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (jComboBox.getItemAt(i).toString().compareTo(object.toString()) <= 0) continue;
            jComboBox.insertItemAt(object, i);
            return;
        }
        jComboBox.addItem(object);
    }

    private DefaultCellEditor createCellEditor(JComboBox jComboBox) {
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeTableCellEditor.this.stopCellEditing();
            }
        });
        return defaultCellEditor;
    }

    private void preselectComboBoxValue(JComboBox jComboBox, String string) {
        if (string == null) {
            return;
        }
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (!string.equals(jComboBox.getItemAt(i).toString())) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
    }

    private DefaultCellEditor getBooleanCellEditor(String string) {
        if (this.booleanCellEditor == null) {
            this.booleanComboBox = new JComboBox();
            this.booleanComboBox.addItem("CK_FALSE");
            this.booleanComboBox.addItem("CK_TRUE");
            this.booleanCellEditor = this.createCellEditor(this.booleanComboBox);
        }
        this.preselectComboBoxValue(this.booleanComboBox, string);
        return this.booleanCellEditor;
    }

    private DefaultCellEditor getObjClassCellEditor(String string) {
        if (this.ObjClassCellEditor == null) {
            this.objClassComboBox = new JComboBox();
            for (Constants.ObjClass objClass : Constants.ObjClass.values()) {
                this.addToComboBox(this.objClassComboBox, (Object)objClass);
            }
            this.ObjClassCellEditor = this.createCellEditor(this.objClassComboBox);
        }
        this.preselectComboBoxValue(this.objClassComboBox, string);
        return this.ObjClassCellEditor;
    }

    private DefaultCellEditor getCertTypeCellEditor(String string) {
        if (this.certTypeCellEditor == null) {
            this.certTypeComboBox = new JComboBox();
            for (Constants.CertType certType : Constants.CertType.values()) {
                this.addToComboBox(this.certTypeComboBox, (Object)certType);
            }
            this.certTypeCellEditor = this.createCellEditor(this.certTypeComboBox);
        }
        this.preselectComboBoxValue(this.certTypeComboBox, string);
        return this.certTypeCellEditor;
    }

    private DefaultCellEditor getKeyTypeCellEditor(String string) {
        if (this.keyTypeCellEditor == null) {
            this.keyTypeComboBox = new JComboBox();
            for (Constants.KeyType keyType : Constants.KeyType.values()) {
                this.addToComboBox(this.keyTypeComboBox, (Object)keyType);
            }
            this.keyTypeCellEditor = this.createCellEditor(this.keyTypeComboBox);
        }
        this.preselectComboBoxValue(this.keyTypeComboBox, string);
        return this.keyTypeCellEditor;
    }

    private DefaultCellEditor getMechTypeCellEditor(String string) {
        if (this.mechTypeCellEditor == null) {
            this.mechTypeComboBox = new JComboBox();
            for (Constants.Mechanism mechanism : Constants.Mechanism.values()) {
                this.addToComboBox(this.mechTypeComboBox, (Object)mechanism);
            }
            this.mechTypeCellEditor = this.createCellEditor(this.mechTypeComboBox);
        }
        this.preselectComboBoxValue(this.mechTypeComboBox, string);
        return this.mechTypeCellEditor;
    }

    private DefaultCellEditor getHwFeatureCellEditor(String string) {
        if (this.hwFeatureCellEditor == null) {
            this.hwFeatureComboBox = new JComboBox();
            for (Constants.HwFeature hwFeature : Constants.HwFeature.values()) {
                this.addToComboBox(this.hwFeatureComboBox, (Object)hwFeature);
            }
            this.hwFeatureCellEditor = this.createCellEditor(this.hwFeatureComboBox);
        }
        this.preselectComboBoxValue(this.hwFeatureComboBox, string);
        return this.hwFeatureCellEditor;
    }

    public AttributeTableCellEditor() {
        super(new JTextField());
        this.clickCountToStart = 1;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.currentAttribute != null) {
            switch (this.currentAttribute.getDataType()) {
                case CK_BBOOL: {
                    return this.booleanComboBox.getSelectedItem().toString();
                }
                case CK_OBJECT_CLASS: {
                    return this.objClassComboBox.getSelectedItem().toString();
                }
                case CK_CERTIFICATE_TYPE: {
                    return this.certTypeComboBox.getSelectedItem().toString();
                }
                case CK_KEY_TYPE: {
                    return this.keyTypeComboBox.getSelectedItem().toString();
                }
                case CK_MECHANISM_TYPE: {
                    return this.mechTypeComboBox.getSelectedItem().toString();
                }
                case CK_HW_FEATURE: {
                    return this.hwFeatureComboBox.getSelectedItem().toString();
                }
            }
        }
        return super.getCellEditorValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentAttribute = null;
        if (object instanceof Attribute) {
            this.currentAttribute = (Attribute)object;
            String string = this.currentAttribute.getValue();
            switch (this.currentAttribute.getDataType()) {
                case CK_BBOOL: {
                    return this.getBooleanCellEditor(string).getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                case CK_OBJECT_CLASS: {
                    return this.getObjClassCellEditor(string).getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                case CK_CERTIFICATE_TYPE: {
                    return this.getCertTypeCellEditor(string).getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                case CK_KEY_TYPE: {
                    return this.getKeyTypeCellEditor(string).getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                case CK_MECHANISM_TYPE: {
                    return this.getMechTypeCellEditor(string).getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                case CK_HW_FEATURE: {
                    return this.getHwFeatureCellEditor(string).getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
            }
            JTextField jTextField = (JTextField)this.getComponent();
            if (jTextField != null) {
                jTextField.setText(string);
            }
            return this.getComponent();
        }
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }
}

