/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import p11cat.Constants;
import p11cat.Messages;
import p11cat.model.InfoTableModel;
import p11cat.view.Table;
import p11cat.view.renderer.LabelCellRenderer;
import p11cat.view.renderer.TextColorCellRenderer;

public class StatusTable
extends Table {
    private static final long serialVersionUID = -650479482064538272L;
    private LabelCellRenderer messageTypeRenderer;
    private TextColorCellRenderer textColorCellRenderer;
    private InfoTableModel model;

    private LabelCellRenderer getMessageTypeRenderer() {
        if (this.messageTypeRenderer == null) {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/info.png"));
            ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/cancel.png"));
            Constants.MessageType[] messageTypeArray = new Constants.MessageType[]{Constants.MessageType.INFO, Constants.MessageType.ERROR};
            Icon[] iconArray = new ImageIcon[]{imageIcon, imageIcon2};
            String[] stringArray = new String[]{null, null};
            this.messageTypeRenderer = new LabelCellRenderer((Object[])messageTypeArray, iconArray, stringArray);
        }
        return this.messageTypeRenderer;
    }

    private TextColorCellRenderer getTextColorCellRenderer() {
        if (this.textColorCellRenderer == null) {
            this.textColorCellRenderer = new TextColorCellRenderer();
        }
        return this.textColorCellRenderer;
    }

    private InfoTableModel createModel(int n) {
        InfoTableModel infoTableModel = new InfoTableModel(n, null);
        infoTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatusTable.this.scrollToLastRow();
                    }
                });
            }
        });
        return infoTableModel;
    }

    private String getTimeStamp() {
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(date);
    }

    private void print(Constants.MessageType messageType, String string, long l) {
        Object[] objectArray;
        if (l >= 0L) {
            objectArray = String.format("%d", l & 0xFFFFL);
            string = Messages.getString("P11CAT.Message.Slot") + " " + (String)objectArray + ": " + string;
        }
        objectArray = new Object[]{messageType, this.getTimeStamp(), string};
        this.model.addRow(objectArray);
        this.adjustColumnWidthForLastRow();
    }

    public StatusTable() {
        this.setTableHeader(null);
        this.setFocusable(false);
        this.setRowSelectionAllowed(false);
        this.setGridColor(this.getBackground());
        this.setAutoResizeMode(0);
        this.model = this.createModel(3);
        this.setModel(this.model);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 == 0) {
            return this.getMessageTypeRenderer();
        }
        return this.getTextColorCellRenderer();
    }

    public void printInfo(String string) {
        this.printInfo(string, -1L);
    }

    public void printInfo(String string, long l) {
        string = string + "\n";
        this.print(Constants.MessageType.INFO, string, l);
    }

    public void printError(String string) {
        this.printError(string, -1L);
    }

    public void printError(String string, long l) {
        string = string + "\n";
        this.print(Constants.MessageType.ERROR, string, l);
    }

    public void printException(Exception exception) {
        this.printException(exception, -1L);
    }

    public void printException(Exception exception, long l) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        String string = stackTraceElementArray[0].toString() + ": " + exception.getMessage();
        this.print(Constants.MessageType.ERROR, string, l);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        String string = "";
        for (int i = 0; i < this.getColumnCount(); ++i) {
            string = string + this.getValueAt(n, i).toString() + "  ";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.getRowCount(); ++i) {
                Constants.MessageType messageType = (Constants.MessageType)((Object)this.getValueAt(i, 0));
                String string = (String)this.getValueAt(i, 1);
                String string2 = (String)this.getValueAt(i, 2);
                bufferedWriter.write(messageType.toString() + "\t" + string + "\t - " + string2);
            }
        }
        catch (Exception exception) {
            this.printException(exception);
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void clear() {
        this.model.clear();
    }
}

