/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import p11cat.Messages;
import p11cat.P11;
import p11cat.controller.OpenCardAction;
import p11cat.controller.RestartAction;
import p11cat.model.Slot;
import p11cat.view.SlotTable;
import p11cat.view.StatusBar;
import p11cat.view.StatusTable;

public class SlotPanel
extends JPanel
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 3558782264031267027L;
    private StatusTable statusTable;
    private JToolBar progressToolBar;
    private JProgressBar progressBar;
    private SlotTable slotTable;
    private JButton button;
    private SlotListTask slotListTask = null;
    private long[] slotList = null;
    private int index = 0;
    private RestartAction restartAction;

    private void executeSlotListTask() {
        this.progressToolBar.setVisible(true);
        this.switchButton(true);
        this.slotListTask = new SlotListTask();
        this.slotListTask.addPropertyChangeListener(this);
        this.restartAction.setIsSlotListTaskRunning(true);
        this.slotListTask.execute();
    }

    private void switchButton(boolean bl) {
        if (bl) {
            this.button.setIcon(new ImageIcon(this.getClass().getResource("/player_pause.png")));
            this.button.setToolTipText(Messages.getString("P11CAT.ButtonToolTip.Pause"));
        } else {
            this.button.setIcon(new ImageIcon(this.getClass().getResource("/player_play.png")));
            this.button.setToolTipText(Messages.getString("P11CAT.ButtonToolTip.Resume"));
        }
    }

    public SlotPanel(OpenCardAction openCardAction, RestartAction restartAction, StatusTable statusTable, StatusBar statusBar) {
        this.restartAction = restartAction;
        this.statusTable = statusTable;
        this.setLayout(new BorderLayout(0, 0));
        this.progressToolBar = new JToolBar();
        this.progressToolBar.setFloatable(false);
        this.progressToolBar.setVisible(false);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.button = new JButton();
        this.button.addActionListener(this);
        this.switchButton(true);
        this.progressToolBar.add(this.progressBar);
        this.progressToolBar.add(this.button);
        this.slotTable = new SlotTable(openCardAction, statusTable, statusBar);
        JScrollPane jScrollPane = new JScrollPane(this.slotTable);
        jScrollPane.setPreferredSize(this.slotTable.getPreferredSize());
        this.add((Component)this.progressToolBar, "North");
        this.add((Component)jScrollPane, "Center");
    }

    public void init(boolean bl) {
        this.slotList = null;
        this.index = 0;
        this.progressBar.setValue(0);
        this.progressToolBar.setVisible(false);
        this.slotTable.init(bl);
        if (bl) {
            this.executeSlotListTask();
        }
    }

    public SlotTable getSlotTable() {
        return this.slotTable;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("progress")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.progressBar.setValue(n);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.slotListTask.isDone()) {
            this.executeSlotListTask();
            this.switchButton(true);
        } else {
            this.slotListTask.cancel(true);
            this.switchButton(false);
        }
    }

    static /* synthetic */ long[] access$002(SlotPanel slotPanel, long[] lArray) {
        slotPanel.slotList = lArray;
        return lArray;
    }

    class SlotListTask
    extends SwingWorker<Void, Object> {
        SlotListTask() {
        }

        @Override
        protected Void doInBackground() {
            this.setProgress(0);
            if (SlotPanel.this.slotList == null) {
                try {
                    SlotPanel.access$002(SlotPanel.this, P11.getSlotList());
                }
                catch (Exception exception) {
                    this.publish(exception);
                }
            }
            if (SlotPanel.this.slotList != null) {
                while (SlotPanel.this.index < SlotPanel.this.slotList.length && !this.isCancelled()) {
                    Slot slot = new Slot(SlotPanel.this.slotList[SlotPanel.this.index]);
                    SlotPanel.this.index++;
                    this.setProgress(SlotPanel.this.index * 100 / SlotPanel.this.slotList.length);
                    this.publish(slot);
                }
            }
            return null;
        }

        @Override
        protected void process(List<Object> list) {
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                if (object instanceof Slot) {
                    SlotPanel.this.slotTable.addSlot((Slot)object);
                    continue;
                }
                if (!(object instanceof Exception)) continue;
                SlotPanel.this.statusTable.printException((Exception)object);
            }
        }

        @Override
        public void done() {
            if (!SlotPanel.this.slotListTask.isCancelled()) {
                SlotPanel.this.progressToolBar.setVisible(false);
            }
            SlotPanel.this.restartAction.setIsSlotListTaskRunning(false);
        }
    }
}

