/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import p11cat.Messages;
import p11cat.P11;
import p11cat.StatusInfo;
import p11cat.controller.ClearStatusTableAction;
import p11cat.controller.EnableAction;
import p11cat.controller.OpenCardAction;
import p11cat.controller.RestartAction;
import p11cat.controller.SaveStatusTableAction;
import p11cat.controller.ShowAboutDialogAction;
import p11cat.controller.ShowVersionInfoDialogAction;
import p11cat.view.Card;
import p11cat.view.CardPanel;
import p11cat.view.P11CAT;
import p11cat.view.SlotPanel;
import p11cat.view.StatusBar;
import p11cat.view.StatusTable;
import p11cat.view.ToolBar;
import p11cat.view.backup.BackupRestorePanel;
import p11cat.view.configMng.ConfigMngPanel;
import p11cat.view.info.InfoPanel;
import p11cat.view.login.LoginPanel;
import p11cat.view.objMng.ObjectMngPanel;
import p11cat.view.slotMng.SlotMngPanel;

public class MainPanel
extends JPanel {
    private static final long serialVersionUID = -8294157074762934261L;
    private ToolBar toolBar;
    private StatusTable statusTable;
    private SlotPanel slotPanel;
    private OpenCardAction openDefaultCardAction;

    public MainPanel(P11CAT p11CAT, JMenuBar jMenuBar) {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        this.statusTable = new StatusTable();
        JScrollPane jScrollPane = new JScrollPane(this.statusTable);
        jScrollPane.getViewport().setBackground(this.statusTable.getBackground());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOrientation(1);
        jToolBar.setFloatable(false);
        jToolBar.add(new SaveStatusTableAction(this.statusTable));
        jToolBar.add(new ClearStatusTableAction(this.statusTable));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jToolBar, "East");
        jPanel.add((Component)jScrollPane, "Center");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setMinimumSize(new Dimension(400, 150));
        jTabbedPane.addTab(Messages.getString("P11CAT.StatusPanel.Title"), jPanel);
        this.toolBar = new ToolBar();
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(this.toolBar);
        this.add((Component)jPanel2, "North");
        RestartAction restartAction = new RestartAction(this);
        this.toolBar.addButton(restartAction, "/reload.png");
        this.toolBar.addSeparator();
        StatusBar statusBar = new StatusBar();
        this.add((Component)statusBar, "South");
        Card card = new Card("Default");
        this.openDefaultCardAction = new OpenCardAction(card, EnableAction.EnableCondition.ALWAYS_TRUE);
        this.slotPanel = new SlotPanel(this.openDefaultCardAction, restartAction, this.statusTable, statusBar);
        JTabbedPane jTabbedPane2 = new JTabbedPane();
        jTabbedPane2.addTab(Messages.getString("P11CAT.SlotPanel.Title"), this.slotPanel);
        StatusInfo statusInfo = new StatusInfo(p11CAT, this.statusTable, this.slotPanel.getSlotTable());
        CardPanel cardPanel = new CardPanel();
        cardPanel.addCard(card);
        InfoPanel infoPanel = new InfoPanel(jMenuBar, this.toolBar, statusInfo);
        cardPanel.addCard(infoPanel);
        LoginPanel loginPanel = new LoginPanel(jMenuBar, this.toolBar, statusInfo, this.openDefaultCardAction);
        cardPanel.addCard(loginPanel);
        SlotMngPanel slotMngPanel = new SlotMngPanel(jMenuBar, this.toolBar, statusInfo);
        cardPanel.addCard(slotMngPanel);
        ObjectMngPanel objectMngPanel = new ObjectMngPanel(jMenuBar, this.toolBar, statusInfo, restartAction);
        cardPanel.addCard(objectMngPanel);
        this.toolBar.addSeparator();
        ConfigMngPanel configMngPanel = new ConfigMngPanel(jMenuBar, this.toolBar, statusInfo);
        cardPanel.addCard(configMngPanel);
        BackupRestorePanel backupRestorePanel = new BackupRestorePanel(jMenuBar, this.toolBar, statusInfo);
        cardPanel.addCard(backupRestorePanel);
        ShowAboutDialogAction showAboutDialogAction = new ShowAboutDialogAction(p11CAT);
        ShowVersionInfoDialogAction showVersionInfoDialogAction = new ShowVersionInfoDialogAction(p11CAT);
        JMenu jMenu = new JMenu(showAboutDialogAction);
        jMenu.add(showAboutDialogAction);
        jMenu.add(showVersionInfoDialogAction);
        jMenuBar.add(jMenu);
        JSplitPane jSplitPane = new JSplitPane(0, cardPanel, jTabbedPane);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder());
        jSplitPane.setResizeWeight(0.9);
        JSplitPane jSplitPane2 = new JSplitPane(1, jTabbedPane2, jSplitPane);
        jSplitPane2.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)jSplitPane2, "Center");
    }

    public void init() {
        try {
            P11.initialize();
            this.statusTable.printInfo(Messages.getString("P11CAT.Message.P11Initialized"));
            this.slotPanel.init(true);
        }
        catch (Exception exception) {
            this.statusTable.printException(exception);
            this.statusTable.printError(Messages.getString("P11CAT.Message.P11CfgCheck"));
            this.slotPanel.init(false);
        }
    }

    public void clear() {
        this.openDefaultCardAction.actionPerformed(null);
        this.slotPanel.getSlotTable().logoutAtRestart(this.statusTable);
        P11.finalizeP11();
        this.statusTable.printInfo(Messages.getString("P11CAT.Message.P11Finalized"));
    }

    public void close() {
        this.clear();
        System.exit(0);
    }
}

