/*
 * Decompiled with CFR 0.152.
 */
package p11cat.model;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import p11cat.Messages;
import p11cat.model.AuthState;
import p11cat.model.Slot;
import p11cat.view.StatusTable;

public class SlotTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4167204683513166524L;
    private String[] columnNames = new String[]{Messages.getString("P11CAT.SlotPanel.Col.SlotId"), Messages.getString("P11CAT.SlotPanel.Col.TokenInit"), Messages.getString("P11CAT.SlotPanel.Col.PinInit"), Messages.getString("P11CAT.SlotPanel.Col.LoginStatus")};
    private Vector<Slot> slots = new Vector();
    private StatusTable statusTable;
    public static final int COLUMN_SLOT_ID = 0;
    public static final int COLUMN_TOKEN_INIT = 1;
    public static final int COLUMN_PIN_INIT = 2;
    public static final int COLUMN_LOGIN_STATUS = 3;

    public SlotTableModel(StatusTable statusTable) {
        this.statusTable = statusTable;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.slots.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Slot slot = this.slots.elementAt(n);
        AuthState authState = new AuthState(slot.getLoginStatus());
        switch (n2) {
            case 0: {
                return slot.getSlotId();
            }
            case 1: {
                return slot.getTokenInitStatus();
            }
            case 2: {
                return slot.getPinInitStatus();
            }
            case 3: {
                return authState.getHexString();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public void addSlot(Slot slot) {
        int n = this.slots.size();
        this.slots.addElement(slot);
        if (slot.getInitException() != null) {
            this.statusTable.printException(slot.getInitException(), slot.getSlotId());
        }
        this.fireTableRowsInserted(n, n);
    }

    public void clear() {
        this.slots.removeAllElements();
        this.fireTableDataChanged();
    }

    public void setLoginStatus(long l, int n) {
        this.slots.elementAt(n).setLoginStatus(l);
        this.fireTableRowsUpdated(n, n);
    }

    public int getLoggedRow() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.slots.elementAt(i).getLoginStatus() == 0L) continue;
            return i;
        }
        return -1;
    }

    public void updateRow(int n) {
        Slot slot = this.slots.elementAt(n);
        if (!slot.updateTokenAndPinInitStatus()) {
            this.statusTable.printException(slot.getInitException(), slot.getSlotId());
        }
        this.fireTableRowsUpdated(n, n);
    }
}

