/*
 * Decompiled with CFR 0.152.
 */
package p11cat.model;

import p11cat.Constants;
import p11cat.P11;

public class Slot {
    private Long slotId;
    private Constants.InitStatus tokenInitStatus;
    private Constants.InitStatus pinInitStatus;
    private long loginStatus;
    private Exception initException = null;

    public Slot(long l) {
        this.slotId = new Long(l);
        this.loginStatus = 0L;
        this.updateTokenAndPinInitStatus();
    }

    public Slot(long l, Constants.InitStatus initStatus, Constants.InitStatus initStatus2, long l2) {
        this.slotId = new Long(l);
        this.tokenInitStatus = initStatus;
        this.pinInitStatus = initStatus2;
        this.loginStatus = l2;
    }

    public boolean updateTokenAndPinInitStatus() {
        try {
            boolean[] blArray = P11.getTokenAndPinInitStatus(this.slotId);
            if (blArray.length == 2) {
                this.tokenInitStatus = blArray[0] ? Constants.InitStatus.TRUE : Constants.InitStatus.FALSE;
                this.pinInitStatus = blArray[1] ? Constants.InitStatus.TRUE : Constants.InitStatus.FALSE;
            } else {
                this.tokenInitStatus = Constants.InitStatus.ERROR;
                this.pinInitStatus = Constants.InitStatus.ERROR;
            }
            this.initException = null;
            return true;
        }
        catch (Exception exception) {
            this.tokenInitStatus = Constants.InitStatus.ERROR;
            this.pinInitStatus = Constants.InitStatus.ERROR;
            this.initException = exception;
            return false;
        }
    }

    public Long getSlotId() {
        return this.slotId;
    }

    public Constants.InitStatus getTokenInitStatus() {
        return this.tokenInitStatus;
    }

    public void setTokenInitStatus(Constants.InitStatus initStatus) {
        this.tokenInitStatus = initStatus;
    }

    public Constants.InitStatus getPinInitStatus() {
        return this.pinInitStatus;
    }

    public void setPinInitStatus(Constants.InitStatus initStatus) {
        this.pinInitStatus = initStatus;
    }

    public Exception getInitException() {
        return this.initException;
    }

    public long getLoginStatus() {
        return this.loginStatus;
    }

    public void setLoginStatus(long l) {
        this.loginStatus = l;
    }
}

