/*
 * Decompiled with CFR 0.152.
 */
package p11cat.model;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import p11cat.Constants;
import p11cat.Messages;
import p11cat.P11;
import p11cat.StatusInfo;
import p11cat.model.Attribute;
import p11cat.model.AuthState;

public class AttributeTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2364471390988524043L;
    private String[] columnNames = new String[]{Messages.getString("P11CAT.AttributeTable.Col.Attribute"), Messages.getString("P11CAT.AttributeTable.Col.DataType"), Messages.getString("P11CAT.AttributeTable.Col.Value")};
    private Vector<Attribute> attributes;
    private long hObject = 0L;
    private StatusInfo statusInfo;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_VALUE = 2;

    private Attribute createAttribute(String string, String string2) {
        for (Constants.Attr attr : Constants.Attr.values()) {
            if (!attr.toString().equals(string)) continue;
            Attribute attribute = Attribute.attributeFactory(attr);
            if (!attribute.checkValue(string2)) break;
            attribute.setValue(string2);
            return attribute;
        }
        return null;
    }

    private Vector<Attribute> createAttributeList(String string) {
        Vector<Attribute> vector = new Vector<Attribute>();
        if (string != null && !string.equals("")) {
            String[] stringArray = string.split(",-,");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("=");
                Attribute attribute = null;
                if (stringArray2.length == 2) {
                    attribute = this.createAttribute(stringArray2[0], stringArray2[1]);
                } else if (stringArray2.length == 1) {
                    attribute = this.createAttribute(stringArray2[0], "");
                }
                if (attribute == null) {
                    return null;
                }
                vector.addElement(attribute);
            }
        }
        return vector;
    }

    public AttributeTableModel(Vector<Attribute> vector, StatusInfo statusInfo) {
        this.attributes = vector == null ? new Vector() : vector;
        this.statusInfo = statusInfo;
    }

    public AttributeTableModel(long l, Vector<Attribute> vector, StatusInfo statusInfo) {
        this.hObject = l;
        this.attributes = vector == null ? new Vector() : vector;
        this.statusInfo = statusInfo;
    }

    public AttributeTableModel(long l, String string, StatusInfo statusInfo) {
        this.hObject = l;
        this.statusInfo = statusInfo;
        this.init(string);
    }

    public boolean init(String string) {
        this.attributes = this.createAttributeList(string);
        if (this.attributes == null) {
            this.attributes = new Vector();
        }
        this.fireTableDataChanged();
        return this.attributes != null;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.attributes.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValueAt(int n, int n2) {
        Attribute attribute = this.attributes.elementAt(n);
        switch (n2) {
            case 0: {
                return attribute.getName();
            }
            case 1: {
                return attribute.getDataType();
            }
            case 2: {
                if (this.hObject == 0L) return attribute;
                try {
                    String string = P11.getAttributeValue(this.hObject, attribute.getName());
                    attribute.setValue(string);
                    return attribute;
                }
                catch (Exception exception) {
                    if (exception.getMessage().indexOf("CKR_ATTRIBUTE_TYPE_INVALID") >= 0) return attribute;
                    this.statusInfo.printException(exception, this.statusInfo.getActiveSlotId());
                }
                return attribute;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 2) {
            AuthState authState = new AuthState(this.statusInfo.getLoginStatus());
            if (this.hObject == Constants.GLOBAL_CONFIG_HANDLE) {
                return authState.isAdmin();
            }
            if (this.hObject == Constants.SLOT_CONFIG_HANDLE) {
                if (authState.isSO()) {
                    try {
                        String string = P11.getAttributeValue(Constants.GLOBAL_CONFIG_HANDLE, Constants.Attr.CKA_CFG_ALLOW_SLOTS.toString());
                        return string != null && string.equals("CK_TRUE") && this.attributes.elementAt(n).isEditable();
                    }
                    catch (Exception exception) {
                        this.statusInfo.printException(exception, this.statusInfo.getActiveSlotId());
                    }
                }
                return false;
            }
            return this.attributes.elementAt(n).isEditable();
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 2 && object instanceof String) {
            String string;
            Attribute attribute = this.attributes.elementAt(n);
            if (!attribute.isValueEqual(string = (String)object)) {
                if (this.hObject != 0L) {
                    long l = this.statusInfo.getActiveSlotId();
                    try {
                        P11.setAttributeValue(this.hObject, attribute.getName(), string);
                        Object[] objectArray = new Object[]{attribute.getName(), string};
                        this.statusInfo.printInfo(Messages.getString("P11CAT.Message.SetAttribute", objectArray), l);
                    }
                    catch (Exception exception) {
                        this.statusInfo.printException(exception, l);
                    }
                } else if (!attribute.checkValue(string)) {
                    return;
                }
                attribute.setValue(string);
            }
            this.fireTableCellUpdated(n, n2);
        }
    }

    public Attribute getAttributeByIndex(int n) {
        return this.attributes.elementAt(n);
    }

    public Attribute getAttributeByName(String string) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attribute = this.attributes.elementAt(i);
            if (!attribute.getName().equals(string)) continue;
            return attribute;
        }
        return null;
    }

    public void setAttributeMarked(int n, boolean bl) {
        this.attributes.elementAt(n).setMarked(bl);
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.addElement(attribute);
        int n = this.getRowCount() - 1;
        this.fireTableRowsInserted(n, n);
    }

    public void removeMarkedAttributes() {
        Iterator<Attribute> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isMarked()) continue;
            iterator.remove();
        }
        this.fireTableDataChanged();
    }

    public void removeAllAttributes() {
        this.attributes.removeAllElements();
        this.fireTableDataChanged();
    }
}

