/*
 * Decompiled with CFR 0.152.
 */
package p11cat.model;

import p11cat.Constants;
import p11cat.model.BoolAttribute;
import p11cat.model.CertTypeAttribute;
import p11cat.model.HwFeatureAttribute;
import p11cat.model.KeyTypeAttribute;
import p11cat.model.MechTypeAttribute;
import p11cat.model.ObjClassAttribute;
import p11cat.model.StringAttribute;
import p11cat.model.ULongAttribute;

public abstract class Attribute {
    private Constants.Attr attr;
    private String value = null;
    private boolean isEditable = true;
    private boolean isMarked = false;

    public static Attribute attributeFactory(Constants.Attr attr) {
        switch (attr.getDataType()) {
            case CK_BBOOL: {
                return new BoolAttribute(attr);
            }
            case CK_ULONG: 
            case ULONG_MASK: {
                return new ULongAttribute(attr);
            }
            case CK_OBJECT_CLASS: {
                return new ObjClassAttribute(attr);
            }
            case CK_CERTIFICATE_TYPE: {
                return new CertTypeAttribute(attr);
            }
            case CK_KEY_TYPE: {
                return new KeyTypeAttribute(attr);
            }
            case CK_MECHANISM_TYPE: {
                return new MechTypeAttribute(attr);
            }
            case CK_HW_FEATURE: {
                return new HwFeatureAttribute(attr);
            }
        }
        return new StringAttribute(attr);
    }

    public static Attribute attributeFactory(Constants.Attr attr, boolean bl) {
        Attribute attribute = Attribute.attributeFactory(attr);
        attribute.setEditable(bl);
        return attribute;
    }

    Attribute(Constants.Attr attr) {
        this.attr = attr;
    }

    public abstract void setDefaultValue();

    public abstract boolean isValueEqual(String var1);

    public abstract boolean checkValue(String var1);

    public String getName() {
        return this.attr.toString();
    }

    public Constants.DataType getDataType() {
        return this.attr.getDataType();
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getName();
    }

    public void setValue(String string) {
        this.value = string;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public boolean isMarked() {
        return this.isMarked;
    }

    public void setMarked(boolean bl) {
        this.isMarked = bl;
    }
}

