/*
 * Decompiled with CFR 0.152.
 */
package p11cat.controller.task;

import p11cat.Messages;
import p11cat.P11;
import p11cat.StatusInfo;
import p11cat.controller.task.AbstractSlotMngTask;
import p11cat.model.AuthState;
import p11cat.view.slotMng.SlotMngPanel;

public class SetPinTask
extends AbstractSlotMngTask {
    private long loginStatus;
    private long slotId;
    private String oldPassword;
    private String newPassword;

    public SetPinTask(StatusInfo statusInfo, SlotMngPanel slotMngPanel, String string, String string2) {
        super(statusInfo, slotMngPanel, false);
        this.loginStatus = statusInfo.getLoginStatus();
        this.slotId = statusInfo.getActiveSlotId();
        this.oldPassword = string;
        this.newPassword = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Void doInBackground() throws Exception {
        AuthState authState = new AuthState(this.loginStatus);
        try {
            if (authState.isZero()) {
                P11.openSession(this.slotId);
                this.publish(Messages.getString("P11CAT.Message.SessionOpened"));
            }
            P11.setPin(this.oldPassword, this.newPassword);
            if (authState.isAdmin()) {
                this.publish(Messages.getString("P11CAT.Message.SetPinGeneric"));
            }
            if (authState.isSO()) {
                this.publish(Messages.getString("P11CAT.Message.SetPinSO"));
            }
            if (authState.isUser()) {
                this.publish(Messages.getString("P11CAT.Message.SetPinUser"));
            }
            this.statusInfo.setLoginStatus(P11.getAuthState());
            P11.closeSession();
            this.publish(Messages.getString("P11CAT.Message.SessionClosed"));
            if (!authState.isZero()) return null;
        }
        catch (Exception exception) {
            try {
                this.publish(exception);
                if (!authState.isZero()) return null;
            }
            catch (Throwable throwable) {
                if (!authState.isZero()) throw throwable;
                P11.closeSession();
                this.publish(Messages.getString("P11CAT.Message.SessionClosed"));
                throw throwable;
            }
            P11.closeSession();
            this.publish(Messages.getString("P11CAT.Message.SessionClosed"));
            return null;
        }
        P11.closeSession();
        this.publish(Messages.getString("P11CAT.Message.SessionClosed"));
        return null;
    }
}

