/*
 * Decompiled with CFR 0.152.
 */
package p11cat.controller.task;

import p11cat.Constants;
import p11cat.Messages;
import p11cat.P11;
import p11cat.StatusInfo;
import p11cat.controller.task.AbstractVoidTask;
import p11cat.model.Message;

public class RestoreKeysTask
extends AbstractVoidTask {
    private String filename;
    private boolean toExternal;

    public RestoreKeysTask(StatusInfo statusInfo, String string, boolean bl) {
        super(statusInfo);
        this.filename = string;
        this.toExternal = bl;
    }

    @Override
    protected Void doInBackground() throws Exception {
        if (this.toExternal) {
            int[] nArray = P11.restoreKeys(this.filename, 1);
            if (nArray != null && nArray.length == 2) {
                Object[] objectArray;
                if (nArray[0] > 0) {
                    objectArray = new Object[]{new Integer(nArray[0]), this.filename};
                    this.publish(Messages.getString("P11CAT.Message.RestoreExtKeysToExt", objectArray));
                }
                if (nArray[1] > 0) {
                    objectArray = new Object[]{new Integer(nArray[1]), this.filename};
                    this.publish(Messages.getString("P11CAT.Message.RestoreIntKeysToExt", objectArray));
                }
            } else {
                String string = Messages.getString("P11CAT.Message.RestoreKeysError");
                this.publish(new Message(Constants.MessageType.ERROR, string));
            }
        } else {
            int[] nArray = P11.restoreKeys(this.filename, 0);
            if (nArray != null && nArray.length == 2) {
                Object[] objectArray;
                if (nArray[0] > 0) {
                    objectArray = new Object[]{new Integer(nArray[0]), this.filename};
                    this.publish(Messages.getString("P11CAT.Message.RestoreExtKeysToInt", objectArray));
                }
                if (nArray[1] > 0) {
                    objectArray = new Object[]{new Integer(nArray[1]), this.filename};
                    this.publish(Messages.getString("P11CAT.Message.RestoreIntKeysToInt", objectArray));
                }
            } else {
                String string = Messages.getString("P11CAT.Message.RestoreKeysError");
                this.publish(new Message(Constants.MessageType.ERROR, string));
            }
        }
        return null;
    }
}

