/*
 * Decompiled with CFR 0.152.
 */
package p11cat.controller.task;

import java.util.Vector;
import p11cat.Messages;
import p11cat.P11;
import p11cat.StatusInfo;
import p11cat.controller.task.AbstractTask;
import p11cat.model.ObjectTableModel;
import p11cat.view.objMng.ObjectTable;

public class DeleteObjectsTask
extends AbstractTask<Integer> {
    private ObjectTableModel objectTableModel;
    private Vector<Long> hObjects = new Vector();

    public DeleteObjectsTask(StatusInfo statusInfo, ObjectTable objectTable) {
        super(statusInfo);
        this.objectTableModel = (ObjectTableModel)objectTable.getModel();
        int[] nArray = objectTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = objectTable.convertRowIndexToModel(nArray[i]);
            this.objectTableModel.setObjectMarked(n, true);
            long l = this.objectTableModel.getObjectHandle(n);
            this.hObjects.addElement(l);
        }
    }

    @Override
    protected Integer doInBackground() {
        int n = 0;
        for (int i = 0; i < this.hObjects.size(); ++i) {
            try {
                P11.destroyObject(this.hObjects.elementAt(i));
                ++n;
                continue;
            }
            catch (Exception exception) {
                this.publish(exception);
            }
        }
        return new Integer(n);
    }

    @Override
    public void taskFinished(Integer n) throws Exception {
        this.objectTableModel.removeMarkedObjects();
        if (n > 0) {
            Object[] objectArray = new Object[]{n};
            long l = this.statusInfo.getActiveSlotId();
            this.statusInfo.printInfo(Messages.getString("P11CAT.Message.DeleteObj", objectArray), l);
        }
    }
}

