/*
 * Decompiled with CFR 0.152.
 */
package p11cat.controller.task;

import java.util.List;
import javax.swing.SwingWorker;
import p11cat.Constants;
import p11cat.StatusInfo;
import p11cat.model.Message;

public abstract class AbstractTask<T>
extends SwingWorker<T, Object> {
    private boolean errorPublished = false;
    protected StatusInfo statusInfo;

    public AbstractTask(StatusInfo statusInfo) {
        this.statusInfo = statusInfo;
        statusInfo.setWaitCursor();
    }

    @Override
    protected void process(List<Object> list) {
        long l = this.statusInfo.getActiveSlotId();
        if (l == -1L) {
            l = this.statusInfo.getSelectedSlotId();
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            if (object instanceof String) {
                this.statusInfo.printInfo((String)object, l);
                continue;
            }
            if (object instanceof Message) {
                Message message = (Message)object;
                if (message.getMessageType().equals((Object)Constants.MessageType.INFO)) {
                    this.statusInfo.printInfo(message.getMessageText(), l);
                    continue;
                }
                this.statusInfo.printError(message.getMessageText(), l);
                this.errorPublished = true;
                continue;
            }
            if (!(object instanceof Exception)) continue;
            this.statusInfo.printException((Exception)object, l);
            this.errorPublished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        try {
            Object t = this.get();
            if (!this.errorPublished) {
                this.taskFinished(t);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            long l = this.statusInfo.getActiveSlotId();
            if (l == -1L) {
                l = this.statusInfo.getSelectedSlotId();
            }
            this.statusInfo.printException(exception, l);
        }
        finally {
            this.statusInfo.setDefaultCursor();
        }
    }

    public abstract void taskFinished(T var1) throws Exception;
}

