/*
 * Decompiled with CFR 0.152.
 */
package p11cat.controller;

import java.awt.event.ActionEvent;
import p11cat.Messages;
import p11cat.P11;
import p11cat.StatusInfo;
import p11cat.controller.EnableAction;
import p11cat.controller.OpenCardAction;
import p11cat.model.AuthState;
import p11cat.view.SlotTable;
import p11cat.view.StatusTable;
import p11cat.view.login.LoginLogoutButton;

public class LogoutAction
extends EnableAction {
    private static final long serialVersionUID = 5956190324738618883L;
    private StatusInfo statusInfo;
    private OpenCardAction openDefaultCardAction;
    private LoginLogoutButton loginLogoutButton;

    public LogoutAction(StatusInfo statusInfo, OpenCardAction openCardAction, LoginLogoutButton loginLogoutButton) {
        super(Messages.getString("P11CAT.Logout.Button"), EnableAction.EnableCondition.ST_LOGIN);
        this.statusInfo = statusInfo;
        this.openDefaultCardAction = openCardAction;
        this.loginLogoutButton = loginLogoutButton;
        statusInfo.registerActionAtSlotTable(this);
    }

    public void logout(boolean bl) {
        P11.logout();
        long l = this.statusInfo.getActiveSlotId();
        if (bl) {
            AuthState authState = new AuthState(this.statusInfo.getLoginStatus());
            if (authState.isAdmin()) {
                this.statusInfo.printInfo(Messages.getString("P11CAT.Message.LogoutGeneric"), l);
            }
            if (authState.isSO()) {
                this.statusInfo.printInfo(Messages.getString("P11CAT.Message.LogoutSO"), l);
            }
            if (authState.isUser()) {
                this.statusInfo.printInfo(Messages.getString("P11CAT.Message.LogoutUser"), l);
            }
            try {
                SlotTable.setCurrentAuthState(P11.getAuthState());
            }
            catch (Exception exception) {
                this.statusInfo.printException(exception, l);
            }
            authState = new AuthState(SlotTable.getCurrentAuthState());
            Object[] objectArray = new Object[]{authState.getHexString()};
            this.statusInfo.printInfo(Messages.getString("P11CAT.Message.NewAuthState", objectArray), l);
        }
        P11.closeSession();
        if (bl) {
            this.statusInfo.printInfo(Messages.getString("P11CAT.Message.SessionClosed"), l);
        }
        this.statusInfo.setLoginStatus(0L);
        this.loginLogoutButton.switchToLogin();
        this.openDefaultCardAction.actionPerformed(null);
    }

    public void logoutAtRestart(StatusTable statusTable, long l, long l2) {
        P11.logout();
        AuthState authState = new AuthState(l);
        if (authState.isAdmin()) {
            statusTable.printInfo(Messages.getString("P11CAT.Message.LogoutGeneric"), l2);
        }
        if (authState.isSO()) {
            statusTable.printInfo(Messages.getString("P11CAT.Message.LogoutSO"), l2);
        }
        if (authState.isUser()) {
            statusTable.printInfo(Messages.getString("P11CAT.Message.LogoutUser"), l2);
        }
        try {
            SlotTable.setCurrentAuthState(P11.getAuthState());
        }
        catch (Exception exception) {
            this.statusInfo.printException(exception, l2);
        }
        authState = new AuthState(SlotTable.getCurrentAuthState());
        Object[] objectArray = new Object[]{authState.getHexString()};
        this.statusInfo.printInfo(Messages.getString("P11CAT.Message.NewAuthState", objectArray), l2);
        P11.closeSession();
        statusTable.printInfo(Messages.getString("P11CAT.Message.SessionClosed"), l2);
        this.loginLogoutButton.switchToLogin();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.logout(true);
    }
}

