/*
 * Decompiled with CFR 0.152.
 */
package com.utimaco.jce.hsm;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import CryptoServerCXI.Item;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import CryptoServerJCE.ToolBox;
import com.utimaco.javacpp.global.UcapiWrapperGlobal;
import com.utimaco.javacpp.ucapi.UcapiAEAData;
import com.utimaco.javacpp.ucapi.UcapiAnswer;
import com.utimaco.javacpp.ucapi.UcapiAuthToken;
import com.utimaco.javacpp.ucapi.UcapiBuffer;
import com.utimaco.javacpp.ucapi.UcapiChaining;
import com.utimaco.javacpp.ucapi.UcapiCluster;
import com.utimaco.javacpp.ucapi.UcapiCommand;
import com.utimaco.javacpp.ucapi.UcapiConfig;
import com.utimaco.javacpp.ucapi.UcapiCredentials;
import com.utimaco.javacpp.ucapi.UcapiDeviceInfo;
import com.utimaco.javacpp.ucapi.UcapiDomainGenInfo;
import com.utimaco.javacpp.ucapi.UcapiExportInfo;
import com.utimaco.javacpp.ucapi.UcapiExportPolicy;
import com.utimaco.javacpp.ucapi.UcapiExternalKeyStorage;
import com.utimaco.javacpp.ucapi.UcapiFindFilter;
import com.utimaco.javacpp.ucapi.UcapiHashInfo;
import com.utimaco.javacpp.ucapi.UcapiKeyBackup;
import com.utimaco.javacpp.ucapi.UcapiKeyBlob;
import com.utimaco.javacpp.ucapi.UcapiKeyExport;
import com.utimaco.javacpp.ucapi.UcapiKeyGenInfo;
import com.utimaco.javacpp.ucapi.UcapiKeyHandle;
import com.utimaco.javacpp.ucapi.UcapiKeyPair;
import com.utimaco.javacpp.ucapi.UcapiKeyProperties;
import com.utimaco.javacpp.ucapi.UcapiKeyTemplate;
import com.utimaco.javacpp.ucapi.UcapiKeyUsage;
import com.utimaco.javacpp.ucapi.UcapiKeyWriteFlags;
import com.utimaco.javacpp.ucapi.UcapiPadding;
import com.utimaco.javacpp.ucapi.UcapiPassword;
import com.utimaco.javacpp.ucapi.UcapiPropertyList;
import com.utimaco.javacpp.ucapi.UcapiSession;
import com.utimaco.javacpp.ucapi.UcapiStorageInfo;
import com.utimaco.javacpp.ucapi.UcapiUserManagement;
import com.utimaco.javacpp.ucapi.UcapiVectorAnswer;
import com.utimaco.javacpp.ucapi.UcapiVectorDeviceInfo;
import com.utimaco.javacpp.ucapi.UcapiVectorKeyHandle;
import com.utimaco.javacpp.ucapi.UcapiVectorU8;
import com.utimaco.javacpp.ucapi.UcapiWrapInfo;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;

public class HSM
implements AutoCloseable {
    private UcapiSession session;
    private UcapiCluster cluster;
    private UcapiExternalKeyStorage keyStorage;
    private UcapiExternalKeyStorage keyStorageExternalPermanent;
    protected UcapiKeyUsage keyUsage;
    protected UcapiKeyWriteFlags keyWriteFlags = null;
    private boolean externalStorage = false;
    private boolean noNativeGC = false;
    private String keyStorePath = null;
    private String keyStoreType = null;
    protected String keyGroup = "";
    protected boolean keysExternal = false;
    protected UcapiExportPolicy exportPolicy;
    protected String user = "JCE";
    private String[] devices;
    private int timeout = 3000;
    private int connectionTimeout = 0;
    private boolean keepSessionAlive = false;
    private boolean endSessionOnShutdown = false;
    private ShutdownThread shutdownThread;
    public static final int MAX_COMMAND_SIZE = 261000;
    public static final int MAX_INPUT_SIZE = 10000000;

    private HSM(HSMBuilder hSMBuilder) {
        this.noNativeGC = hSMBuilder.noNativeGC;
        if (this.noNativeGC) {
            System.setProperty("org.bytedeco.javacpp.noPointerGC", "true");
        } else {
            System.setProperty("org.bytedeco.javacpp.noPointerGC", "false");
        }
        UcapiVectorDeviceInfo ucapiVectorDeviceInfo = new UcapiVectorDeviceInfo();
        this.timeout = hSMBuilder.timeout;
        this.user = hSMBuilder.user;
        this.keyGroup = hSMBuilder.keyGroup;
        this.connectionTimeout = hSMBuilder.connectionTimeout;
        this.keepSessionAlive = hSMBuilder.keepSessionAlive;
        this.devices = hSMBuilder.devices;
        this.endSessionOnShutdown = hSMBuilder.endSessionOnShutdown;
        for (String string : this.devices) {
            String string2 = new String(string);
            UcapiDeviceInfo ucapiDeviceInfo = new UcapiDeviceInfo(string2, this.timeout, this.connectionTimeout, this.keepSessionAlive);
            ucapiVectorDeviceInfo.push_back(ucapiDeviceInfo);
        }
        this.externalStorage = hSMBuilder.externalStorage;
        this.keyStorePath = hSMBuilder.keyStorePath;
        this.keyStoreType = hSMBuilder.keyStoreType;
        UcapiConfig ucapiConfig = new UcapiConfig();
        if (Log.filename != null && Log.level > 0 && Log.level < 5) {
            Log.log(LogLevel.Info, "JCE Provider log file enabled with level " + Log.level + " in path " + Log.filename + Log.extension);
            String string = Log.filename + "-ucapi" + Log.extension;
            Log.log(LogLevel.Info, "Ucapi log file enabled with level " + Log.level + " in path " + string);
            ucapiConfig.set_log_level(Log.level);
            ucapiConfig.set_log_path(new BytePointer(string));
            ucapiConfig.set_log_size(Log.size);
        }
        ucapiConfig.device_infos(ucapiVectorDeviceInfo);
        if (this.externalStorage && "Legacy".equalsIgnoreCase(this.keyStoreType)) {
            Log.log(LogLevel.Info, "Legacy external storage enabled");
            UcapiStorageInfo ucapiStorageInfo = new UcapiStorageInfo(UcapiWrapperGlobal.StorageID.CXI_LEGACY);
            ucapiStorageInfo.config(new BytePointer(this.keyStorePath));
            ucapiConfig.cxi_keystore_info(ucapiStorageInfo);
        } else if (this.externalStorage && "ODBC".equalsIgnoreCase(this.keyStoreType)) {
            Log.log(LogLevel.Info, "ODBC external storage enabled");
            UcapiStorageInfo ucapiStorageInfo = new UcapiStorageInfo(UcapiWrapperGlobal.StorageID.ODBC);
            ucapiStorageInfo.config(new BytePointer(this.keyStorePath));
            ucapiConfig.odbc_keystore_info(ucapiStorageInfo);
        }
        this.cluster = new UcapiCluster(ucapiConfig);
        this.session = new UcapiSession(this.cluster);
        this.keyStorage = new UcapiExternalKeyStorage(ucapiConfig);
        this.keyStorage.set_default_plugin_id(UcapiWrapperGlobal.StorageID.EPHEMERAL);
        this.keyStorageExternalPermanent = new UcapiExternalKeyStorage(ucapiConfig);
        if (this.externalStorage && "Legacy".equalsIgnoreCase(this.keyStoreType)) {
            this.keyStorageExternalPermanent.set_default_plugin_id(UcapiWrapperGlobal.StorageID.CXI_LEGACY);
        } else if (this.externalStorage && "ODBC".equalsIgnoreCase(this.keyStoreType)) {
            this.keyStorageExternalPermanent.set_default_plugin_id(UcapiWrapperGlobal.StorageID.ODBC);
        } else {
            this.keyStorageExternalPermanent.set_default_plugin_id(UcapiWrapperGlobal.StorageID.INTERNAL);
        }
        this.keyUsage = new UcapiKeyUsage();
        this.keyUsage.encrypt(true);
        this.keyUsage.decrypt(true);
        this.keyUsage.sign(true);
        this.keyUsage.verify(true);
        this.keyUsage.verify_recover(true);
        this.keyUsage.wrap(true);
        this.keyUsage.unwrap(true);
        this.keyUsage.derive(true);
        this.defaultKeyFlags();
    }

    public void handleKeyUsage(String string) {
        int n = 1;
        int n2 = 2;
        int n3 = 4;
        int n4 = 8;
        int n5 = 16;
        int n6 = 32;
        int n7 = 128;
        int n8 = 32;
        this.keyUsage.decrypt(false);
        this.keyUsage.encrypt(false);
        this.keyUsage.sign(false);
        this.keyUsage.verify(false);
        this.keyUsage.derive(false);
        this.keyUsage.wrap(false);
        this.keyUsage.unwrap(false);
        this.keyUsage.verify_recover(false);
        int n9 = Integer.parseInt(string);
        if ((n9 & n) != 0) {
            this.keyUsage.decrypt(true);
        }
        if ((n9 & n5) != 0) {
            this.keyUsage.encrypt(true);
        }
        if ((n9 & n2) != 0) {
            this.keyUsage.sign(true);
        }
        if ((n9 & n6) != 0) {
            this.keyUsage.verify(true);
        }
        if ((n9 & n3) != 0) {
            this.keyUsage.derive(true);
        }
        if ((n9 & n4) != 0) {
            this.keyUsage.wrap(true);
        }
        if ((n9 & n7) != 0) {
            this.keyUsage.unwrap(true);
        }
        if ((n9 & n8) != 0) {
            this.keyUsage.verify_recover(true);
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getKeyGroup() {
        return this.keyGroup;
    }

    public void setKeyGroup(String string) {
        this.keyGroup = string;
    }

    public UcapiExportPolicy getExportPolicy() {
        return this.exportPolicy;
    }

    public void setExportPolicy(UcapiExportPolicy ucapiExportPolicy) {
        this.exportPolicy = ucapiExportPolicy;
    }

    public boolean isExternalStorage() {
        return this.externalStorage;
    }

    public void setExternalStorage(boolean bl) {
        this.externalStorage = bl;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String string) {
        this.keyStorePath = string;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String string) {
        this.keyStoreType = string;
    }

    public void loginSign(String string, String string2, String string3) {
        String string4 = new String(string);
        String string5 = new String(string2);
        UcapiPassword ucapiPassword = string3 != null ? new UcapiPassword(string3) : new UcapiPassword();
        UcapiCredentials ucapiCredentials = UcapiCredentials.from_name_and_keyspec(string4, string5, ucapiPassword);
        if (this.endSessionOnShutdown && this.shutdownThread == null) {
            this.shutdownThread = new ShutdownThread(this);
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }
        this.session.login(ucapiCredentials);
    }

    public void login(String string, String string2) {
        UcapiPassword ucapiPassword = new UcapiPassword(string2);
        String string3 = new String(string);
        UcapiCredentials ucapiCredentials = UcapiCredentials.from_name_and_pw(string3, ucapiPassword);
        if (this.endSessionOnShutdown && this.shutdownThread == null) {
            this.shutdownThread = new ShutdownThread(this);
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }
        this.session.login(ucapiCredentials);
    }

    public void setEndSessionOnShutdown(boolean bl) {
        this.endSessionOnShutdown = bl;
    }

    public UcapiSession getSession() {
        return this.session;
    }

    public UcapiExternalKeyStorage getKeyStorage() {
        return this.keyStorage;
    }

    public UcapiExternalKeyStorage getKeyStorageExternalPermanent() {
        return this.keyStorageExternalPermanent;
    }

    @Override
    public void close() {
        this.closeAll();
    }

    public void logoff() {
        if (this.session != null && !this.session.isNull()) {
            this.session.logout_all();
        }
    }

    private void closeAll() {
        if (this.exportPolicy != null) {
            this.exportPolicy.close();
        }
        if (this.keyUsage != null) {
            this.keyUsage.close();
        }
        if (this.keyWriteFlags != null) {
            this.keyWriteFlags.close();
        }
        if (this.session != null && !this.session.isNull()) {
            this.session.close();
        }
        if (this.keyStorage != null) {
            this.keyStorage.close();
        }
        if (this.keyStorageExternalPermanent != null) {
            this.keyStorageExternalPermanent.close();
        }
        if (this.cluster != null && !this.cluster.isNull()) {
            this.cluster.close();
        }
        try {
            if (this.shutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
                this.shutdownThread = null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean isEphemeralStored(UcapiKeyHandle ucapiKeyHandle) {
        return ucapiKeyHandle.storage_id().value == UcapiWrapperGlobal.StorageID.EPHEMERAL.value;
    }

    public UcapiKeyProperties getKeyProperties(UcapiKeyHandle ucapiKeyHandle, short[] sArray) {
        ShortPointer shortPointer = new ShortPointer(sArray);
        return UcapiWrapperGlobal.key_get_properties(this.getSession(), this.isEphemeralStored(ucapiKeyHandle) ? this.getKeyStorage() : this.keyStorageExternalPermanent, ucapiKeyHandle, shortPointer, sArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] exportSecretKey(UcapiKeyHandle ucapiKeyHandle) throws CryptoServerException {
        UcapiExportInfo ucapiExportInfo = null;
        Pointer pointer = null;
        try {
            ucapiExportInfo = new UcapiExportInfo();
            ucapiExportInfo.blob_type(UcapiWrapperGlobal.ExportBlobType.SIMPLE);
            ucapiExportInfo.key_type(UcapiWrapperGlobal.KeyType.SECRET);
            pointer = UcapiWrapperGlobal.key_export(this.getSession(), this.isEphemeralStored(ucapiKeyHandle) ? this.getKeyStorage() : this.getKeyStorageExternalPermanent(), ucapiKeyHandle, ucapiExportInfo, null);
            byte[] byArray = Item.getItem(CryptoServerCXI.TAG_KB, ToolBox.exportKeyToByteArray((UcapiKeyExport)pointer), 0);
            byte[] byArray2 = Item.getItem(CryptoServerCXI.TAG_KC, byArray, 0);
            return byArray2;
        }
        finally {
            if (ucapiExportInfo != null) {
                ucapiExportInfo.close();
            }
            if (pointer != null) {
                pointer.close();
            }
        }
    }

    public UcapiVectorKeyHandle findKey(UcapiKeyTemplate ucapiKeyTemplate) {
        UcapiFindFilter ucapiFindFilter = new UcapiFindFilter();
        if (this.isExternalStorage()) {
            ucapiFindFilter.internal_persistent(false);
            ucapiFindFilter.internal_volatile(false);
        } else {
            ucapiFindFilter.external_ephemeral(false);
            ucapiFindFilter.external_persistent(false);
        }
        return UcapiWrapperGlobal.key_find(this.getSession(), this.getKeyStorageExternalPermanent(), ucapiKeyTemplate, ucapiFindFilter);
    }

    public void deleteKey(UcapiVectorKeyHandle ucapiVectorKeyHandle) {
        UcapiWrapperGlobal.key_delete(this.getSession(), this.getKeyStorageExternalPermanent(), ucapiVectorKeyHandle);
    }

    public UcapiVectorKeyHandle findKeyByName(String string, UcapiKeyTemplate ucapiKeyTemplate) {
        UcapiKeyTemplate ucapiKeyTemplate2 = ucapiKeyTemplate == null ? new UcapiKeyTemplate() : ucapiKeyTemplate;
        ucapiKeyTemplate2.set_name(new String(string));
        return this.findKey(ucapiKeyTemplate2);
    }

    public UcapiVectorKeyHandle findKeyByLabel(String string, UcapiKeyTemplate ucapiKeyTemplate) {
        UcapiKeyTemplate ucapiKeyTemplate2 = ucapiKeyTemplate == null ? new UcapiKeyTemplate() : ucapiKeyTemplate;
        ucapiKeyTemplate2.set_label(new String(string));
        return this.findKey(ucapiKeyTemplate2);
    }

    public UcapiVectorKeyHandle findKeyByCertificate(Certificate certificate, UcapiKeyTemplate ucapiKeyTemplate) throws CertificateEncodingException {
        UcapiKeyTemplate ucapiKeyTemplate2 = ucapiKeyTemplate == null ? new UcapiKeyTemplate() : ucapiKeyTemplate;
        ucapiKeyTemplate2.set_certificate(new UcapiVectorU8(certificate.getEncoded()));
        return this.findKey(ucapiKeyTemplate2);
    }

    public CryptoServerPublicKey importPublicDSAKey(DSAPublicKeySpec dSAPublicKeySpec) throws CryptoServerException {
        try (UcapiKeyTemplate ucapiKeyTemplate = new UcapiKeyTemplate();){
            ucapiKeyTemplate.set_usage(this.keyUsage);
            ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.DSA);
            ucapiKeyTemplate.set_type(UcapiWrapperGlobal.KeyType.PUBLIC);
            ucapiKeyTemplate.set_dsa_generator(ToolBox.bigIntegerToU8(dSAPublicKeySpec.getG()));
            ucapiKeyTemplate.set_dsa_prime_p(ToolBox.bigIntegerToU8(dSAPublicKeySpec.getP()));
            ucapiKeyTemplate.set_dsa_prime_q(ToolBox.bigIntegerToU8(dSAPublicKeySpec.getQ()));
            ucapiKeyTemplate.set_dsa_public_key(ToolBox.bigIntegerToU8(dSAPublicKeySpec.getY()));
            ucapiKeyTemplate.set_value(ToolBox.bigIntegerToU8(dSAPublicKeySpec.getY()));
            UcapiKeyHandle ucapiKeyHandle = UcapiWrapperGlobal.object_create(this.getSession(), this.keyStorage, ucapiKeyTemplate, this.keyWriteFlags);
            CryptoServerPublicKey cryptoServerPublicKey = new CryptoServerPublicKey(this, UcapiWrapperGlobal.Algorithm.DSA.name(), ucapiKeyHandle);
            return cryptoServerPublicKey;
        }
    }

    public UcapiKeyProperties generateDSAParams(int n, int n2) {
        UcapiDomainGenInfo ucapiDomainGenInfo = new UcapiDomainGenInfo();
        ucapiDomainGenInfo.p_size(n);
        ucapiDomainGenInfo.q_size(n2);
        ucapiDomainGenInfo.rndMode(UcapiWrapperGlobal.RNDMode.REAL);
        ucapiDomainGenInfo.hashAlgo(UcapiWrapperGlobal.HashAlgo.SHA1);
        ucapiDomainGenInfo.domainGeneration(UcapiWrapperGlobal.DomainGeneration.DPGEN_DP);
        UcapiCommand ucapiCommand = UcapiWrapperGlobal.generate_dsa_param(ucapiDomainGenInfo);
        UcapiVectorAnswer ucapiVectorAnswer = this.session.exec_broadcast(ucapiCommand);
        UcapiAnswer ucapiAnswer = ucapiVectorAnswer.get(0L);
        UcapiPropertyList ucapiPropertyList = new UcapiPropertyList();
        UcapiWrapperGlobal.generate_dsa_param(ucapiAnswer, ucapiPropertyList);
        return new UcapiKeyProperties(ucapiPropertyList);
    }

    /*
     * Exception decompiling
     */
    public CryptoServerPublicKey importPublicECKey(ECPublicKeySpec var1_1) throws CryptoServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createObject(UcapiKeyTemplate ucapiKeyTemplate) {
        UcapiWrapperGlobal.object_create(this.session, this.keyStorage, ucapiKeyTemplate, this.keyWriteFlags);
    }

    public boolean objectExists(UcapiKeyTemplate ucapiKeyTemplate) {
        UcapiVectorKeyHandle ucapiVectorKeyHandle = this.findKey(ucapiKeyTemplate);
        return !ucapiVectorKeyHandle.empty();
    }

    public void changeUserPassword(String string, String string2) {
        UcapiUserManagement ucapiUserManagement = new UcapiUserManagement(this.session);
        UcapiAuthToken ucapiAuthToken = new UcapiAuthToken(new String(string2));
        ucapiUserManagement.change_user(new String(string), ucapiAuthToken);
        ucapiUserManagement.close();
    }

    /*
     * Exception decompiling
     */
    public byte[] getHash(byte[] var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getInternalHash(byte[] byArray, String string) {
        UcapiHashInfo ucapiHashInfo = new UcapiHashInfo();
        ucapiHashInfo.hash_algo(ToolBox.getHashAlgoFromString(string));
        Pointer pointer = null;
        try {
            pointer = UcapiWrapperGlobal.hash(this.getSession(), this.getKeyStorage(), ucapiHashInfo, byArray, (long)byArray.length);
            byte[] byArray2 = ToolBox.ucapiVecU8ToByteArray((UcapiVectorU8)pointer);
            return byArray2;
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            exception.printStackTrace();
            byte[] byArray3 = null;
            return byArray3;
        }
        finally {
            if (ucapiHashInfo != null) {
                ucapiHashInfo.close();
            }
            if (pointer != null) {
                pointer.close();
            }
        }
    }

    public CryptoServerPublicKey importPublicRSAKey(RSAPublicKeySpec rSAPublicKeySpec) {
        try (UcapiKeyTemplate ucapiKeyTemplate = new UcapiKeyTemplate();){
            ucapiKeyTemplate.set_usage(this.keyUsage);
            ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.RSA);
            ucapiKeyTemplate.set_rsa_exponent(ToolBox.bigIntegerToU8(rSAPublicKeySpec.getPublicExponent()));
            ucapiKeyTemplate.set_rsa_modulus(ToolBox.bigIntegerToU8(rSAPublicKeySpec.getModulus()));
            ucapiKeyTemplate.set_size(rSAPublicKeySpec.getModulus().bitLength());
            ucapiKeyTemplate.set_type(UcapiWrapperGlobal.KeyType.PUBLIC);
            UcapiKeyHandle ucapiKeyHandle = UcapiWrapperGlobal.object_create(this.getSession(), this.keyStorage, ucapiKeyTemplate, this.keyWriteFlags);
            CryptoServerPublicKey cryptoServerPublicKey = new CryptoServerPublicKey(this, UcapiWrapperGlobal.Algorithm.RSA.name(), ucapiKeyHandle);
            return cryptoServerPublicKey;
        }
    }

    public UcapiKeyPair generateKeyPair(UcapiKeyTemplate ucapiKeyTemplate, UcapiKeyTemplate ucapiKeyTemplate2) {
        UcapiKeyGenInfo ucapiKeyGenInfo = new UcapiKeyGenInfo();
        return UcapiWrapperGlobal.key_pair_generate(this.getSession(), this.getKeyStorage(), ucapiKeyGenInfo, ucapiKeyTemplate, ucapiKeyTemplate2, this.getKeyWriteFlags(), this.getKeyWriteFlags());
    }

    public UcapiKeyHandle backupAndRestoreKey(UcapiKeyHandle ucapiKeyHandle, UcapiKeyTemplate ucapiKeyTemplate, UcapiKeyWriteFlags ucapiKeyWriteFlags, UcapiExternalKeyStorage ucapiExternalKeyStorage) {
        UcapiKeyBackup ucapiKeyBackup = UcapiWrapperGlobal.key_backup(this.session, this.isEphemeralStored(ucapiKeyHandle) ? this.getKeyStorage() : this.getKeyStorageExternalPermanent(), ucapiKeyHandle);
        if (ucapiKeyBackup != null) {
            return UcapiWrapperGlobal.key_restore(this.session, ucapiExternalKeyStorage, ucapiKeyBackup, ucapiKeyWriteFlags, ucapiKeyTemplate);
        }
        return null;
    }

    public void backupAndRestoreKey(UcapiKeyHandle ucapiKeyHandle, UcapiKeyTemplate ucapiKeyTemplate, UcapiKeyWriteFlags ucapiKeyWriteFlags) {
        this.backupAndRestoreKey(ucapiKeyHandle, ucapiKeyTemplate, ucapiKeyWriteFlags, this.getKeyStorageExternalPermanent());
    }

    public byte[] generateRandomNumber(int n, UcapiWrapperGlobal.RNDMode rNDMode) {
        try (UcapiVectorU8 ucapiVectorU8 = UcapiWrapperGlobal.random_data(this.getSession(), n, rNDMode);){
            byte[] byArray = ToolBox.ucapiVecU8ToByteArray(ucapiVectorU8);
            return byArray;
        }
    }

    public UcapiKeyUsage getKeyUsage() {
        return this.keyUsage;
    }

    public UcapiKeyWriteFlags getKeyWriteFlags() {
        return this.keyWriteFlags;
    }

    public void setKeyWriteFlags(UcapiKeyWriteFlags ucapiKeyWriteFlags) {
        this.keyWriteFlags = ucapiKeyWriteFlags;
    }

    private void defaultKeyFlags() {
        this.keyWriteFlags = new UcapiKeyWriteFlags();
        this.setKeyExternal(true);
        this.setKeyPersistent(false);
    }

    public void setKeyPersistent(boolean bl) {
        this.keyWriteFlags.lifetime(bl ? (byte)4 : 8);
    }

    public void setKeyOverWrite(boolean bl) {
        this.keyWriteFlags.mode(bl ? (byte)1 : 0);
    }

    public void setKeyExternal(boolean bl) {
        this.keyWriteFlags.location(bl ? (byte)2 : 0);
    }

    public String[] getDevices() {
        return this.devices;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public UcapiKeyHandle importPrivateKeyRSA(boolean bl, UcapiExportPolicy ucapiExportPolicy, RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec) throws Exception {
        UcapiKeyTemplate ucapiKeyTemplate = new UcapiKeyTemplate();
        ucapiKeyTemplate.set_usage(this.keyUsage);
        ucapiKeyTemplate.set_type(UcapiWrapperGlobal.KeyType.PRIVATE);
        ucapiKeyTemplate.set_export_policy(ucapiExportPolicy);
        UcapiKeyWriteFlags ucapiKeyWriteFlags = new UcapiKeyWriteFlags();
        if (bl) {
            ucapiKeyWriteFlags.location((byte)2);
            ucapiKeyWriteFlags.lifetime((byte)8);
        }
        UcapiExportInfo ucapiExportInfo = new UcapiExportInfo();
        ucapiExportInfo.blob_type(UcapiWrapperGlobal.ExportBlobType.SIMPLE);
        ucapiExportInfo.key_type(UcapiWrapperGlobal.KeyType.PRIVATE);
        UcapiChaining ucapiChaining = new UcapiChaining();
        ucapiChaining.set_ecb();
        ucapiExportInfo.chaining(ucapiChaining);
        UcapiPadding ucapiPadding = new UcapiPadding();
        ucapiPadding.set_zero();
        ucapiExportInfo.padding(ucapiPadding);
        CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
        ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.RSA);
        keyAttributes.setAlgo(3);
        keyAttributes.setSize(rSAPrivateCrtKeySpec.getModulus().bitLength());
        keyAttributes.setExponent(rSAPrivateCrtKeySpec.getPublicExponent());
        CryptoServerCXI.KeyComponents keyComponents = new CryptoServerCXI.KeyComponents();
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_SEXP, rSAPrivateCrtKeySpec.getPrivateExponent());
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_P, rSAPrivateCrtKeySpec.getPrimeP());
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_Q, rSAPrivateCrtKeySpec.getPrimeQ());
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_DP, rSAPrivateCrtKeySpec.getPrimeExponentP());
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_DQ, rSAPrivateCrtKeySpec.getPrimeExponentQ());
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_U, rSAPrivateCrtKeySpec.getCrtCoefficient());
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_MOD, rSAPrivateCrtKeySpec.getModulus());
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_PEXP, rSAPrivateCrtKeySpec.getPublicExponent());
        byte[] byArray = Item.mkItemList(CryptoServerCXI.TAG_BH, Item.mkItemList(CryptoServerCXI.TAG_PL, keyAttributes.toByteArray()), CryptoServerCXI.TAG_KC, keyComponents.getList());
        byArray = Item.mkItemList(CryptoServerCXI.TAG_KB, byArray);
        BytePointer bytePointer = new BytePointer(byArray);
        UcapiBuffer ucapiBuffer = new UcapiBuffer(byArray.length);
        ucapiBuffer.write(bytePointer, byArray.length);
        UcapiKeyBlob ucapiKeyBlob = new UcapiKeyBlob(ucapiBuffer);
        UcapiKeyExport ucapiKeyExport = new UcapiKeyExport(ucapiKeyBlob);
        return UcapiWrapperGlobal.key_import(this.getSession(), this.getKeyStorage(), ucapiKeyExport, ucapiExportInfo, ucapiKeyTemplate, null, ucapiKeyWriteFlags);
    }

    public UcapiKeyHandle importPrivateKeyRSA(boolean bl, UcapiExportPolicy ucapiExportPolicy, RSAPrivateKeySpec rSAPrivateKeySpec) throws Exception {
        UcapiKeyTemplate ucapiKeyTemplate = new UcapiKeyTemplate();
        ucapiKeyTemplate.set_usage(this.keyUsage);
        ucapiKeyTemplate.set_type(UcapiWrapperGlobal.KeyType.PRIVATE);
        ucapiKeyTemplate.set_export_policy(ucapiExportPolicy);
        UcapiKeyWriteFlags ucapiKeyWriteFlags = new UcapiKeyWriteFlags();
        if (bl) {
            ucapiKeyWriteFlags.location((byte)2);
            ucapiKeyWriteFlags.lifetime((byte)8);
        }
        UcapiExportInfo ucapiExportInfo = new UcapiExportInfo();
        ucapiExportInfo.blob_type(UcapiWrapperGlobal.ExportBlobType.SIMPLE);
        ucapiExportInfo.key_type(UcapiWrapperGlobal.KeyType.PRIVATE);
        UcapiChaining ucapiChaining = new UcapiChaining();
        ucapiChaining.set_ecb();
        ucapiExportInfo.chaining(ucapiChaining);
        UcapiPadding ucapiPadding = new UcapiPadding();
        ucapiPadding.set_zero();
        ucapiExportInfo.padding(ucapiPadding);
        CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
        ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.RSA);
        keyAttributes.setAlgo(3);
        keyAttributes.setSize(rSAPrivateKeySpec.getModulus().bitLength());
        CryptoServerCXI.KeyComponents keyComponents = new CryptoServerCXI.KeyComponents();
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_SEXP, rSAPrivateKeySpec.getPrivateExponent());
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_MOD, rSAPrivateKeySpec.getModulus());
        byte[] byArray = Item.mkItemList(CryptoServerCXI.TAG_BH, Item.mkItemList(CryptoServerCXI.TAG_PL, keyAttributes.toByteArray()), CryptoServerCXI.TAG_KC, keyComponents.getList());
        byArray = Item.mkItemList(CryptoServerCXI.TAG_KB, byArray);
        BytePointer bytePointer = new BytePointer(byArray);
        UcapiBuffer ucapiBuffer = new UcapiBuffer(byArray.length);
        ucapiBuffer.write(bytePointer, byArray.length);
        UcapiKeyBlob ucapiKeyBlob = new UcapiKeyBlob(ucapiBuffer);
        UcapiKeyExport ucapiKeyExport = new UcapiKeyExport(ucapiKeyBlob);
        return UcapiWrapperGlobal.key_import(this.getSession(), this.getKeyStorage(), ucapiKeyExport, ucapiExportInfo, ucapiKeyTemplate, null, ucapiKeyWriteFlags);
    }

    public UcapiKeyHandle importSecretKey(int n, int n2, boolean bl, UcapiExportPolicy ucapiExportPolicy, byte[] byArray) throws Exception {
        UcapiKeyTemplate ucapiKeyTemplate = new UcapiKeyTemplate();
        ucapiKeyTemplate.set_usage(this.keyUsage);
        ucapiKeyTemplate.set_type(UcapiWrapperGlobal.KeyType.SECRET);
        ucapiKeyTemplate.set_export_policy(ucapiExportPolicy);
        UcapiKeyWriteFlags ucapiKeyWriteFlags = new UcapiKeyWriteFlags();
        if (bl) {
            ucapiKeyWriteFlags.location((byte)2);
            ucapiKeyWriteFlags.lifetime((byte)8);
        }
        if (n == 20) {
            ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.DES);
            ucapiKeyTemplate.set_size(n2 * 7);
        } else {
            ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.AES);
            ucapiKeyTemplate.set_size(n2 * 8);
        }
        ucapiKeyTemplate.set_value(new UcapiVectorU8(byArray));
        return UcapiWrapperGlobal.object_create(this.getSession(), this.keyStorage, ucapiKeyTemplate, ucapiKeyWriteFlags);
    }

    public UcapiKeyHandle unwrapKey(UcapiVectorU8 ucapiVectorU8, UcapiKeyTemplate ucapiKeyTemplate, UcapiWrapInfo ucapiWrapInfo, UcapiKeyHandle ucapiKeyHandle, UcapiKeyWriteFlags ucapiKeyWriteFlags) {
        return UcapiWrapperGlobal.key_unwrap(this.getSession(), this.getKeyStorage(), ucapiVectorU8, ucapiKeyTemplate, ucapiWrapInfo, ucapiKeyHandle, ucapiKeyWriteFlags);
    }

    public UcapiVectorU8 wrapKey(UcapiKeyHandle ucapiKeyHandle, UcapiKeyHandle ucapiKeyHandle2, UcapiWrapInfo ucapiWrapInfo, UcapiAEAData ucapiAEAData) {
        return UcapiWrapperGlobal.key_wrap(this.getSession(), this.getKeyStorage(), ucapiKeyHandle, ucapiWrapInfo, ucapiKeyHandle2, ucapiAEAData);
    }

    public UcapiKeyHandle importPrivateKeyDSA(boolean bl, UcapiExportPolicy ucapiExportPolicy, DSAPrivateKeySpec dSAPrivateKeySpec) throws Exception {
        UcapiKeyTemplate ucapiKeyTemplate = new UcapiKeyTemplate();
        ucapiKeyTemplate.set_usage(this.keyUsage);
        ucapiKeyTemplate.set_type(UcapiWrapperGlobal.KeyType.PRIVATE);
        ucapiKeyTemplate.set_export_policy(ucapiExportPolicy);
        UcapiKeyWriteFlags ucapiKeyWriteFlags = new UcapiKeyWriteFlags();
        if (bl) {
            ucapiKeyWriteFlags.location((byte)2);
            ucapiKeyWriteFlags.lifetime((byte)8);
        }
        UcapiExportInfo ucapiExportInfo = new UcapiExportInfo();
        ucapiExportInfo.blob_type(UcapiWrapperGlobal.ExportBlobType.SIMPLE);
        ucapiExportInfo.key_type(UcapiWrapperGlobal.KeyType.PRIVATE);
        UcapiChaining ucapiChaining = new UcapiChaining();
        ucapiChaining.set_ecb();
        ucapiExportInfo.chaining(ucapiChaining);
        UcapiPadding ucapiPadding = new UcapiPadding();
        ucapiPadding.set_zero();
        ucapiExportInfo.padding(ucapiPadding);
        CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
        ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.DSA);
        keyAttributes.setAlgo(5);
        keyAttributes.setSize(dSAPrivateKeySpec.getP().bitLength());
        keyAttributes.setParamP(dSAPrivateKeySpec.getP());
        keyAttributes.setParamQ(dSAPrivateKeySpec.getQ());
        keyAttributes.setParamG(dSAPrivateKeySpec.getG());
        CryptoServerCXI.KeyComponents keyComponents = new CryptoServerCXI.KeyComponents();
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_SK, dSAPrivateKeySpec.getX());
        byte[] byArray = Item.mkItemList(CryptoServerCXI.TAG_BH, Item.mkItemList(CryptoServerCXI.TAG_PL, keyAttributes.toByteArray()), CryptoServerCXI.TAG_KC, keyComponents.getList());
        byArray = Item.mkItemList(CryptoServerCXI.TAG_KB, byArray);
        BytePointer bytePointer = new BytePointer(byArray);
        UcapiBuffer ucapiBuffer = new UcapiBuffer(byArray.length);
        ucapiBuffer.write(bytePointer, byArray.length);
        UcapiKeyBlob ucapiKeyBlob = new UcapiKeyBlob(ucapiBuffer);
        UcapiKeyExport ucapiKeyExport = new UcapiKeyExport(ucapiKeyBlob);
        return UcapiWrapperGlobal.key_import(this.getSession(), this.getKeyStorage(), ucapiKeyExport, ucapiExportInfo, ucapiKeyTemplate, null, ucapiKeyWriteFlags);
    }

    public UcapiKeyHandle importPrivateKeyEC(boolean bl, UcapiExportPolicy ucapiExportPolicy, ECPrivateKeySpec eCPrivateKeySpec) throws Exception {
        UcapiKeyTemplate ucapiKeyTemplate = new UcapiKeyTemplate();
        ucapiKeyTemplate.set_usage(this.keyUsage);
        ucapiKeyTemplate.set_type(UcapiWrapperGlobal.KeyType.PRIVATE);
        ucapiKeyTemplate.set_export_policy(ucapiExportPolicy);
        UcapiKeyWriteFlags ucapiKeyWriteFlags = new UcapiKeyWriteFlags();
        if (bl) {
            ucapiKeyWriteFlags.location((byte)2);
            ucapiKeyWriteFlags.lifetime((byte)8);
        }
        UcapiExportInfo ucapiExportInfo = new UcapiExportInfo();
        ucapiExportInfo.blob_type(UcapiWrapperGlobal.ExportBlobType.SIMPLE);
        ucapiExportInfo.key_type(UcapiWrapperGlobal.KeyType.PRIVATE);
        UcapiChaining ucapiChaining = new UcapiChaining();
        ucapiChaining.set_ecb();
        ucapiExportInfo.chaining(ucapiChaining);
        UcapiPadding ucapiPadding = new UcapiPadding();
        ucapiPadding.set_zero();
        ucapiExportInfo.padding(ucapiPadding);
        CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
        ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.ECDSA);
        keyAttributes.setAlgo(4);
        keyAttributes.setSize(0);
        keyAttributes.setCurve(eCPrivateKeySpec.getParams());
        CryptoServerCXI.KeyComponents keyComponents = new CryptoServerCXI.KeyComponents();
        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_SK, eCPrivateKeySpec.getS());
        byte[] byArray = Item.mkItemList(CryptoServerCXI.TAG_BH, Item.mkItemList(CryptoServerCXI.TAG_PL, keyAttributes.toByteArray()), CryptoServerCXI.TAG_KC, keyComponents.getList());
        byArray = Item.mkItemList(CryptoServerCXI.TAG_KB, byArray);
        BytePointer bytePointer = new BytePointer(byArray);
        UcapiBuffer ucapiBuffer = new UcapiBuffer(byArray.length);
        ucapiBuffer.write(bytePointer, byArray.length);
        UcapiKeyBlob ucapiKeyBlob = new UcapiKeyBlob(ucapiBuffer);
        UcapiKeyExport ucapiKeyExport = new UcapiKeyExport(ucapiKeyBlob);
        return UcapiWrapperGlobal.key_import(this.getSession(), this.getKeyStorage(), ucapiKeyExport, ucapiExportInfo, ucapiKeyTemplate, null, ucapiKeyWriteFlags);
    }

    public int getKeySize(UcapiKeyHandle ucapiKeyHandle) {
        short[] sArray = new short[]{UcapiWrapperGlobal.PropertyID.KEY_SIZE.value};
        ShortPointer shortPointer = new ShortPointer(sArray);
        try (UcapiKeyProperties ucapiKeyProperties = UcapiWrapperGlobal.key_get_properties(this.getSession(), this.isEphemeralStored(ucapiKeyHandle) ? this.getKeyStorage() : this.getKeyStorageExternalPermanent(), ucapiKeyHandle, shortPointer, 1L);){
            int n = ucapiKeyProperties.get_size().value();
            return n;
        }
    }

    public UcapiExportPolicy createExportPolicy(boolean bl, boolean bl2) {
        UcapiExportPolicy ucapiExportPolicy = ToolBox.setDefaultExportPolicy(null);
        ucapiExportPolicy.allow_wrapped_export(bl);
        ucapiExportPolicy.allow_plain_export(bl2);
        return ucapiExportPolicy;
    }

    private static class ShutdownThread
    extends Thread {
        private HSM hsm;

        ShutdownThread(HSM hSM) {
            this.hsm = hSM;
        }

        @Override
        public void run() {
            try {
                if (this.hsm != null) {
                    this.hsm.logoff();
                    this.hsm.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class HSMBuilder {
        private String[] devices;
        private int timeout = 3000;
        private int connectionTimeout = 0;
        private boolean externalStorage = false;
        private boolean noNativeGC = false;
        private String keyStorePath = null;
        private String keyStoreType = null;
        boolean keepSessionAlive = false;
        private String user = "JCE";
        private String keyGroup = "";
        boolean endSessionOnShutdown = false;

        public HSMBuilder(String string) {
            this(new String[]{string});
        }

        public HSMBuilder(String[] stringArray) {
            this.devices = stringArray;
        }

        public HSMBuilder timeout(int n) {
            this.timeout = n;
            return this;
        }

        public HSMBuilder connectionTimeout(int n) {
            this.connectionTimeout = n;
            return this;
        }

        public HSMBuilder externalStorage(boolean bl) {
            this.externalStorage = bl;
            return this;
        }

        public HSMBuilder noNativeGC(boolean bl) {
            this.noNativeGC = bl;
            return this;
        }

        public HSMBuilder user(String string) {
            this.user = string;
            return this;
        }

        public HSMBuilder keyGroup(String string) {
            this.keyGroup = string;
            return this;
        }

        public HSMBuilder keyStorePath(String string) {
            this.keyStorePath = string;
            return this;
        }

        public HSMBuilder keyStoreType(String string) {
            this.keyStoreType = string;
            return this;
        }

        public HSMBuilder keepSessionAlive(boolean bl) {
            this.keepSessionAlive = bl;
            return this;
        }

        public HSMBuilder endSessionOnShutDown(boolean bl) {
            this.endSessionOnShutdown = bl;
            return this;
        }

        public HSM build() {
            return new HSM(this);
        }
    }
}

