/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerJCE.AsnBuffer;
import CryptoServerJCE.CryptoServerJCEException;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerProviderJCEException;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import CryptoServerJCE.ToolBox;
import com.utimaco.javacpp.global.UcapiWrapperGlobal;
import com.utimaco.javacpp.ucapi.UcapiKeyHandle;
import com.utimaco.javacpp.ucapi.UcapiSignInfo;
import com.utimaco.javacpp.ucapi.UcapiVectorU8;
import com.utimaco.jce.hsm.HSM;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.bytedeco.javacpp.Pointer;

public class CryptoServerSignature
extends SignatureSpi {
    private final HSM hsm;
    private final String keyAlgo;
    private final int sigAlgo;
    private final int hashAlgo;
    private final String signatureAlgo;
    private int mode;
    private ByteArrayOutputStream buffer;
    private MessageDigest md;
    private UcapiKeyHandle skey;
    private UcapiKeyHandle pkey;
    private UcapiSignInfo signInfo;
    private final int MODE_SIGN = 1;
    private final int MODE_VERIFY = 2;

    CryptoServerSignature(HSM hSM, String string, int n, int n2) throws NoSuchAlgorithmException {
        Log.log(LogLevel.Trace, "enter....");
        this.signatureAlgo = string;
        this.hsm = hSM;
        this.sigAlgo = n;
        this.hashAlgo = n2;
        switch (n) {
            case 1: {
                this.keyAlgo = "RSA";
                break;
            }
            case 2: {
                this.keyAlgo = "DSA";
                break;
            }
            case 5: {
                this.keyAlgo = "EdDSA";
                break;
            }
            case 4: {
                this.keyAlgo = "EC";
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
        if (!this.isSignaturePSS()) {
            if (n2 == 0) {
                this.buffer = new ByteArrayOutputStream();
                return;
            }
            String string2 = CryptoServerSignature.getHashName(n2);
            try {
                if (CryptoServerProvider.PROVIDER_HASH_RNG != null) {
                    this.md = MessageDigest.getInstance(string2, CryptoServerProvider.PROVIDER_HASH_RNG);
                }
                this.md = MessageDigest.getInstance(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.log(LogLevel.Error, exception.getMessage());
                throw new NoSuchAlgorithmException("Algorithm " + string2 + " of Provider " + CryptoServerProvider.PROVIDER_HASH_RNG.getName() + " not found");
            }
        } else {
            switch (n2) {
                case 0: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException();
                }
            }
        }
    }

    private void initializeParametersPSS(int n) {
        switch (n) {
            case 0: 
            case 10: {
                try {
                    this.engineSetParameter(PSSParameterSpec.DEFAULT);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Log.log(LogLevel.Error, invalidAlgorithmParameterException.getMessage());
                }
                break;
            }
            case 11: {
                try {
                    this.engineSetParameter(new PSSParameterSpec("SHA-224", "MGF1", MGF1ParameterSpec.SHA224, 28, 1));
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Log.log(LogLevel.Error, invalidAlgorithmParameterException.getMessage());
                }
                break;
            }
            case 12: {
                try {
                    this.engineSetParameter(new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1));
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Log.log(LogLevel.Error, invalidAlgorithmParameterException.getMessage());
                }
                break;
            }
            case 13: {
                try {
                    this.engineSetParameter(new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1));
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Log.log(LogLevel.Error, invalidAlgorithmParameterException.getMessage());
                }
                break;
            }
            case 14: {
                try {
                    this.engineSetParameter(new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1));
                    break;
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Log.log(LogLevel.Error, invalidAlgorithmParameterException.getMessage());
                }
            }
        }
    }

    private void setHash(String string) throws Exception {
        this.signInfo.hash_algo(this.selectHashAlgo(string));
        this.md = CryptoServerProvider.PROVIDER_HASH_RNG != null ? MessageDigest.getInstance(string, CryptoServerProvider.PROVIDER_HASH_RNG) : MessageDigest.getInstance(string);
    }

    private boolean isSignaturePSS() {
        return this.signatureAlgo.indexOf("RSASSA-PSS") != -1;
    }

    private boolean isSignatureP1363Format() {
        return this.signatureAlgo.indexOf("inP1363Format") != -1;
    }

    private void initializeSignInfo() {
        this.signInfo = new UcapiSignInfo();
        this.signInfo.format(UcapiWrapperGlobal.Format.NONE);
        this.signInfo.hash_mode(UcapiWrapperGlobal.HashMode.HASH);
        this.signInfo.padding().set_none();
        this.signInfo.chaining().set_none();
        switch (this.sigAlgo) {
            case 1: {
                this.signInfo.padding().set_pkcs1();
                break;
            }
            case 2: {
                this.signInfo.format(UcapiWrapperGlobal.Format.ASN1);
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                this.signInfo.format(UcapiWrapperGlobal.Format.ASN1);
            }
        }
        if (!this.isSignaturePSS()) {
            this.signInfo.hash_algo(ToolBox.getHashMechanism(this.hashAlgo));
        } else {
            this.initializeParametersPSS(this.hashAlgo);
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        Log.log(LogLevel.Trace, "enter....");
        if (!(privateKey instanceof CryptoServerPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.skey = ((CryptoServerPrivateKey)privateKey).keyHandle;
        if (!"EdDSA".equals(this.keyAlgo) && !this.keyAlgo.equals(((CryptoServerPrivateKey)privateKey).getAlgorithm())) {
            throw new InvalidKeyException();
        }
        if (this.signInfo == null) {
            this.initializeSignInfo();
        }
        this.mode = 1;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        Log.log(LogLevel.Trace, "enter....");
        if (!(publicKey instanceof CryptoServerPublicKey)) {
            throw new InvalidKeyException();
        }
        this.pkey = ((CryptoServerPublicKey)publicKey).keyHandle;
        if (!"EdDSA".equals(this.keyAlgo) && !this.keyAlgo.equals(((CryptoServerPublicKey)publicKey).getAlgorithm())) {
            throw new InvalidKeyException();
        }
        if (this.signInfo == null) {
            this.initializeSignInfo();
        }
        this.mode = 2;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        Log.log(LogLevel.Trace, "enter....");
        if (this.signInfo == null) {
            throw new CryptoServerProviderJCEException("The mechanism is not initialized. Please, invoke the initialization before.");
        }
        if (this.signInfo.hash_algo().value == UcapiWrapperGlobal.HashAlgo.NONE.value) {
            this.buffer.write(byArray, n, n2);
        } else {
            this.md.update(byArray, n, n2);
        }
    }

    @Override
    protected void engineUpdate(byte by) {
        Log.log(LogLevel.Trace, "enter....");
        if (this.signInfo == null) {
            throw new CryptoServerProviderJCEException("The mechanism is not initialized. Please, invoke the initialization before.");
        }
        if (this.signInfo.hash_algo().value == UcapiWrapperGlobal.HashAlgo.NONE.value) {
            this.buffer.write(by);
        } else {
            this.md.update(by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] signSetFipsProp(UcapiWrapperGlobal.SignFlags signFlags, byte[] byArray, UcapiVectorU8 ucapiVectorU8) throws IOException, CryptoServerJCEException {
        this.signInfo.sign_flags(signFlags);
        byte[] byArray2 = null;
        try (Pointer pointer = null;
             UcapiVectorU8 ucapiVectorU82 = new UcapiVectorU8(byArray);){
            pointer = UcapiWrapperGlobal.sign(this.hsm.getSession(), this.hsm.isEphemeralStored(this.skey) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.signInfo, this.skey, ucapiVectorU82.get(), ucapiVectorU82.size(), ucapiVectorU8);
            byArray2 = ((UcapiVectorU8)pointer).get();
            if (this.isSignatureP1363Format()) {
                byArray2 = this.decodeAsn1ToP1363Format(byArray2);
            }
        }
        return byArray2;
    }

    private byte[] decodeP1363FormatToAsn1(byte[] byArray) throws IOException, CryptoServerJCEException {
        if (byArray.length % 2 != 0) {
            throw new CryptoServerJCEException(-1335361526, "Error parsing p1363format signature: signature length is odd");
        }
        try {
            byte[] byArray2 = new byte[byArray.length / 2];
            byte[] byArray3 = new byte[byArray.length / 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
            String string = new String(ToolBox.bytesToHexString(byArray2));
            String string2 = new String(ToolBox.bytesToHexString(byArray3));
            if (string.indexOf("00") == 0) {
                string = string.toUpperCase().replaceFirst("(00)+", "");
            }
            if (string2.indexOf("00") == 0) {
                string2 = string2.toUpperCase().replaceFirst("(00)+", "");
            }
            if (Integer.parseInt(String.valueOf(string.charAt(0)), 16) > 7) {
                string = "00" + string;
            }
            if (Integer.parseInt(String.valueOf(string2.charAt(0)), 16) > 7) {
                string2 = "00" + string2;
            }
            AsnBuffer asnBuffer = new AsnBuffer();
            AsnBuffer asnBuffer2 = new AsnBuffer();
            asnBuffer2.addINT(2, ToolBox.hexStringToByteArray(string));
            asnBuffer2.addINT(2, ToolBox.hexStringToByteArray(string2));
            asnBuffer.addSEQ(asnBuffer2);
            return asnBuffer.getData();
        }
        catch (Exception exception) {
            CryptoServerJCEException cryptoServerJCEException = new CryptoServerJCEException(-1335361526, "Error parsing p1363format signature: " + exception.toString());
            cryptoServerJCEException.initCause(exception);
            throw cryptoServerJCEException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] decodeAsn1ToP1363Format(byte[] byArray) throws IOException, CryptoServerJCEException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            AsnBuffer asnBuffer = new AsnBuffer(byArray);
            AsnBuffer asnBuffer2 = asnBuffer.getSEQ();
            byte[] byArray2 = asnBuffer2.getINT(2);
            byte[] byArray3 = asnBuffer2.getINT(2);
            BigInteger bigInteger = new BigInteger(1, byArray2);
            BigInteger bigInteger2 = new BigInteger(1, byArray3);
            String string = new String(ToolBox.bytesToHexString(bigInteger.toByteArray()));
            String string2 = new String(ToolBox.bytesToHexString(bigInteger2.toByteArray()));
            if (string.indexOf("00") == 0) {
                string = string.toUpperCase().replaceFirst("00", "");
            }
            if (string2.indexOf("00") == 0) {
                string2 = string2.toUpperCase().replaceFirst("00", "");
            }
            if (string.length() < string2.length()) {
                while (string.length() < string2.length()) {
                    string = "0" + string;
                }
            } else if (string.length() > string2.length()) {
                while (string.length() > string2.length()) {
                    string2 = "0" + string2;
                }
            }
            byteArrayOutputStream.write(ToolBox.hexStringToByteArray(string));
            byteArrayOutputStream.write(ToolBox.hexStringToByteArray(string2));
            byteArrayOutputStream.flush();
            byte[] byArray4 = byteArrayOutputStream.toByteArray();
            return byArray4;
        }
        catch (Exception exception) {
            CryptoServerJCEException cryptoServerJCEException = new CryptoServerJCEException(-1335361526, "Error parsing asn1 signature: " + exception.toString());
            cryptoServerJCEException.initCause(exception);
            throw cryptoServerJCEException;
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray;
        Log.log(LogLevel.Trace, "enter....");
        if (this.signInfo == null) {
            throw new CryptoServerProviderJCEException("The mechanism is not initialized. Please, invoke the initialization before.");
        }
        if (this.mode != 1) {
            throw new SignatureException();
        }
        if (this.signInfo.hash_algo().value == UcapiWrapperGlobal.HashAlgo.NONE.value) {
            byArray = this.buffer.toByteArray();
            this.buffer.reset();
        } else {
            byArray = this.md.digest();
            this.md.reset();
        }
        try {
            byte[] byArray2 = this.signSetFipsProp(UcapiWrapperGlobal.SignFlags.NONE, byArray, null);
            return byArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.log(LogLevel.Error, exception.getMessage());
            SignatureException signatureException = new SignatureException(exception.toString());
            signatureException.initCause(exception);
            throw signatureException;
        }
        finally {
            if (this.signInfo != null) {
                this.signInfo.close();
                this.signInfo = null;
            }
        }
    }

    @Override
    protected int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        Log.log(LogLevel.Trace, "enter....");
        byte[] byArray2 = this.engineSign();
        if (byArray2.length > n2) {
            throw new SignatureException("Buffer too small");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    /*
     * Exception decompiling
     */
    protected boolean verifySetFipsProp(UcapiWrapperGlobal.VerifyFlags var1_1, byte[] var2_2, byte[] var3_3) throws IOException, CryptoServerJCEException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2;
        Log.log(LogLevel.Trace, "enter....");
        if (this.signInfo == null) {
            throw new CryptoServerProviderJCEException("The mechanism is not initialized. Please, invoke the initialization before.");
        }
        if (this.mode != 2) {
            throw new SignatureException();
        }
        if (this.signInfo.hash_algo().value == UcapiWrapperGlobal.HashAlgo.NONE.value) {
            byArray2 = this.buffer.toByteArray();
            this.buffer.reset();
        } else {
            byArray2 = this.md.digest();
            this.md.reset();
        }
        try {
            boolean bl = this.verifySetFipsProp(UcapiWrapperGlobal.VerifyFlags.NONE, byArray2, byArray);
            return bl;
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            SignatureException signatureException = new SignatureException(exception.toString());
            signatureException.initCause(exception);
            throw signatureException;
        }
        finally {
            if (this.signInfo != null) {
                this.signInfo.close();
                this.signInfo = null;
            }
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        Log.log(LogLevel.Trace, "enter....");
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return this.engineVerify(byArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        Log.log(LogLevel.Trace, "enter....");
        if (this.signInfo == null) {
            this.initializeSignInfo();
        }
        if (algorithmParameterSpec != null) {
            UcapiWrapperGlobal.HashAlgo hashAlgo;
            UcapiWrapperGlobal.HashAlgo hashAlgo2;
            if (!(algorithmParameterSpec instanceof PSSParameterSpec)) throw new InvalidAlgorithmParameterException("invalid AlgorithmParameterSpec");
            if (!this.isSignaturePSS()) {
                throw new UnsupportedOperationException("engineSetParameter unsupported");
            }
            PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
            String string = pSSParameterSpec.getDigestAlgorithm();
            try {
                hashAlgo2 = this.selectHashAlgo(string);
                this.setHash(string);
            }
            catch (Exception exception) {
                Log.log(LogLevel.Error, exception.getMessage());
                throw new InvalidAlgorithmParameterException("unsupported digest algorithm: " + string);
            }
            AlgorithmParameterSpec algorithmParameterSpec2 = pSSParameterSpec.getMGFParameters();
            if (!pSSParameterSpec.getMGFAlgorithm().equals("MGF1") || !(algorithmParameterSpec2 instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("invalid MGF algorithm");
            }
            if (pSSParameterSpec.getTrailerField() != 1) {
                throw new InvalidAlgorithmParameterException("invalid trailer field value [has to be == 1]");
            }
            MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)algorithmParameterSpec2;
            String string2 = mGF1ParameterSpec.getDigestAlgorithm();
            try {
                hashAlgo = this.selectHashAlgo(string2);
            }
            catch (Exception exception) {
                Log.log(LogLevel.Error, exception.getMessage());
                throw new InvalidAlgorithmParameterException("unsupported mgf1 digest algorithm: " + string2);
            }
            this.signInfo.padding().set_pss(hashAlgo2, hashAlgo, pSSParameterSpec.getSaltLength());
            return;
        }
        this.signInfo.padding().set_none();
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) {
        Log.log(LogLevel.Trace, "enter....");
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        Log.log(LogLevel.Trace, "enter....");
        return null;
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) {
        Log.log(LogLevel.Trace, "enter....");
    }

    private static String getHashName(int n) throws NoSuchAlgorithmException {
        switch (n) {
            case 10: {
                return "SHA-1";
            }
            case 11: {
                return "SHA-224";
            }
            case 12: {
                return "SHA-256";
            }
            case 13: {
                return "SHA-384";
            }
            case 14: {
                return "SHA-512";
            }
            case 16: {
                return "SHA3-224";
            }
            case 17: {
                return "SHA3-256";
            }
            case 18: {
                return "SHA3-384";
            }
            case 19: {
                return "SHA3-512";
            }
            case 15: {
                return "MD5";
            }
        }
        throw new NoSuchAlgorithmException();
    }

    private UcapiWrapperGlobal.HashAlgo selectHashAlgo(String string) throws NoSuchAlgorithmException {
        switch (string) {
            case "MD5": {
                return UcapiWrapperGlobal.HashAlgo.MD5;
            }
            case "RMD-160": {
                return UcapiWrapperGlobal.HashAlgo.RMD160;
            }
            case "SHA-1": {
                return UcapiWrapperGlobal.HashAlgo.SHA1;
            }
            case "SHA-224": {
                return UcapiWrapperGlobal.HashAlgo.SHA224;
            }
            case "SHA3-224": {
                return UcapiWrapperGlobal.HashAlgo.SHA3_224;
            }
            case "SHA-256": {
                return UcapiWrapperGlobal.HashAlgo.SHA256;
            }
            case "SHA3-256": {
                return UcapiWrapperGlobal.HashAlgo.SHA3_256;
            }
            case "SHA-384": {
                return UcapiWrapperGlobal.HashAlgo.SHA384;
            }
            case "SHA3-384": {
                return UcapiWrapperGlobal.HashAlgo.SHA3_384;
            }
            case "SHA-512": {
                return UcapiWrapperGlobal.HashAlgo.SHA512;
            }
            case "SHA3-512": {
                return UcapiWrapperGlobal.HashAlgo.SHA3_512;
            }
        }
        throw new NoSuchAlgorithmException();
    }
}

