/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import com.utimaco.jce.hsm.HSM;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;

public class CryptoServerMessageDigest
extends MessageDigestSpi {
    private final HSM hsm;
    private final String algorithm;
    private final int digestLen;
    private byte[] info = null;
    private boolean err;

    CryptoServerMessageDigest(HSM hSM, String string) throws NoSuchAlgorithmException {
        Log.log(LogLevel.Trace, "enter....");
        this.hsm = hSM;
        this.algorithm = string;
        this.digestLen = CryptoServerMessageDigest.setDigestLen(string);
    }

    @Override
    protected int engineGetDigestLength() {
        Log.log(LogLevel.Trace, "enter....");
        return this.digestLen;
    }

    protected String getAlgorithm() {
        Log.log(LogLevel.Trace, "enter....");
        return this.algorithm;
    }

    @Override
    protected byte[] engineDigest() {
        Log.log(LogLevel.Trace, "enter....");
        return this.prvEngineDigest(null);
    }

    protected byte[] engineDigest(byte[] byArray) {
        Log.log(LogLevel.Trace, "enter....");
        return this.prvEngineDigest(byArray);
    }

    @Override
    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        Log.log(LogLevel.Trace, "enter....");
        if (this.err) {
            return 0;
        }
        byte[] byArray2 = this.prvEngineDigest(byArray);
        int n3 = byArray2.length;
        if (n3 > n2) {
            throw new DigestException("len not sufficent");
        }
        System.arraycopy(byArray2, 0, byArray, n, n3);
        return n3;
    }

    @Override
    protected void engineReset() {
        Log.log(LogLevel.Trace, "enter....");
        this.info = null;
        this.err = false;
    }

    @Override
    protected void engineUpdate(byte by) {
        Log.log(LogLevel.Trace, "enter....");
        this.info = this.info == null ? new byte[]{} : this.info;
        this.engineUpdate(new byte[]{by}, this.info.length, 1);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        Log.log(LogLevel.Trace, "enter....");
        this.info = this.info == null ? new byte[]{} : this.info;
        byte[] byArray2 = new byte[n2 + this.info.length];
        try {
            System.arraycopy(this.info, 0, byArray2, 0, this.info.length);
            System.arraycopy(byArray, 0, byArray2, this.info.length, n2);
            this.info = byArray2;
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            this.err = true;
            exception.printStackTrace();
        }
    }

    protected void engineUpdate(byte[] byArray) {
        Log.log(LogLevel.Trace, "enter....");
        this.info = byArray;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        Log.log(LogLevel.Trace, "enter....");
        try {
            this.info = byteBuffer.array();
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            this.err = true;
            exception.printStackTrace();
        }
    }

    private byte[] prvEngineDigest(byte[] byArray) {
        Log.log(LogLevel.Trace, "enter....");
        byte[] byArray2 = this.info = byArray != null ? byArray : this.info;
        if (this.err) {
            return null;
        }
        byte[] byArray3 = null;
        byArray3 = !CryptoServerProvider.USE_HSM_FOR_HASHING ? this.hsm.getHash(this.info, this.algorithm) : this.hsm.getInternalHash(this.info, this.algorithm);
        this.engineReset();
        return byArray3;
    }

    private static int setDigestLen(String string) throws NoSuchAlgorithmException {
        switch (string) {
            case "MD5": {
                return 16;
            }
            case "RMD-160": 
            case "SHA-1": {
                return 20;
            }
            case "SHA-224": 
            case "SHA3-224": {
                return 28;
            }
            case "SHA-256": 
            case "SHA3-256": {
                return 32;
            }
            case "SHA-384": 
            case "SHA3-384": {
                return 48;
            }
            case "SHA-512": 
            case "SHA3-512": {
                return 64;
            }
        }
        throw new NoSuchAlgorithmException();
    }
}

