/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerJCE.CryptoServerKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerSecretKey;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import CryptoServerJCE.ToolBox;
import com.utimaco.javacpp.global.UcapiWrapperGlobal;
import com.utimaco.javacpp.ucapi.UcapiExportPolicy;
import com.utimaco.javacpp.ucapi.UcapiKeyGenInfo;
import com.utimaco.javacpp.ucapi.UcapiKeyHandle;
import com.utimaco.javacpp.ucapi.UcapiKeyTemplate;
import com.utimaco.javacpp.ucapi.UcapiKeyWriteFlags;
import com.utimaco.jce.hsm.HSM;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import org.bytedeco.javacpp.Pointer;

public class CryptoServerKeyGenerator
extends KeyGeneratorSpi {
    private final HSM hsm;
    private final int algo;
    private final String algoStr;
    private int keySize;
    private final UcapiWrapperGlobal.Algorithm ucapiAlgo;
    private CryptoServerKeyGenParameterSpec cp;

    CryptoServerKeyGenerator(HSM hSM, String string, int n) throws NoSuchAlgorithmException {
        Log.log(LogLevel.Trace, "enter....");
        this.hsm = hSM;
        this.algo = n;
        this.algoStr = string;
        switch (n) {
            case 20: {
                this.keySize = 168;
                this.ucapiAlgo = UcapiWrapperGlobal.Algorithm.DES;
                break;
            }
            case 21: {
                this.keySize = 192;
                this.ucapiAlgo = UcapiWrapperGlobal.Algorithm.AES;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) throws InvalidParameterException {
        Log.log(LogLevel.Trace, "enter....");
        switch (this.algo) {
            case 20: {
                if (n != 56 && n != 112 && n != 168) {
                    throw new InvalidParameterException();
                }
                this.keySize = n;
                break;
            }
            case 21: {
                if (n != 128 && n != 192 && n != 256) {
                    throw new InvalidParameterException();
                }
                this.keySize = n;
                break;
            }
            default: {
                throw new InvalidParameterException();
            }
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidParameterException {
        Log.log(LogLevel.Trace, "enter....");
        if (!(algorithmParameterSpec instanceof CryptoServerKeyGenParameterSpec)) {
            throw new InvalidParameterException();
        }
        this.cp = (CryptoServerKeyGenParameterSpec)algorithmParameterSpec;
        this.engineInit(this.cp.keySize, null);
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        Log.log(LogLevel.Trace, "enter....");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        UcapiKeyHandle ucapiKeyHandle;
        Log.log(LogLevel.Trace, "enter....");
        UcapiKeyTemplate ucapiKeyTemplate = null;
        Pointer pointer = null;
        Pointer pointer2 = null;
        Pointer pointer3 = null;
        try {
            ucapiKeyTemplate = new UcapiKeyTemplate();
            ucapiKeyTemplate.set_algorithm(this.ucapiAlgo);
            ucapiKeyTemplate.set_size(this.keySize);
            if (this.cp != null && this.cp.isConfigured) {
                pointer3 = ToolBox.setDefaultExportPolicy(null);
                ((UcapiExportPolicy)pointer3).allow_wrapped_export(this.cp.allow_wrapped_export);
                ((UcapiExportPolicy)pointer3).allow_plain_export(this.cp.allow_plain_export);
            } else {
                pointer3 = this.hsm.getExportPolicy();
            }
            ucapiKeyTemplate.set_export_policy((UcapiExportPolicy)pointer3);
            ucapiKeyTemplate.set_usage(this.hsm.getKeyUsage());
            if (this.hsm.getKeyGroup() != null) {
                ucapiKeyTemplate.set_group(this.hsm.getKeyGroup());
            }
            ucapiKeyTemplate.set_date_generated(ToolBox.generateFormatCurrentDate());
            pointer = new UcapiKeyWriteFlags();
            ((UcapiKeyWriteFlags)pointer).location((byte)2);
            ((UcapiKeyWriteFlags)pointer).lifetime((byte)8);
            pointer2 = new UcapiKeyGenInfo();
            ucapiKeyHandle = UcapiWrapperGlobal.key_generate(this.hsm.getSession(), this.hsm.getKeyStorage(), (UcapiKeyGenInfo)pointer2, ucapiKeyTemplate, (UcapiKeyWriteFlags)pointer);
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (pointer2 != null) {
                pointer2.close();
            }
            if (pointer != null) {
                pointer.close();
            }
            if (this.cp != null && this.cp.isConfigured && pointer3 != null) {
                pointer3.close();
            }
            if (ucapiKeyTemplate != null) {
                ucapiKeyTemplate.close();
            }
        }
        return new CryptoServerSecretKey(this.hsm, this.algoStr, ucapiKeyHandle);
    }
}

