/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerJCE.CryptoServerDSAPrivateKey;
import CryptoServerJCE.CryptoServerECPrivateKey;
import CryptoServerJCE.CryptoServerKeySpec;
import CryptoServerJCE.CryptoServerRSAPrivateKey;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import com.utimaco.javacpp.ucapi.UcapiExportPolicy;
import com.utimaco.javacpp.ucapi.UcapiKeyHandle;
import com.utimaco.jce.hsm.HSM;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class CryptoServerKeyFactory
extends KeyFactorySpi {
    private HSM hsm;
    private final int algo;

    CryptoServerKeyFactory(HSM hSM, String string, int n) throws NoSuchAlgorithmException {
        Log.log(LogLevel.Trace, "enter....");
        this.hsm = hSM;
        this.algo = n;
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("Invalid Algorithm: " + n);
            }
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        Log.log(LogLevel.Trace, "enter....");
        try {
            switch (this.algo) {
                case 1: {
                    if (!(keySpec instanceof RSAPublicKeySpec)) {
                        throw new InvalidKeySpecException();
                    }
                    RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                    return this.hsm.importPublicRSAKey(rSAPublicKeySpec);
                }
                case 2: {
                    if (!(keySpec instanceof DSAPublicKeySpec)) {
                        throw new InvalidKeySpecException();
                    }
                    DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
                    return this.hsm.importPublicDSAKey(dSAPublicKeySpec);
                }
                case 3: {
                    if (!(keySpec instanceof ECPublicKeySpec)) {
                        throw new InvalidKeySpecException();
                    }
                    ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)keySpec;
                    return this.hsm.importPublicECKey(eCPublicKeySpec);
                }
            }
            throw new InvalidKeySpecException();
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException(exception.toString());
            invalidKeySpecException.initCause(exception);
            exception.printStackTrace();
            throw invalidKeySpecException;
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        Log.log(LogLevel.Trace, "enter....");
        try {
            KeySpec keySpec2 = keySpec;
            UcapiExportPolicy ucapiExportPolicy = this.hsm.getExportPolicy();
            if (keySpec != null && keySpec instanceof CryptoServerKeySpec) {
                keySpec2 = ((CryptoServerKeySpec)keySpec).getKeySpec();
                if (((CryptoServerKeySpec)keySpec).isConfigured) {
                    ucapiExportPolicy = this.hsm.createExportPolicy(((CryptoServerKeySpec)keySpec).allow_wrapped_export, ((CryptoServerKeySpec)keySpec).allow_plain_export);
                }
            }
            switch (this.algo) {
                case 1: {
                    if (keySpec2 instanceof RSAPrivateCrtKeySpec) {
                        RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec2;
                        UcapiKeyHandle ucapiKeyHandle = this.hsm.importPrivateKeyRSA(true, ucapiExportPolicy, rSAPrivateCrtKeySpec);
                        return new CryptoServerRSAPrivateKey(this.hsm, ucapiKeyHandle);
                    }
                    if (keySpec2 instanceof RSAPrivateKeySpec) {
                        RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec2;
                        UcapiKeyHandle ucapiKeyHandle = this.hsm.importPrivateKeyRSA(true, ucapiExportPolicy, rSAPrivateKeySpec);
                        return new CryptoServerRSAPrivateKey(this.hsm, ucapiKeyHandle);
                    }
                    throw new InvalidKeySpecException();
                }
                case 2: {
                    if (!(keySpec2 instanceof DSAPrivateKeySpec)) {
                        throw new InvalidKeySpecException();
                    }
                    DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)keySpec2;
                    UcapiKeyHandle ucapiKeyHandle = this.hsm.importPrivateKeyDSA(true, ucapiExportPolicy, dSAPrivateKeySpec);
                    return new CryptoServerDSAPrivateKey(this.hsm, ucapiKeyHandle);
                }
                case 3: {
                    if (!(keySpec2 instanceof ECPrivateKeySpec)) {
                        throw new InvalidKeySpecException();
                    }
                    ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)keySpec2;
                    UcapiKeyHandle ucapiKeyHandle = this.hsm.importPrivateKeyEC(true, ucapiExportPolicy, eCPrivateKeySpec);
                    return new CryptoServerECPrivateKey(this.hsm, ucapiKeyHandle);
                }
            }
            throw new InvalidKeySpecException();
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException(exception.toString());
            invalidKeySpecException.initCause(exception);
            throw invalidKeySpecException;
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        Log.log(LogLevel.Trace, "enter....");
        throw new InvalidKeyException();
    }

    /*
     * Exception decompiling
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key var1_1, Class<T> var2_2) throws InvalidKeySpecException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

