/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import CryptoServerCXI.Item;
import CryptoServerJCE.CryptoServerECPrivateKey;
import CryptoServerJCE.CryptoServerKeyFactory;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.CryptoServerSecretKey;
import CryptoServerJCE.CryptoServerSharedInfoParameterSpec;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import CryptoServerJCE.ToolBox;
import com.utimaco.javacpp.global.UcapiWrapperGlobal;
import com.utimaco.javacpp.ucapi.UcapiAgreeSecretInfo;
import com.utimaco.javacpp.ucapi.UcapiExportInfo;
import com.utimaco.javacpp.ucapi.UcapiExportPolicy;
import com.utimaco.javacpp.ucapi.UcapiKeyBlob;
import com.utimaco.javacpp.ucapi.UcapiKeyDeriveInfo;
import com.utimaco.javacpp.ucapi.UcapiKeyExport;
import com.utimaco.javacpp.ucapi.UcapiKeyHandle;
import com.utimaco.javacpp.ucapi.UcapiKeyTemplate;
import com.utimaco.javacpp.ucapi.UcapiKeyWriteFlags;
import com.utimaco.javacpp.ucapi.UcapiVectorU8;
import com.utimaco.jce.hsm.HSM;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.bytedeco.javacpp.Pointer;

public class CryptoServerKeyAgreement
extends KeyAgreementSpi {
    private final HSM hsm;
    private final String keyAlgo;
    private final int agreementAlgo;
    private final int hashAlgo;
    private final boolean extraFlag;
    private CryptoServerPrivateKey skey;
    private byte[] publicValue;
    private byte[] sharedData;
    private int secretLen;
    private int mech;
    private boolean tr03111FormatX = false;
    private static final int MECH_KDF_ECDH = 666;
    private static final int MECH_KDF_ECDH_COF = 667;
    private static final String OID_AES = "2.16.840.1.101.3.4.1";

    public CryptoServerKeyAgreement(HSM hSM, String string, int n, int n2, boolean bl) throws NoSuchAlgorithmException {
        this.hsm = hSM;
        this.agreementAlgo = n;
        this.sharedData = new byte[0];
        this.extraFlag = bl;
        switch (n) {
            case 35: {
                this.keyAlgo = "EC";
                this.hashAlgo = n2;
                this.mech = 666;
                break;
            }
            case 36: {
                this.keyAlgo = "EC";
                this.hashAlgo = n2;
                this.mech = 667;
                break;
            }
            case 34: {
                this.keyAlgo = "EC";
                this.hashAlgo = -1;
                this.tr03111FormatX = bl;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
    }

    @Override
    public void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            if (!(key instanceof CryptoServerPrivateKey)) {
                throw new InvalidKeyException();
            }
            if (!this.keyAlgo.equals(key.getAlgorithm())) {
                throw new InvalidKeyException();
            }
            this.skey = (CryptoServerPrivateKey)key;
            if (this.mech == 667) {
                if (!(key instanceof CryptoServerECPrivateKey)) {
                    throw new InvalidKeyException();
                }
                CryptoServerECPrivateKey cryptoServerECPrivateKey = (CryptoServerECPrivateKey)key;
                ECParameterSpec eCParameterSpec = cryptoServerECPrivateKey.getParams();
                if (eCParameterSpec.getCurve().getField() instanceof ECFieldF2m) {
                    throw new InvalidKeyException("Binary field curves not supported");
                }
            }
            int n = this.getEcPrivateKeySize();
            this.secretLen = n + 7 >> 3 << 3;
            this.publicValue = null;
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            throw new InvalidKeyException(exception);
        }
    }

    private int getEcPrivateKeySize() {
        return this.hsm.getKeySize(this.skey.keyHandle);
    }

    @Override
    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Log.log(LogLevel.Trace, "enter....");
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof CryptoServerSharedInfoParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported parameter type");
            }
            if (this.mech == -1) {
                throw new InvalidAlgorithmParameterException("Algorithm does not support parameters");
            }
        }
        this.sharedData = ((CryptoServerSharedInfoParameterSpec)algorithmParameterSpec).getData();
        this.engineInit(key, secureRandom);
    }

    @Override
    public Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        block11: {
            Log.log(LogLevel.Trace, "enter....");
            if (this.skey == null) {
                throw new IllegalStateException("Not initialized");
            }
            if (this.publicValue != null) {
                throw new IllegalStateException("Phase already executed");
            }
            if (!bl) {
                throw new IllegalStateException("Only key agreement between 2 parties allowed");
            }
            if (!(key instanceof PublicKey)) {
                throw new InvalidKeyException("Key must be a PublicKey");
            }
            if ("EC".equalsIgnoreCase(this.keyAlgo)) {
                try {
                    CryptoServerECPrivateKey cryptoServerECPrivateKey = (CryptoServerECPrivateKey)this.skey;
                    if (key instanceof ECPublicKey && (key.getAlgorithm().equalsIgnoreCase("EC") || key.getAlgorithm().equalsIgnoreCase("ECDH"))) {
                        ECParameterSpec eCParameterSpec = cryptoServerECPrivateKey.getParams();
                        ECParameterSpec eCParameterSpec2 = ((ECPublicKey)key).getParams();
                        if (!(eCParameterSpec.getCurve().equals(eCParameterSpec2.getCurve()) && eCParameterSpec.getGenerator().equals(eCParameterSpec2.getGenerator()) && eCParameterSpec.getOrder().equals(eCParameterSpec2.getOrder()) && eCParameterSpec.getCofactor() == eCParameterSpec2.getCofactor())) {
                            throw new InvalidKeyException("PublicKey EC parameters must match PrivateKey EC parameters");
                        }
                        ECPoint eCPoint = ((ECPublicKey)key).getW();
                        this.publicValue = ToolBox.encodePoint(eCPoint, eCParameterSpec2.getCurve());
                        break block11;
                    }
                    if (key instanceof CryptoServerPublicKey && key.getAlgorithm().equalsIgnoreCase("EC")) {
                        byte[] byArray = cryptoServerECPrivateKey.getInternalParams().getEncoded();
                        CryptoServerPublicKey cryptoServerPublicKey = (CryptoServerPublicKey)key;
                        byte[] byArray2 = ToolBox.getEncodedCurve(cryptoServerPublicKey.keyHandle, this.hsm);
                        if (Arrays.equals(byArray2, byArray)) {
                            throw new InvalidKeyException("PublicKey EC parameters must match PrivateKey EC parameters");
                        }
                        this.publicValue = byArray2;
                        break block11;
                    }
                    throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
                }
                catch (Exception exception) {
                    Log.log(LogLevel.Error, exception.getMessage());
                    exception.printStackTrace();
                    throw new InvalidKeyException(exception);
                }
            }
        }
        return null;
    }

    @Override
    public byte[] engineGenerateSecret() throws IllegalStateException {
        Log.log(LogLevel.Trace, "enter....");
        if (this.agreementAlgo == 34) {
            if (this.skey == null || this.publicValue == null) {
                throw new IllegalStateException("Not initialized correctly");
            }
            Pointer pointer = null;
            Pointer pointer2 = null;
            try {
                byte[] byArray;
                ECParameterSpec eCParameterSpec = new CryptoServerCXI.ECParameter(ToolBox.getEncodedCurve(this.skey.keyHandle, this.hsm)).getSpec();
                CryptoServerKeyFactory cryptoServerKeyFactory = new CryptoServerKeyFactory(this.hsm, null, 3);
                ECPoint eCPoint = ToolBox.decodePoint(this.publicValue, eCParameterSpec.getCurve());
                ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
                PublicKey publicKey = cryptoServerKeyFactory.engineGeneratePublic(eCPublicKeySpec);
                pointer = new UcapiAgreeSecretInfo();
                if (this.tr03111FormatX) {
                    ((UcapiAgreeSecretInfo)pointer).format(UcapiWrapperGlobal.Format.X_COORD);
                } else {
                    ((UcapiAgreeSecretInfo)pointer).format(UcapiWrapperGlobal.Format.NONE);
                }
                ((UcapiAgreeSecretInfo)pointer).flags(UcapiWrapperGlobal.AgreeSecretFlags.NO_ENCRYPTION);
                ((UcapiAgreeSecretInfo)pointer).pubkey_handle(((CryptoServerPublicKey)publicKey).keyHandle);
                pointer2 = UcapiWrapperGlobal.agree_secret(this.hsm.getSession(), this.hsm.isEphemeralStored(this.skey.keyHandle) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.skey.keyHandle, (UcapiAgreeSecretInfo)pointer);
                byte[] byArray2 = byArray = ToolBox.ucapiVecU8ToByteArray((UcapiVectorU8)pointer2);
                return byArray2;
            }
            catch (Exception exception) {
                Log.log(LogLevel.Error, exception.getMessage());
                throw new IllegalStateException(exception);
            }
            finally {
                if (pointer != null) {
                    pointer.close();
                }
                if (pointer2 != null) {
                    pointer2.close();
                }
            }
        }
        CryptoServerSecretKey cryptoServerSecretKey = null;
        Pointer pointer = null;
        Pointer pointer3 = null;
        Pointer pointer4 = null;
        try {
            byte[] byArray;
            cryptoServerSecretKey = (CryptoServerSecretKey)this.engineGenerateSecret("Generic");
            pointer = new UcapiExportInfo();
            ((UcapiExportInfo)pointer).blob_type(UcapiWrapperGlobal.ExportBlobType.SIMPLE);
            ((UcapiExportInfo)pointer).key_type(UcapiWrapperGlobal.KeyType.SECRET);
            pointer3 = UcapiWrapperGlobal.key_export(this.hsm.getSession(), this.hsm.isEphemeralStored(this.skey.keyHandle) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), cryptoServerSecretKey.getKeyHandle(), (UcapiExportInfo)pointer, null);
            pointer4 = new UcapiKeyBlob((UcapiKeyExport)pointer3);
            byte[] byArray3 = Item.getItem(CryptoServerCXI.TAG_KB, ToolBox.exportKeyToByteArray((UcapiKeyExport)pointer3), 0);
            byte[] byArray4 = byArray = Item.getItem(CryptoServerCXI.TAG_KC, byArray3, 0);
            return byArray4;
        }
        catch (CryptoServerException | InvalidKeyException | NoSuchAlgorithmException exception) {
            throw new IllegalStateException(exception);
        }
        finally {
            if (cryptoServerSecretKey != null && cryptoServerSecretKey.keyHandle != null) {
                cryptoServerSecretKey.keyHandle.close();
            }
            if (pointer != null) {
                pointer.close();
            }
            if (pointer3 != null) {
                pointer3.close();
            }
            if (pointer4 != null) {
                pointer4.close();
            }
        }
    }

    @Override
    public int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        Log.log(LogLevel.Trace, "enter....");
        if (n + this.secretLen > byArray.length) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (byArray.length - n) + " available");
        }
        byte[] byArray2 = this.engineGenerateSecret();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    @Override
    public SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (string == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (this.skey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        if (this.agreementAlgo == 34) {
            throw new NoSuchAlgorithmException("Key agreement service does not have a KDF");
        }
        UcapiKeyTemplate ucapiKeyTemplate = null;
        Pointer pointer = null;
        Pointer pointer2 = null;
        Pointer pointer3 = null;
        try {
            Object object;
            ucapiKeyTemplate = new UcapiKeyTemplate();
            ucapiKeyTemplate.set_type(UcapiWrapperGlobal.KeyType.SECRET);
            if (string.equalsIgnoreCase("DES")) {
                ucapiKeyTemplate.set_size(56);
                ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.DES);
            } else if (string.equalsIgnoreCase("DESede")) {
                ucapiKeyTemplate.set_size(168);
                ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.DES);
            } else if (string.equalsIgnoreCase("AES") || string.equals(OID_AES)) {
                ucapiKeyTemplate.set_size(256);
                ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.AES);
            } else if (string.startsWith(OID_AES)) {
                object = string.split("\\.");
                if (((String[])object).length != 9) {
                    throw new NoSuchAlgorithmException("Unknown algorithm " + string);
                }
                try {
                    int n = Integer.parseInt(object[8]);
                    if (n < 20) {
                        ucapiKeyTemplate.set_size(128);
                    } else if (n < 40) {
                        ucapiKeyTemplate.set_size(192);
                    } else {
                        ucapiKeyTemplate.set_size(256);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NoSuchAlgorithmException("Unknown algorithm " + string);
                }
                ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.AES);
            } else if (string.equalsIgnoreCase("Generic")) {
                ucapiKeyTemplate.set_size(this.secretLen);
                ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.RAW);
            } else {
                throw new NoSuchAlgorithmException("Unknown algorithm " + string);
            }
            if (ucapiKeyTemplate.get_size().value() > this.secretLen && this.hashAlgo == 0) {
                throw new InvalidKeyException("Could only generate secret keys with length <=" + this.secretLen);
            }
            pointer = new UcapiExportPolicy();
            ((UcapiExportPolicy)pointer).allow_backup(true);
            ((UcapiExportPolicy)pointer).allow_plain_export(true);
            ((UcapiExportPolicy)pointer).allow_wrapped_export(true);
            ucapiKeyTemplate.set_export_policy((UcapiExportPolicy)pointer);
            ucapiKeyTemplate.set_usage(this.hsm.getKeyUsage());
            pointer2 = new UcapiKeyDeriveInfo();
            object = null;
            if (this.mech == 667) {
                object = this.extraFlag ? UcapiWrapperGlobal.ECKDF.NIST_SP800_56A : UcapiWrapperGlobal.ECKDF.ANSI_X9_63;
                ((UcapiKeyDeriveInfo)pointer2).set_ecdh_cofactor((UcapiWrapperGlobal.ECKDF)((Object)object), ToolBox.getHashMechanism(this.hashAlgo), this.sharedData, this.sharedData != null ? this.sharedData.length : 0, this.publicValue, this.publicValue.length);
            } else {
                object = UcapiWrapperGlobal.ECKDF.ANSI_X9_63;
                ((UcapiKeyDeriveInfo)pointer2).set_ecdh((UcapiWrapperGlobal.ECKDF)((Object)object), ToolBox.getHashMechanism(this.hashAlgo), this.sharedData, this.sharedData != null ? this.sharedData.length : 0, this.publicValue, this.publicValue.length);
            }
            pointer3 = new UcapiKeyWriteFlags();
            ((UcapiKeyWriteFlags)pointer3).location((byte)2);
            UcapiKeyHandle ucapiKeyHandle = UcapiWrapperGlobal.key_derive(this.hsm.getSession(), this.hsm.isEphemeralStored(this.skey.keyHandle) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.skey.keyHandle, (UcapiKeyDeriveInfo)pointer2, ucapiKeyTemplate, (UcapiKeyWriteFlags)pointer3);
            CryptoServerSecretKey cryptoServerSecretKey = new CryptoServerSecretKey(this.hsm, string, ucapiKeyHandle);
            return cryptoServerSecretKey;
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            throw new InvalidKeyException(exception);
        }
        finally {
            if (pointer3 != null) {
                pointer3.close();
            }
            if (pointer2 != null) {
                pointer2.close();
            }
            if (pointer != null) {
                pointer.close();
            }
            if (ucapiKeyTemplate != null) {
                ucapiKeyTemplate.close();
            }
        }
    }
}

