/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerJCE.CryptoServerJCEException;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.ToolBox;
import com.utimaco.javacpp.global.UcapiWrapperGlobal;
import com.utimaco.javacpp.ucapi.UcapiKeyHandle;
import com.utimaco.javacpp.ucapi.UcapiKeyProperties;
import com.utimaco.jce.hsm.HSM;
import java.math.BigInteger;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;

public final class CryptoServerDSAPrivateKey
extends CryptoServerPrivateKey
implements DSAKey {
    private static final long serialVersionUID = 199576939900390733L;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;

    CryptoServerDSAPrivateKey(HSM hSM, UcapiKeyHandle ucapiKeyHandle) throws CryptoServerJCEException {
        super(hSM, UcapiWrapperGlobal.Algorithm.DSA.name(), ucapiKeyHandle);
        short[] sArray = new short[]{UcapiWrapperGlobal.PropertyID.KEY_DSA_P.value, UcapiWrapperGlobal.PropertyID.KEY_DSA_Q.value, UcapiWrapperGlobal.PropertyID.KEY_DSA_G.value};
        try (UcapiKeyProperties ucapiKeyProperties = hSM.getKeyProperties(this.keyHandle, sArray);){
            this.p = new BigInteger(1, ToolBox.ucapiVecU8ToByteArray(ucapiKeyProperties.get_dsa_prime_p().value()));
            this.q = new BigInteger(1, ToolBox.ucapiVecU8ToByteArray(ucapiKeyProperties.get_dsa_prime_q().value()));
            this.g = new BigInteger(1, ToolBox.ucapiVecU8ToByteArray(ucapiKeyProperties.get_dsa_generator().value()));
        }
        catch (Exception exception) {
            throw new CryptoServerJCEException(-1182728192, "Invalid parameter value for CryptoServerDSAPrivateKey");
        }
    }

    @Override
    public DSAParams getParams() {
        return new DSAParameterSpec(this.p, this.q, this.g);
    }
}

