/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import java.security.spec.AlgorithmParameterSpec;

public class CryptoServerCCMParameterSpec
implements AlgorithmParameterSpec {
    private byte[] nonce;
    private byte[] aad;
    private int dataLen;
    private int macLen;

    public CryptoServerCCMParameterSpec(byte[] byArray, byte[] byArray2, int n, int n2) throws IllegalArgumentException {
        Log.log(LogLevel.Trace, "enter....");
        this.checkMacLen(n2);
        this.checkNonceDataLen(byArray.length, n);
        this.nonce = byArray;
        this.aad = byArray2;
        this.dataLen = n;
        this.macLen = n2;
    }

    public CryptoServerCCMParameterSpec(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws IllegalArgumentException {
        Log.log(LogLevel.Trace, "enter....");
        this.checkMacLen(n4);
        this.checkNonceDataLen(n2, n3);
        this.nonce = new byte[n2];
        System.arraycopy(byArray, n, this.nonce, 0, n2);
        this.aad = byArray2;
        this.dataLen = n3;
        this.macLen = n4;
    }

    public byte[] getNonce() {
        Log.log(LogLevel.Trace, "enter....");
        return this.nonce;
    }

    public byte[] getAad() {
        Log.log(LogLevel.Trace, "enter....");
        return this.aad;
    }

    public int getDataLen() {
        Log.log(LogLevel.Trace, "enter....");
        return this.dataLen;
    }

    public int getMacLen() {
        Log.log(LogLevel.Trace, "enter....");
        return this.macLen;
    }

    private void checkNonceDataLen(int n, int n2) {
        if (n < 7 || n > 13) {
            String string = "nonce length invalid: " + n;
            Log.log(LogLevel.Error, string);
            throw new IllegalArgumentException(string);
        }
        if (n > 11 && n2 >= 1 << 8 * (15 - n)) {
            String string = "dataLen too big for nonce: " + n2;
            Log.log(LogLevel.Error, string);
            throw new IllegalArgumentException(string);
        }
    }

    private void checkMacLen(int n) throws IllegalArgumentException {
        if (n < 4 || n > 16 || n % 2 != 0) {
            String string = "macLen invalid: " + n;
            Log.log(LogLevel.Error, string);
            throw new IllegalArgumentException(string);
        }
    }
}

