/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerException;
import CryptoServerJCE.AsnBuffer;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import CryptoServerJCE.ToolBox;
import com.utimaco.javacpp.global.UcapiWrapperGlobal;
import com.utimaco.javacpp.ucapi.UcapiKeyHandle;
import com.utimaco.javacpp.ucapi.UcapiKeyProperties;
import com.utimaco.javacpp.ucapi.UcapiSignInfo;
import com.utimaco.javacpp.ucapi.UcapiVectorU8;
import com.utimaco.jce.hsm.HSM;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.bytedeco.javacpp.Pointer;

public class CertBuilder {
    private static final byte[] OID_RSA_ENCRYPTION = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};
    private static final byte[] OID_EC_PUBLICKEY = new byte[]{42, -122, 72, -50, 61, 2, 1};
    private static final byte[] OID_DSA = new byte[]{42, -122, 72, -50, 56, 4, 1};
    private static final byte[] OID_RSA_SHA1 = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 5};
    private static final byte[] OID_DSA_SHA1 = new byte[]{42, -122, 72, -50, 56, 4, 3};
    private static final byte[] OID_ECDSA_WITH_SHA1 = new byte[]{42, -122, 72, -50, 61, 4, 1};
    static final ECCurve[] curves = new ECCurve[]{new ECCurve("secp112r1", new byte[]{43, -127, 4, 0, 6}), new ECCurve("secp112r2", new byte[]{43, -127, 4, 0, 7}), new ECCurve("secp128r1", new byte[]{43, -127, 4, 0, 28}), new ECCurve("secp128r2", new byte[]{43, -127, 4, 0, 29}), new ECCurve("secp160k1", new byte[]{43, -127, 4, 0, 9}), new ECCurve("secp160r1", new byte[]{43, -127, 4, 0, 8}), new ECCurve("secp160r2", new byte[]{43, -127, 4, 0, 30}), new ECCurve("secp192k1", new byte[]{43, -127, 4, 0, 31}), new ECCurve("secp192r1", new byte[]{42, -122, 72, -50, 61, 3, 1, 1}), new ECCurve("secp224k1", new byte[]{43, -127, 4, 0, 32}), new ECCurve("secp224r1", new byte[]{43, -127, 4, 0, 33}), new ECCurve("secp256k1", new byte[]{43, -127, 4, 0, 10}), new ECCurve("secp256r1", new byte[]{42, -122, 72, -50, 61, 3, 1, 7}), new ECCurve("secp384r1", new byte[]{43, -127, 4, 0, 34}), new ECCurve("secp521r1", new byte[]{43, -127, 4, 0, 35}), new ECCurve("NIST-P192", new byte[]{42, -122, 72, -50, 61, 3, 1, 1}), new ECCurve("NIST-P224", new byte[]{43, -127, 4, 0, 33}), new ECCurve("NIST-P256", new byte[]{42, -122, 72, -50, 61, 3, 1, 7}), new ECCurve("NIST-P384", new byte[]{43, -127, 4, 0, 34}), new ECCurve("NIST-P521", new byte[]{43, -127, 4, 0, 35}), new ECCurve("sect113r1", new byte[]{43, -127, 4, 0, 4}), new ECCurve("sect113r2", new byte[]{43, -127, 4, 0, 5}), new ECCurve("sect131r1", new byte[]{43, -127, 4, 0, 22}), new ECCurve("sect131r2", new byte[]{43, -127, 4, 0, 23}), new ECCurve("sect163k1", new byte[]{43, -127, 4, 0, 1}), new ECCurve("sect163r1", new byte[]{43, -127, 4, 0, 2}), new ECCurve("sect163r2", new byte[]{43, -127, 4, 0, 15}), new ECCurve("sect193r1", new byte[]{43, -127, 4, 0, 24}), new ECCurve("sect193r2", new byte[]{43, -127, 4, 0, 25}), new ECCurve("sect233k1", new byte[]{43, -127, 4, 0, 26}), new ECCurve("sect233r1", new byte[]{43, -127, 4, 0, 27}), new ECCurve("sect239k1", new byte[]{43, -127, 4, 0, 3}), new ECCurve("sect283k1", new byte[]{43, -127, 4, 0, 16}), new ECCurve("sect283r1", new byte[]{43, -127, 4, 0, 17}), new ECCurve("sect409k1", new byte[]{43, -127, 4, 0, 36}), new ECCurve("sect409r1", new byte[]{43, -127, 4, 0, 37}), new ECCurve("sect571k1", new byte[]{43, -127, 4, 0, 38}), new ECCurve("sect571r1", new byte[]{43, -127, 4, 0, 39}), new ECCurve("NIST-K163", new byte[]{43, -127, 4, 0, 1}), new ECCurve("NIST-B163", new byte[]{43, -127, 4, 0, 15}), new ECCurve("NIST-K233", new byte[]{43, -127, 4, 0, 26}), new ECCurve("NIST-B233", new byte[]{43, -127, 4, 0, 27}), new ECCurve("NIST-K283", new byte[]{43, -127, 4, 0, 16}), new ECCurve("NIST-B283", new byte[]{43, -127, 4, 0, 17}), new ECCurve("NIST-K409", new byte[]{43, -127, 4, 0, 36}), new ECCurve("NIST-B409", new byte[]{43, -127, 4, 0, 37}), new ECCurve("NIST-K571", new byte[]{43, -127, 4, 0, 38}), new ECCurve("NIST-B571", new byte[]{43, -127, 4, 0, 39}), new ECCurve("brainpoolP160r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 1}), new ECCurve("brainpoolP160t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 2}), new ECCurve("brainpoolP192r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 3}), new ECCurve("brainpoolP192t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 4}), new ECCurve("brainpoolP224r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 5}), new ECCurve("brainpoolP224t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 6}), new ECCurve("brainpoolP256r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 7}), new ECCurve("brainpoolP256t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 8}), new ECCurve("brainpoolP320r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 9}), new ECCurve("brainpoolP320t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 10}), new ECCurve("brainpoolP384r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 11}), new ECCurve("brainpoolP384t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 12}), new ECCurve("brainpoolP512r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 13}), new ECCurve("brainpoolP512t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 14}), new ECCurve("curve25519", new byte[]{43, 6, 1, 4, 1, -105, 85, 1, 5, 1}), new ECCurve("FRP256v1", new byte[]{42, -127, 122, 1, -127, 95, 101, -126, 0, 1}), new ECCurve("sm2p256v1", new byte[]{42, -127, 28, -49, 85, 1, -126, 45}), new ECCurve("edwards25519", new byte[]{43, 101, 112}), new ECCurve("edwards448", new byte[]{43, 101, 113})};

    public static byte[] buildPublicKeyInfoX509(HSM hSM, UcapiKeyHandle ucapiKeyHandle) throws ParseException, CryptoServerException {
        AsnBuffer asnBuffer = CertBuilder.getPublicKeyInfo(hSM, ucapiKeyHandle);
        AsnBuffer asnBuffer2 = new AsnBuffer();
        asnBuffer2.addSEQ(asnBuffer);
        return asnBuffer2.getData();
    }

    public static AsnBuffer getPublicKeyInfo(HSM hSM, UcapiKeyHandle ucapiKeyHandle) throws ParseException, CryptoServerException {
        AsnBuffer asnBuffer = new AsnBuffer();
        short[] sArray = new short[]{UcapiWrapperGlobal.PropertyID.KEY_ALGO.value, UcapiWrapperGlobal.PropertyID.KEY_RSA_EXP.value, UcapiWrapperGlobal.PropertyID.KEY_RSA_MOD.value, UcapiWrapperGlobal.PropertyID.KEY_DSA_P.value, UcapiWrapperGlobal.PropertyID.KEY_DSA_G.value, UcapiWrapperGlobal.PropertyID.KEY_DSA_Q.value, UcapiWrapperGlobal.PropertyID.KEY_DSA_PUBKEY.value, UcapiWrapperGlobal.PropertyID.KEY_EC_CURVE.value, UcapiWrapperGlobal.PropertyID.KEY_EC_PUBKEY.value};
        UcapiKeyProperties ucapiKeyProperties = hSM.getKeyProperties(ucapiKeyHandle, sArray);
        UcapiWrapperGlobal.Algorithm algorithm = ucapiKeyProperties.get_algorithm().value();
        if (algorithm.value == UcapiWrapperGlobal.Algorithm.RSA.value) {
            AsnBuffer asnBuffer2 = new AsnBuffer();
            asnBuffer2.addItem(6, OID_RSA_ENCRYPTION);
            asnBuffer2.addItem(5, new byte[0]);
            asnBuffer.addSEQ(asnBuffer2);
        } else if (algorithm.value == UcapiWrapperGlobal.Algorithm.DSA.value || algorithm.value == UcapiWrapperGlobal.Algorithm.DH.value || algorithm.value == UcapiWrapperGlobal.Algorithm.DH_PKCS.value) {
            AsnBuffer asnBuffer3 = new AsnBuffer();
            asnBuffer3.addItem(6, OID_DSA);
            UcapiVectorU8 ucapiVectorU8 = ucapiKeyProperties.get_dsa_prime_p().value();
            UcapiVectorU8 ucapiVectorU82 = ucapiKeyProperties.get_dsa_prime_q().value();
            UcapiVectorU8 ucapiVectorU83 = ucapiKeyProperties.get_dsa_generator().value();
            byte[] byArray = ToolBox.ucapiVecU8ToByteArray(ucapiVectorU8);
            byte[] byArray2 = ToolBox.ucapiVecU8ToByteArray(ucapiVectorU82);
            byte[] byArray3 = ToolBox.ucapiVecU8ToByteArray(ucapiVectorU83);
            if (byArray == null || byArray3 == null || byArray2 == null) {
                throw new CryptoServerException(-1182728192, "missing DSA domain parameter");
            }
            AsnBuffer asnBuffer4 = new AsnBuffer();
            if ((byArray[0] & 0x80) != 0) {
                byArray = ToolBox.concat(new byte[]{0}, byArray);
            }
            asnBuffer4.addItem(2, byArray);
            if (byArray2 != null) {
                if ((byArray2[0] & 0x80) != 0) {
                    byArray2 = ToolBox.concat(new byte[]{0}, byArray2);
                }
                asnBuffer4.addItem(2, byArray2);
            }
            if ((byArray3[0] & 0x80) != 0) {
                byArray3 = ToolBox.concat(new byte[]{0}, byArray3);
            }
            asnBuffer4.addItem(2, byArray3);
            asnBuffer3.addSEQ(asnBuffer4);
            asnBuffer.addSEQ(asnBuffer3);
        } else if (algorithm.value == UcapiWrapperGlobal.Algorithm.EC_Edwards.value || algorithm.value == UcapiWrapperGlobal.Algorithm.EC.value || algorithm.value == UcapiWrapperGlobal.Algorithm.ECDH.value) {
            byte[] byArray = null;
            UcapiVectorU8 ucapiVectorU8 = ucapiKeyProperties.get_ec_curve_oid().value();
            byArray = ToolBox.ucapiVecU8ToByteArray(ucapiVectorU8);
            String string = null;
            try {
                string = new String(byArray, "UTF-8");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            byte[] byArray4 = null;
            for (ECCurve eCCurve : curves) {
                if (!eCCurve.name.equals(string)) continue;
                byArray4 = eCCurve.oid;
                break;
            }
            if (byArray4 == null) {
                throw new CryptoServerException(-1182728192, "unsupported EC parameter: " + string);
            }
            AsnBuffer asnBuffer5 = new AsnBuffer();
            if (algorithm.value != UcapiWrapperGlobal.Algorithm.EC_Edwards.value) {
                asnBuffer5.addItem(6, OID_EC_PUBLICKEY);
            }
            asnBuffer5.addItem(6, byArray4);
            asnBuffer.addSEQ(asnBuffer5);
        }
        asnBuffer.addItem(3, CertBuilder.encodePublicKey(ucapiKeyProperties, algorithm));
        return asnBuffer;
    }

    private static byte[] encodePublicKey(UcapiKeyProperties ucapiKeyProperties, UcapiWrapperGlobal.Algorithm algorithm) throws ParseException, CryptoServerException {
        if (algorithm.value == UcapiWrapperGlobal.Algorithm.RSA.value) {
            UcapiVectorU8 ucapiVectorU8 = ucapiKeyProperties.get_rsa_modulus().value();
            UcapiVectorU8 ucapiVectorU82 = ucapiKeyProperties.get_rsa_exponent().value();
            byte[] byArray = ToolBox.ucapiVecU8ToByteArray(ucapiVectorU8);
            byte[] byArray2 = ToolBox.ucapiVecU8ToByteArray(ucapiVectorU82);
            if (byArray == null || byArray2 == null) {
                throw new CryptoServerException(-1182728192, "missing RSA public key components");
            }
            AsnBuffer asnBuffer = new AsnBuffer();
            asnBuffer.addItem(2, ToolBox.concat(new byte[]{0}, byArray));
            if ((byArray2[0] & 0x80) != 0) {
                byArray2 = ToolBox.concat(new byte[]{0}, byArray2);
            }
            asnBuffer.addItem(2, byArray2);
            AsnBuffer asnBuffer2 = new AsnBuffer();
            asnBuffer2.addSEQ(asnBuffer);
            return ToolBox.concat(new byte[]{0}, asnBuffer2.getData());
        }
        if (algorithm.value == UcapiWrapperGlobal.Algorithm.DSA.value || algorithm.value == UcapiWrapperGlobal.Algorithm.DH.value || algorithm.value == UcapiWrapperGlobal.Algorithm.DH_PKCS.value) {
            UcapiVectorU8 ucapiVectorU8 = ucapiKeyProperties.get_dsa_public_key().value();
            byte[] byArray = ToolBox.ucapiVecU8ToByteArray(ucapiVectorU8);
            if (byArray == null) {
                throw new CryptoServerException(-1182728192, "missing DSA public key");
            }
            AsnBuffer asnBuffer = new AsnBuffer();
            if ((byArray[0] & 0x80) != 0) {
                byArray = ToolBox.concat(new byte[]{0}, byArray);
            }
            asnBuffer.addItem(2, byArray);
            return ToolBox.concat(new byte[]{0}, asnBuffer.getData());
        }
        if (algorithm.value == UcapiWrapperGlobal.Algorithm.EC.value || algorithm.value == UcapiWrapperGlobal.Algorithm.ECDSA.value || algorithm.value == UcapiWrapperGlobal.Algorithm.ECDH.value || algorithm.value == UcapiWrapperGlobal.Algorithm.EC_Edwards.value) {
            UcapiVectorU8 ucapiVectorU8 = ucapiKeyProperties.get_ec_public_key().value();
            byte[] byArray = ToolBox.ucapiVecU8ToByteArray(ucapiVectorU8);
            if (byArray == null) {
                throw new CryptoServerException(-1182728192, "missing EC public key");
            }
            return ToolBox.concat(new byte[]{0}, byArray);
        }
        Log.log(LogLevel.Error, "invalid algorithm");
        return null;
    }

    private static AsnBuffer getCertificateVersionV3() throws ParseException {
        byte[] byArray = new byte[]{2};
        AsnBuffer asnBuffer = new AsnBuffer();
        asnBuffer.addINT(2, byArray);
        return asnBuffer;
    }

    private static AsnBuffer getAlgorithm(byte[] byArray) throws ParseException {
        AsnBuffer asnBuffer = new AsnBuffer();
        asnBuffer.addItem(6, byArray);
        asnBuffer.addItem(5, new byte[0]);
        return asnBuffer;
    }

    private static AsnBuffer getCommonName(String string) throws ParseException, UnsupportedEncodingException {
        AsnBuffer asnBuffer = new AsnBuffer();
        AsnBuffer asnBuffer2 = new AsnBuffer();
        AsnBuffer asnBuffer3 = new AsnBuffer();
        asnBuffer3.addItem(6, new byte[]{85, 4, 3});
        asnBuffer3.addItem(12, string.getBytes("UTF-8"));
        asnBuffer2.addSEQ(asnBuffer3);
        asnBuffer.addSET(asnBuffer2);
        return asnBuffer;
    }

    private static AsnBuffer getValidity(int n) throws ParseException, UnsupportedEncodingException {
        AsnBuffer asnBuffer = new AsnBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date date = calendar.getTime();
        calendar.add(1, n);
        Date date2 = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String string = simpleDateFormat.format(date) + "Z";
        String string2 = simpleDateFormat.format(date2) + "Z";
        asnBuffer.addItem(24, string.getBytes());
        asnBuffer.addItem(24, string2.getBytes());
        return asnBuffer;
    }

    public static byte[] generateSelfSignedCertificate(HSM hSM, String string, CryptoServerPublicKey cryptoServerPublicKey, CryptoServerPrivateKey cryptoServerPrivateKey) throws ParseException, UnsupportedEncodingException, CryptoServerException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, InvalidKeySpecException {
        AsnBuffer asnBuffer = new AsnBuffer();
        asnBuffer.addItem(160, CertBuilder.getCertificateVersionV3().getData());
        BigInteger bigInteger = new BigInteger(Long.toString(new SecureRandom().nextLong()));
        asnBuffer.addINT(2, bigInteger.toByteArray());
        if ("RSA".equals(cryptoServerPrivateKey.getAlgorithm())) {
            asnBuffer.addSEQ(CertBuilder.getAlgorithm(OID_RSA_SHA1));
        } else if ("DSA".equals(cryptoServerPrivateKey.getAlgorithm())) {
            asnBuffer.addSEQ(CertBuilder.getAlgorithm(OID_DSA_SHA1));
        } else if ("EC".equals(cryptoServerPrivateKey.getAlgorithm())) {
            asnBuffer.addSEQ(CertBuilder.getAlgorithm(OID_ECDSA_WITH_SHA1));
        } else {
            throw new InvalidKeyException("Invalid key algorithm: " + cryptoServerPrivateKey.getAlgorithm());
        }
        asnBuffer.addSEQ(CertBuilder.getCommonName(string));
        asnBuffer.addSEQ(CertBuilder.getValidity(50));
        asnBuffer.addSEQ(CertBuilder.getCommonName(string));
        AsnBuffer asnBuffer2 = CertBuilder.getPublicKeyInfo(hSM, cryptoServerPublicKey.getKeyHandle());
        asnBuffer.addSEQ(asnBuffer2);
        AsnBuffer asnBuffer3 = new AsnBuffer();
        asnBuffer3.addSEQ(asnBuffer);
        byte[] byArray = CertBuilder.hashAndSignTBS(hSM, cryptoServerPrivateKey, asnBuffer3.getData());
        AsnBuffer asnBuffer4 = new AsnBuffer(asnBuffer3.getData());
        if ("RSA".equals(cryptoServerPrivateKey.getAlgorithm())) {
            asnBuffer4.addSEQ(CertBuilder.getAlgorithm(OID_RSA_SHA1));
        } else if ("DSA".equals(cryptoServerPrivateKey.getAlgorithm())) {
            asnBuffer4.addSEQ(CertBuilder.getAlgorithm(OID_DSA_SHA1));
        } else if ("EC".equals(cryptoServerPrivateKey.getAlgorithm())) {
            asnBuffer4.addSEQ(CertBuilder.getAlgorithm(OID_ECDSA_WITH_SHA1));
        }
        asnBuffer4.addItem(3, ToolBox.concat(new byte[]{0}, byArray));
        AsnBuffer asnBuffer5 = new AsnBuffer();
        asnBuffer5.addSEQ(asnBuffer4);
        return asnBuffer5.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hashAndSignTBS(HSM hSM, CryptoServerPrivateKey cryptoServerPrivateKey, byte[] byArray) throws InvalidKeyException {
        Pointer pointer = null;
        Pointer pointer2 = null;
        Pointer pointer3 = null;
        byte[] byArray2 = null;
        try {
            pointer = UcapiWrapperGlobal.hash_data(UcapiWrapperGlobal.HashAlgo.SHA1, byArray, (long)byArray.length);
            pointer2 = new UcapiSignInfo();
            ((UcapiSignInfo)pointer2).hash_mode(UcapiWrapperGlobal.HashMode.HASH);
            ((UcapiSignInfo)pointer2).hash_algo(UcapiWrapperGlobal.HashAlgo.SHA1);
            ((UcapiSignInfo)pointer2).chaining().set_none();
            if ("RSA".equals(cryptoServerPrivateKey.getAlgorithm())) {
                ((UcapiSignInfo)pointer2).format(UcapiWrapperGlobal.Format.NONE);
                ((UcapiSignInfo)pointer2).padding().set_pkcs1();
            } else if ("DSA".equals(cryptoServerPrivateKey.getAlgorithm()) || "EC".equals(cryptoServerPrivateKey.getAlgorithm())) {
                ((UcapiSignInfo)pointer2).format(UcapiWrapperGlobal.Format.ASN1);
                ((UcapiSignInfo)pointer2).padding().set_none();
            } else {
                throw new InvalidKeyException("Invalid key algorithm: " + cryptoServerPrivateKey.getAlgorithm());
            }
            byte[] byArray3 = ToolBox.ucapiVecU8ToByteArray((UcapiVectorU8)pointer);
            pointer3 = UcapiWrapperGlobal.sign(hSM.getSession(), hSM.isEphemeralStored(cryptoServerPrivateKey.getKeyHandle()) ? hSM.getKeyStorage() : hSM.getKeyStorageExternalPermanent(), (UcapiSignInfo)pointer2, cryptoServerPrivateKey.getKeyHandle(), byArray3, (long)byArray3.length);
            byArray2 = ToolBox.ucapiVecU8ToByteArray((UcapiVectorU8)pointer3);
        }
        finally {
            if (pointer != null) {
                pointer.close();
            }
            if (pointer2 != null) {
                pointer2.close();
            }
            if (pointer3 != null) {
                pointer3.close();
            }
        }
        return byArray2;
    }

    static class ECCurve {
        public String name;
        public byte[] oid;

        public ECCurve(String string, byte[] byArray) {
            this.name = string;
            this.oid = byArray;
        }
    }
}

