/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerAPI;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Properties;

public class CryptoServerUtil {
    private static final String ERR_FILE = "/errlist.txt";
    private static final String MAP_FILE = "/res/csa_native_arch.map";
    private static final String[] CFG = new String[]{"-rel", "-dbg", ""};

    public static void store_int2(int n, byte[] byArray, int n2) {
        byArray[n2 + 1] = (byte)n;
        byArray[n2] = (byte)(n >>>= 8);
    }

    public static void store_int3(int n, byte[] byArray, int n2) {
        byArray[n2 + 2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >>>= 8);
        byArray[n2] = (byte)(n >>>= 8);
    }

    public static void store_int4(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = (byte)n;
        byArray[n2 + 2] = (byte)(n >>>= 8);
        byArray[n2 + 1] = (byte)(n >>>= 8);
        byArray[n2] = (byte)(n >>>= 8);
    }

    public static int load_int2(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public static int load_int3(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF;
    }

    public static int load_int4(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static String toHexString(int n, int n2, char c) {
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c);
        for (int i = n2 - 1; i >= 0; --i) {
            cArray[i] = Character.forDigit(n & 0xF, 16);
            if ((n >>>= 4) == 0) break;
        }
        return new String(cArray);
    }

    public static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] copyOf(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static byte[] lstrip(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = byArray.length;
        while (n3 > 0 && byArray[n2] == (byte)n) {
            --n3;
            ++n2;
        }
        return CryptoServerUtil.copyOf(byArray, n2, n3);
    }

    public static void xtrace(PrintStream printStream, String string, byte[] byArray) {
        printStream.println(string + ":");
        CryptoServerUtil.xtrace(printStream, byArray);
    }

    public static void xtrace(PrintStream printStream, byte[] byArray) {
        for (int i = 0; i < byArray.length; i += 16) {
            int n;
            printStream.print(CryptoServerUtil.toHexString(i, 6, ' '));
            printStream.print("  ");
            for (n = 0; n < 16; ++n) {
                if ((n & 3) == 0) {
                    printStream.print(' ');
                }
                if ((n & 7) == 0) {
                    printStream.print(' ');
                }
                if (i + n < byArray.length) {
                    printStream.print(CryptoServerUtil.toHexString(byArray[i + n] & 0xFF, 2, '0'));
                    continue;
                }
                printStream.print("  ");
            }
            printStream.print("  |");
            for (n = 0; n < 16; ++n) {
                if (i + n < byArray.length) {
                    byte by = byArray[i + n];
                    if (by <= 32 || by >= 127) {
                        printStream.print(' ');
                        continue;
                    }
                    printStream.print((char)by);
                    continue;
                }
                printStream.print(' ');
            }
            printStream.println('|');
        }
    }

    public static void xtrace(String string, byte[] byArray) {
        CryptoServerUtil.xtrace(System.out, string, byArray);
    }

    public static void xtrace(byte[] byArray) {
        CryptoServerUtil.xtrace(System.out, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadLibrary(String string) throws IOException {
        Object object;
        File[] fileArray;
        Object object2;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        File file = null;
        String string2 = null;
        try {
            int n;
            inputStream = this.getClass().getResourceAsStream(MAP_FILE);
            if (inputStream == null) {
                throw new FileNotFoundException("jar:/res/csa_native_arch.map");
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            inputStream = null;
            object2 = System.getProperty("os.name");
            fileArray = System.getProperty("os.arch");
            String string3 = (String)object2 + "." + (String)fileArray;
            String string4 = properties.getProperty(string3);
            if (string4 == null && ((String)object2).startsWith("Windows")) {
                string4 = properties.getProperty("Windows." + (String)fileArray);
            }
            if (string4 == null) {
                throw new IOException("Native Library Mapping Property not found: " + string3);
            }
            for (int i = 0; inputStream == null && i < CFG.length; ++i) {
                string2 = "/" + string4 + CFG[i] + "/" + System.mapLibraryName(string);
                if (string2.endsWith(".a") && ((String)object2).equals("AIX")) {
                    string2 = string2.replaceFirst(".a$", ".so");
                }
                inputStream = this.getClass().getResourceAsStream(string2);
            }
            if (inputStream == null) {
                throw new FileNotFoundException("jar:/" + string4 + "-<cfg>/" + System.mapLibraryName(string));
            }
            object = System.getenv("XDG_RUNTIME_DIR");
            file = object != null ? File.createTempFile(string, string2.substring(string2.lastIndexOf(46)), new File((String)object)) : File.createTempFile(string, string2.substring(string2.lastIndexOf(46)));
            outputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.close();
            outputStream = null;
            inputStream.close();
            System.load(file.getPath());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (file != null && !file.delete() && (object2 = file.getParentFile()) != null) {
                object = new Filter(string, string2.substring(string2.lastIndexOf(46)));
                fileArray = ((File)object2).listFiles((FilenameFilter)object);
                for (int i = 0; i < fileArray.length && i < 3; ++i) {
                    fileArray[i].delete();
                }
            }
        }
    }

    void getErrorList(Properties properties, String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string == null ? ERR_FILE : string);
        if (inputStream != null) {
            properties.load(inputStream);
            inputStream.close();
        }
    }

    class Filter
    implements FilenameFilter {
        String start;
        String end;

        public Filter(String string, String string2) {
            this.start = string;
            this.end = string2;
        }

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith(this.start) && string.endsWith(this.end);
        }
    }
}

