/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerSecretKey;
import CryptoServerJCE.Log;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoServerSecretKeyFactory
extends SecretKeyFactorySpi {
    private final CryptoServerProvider provider;
    private final int algo;

    CryptoServerSecretKeyFactory(Provider provider, String string, int n) throws NoSuchAlgorithmException {
        Log.log("T: enter...");
        this.provider = (CryptoServerProvider)provider;
        this.algo = n;
        switch (n) {
            case 20: 
            case 21: {
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        Log.log("T: enter...");
        CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
        try {
            keyAttributes.setGenerationDate(new Date());
            keyAttributes.setExport(this.provider.export);
            keyAttributes.setUsage(this.provider.usage);
            switch (this.algo) {
                case 20: {
                    keyAttributes.setAlgo(1);
                    if (keySpec instanceof SecretKeySpec) {
                        SecretKeySpec secretKeySpec = (SecretKeySpec)keySpec;
                        keyAttributes.setSize(secretKeySpec.getEncoded().length * 7);
                        CryptoServerCXI.Key key = this.provider.cs.importClearKey(3, 65536, keyAttributes, new CryptoServerCXI.KeyComponents(secretKeySpec.getEncoded()));
                        return new CryptoServerSecretKey(this.provider, "DES", key);
                    }
                    if (keySpec instanceof DESKeySpec) {
                        DESKeySpec dESKeySpec = (DESKeySpec)keySpec;
                        keyAttributes.setSize(dESKeySpec.getKey().length * 7);
                        CryptoServerCXI.Key key = this.provider.cs.importClearKey(3, 65536, keyAttributes, new CryptoServerCXI.KeyComponents(dESKeySpec.getKey()));
                        return new CryptoServerSecretKey(this.provider, "DES", key);
                    }
                    if (keySpec instanceof DESedeKeySpec) {
                        DESedeKeySpec dESedeKeySpec = (DESedeKeySpec)keySpec;
                        keyAttributes.setSize(dESedeKeySpec.getKey().length * 7);
                        CryptoServerCXI.Key key = this.provider.cs.importClearKey(3, 65536, keyAttributes, new CryptoServerCXI.KeyComponents(dESedeKeySpec.getKey()));
                        return new CryptoServerSecretKey(this.provider, "DES", key);
                    }
                    throw new InvalidKeySpecException("Invalid key class");
                }
                case 21: {
                    keyAttributes.setAlgo(2);
                    if (keySpec instanceof SecretKeySpec) {
                        SecretKeySpec secretKeySpec = (SecretKeySpec)keySpec;
                        keyAttributes.setSize(secretKeySpec.getEncoded().length * 8);
                        CryptoServerCXI.Key key = this.provider.cs.importClearKey(3, 65536, keyAttributes, new CryptoServerCXI.KeyComponents(secretKeySpec.getEncoded()));
                        return new CryptoServerSecretKey(this.provider, "AES", key);
                    }
                    throw new InvalidKeySpecException("Invalid key class");
                }
            }
            throw new InvalidKeySpecException();
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException(exception.toString());
            invalidKeySpecException.initCause(exception);
            throw invalidKeySpecException;
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        Log.log("T: enter...");
        throw new InvalidKeyException();
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        Log.log("T: enter...");
        if (!(secretKey instanceof CryptoServerSecretKey)) {
            throw new InvalidKeySpecException("Invalid key object");
        }
        try {
            CryptoServerSecretKey cryptoServerSecretKey = (CryptoServerSecretKey)secretKey;
            if (clazz.getName().equals("javax.crypto.spec.SecretKeySpec")) {
                CryptoServerCXI.KeyAttAndComp keyAttAndComp = this.provider.cs.exportClearKey(cryptoServerSecretKey.key, 8);
                return new SecretKeySpec(keyAttAndComp.keyComponents.getList(), cryptoServerSecretKey.getAlgorithm());
            }
            if (clazz.getName().equals("javax.crypto.spec.DESKeySpec")) {
                CryptoServerCXI.KeyAttAndComp keyAttAndComp = this.provider.cs.exportClearKey(cryptoServerSecretKey.key, 8);
                return new DESKeySpec(keyAttAndComp.keyComponents.getList());
            }
            if (clazz.getName().equals("javax.crypto.spec.DESedeKeySpec")) {
                CryptoServerCXI.KeyAttAndComp keyAttAndComp = this.provider.cs.exportClearKey(cryptoServerSecretKey.key, 8);
                byte[] byArray = keyAttAndComp.keyComponents.getList();
                switch (byArray.length) {
                    case 16: {
                        byte[] byArray2 = new byte[24];
                        System.arraycopy(byArray, 0, byArray2, 0, 16);
                        System.arraycopy(byArray, 0, byArray2, 16, 8);
                        return new DESedeKeySpec(byArray2);
                    }
                    case 24: {
                        return new DESedeKeySpec(byArray);
                    }
                }
            }
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException(exception.toString());
            invalidKeySpecException.initCause(exception);
            throw invalidKeySpecException;
        }
        throw new InvalidKeySpecException();
    }
}

