/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.ByteFifo;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerSecretKey;
import CryptoServerJCE.Log;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoServerMac
extends MacSpi {
    private final CryptoServerProvider provider;
    private final String algorithm;
    private int algo;
    private int blockSize;
    private int mech;
    private int padding;
    private CryptoServerCXI.Key key;
    private CryptoServerCXI.ByteArray iv;
    private byte[] iv_init;
    private CryptoServerCXI.ByteArray last_res;
    private ByteFifo buff;
    private boolean err;
    private final int PAD_NONE = 0;
    private final int PAD_PKCS5 = 1;

    CryptoServerMac(Provider provider, String string, int n) throws NoSuchAlgorithmException {
        Log.log("T: enter...");
        this.provider = (CryptoServerProvider)provider;
        this.algorithm = string;
        this.algo = n;
        this.err = false;
        this.padding = 0;
        this.mech = 0;
        if (string.equals("DES") || string.equals("AES")) {
            this.padding = 0;
            this.mech = 0x100000;
        } else if (string.equals("DESwithPKCS5Padding") || string.equals("AESwithPKCS5Padding")) {
            this.padding = 1;
            this.mech = 0x100000;
        } else if (string.startsWith("Hmac")) {
            this.mech = 0x1000000 | CryptoServerMac.selectHashAlgoCXI(string);
        } else {
            throw new NoSuchAlgorithmException();
        }
    }

    @Override
    protected int engineGetMacLength() {
        Log.log("T: enter...");
        return this.blockSize;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        Log.log("T: enter...");
        this.buff = new ByteFifo();
        this.iv = null;
        this.iv_init = null;
        this.last_res = null;
        this.err = false;
        switch (this.algo) {
            case 20: {
                if (!key.getAlgorithm().startsWith("DES")) {
                    throw new InvalidKeyException();
                }
                this.blockSize = 8;
                break;
            }
            case 21: {
                if (!key.getAlgorithm().startsWith("AES")) {
                    throw new InvalidKeyException();
                }
                this.blockSize = 16;
                break;
            }
            case 0: {
                if (key.getAlgorithm().startsWith("DES")) {
                    this.algo = 20;
                    this.blockSize = 8;
                    break;
                }
                if (!key.getAlgorithm().startsWith("AES")) break;
                this.algo = 21;
                this.blockSize = 16;
                break;
            }
            default: {
                throw new InvalidKeyException();
            }
        }
        if (key instanceof CryptoServerSecretKey) {
            object = (CryptoServerSecretKey)key;
            this.key = ((CryptoServerSecretKey)object).key;
        } else if (key instanceof SecretKeySpec) {
            object = (SecretKeySpec)key;
            CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
            keyAttributes.setExport(this.provider.export);
            keyAttributes.setUsage(this.provider.usage);
            switch (this.algo) {
                case 20: {
                    keyAttributes.setAlgo(1);
                    keyAttributes.setSize(((SecretKeySpec)object).getEncoded().length * 7);
                    break;
                }
                case 21: {
                    keyAttributes.setAlgo(2);
                    keyAttributes.setSize(((SecretKeySpec)object).getEncoded().length * 8);
                }
            }
            try {
                this.key = this.provider.cs.importClearKey(3, 65536, keyAttributes, new CryptoServerCXI.KeyComponents(((SecretKeySpec)object).getEncoded()));
            }
            catch (Exception exception) {
                Log.log("E: " + exception.getMessage());
                InvalidKeyException invalidKeyException = new InvalidKeyException(exception.toString());
                invalidKeyException.initCause(exception);
                throw invalidKeyException;
            }
        } else {
            throw new InvalidKeyException("Invalid key class: " + key.toString());
        }
        if (this.algorithm.startsWith("Hmac") && algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("HMAC does not use parameters");
        }
        if (algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                object = (IvParameterSpec)algorithmParameterSpec;
                this.iv_init = ((IvParameterSpec)object).getIV();
                if (this.iv_init.length != this.blockSize) {
                    throw new InvalidAlgorithmParameterException("Invalid IV length");
                }
                this.iv = new CryptoServerCXI.ByteArray(this.iv_init);
            } else {
                throw new InvalidAlgorithmParameterException("Invalid parameter class: " + algorithmParameterSpec.toString());
            }
        }
    }

    @Override
    protected void engineReset() {
        Log.log("T: enter...");
        this.buff = new ByteFifo();
        if (this.iv != null) {
            this.iv.setBytes(this.iv_init);
        }
        this.last_res = null;
        this.err = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        Log.log("T: enter...");
        int n7 = n6 = this.algorithm.startsWith("Hmac") ? 32 : 0;
        if (this.err) {
            return;
        }
        if (this.last_res == null) {
            this.last_res = this.iv;
        }
        if (n2 != 0) {
            this.buff.put(byArray, n, n2);
        }
        if ((n5 = (n4 = this.buff.getSize()) - (n3 = n4 % this.blockSize)) < 1000) {
            return;
        }
        byte[] byArray2 = this.buff.get(n5);
        try {
            this.last_res = new CryptoServerCXI.ByteArray(this.provider.cs.sign(n6, this.key, this.mech | 0, null, byArray2, this.last_res));
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            this.err = true;
            exception.printStackTrace();
        }
    }

    @Override
    protected void engineUpdate(byte by) {
        Log.log("T: enter...");
        if (this.err) {
            return;
        }
        this.buff.expand(this.blockSize);
        this.buff.fill(by, 1);
        if (this.buff.getSize() > 1000) {
            this.engineUpdate(null, 0, 0);
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        byte[] byArray;
        Log.log("T: enter...");
        if (this.err) {
            return null;
        }
        int n = this.buff.getSize();
        if (n == 0 && !this.algorithm.startsWith("Hmac")) {
            byArray = this.last_res.getBytes();
        } else {
            if (!this.algorithm.startsWith("Hmac")) {
                switch (this.padding) {
                    case 0: {
                        if (n % this.blockSize == 0) break;
                        return null;
                    }
                    case 1: {
                        if (n % this.blockSize == 0) break;
                        int n2 = this.blockSize - n % this.blockSize;
                        this.buff.expand(n2);
                        this.buff.fill((byte)n2, n2);
                        n += n2;
                    }
                }
            }
            byte[] byArray2 = this.buff.get(n);
            try {
                byArray = this.provider.cs.sign(0, this.key, this.mech | 0, null, byArray2, this.last_res);
            }
            catch (Exception exception) {
                Log.log("E: " + exception.getMessage());
                this.err = true;
                exception.printStackTrace();
                return null;
            }
        }
        this.engineReset();
        return byArray;
    }

    private static int selectHashAlgoCXI(String string) throws NoSuchAlgorithmException {
        switch (string) {
            case "HmacMD5": {
                return 80;
            }
            case "HmacRMD160": {
                return 32;
            }
            case "HmacSHA1": {
                return 16;
            }
            case "HmacSHA224": {
                return 48;
            }
            case "HmacSHA3-224": {
                return 128;
            }
            case "HmacSHA256": {
                return 64;
            }
            case "HmacSHA3-256": {
                return 144;
            }
            case "HmacSHA384": {
                return 96;
            }
            case "HmacSHA3-384": {
                return 160;
            }
            case "HmacSHA512": {
                return 112;
            }
            case "HmacSHA3-512": {
                return 176;
            }
        }
        throw new NoSuchAlgorithmException();
    }
}

