/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.CryptoServerKey;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.Log;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;

public class CryptoServerKeyFactory
extends KeyFactorySpi {
    private final CryptoServerProvider provider;
    private final int algo;

    CryptoServerKeyFactory(Provider provider, String string, int n) throws NoSuchAlgorithmException {
        Log.log("T: enter...");
        this.provider = (CryptoServerProvider)provider;
        this.algo = n;
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("Invalid Algorithm: " + n);
            }
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        Log.log("T: enter...");
        CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
        try {
            keyAttributes.setGenerationDate(new Date());
            keyAttributes.setExport(this.provider.export);
            keyAttributes.setUsage(this.provider.usage);
            switch (this.algo) {
                case 1: {
                    if (!(keySpec instanceof RSAPublicKeySpec)) {
                        throw new InvalidKeySpecException();
                    }
                    RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                    keyAttributes.setAlgo(3);
                    keyAttributes.setExponent(rSAPublicKeySpec.getPublicExponent());
                    keyAttributes.setModulus(rSAPublicKeySpec.getModulus());
                    keyAttributes.setSize(rSAPublicKeySpec.getModulus().bitLength());
                    CryptoServerCXI.Key key = this.provider.cs.importClearKey(3, 65536, keyAttributes, null);
                    return new CryptoServerPublicKey(this.provider, "RSA", key);
                }
                case 2: {
                    if (!(keySpec instanceof DSAPublicKeySpec)) {
                        throw new InvalidKeySpecException();
                    }
                    DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
                    keyAttributes.setAlgo(5);
                    keyAttributes.setParamP(dSAPublicKeySpec.getP());
                    keyAttributes.setParamQ(dSAPublicKeySpec.getQ());
                    keyAttributes.setParamG(dSAPublicKeySpec.getG());
                    keyAttributes.setDSAPub(dSAPublicKeySpec.getY());
                    keyAttributes.setSize(dSAPublicKeySpec.getP().bitLength());
                    CryptoServerCXI.Key key = this.provider.cs.importClearKey(3, 65536, keyAttributes, null);
                    return new CryptoServerPublicKey(this.provider, "DSA", key);
                }
                case 3: {
                    if (!(keySpec instanceof ECPublicKeySpec)) {
                        throw new InvalidKeySpecException();
                    }
                    CryptoServerCXI.ECPublicKey eCPublicKey = new CryptoServerCXI.ECPublicKey((ECPublicKeySpec)keySpec);
                    keyAttributes.setAlgo(4);
                    keyAttributes.setCurve(eCPublicKey.getParams());
                    keyAttributes.setECPub(eCPublicKey.getEncoded());
                    keyAttributes.setSize(0);
                    CryptoServerCXI.Key key = this.provider.cs.importClearKey(3, 65536, keyAttributes, null);
                    return new CryptoServerPublicKey(this.provider, "EC", key);
                }
            }
            throw new InvalidKeySpecException();
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException(exception.toString());
            invalidKeySpecException.initCause(exception);
            throw invalidKeySpecException;
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        Log.log("T: enter...");
        CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
        CryptoServerCXI.KeyComponents keyComponents = new CryptoServerCXI.KeyComponents();
        try {
            keyAttributes.setGenerationDate(new Date());
            keyAttributes.setExport(this.provider.export);
            keyAttributes.setUsage(this.provider.usage);
            switch (this.algo) {
                case 1: {
                    keyAttributes.setAlgo(3);
                    if (keySpec instanceof RSAPrivateCrtKeySpec) {
                        RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                        keyAttributes.setExponent(rSAPrivateCrtKeySpec.getPublicExponent());
                        keyAttributes.setSize(rSAPrivateCrtKeySpec.getModulus().bitLength());
                        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_SEXP, rSAPrivateCrtKeySpec.getPrivateExponent());
                        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_P, rSAPrivateCrtKeySpec.getPrimeP());
                        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_Q, rSAPrivateCrtKeySpec.getPrimeQ());
                        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_DP, rSAPrivateCrtKeySpec.getPrimeExponentP());
                        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_DQ, rSAPrivateCrtKeySpec.getPrimeExponentQ());
                        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_U, rSAPrivateCrtKeySpec.getCrtCoefficient());
                        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_MOD, rSAPrivateCrtKeySpec.getModulus());
                        CryptoServerCXI.Key key = this.provider.cs.importClearKey(3, 65536, keyAttributes, keyComponents);
                        return new CryptoServerPrivateKey(this.provider, "RSA", key);
                    }
                    if (keySpec instanceof RSAPrivateKeySpec) {
                        RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
                        keyAttributes.setSize(rSAPrivateKeySpec.getModulus().bitLength());
                        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_SEXP, rSAPrivateKeySpec.getPrivateExponent());
                        keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_MOD, rSAPrivateKeySpec.getModulus());
                        CryptoServerCXI.Key key = this.provider.cs.importClearKey(3, 65536, keyAttributes, keyComponents);
                        return new CryptoServerPrivateKey(this.provider, "RSA", key);
                    }
                    throw new InvalidKeySpecException();
                }
                case 2: {
                    if (!(keySpec instanceof DSAPrivateKeySpec)) {
                        throw new InvalidKeySpecException();
                    }
                    DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)keySpec;
                    keyAttributes.setAlgo(5);
                    keyAttributes.setParamP(dSAPrivateKeySpec.getP());
                    keyAttributes.setParamQ(dSAPrivateKeySpec.getQ());
                    keyAttributes.setParamG(dSAPrivateKeySpec.getG());
                    keyAttributes.setSize(dSAPrivateKeySpec.getP().bitLength());
                    keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_SK, dSAPrivateKeySpec.getX());
                    CryptoServerCXI.Key key = this.provider.cs.importClearKey(3, 65536, keyAttributes, keyComponents);
                    return new CryptoServerPrivateKey(this.provider, "DSA", key);
                }
                case 3: {
                    if (!(keySpec instanceof ECPrivateKeySpec)) {
                        throw new InvalidKeySpecException();
                    }
                    ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)keySpec;
                    keyAttributes.setAlgo(4);
                    keyAttributes.setCurve(eCPrivateKeySpec.getParams());
                    keyAttributes.setSize(0);
                    keyComponents.add(CryptoServerCXI.KeyComponents.TYPE_SK, eCPrivateKeySpec.getS());
                    CryptoServerCXI.Key key = this.provider.cs.importClearKey(3, 65536, keyAttributes, keyComponents);
                    return new CryptoServerPrivateKey(this.provider, "EC", key);
                }
            }
            throw new InvalidKeySpecException();
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException(exception.toString());
            invalidKeySpecException.initCause(exception);
            throw invalidKeySpecException;
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        Log.log("T: enter...");
        throw new InvalidKeyException();
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        Log.log("T: enter...");
        if (!(key instanceof CryptoServerKey)) {
            throw new InvalidKeySpecException("Invalid key object");
        }
        try {
            CryptoServerKey cryptoServerKey = (CryptoServerKey)key;
            if (clazz.getName().equals("java.security.spec.RSAPublicKeySpec")) {
                CryptoServerCXI.KeyAttAndComp keyAttAndComp = this.provider.cs.exportClearKey(cryptoServerKey.key, 1);
                CryptoServerCXI.KeyComponents keyComponents = keyAttAndComp.keyComponents;
                Constructor<T> constructor = clazz.getConstructor(BigInteger.class, BigInteger.class);
                Object[] objectArray = new Object[]{new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_MOD)), new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_PEXP))};
                return (T)((KeySpec)constructor.newInstance(objectArray));
            }
            if (clazz.getName().equals("java.security.spec.RSAPrivateCrtKeySpec")) {
                CryptoServerCXI.KeyAttAndComp keyAttAndComp = this.provider.cs.exportClearKey(cryptoServerKey.key, 3);
                CryptoServerCXI.KeyComponents keyComponents = keyAttAndComp.keyComponents;
                Constructor<T> constructor = clazz.getConstructor(BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class);
                Object[] objectArray = new Object[]{new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_MOD)), new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_PEXP)), new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_SEXP)), new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_P)), new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_Q)), new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_DP)), new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_DQ)), new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_U))};
                return (T)((KeySpec)constructor.newInstance(objectArray));
            }
            if (clazz.getName().equals("java.security.spec.RSAPrivateKeySpec")) {
                CryptoServerCXI.KeyAttAndComp keyAttAndComp = this.provider.cs.exportClearKey(cryptoServerKey.key, 3);
                CryptoServerCXI.KeyComponents keyComponents = keyAttAndComp.keyComponents;
                Constructor<T> constructor = clazz.getConstructor(BigInteger.class, BigInteger.class);
                Object[] objectArray = new Object[]{new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_MOD)), new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_SEXP))};
                return (T)((KeySpec)constructor.newInstance(objectArray));
            }
            if (clazz.getName().equals("java.security.spec.DSAPublicKeySpec")) {
                CryptoServerCXI.KeyAttAndComp keyAttAndComp = this.provider.cs.exportClearKey(cryptoServerKey.key, 1);
                CryptoServerCXI.KeyComponents keyComponents = keyAttAndComp.keyComponents;
                CryptoServerCXI.KeyAttributes keyAttributes = keyAttAndComp.keyAttributes;
                Constructor<T> constructor = clazz.getConstructor(BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class);
                Object[] objectArray = new Object[]{new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_PK)), new BigInteger(1, keyAttributes.getParamP()), new BigInteger(1, keyAttributes.getParamQ()), new BigInteger(1, keyAttributes.getParamG())};
                return (T)((KeySpec)constructor.newInstance(objectArray));
            }
            if (clazz.getName().equals("java.security.spec.DSAPrivateKeySpec")) {
                CryptoServerCXI.KeyAttAndComp keyAttAndComp = this.provider.cs.exportClearKey(cryptoServerKey.key, 3);
                CryptoServerCXI.KeyComponents keyComponents = keyAttAndComp.keyComponents;
                CryptoServerCXI.KeyAttributes keyAttributes = keyAttAndComp.keyAttributes;
                Constructor<T> constructor = clazz.getConstructor(BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class);
                Object[] objectArray = new Object[]{new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_SK)), new BigInteger(1, keyAttributes.getParamP()), new BigInteger(1, keyAttributes.getParamQ()), new BigInteger(1, keyAttributes.getParamG())};
                return (T)((KeySpec)constructor.newInstance(objectArray));
            }
            if (clazz.getName().equals("java.security.spec.ECPublicKeySpec")) {
                CryptoServerCXI.KeyAttAndComp keyAttAndComp = this.provider.cs.exportClearKey(cryptoServerKey.key, 1);
                CryptoServerCXI.KeyAttributes keyAttributes = keyAttAndComp.keyAttributes;
                CryptoServerCXI.KeyComponents keyComponents = keyAttAndComp.keyComponents;
                Constructor<T> constructor = clazz.getConstructor(ECPoint.class, ECParameterSpec.class);
                Object[] objectArray = new Object[2];
                byte[] byArray = keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_PK);
                int n = (byArray.length - 1) / 2;
                byte[] byArray2 = new byte[n];
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray, 1, byArray2, 0, n);
                System.arraycopy(byArray, 1 + n, byArray3, 0, n);
                byte[] byArray4 = keyAttributes.getCurveEncoded();
                CryptoServerCXI.ECParameter eCParameter = new CryptoServerCXI.ECParameter(byArray4);
                objectArray[0] = new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
                objectArray[1] = eCParameter.getSpec();
                return (T)((KeySpec)constructor.newInstance(objectArray));
            }
            if (clazz.getName().equals("java.security.spec.ECPrivateKeySpec")) {
                CryptoServerCXI.KeyAttAndComp keyAttAndComp = this.provider.cs.exportClearKey(cryptoServerKey.key, 3);
                CryptoServerCXI.KeyComponents keyComponents = keyAttAndComp.keyComponents;
                CryptoServerCXI.KeyAttributes keyAttributes = keyAttAndComp.keyAttributes;
                Constructor<T> constructor = clazz.getConstructor(BigInteger.class, ECParameterSpec.class);
                Object[] objectArray = new Object[]{new BigInteger(1, keyComponents.getItem(CryptoServerCXI.KeyComponents.TYPE_SK)), new CryptoServerCXI.ECParameter(keyAttributes.getCurveEncoded()).getSpec()};
                return (T)((KeySpec)constructor.newInstance(objectArray));
            }
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException(exception.toString());
            invalidKeySpecException.initCause(exception);
            throw invalidKeySpecException;
        }
        throw new InvalidKeySpecException();
    }
}

