/*
 * Decompiled with CFR 0.152.
 */
package fips140se;

import CryptoServerAPI.CryptoServerUtil;
import CryptoServerJCE.CryptoServerECKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerProvider;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;

public class sign_EC_FIPS140SE {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE - sign_EC_FIPS140SE ---\n");
        String[] stringArray2 = new String[]{"NIST-P192", "NIST-P224", "NIST-P256", "NIST-P384", "NIST-P521"};
        String[] stringArray3 = new String[]{"SHA1withECDSA", "SHA256withECDSA", "SHA384withECDSA", "SHA512withECDSA", "NONEwithECDSA"};
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = new CryptoServerProvider(stringArray.length > 0 ? stringArray[0] : "CryptoServer.cfg");
            System.out.println("Device  : " + cryptoServerProvider.getCryptoServer().getDevice());
            cryptoServerProvider.loginPassword("JCE", "12345678");
            CryptoServerProvider cryptoServerProvider2 = cryptoServerProvider;
            CryptoServerProvider cryptoServerProvider3 = cryptoServerProvider;
            for (String string : stringArray2) {
                System.out.println("curve: " + string);
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", cryptoServerProvider2);
                CryptoServerECKeyGenParameterSpec cryptoServerECKeyGenParameterSpec = new CryptoServerECKeyGenParameterSpec(string);
                keyPairGenerator.initialize(cryptoServerECKeyGenParameterSpec);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                PublicKey publicKey = keyPair.getPublic();
                try {
                    Object object = KeyFactory.getInstance("EC", cryptoServerProvider2);
                    ECPublicKeySpec eCPublicKeySpec = ((KeyFactory)object).getKeySpec(keyPair.getPublic(), ECPublicKeySpec.class);
                    object = KeyFactory.getInstance("EC", cryptoServerProvider3);
                    publicKey = ((KeyFactory)object).generatePublic(eCPublicKeySpec);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    invalidKeySpecException.printStackTrace();
                }
                for (String string2 : stringArray3) {
                    System.out.println("  algo: " + string2);
                    Signature signature = Signature.getInstance(string2, cryptoServerProvider2);
                    Signature signature2 = Signature.getInstance(string2, cryptoServerProvider3);
                    for (int i = 0; i < 33; i += 3) {
                        byte[] byArray = string2.indexOf("NONE") < 0 ? sign_EC_FIPS140SE.getRandom(i) : sign_EC_FIPS140SE.getRandom(10);
                        for (int j = 0; j < 22; j += 2) {
                            byte[] byArray2 = string2.indexOf("NONE") < 0 ? sign_EC_FIPS140SE.getRandom(j) : sign_EC_FIPS140SE.getRandom(10);
                            byte[] byArray3 = sign_EC_FIPS140SE.cat(byArray, byArray2);
                            signature.initSign(privateKey);
                            signature.update(byArray);
                            signature.update(byArray2);
                            byte[] byArray4 = signature.sign();
                            signature2.initVerify(publicKey);
                            signature2.update(byArray3);
                            if (signature2.verify(byArray4)) continue;
                            CryptoServerUtil.xtrace("data", byArray3);
                            CryptoServerUtil.xtrace("sign", byArray4);
                            throw new Exception("Signature Verification failed");
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.logoff();
            }
        }
        System.out.println("Done");
    }

    private static byte[] getRandom(int n) {
        try {
            byte[] byArray = new byte[n];
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            if (n > 0) {
                do {
                    secureRandom.nextBytes(byArray);
                } while (byArray[0] == 0);
            }
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] cat(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }
}

