/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerAPI.CryptoServerUtil;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.DumyCertificate;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import java.util.Enumeration;

public class cert_Import {
    private static final byte[] TestCertificate = new byte[]{48, -126, 3, 123, 48, -126, 2, 99, -96, 3, 2, 1, 2, 2, 1, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 55, 49, 22, 48, 20, 6, 3, 85, 4, 3, 19, 13, 79, 83, 83, 76, 32, 82, 83, 65, 32, 82, 111, 111, 116, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 68, 69, 49, 16, 48, 14, 6, 3, 85, 4, 10, 19, 7, 85, 116, 105, 109, 97, 99, 111, 48, 30, 23, 13, 48, 56, 48, 49, 49, 52, 48, 57, 53, 57, 49, 53, 90, 23, 13, 49, 56, 48, 49, 49, 49, 48, 57, 53, 57, 49, 53, 90, 48, 55, 49, 22, 48, 20, 6, 3, 85, 4, 3, 19, 13, 79, 83, 83, 76, 32, 82, 83, 65, 32, 82, 111, 111, 116, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 68, 69, 49, 16, 48, 14, 6, 3, 85, 4, 10, 19, 7, 85, 116, 105, 109, 97, 99, 111, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -45, -53, 88, 90, -78, 64, -11, -70, -42, 35, 56, -54, -119, 3, 10, 22, -101, 8, 14, 57, 56, 77, -77, -11, -125, 6, 110, -61, -14, -72, 112, 94, 80, -45, 66, 98, -31, 16, -112, -107, 18, -110, 22, -61, -103, 121, -101, 13, 89, -116, 73, -53, -67, -50, -125, -34, 84, 61, -63, -64, 38, -56, -69, 96, -73, -97, -50, -73, 16, -56, -103, -74, 68, -49, 18, 87, 28, 113, 62, 115, 91, 107, 42, -61, 72, 107, -72, -21, 91, 95, -121, -30, 19, 8, -120, -64, 1, 58, -105, -43, -22, 98, 70, -2, 77, 20, -106, -16, 1, -64, 71, -69, -12, -95, 98, 62, 78, 79, -61, 66, -58, 66, 103, 81, -113, 44, -3, 32, 25, -126, 82, -121, 43, -1, -31, -127, -68, -74, -16, -105, 84, 77, 73, 45, 51, -51, -3, 33, -65, -120, 1, -56, -128, -35, 115, 52, 119, 23, -27, -115, -60, -40, 27, -91, -26, 125, 39, 116, -90, 31, 110, 108, -109, -91, -54, -96, -42, -41, 97, 124, -41, -112, 92, -51, 75, 99, -120, 67, 104, -20, -79, 60, 119, 42, 70, -27, 22, 59, -1, 25, -58, 73, 101, 79, 32, 125, 103, -9, 72, 50, 116, 31, 82, -10, -20, -90, 111, 99, -21, 23, -84, 59, 79, -113, -56, -125, 104, 118, 15, -31, -87, -12, -84, 83, 59, 86, -38, -78, 28, 1, -38, -76, 84, -30, 125, -43, -33, -53, -19, -57, -24, -45, -42, -70, 68, 49, 2, 3, 1, 0, 1, -93, -127, -111, 48, -127, -114, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -52, 112, 16, -113, -9, 56, 62, -84, 9, 106, 95, -28, 15, -25, 5, 110, 6, 121, 54, 98, 48, 95, 6, 3, 85, 29, 35, 4, 88, 48, 86, -128, 20, -52, 112, 16, -113, -9, 56, 62, -84, 9, 106, 95, -28, 15, -25, 5, 110, 6, 121, 54, 98, -95, 59, -92, 57, 48, 55, 49, 22, 48, 20, 6, 3, 85, 4, 3, 19, 13, 79, 83, 83, 76, 32, 82, 83, 65, 32, 82, 111, 111, 116, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 68, 69, 49, 16, 48, 14, 6, 3, 85, 4, 10, 19, 7, 85, 116, 105, 109, 97, 99, 111, -126, 1, 1, 48, 12, 6, 3, 85, 29, 19, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 55, 51, -11, 46, 108, 91, 46, -65, -124, -48, -15, -16, -33, -9, 98, -10, -127, -120, 62, 34, -43, -103, -24, -117, 32, -108, -44, 118, -8, 44, 11, -74, -97, -84, 77, -106, 105, -101, -37, 39, 30, -88, -103, 104, 8, 30, 93, 50, 19, 99, -86, -121, -50, -95, -1, 76, -124, -63, 118, 114, -73, 9, 4, 55, 123, -69, -43, -12, 7, -80, -102, 120, -114, 55, -30, 100, -96, -23, -78, 120, -24, -13, 125, 3, 40, -53, -27, -81, -7, -56, -30, 8, -33, -44, 82, 87, -42, -96, 68, -93, 122, -90, 75, -103, 5, -64, 23, -95, -113, -11, -83, 73, 86, -124, 125, -34, 30, -101, -58, -77, 62, 102, -115, 3, 98, -102, 57, 54, 101, -59, -120, -99, -100, 83, 86, -9, 53, -114, 109, -102, -93, 13, -120, -77, 43, 98, -78, -18, 64, -63, 37, -40, -81, 30, 87, -126, 53, -80, 72, 99, 120, -74, 82, -34, 21, 48, -91, -90, 110, 35, 119, -91, -45, 9, -80, -11, 116, 95, -49, 100, 13, -8, 90, 118, 124, 89, 96, -92, -29, -67, -112, -79, -104, 13, 3, -19, -63, -65, 71, 38, 15, 127, 120, 63, 46, -112, -77, -24, 56, -52, -69, -16, -37, -74, -36, -44, -109, 62, -128, 90, 122, -53, 40, -7, -14, -85, 103, -104, 54, -35, -64, -23, 30, -99, 48, 0, 77, 6, -4, 101, -112, -8, -28, 62, -95, -128, 75, -42, 103, -70, 64, 13, -87, 39, -102, 80};

    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE: key_Certificate ---\n");
        String string = "RSA_prv_cert_1";
        String string2 = "RSA_pub_cert_1";
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = new CryptoServerProvider(stringArray.length > 0 ? stringArray[0] : "CryptoServer.cfg");
            System.out.println("Device  : " + cryptoServerProvider.getCryptoServer().getDevice());
            cryptoServerProvider.loginPassword("JCE", "12345678");
            KeyStore keyStore = KeyStore.getInstance("CryptoServer", cryptoServerProvider);
            keyStore.load(null, null);
            System.out.println("import certificate...");
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(TestCertificate));
            keyStore.setCertificateEntry(string2, x509Certificate);
            x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
            if (x509Certificate == null) {
                throw new Exception("certificate not found");
            }
            CryptoServerUtil.xtrace("cert", x509Certificate.getEncoded());
            System.out.println("get certificate chain...");
            Certificate[] certificateArray = keyStore.getCertificateChain(string2);
            if (certificateArray == null) {
                throw new Exception("certificate chain not found");
            }
            for (int i = 0; i < certificateArray.length; ++i) {
                CryptoServerUtil.xtrace("cert[" + i + "]", certificateArray[i].getEncoded());
            }
            System.out.println("import private RSA key...");
            PrivateKey privateKey = (PrivateKey)RSATestKey.getPrivateCRTKey(cryptoServerProvider);
            PublicKey publicKey = (PublicKey)RSATestKey.getPublicKey(cryptoServerProvider);
            Certificate[] certificateArray2 = new DumyCertificate[]{cryptoServerProvider.getDumyCertificate(publicKey)};
            keyStore.setKeyEntry(string, privateKey, null, certificateArray2);
            System.out.println("load private RSA key...");
            privateKey = (PrivateKey)keyStore.getKey(string, null);
            if (privateKey == null) {
                throw new Exception("key not found");
            }
            Enumeration<String> enumeration = keyStore.aliases();
            System.out.println(String.format("%-12s %-20s %s", "type", "name", "creation date"));
            System.out.println("----------------------------------------------------------------------");
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                Date date = keyStore.getCreationDate(string3);
                String string4 = keyStore.isKeyEntry(string3) ? "Key" : (keyStore.isCertificateEntry(string3) ? "Certificate" : "???");
                System.out.println(String.format("%-12s %-20s %s", string4, string3, date));
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.logoff();
            }
        }
        System.out.println("Done");
    }

    private static class RSATestKey {
        static final String modulus = "B7F3893AAB150BAFECC1931097893C38751AD728DD56DEB8F1A41097755B5E0664FF32FD902B04EDCFD5E2EF8330FDF07C15F9C2229E53F71446EEDBC82BEA3D1679B2BBC07B269D0832D098B3478189CB1FD9F770ED5231EE9AA05BEBE2D0F13F4813F919EB8B3B14AEEE0EE22EDEB152CB5B5798712CDE28273B7E5AB232EB";
        static final String pExponent = "010001";
        static final String sExponent = "0C69C84467C01B524B5942B9D76800E2D47033BDC3B5F580A879C84ED8320AB5C6C1FBE8657EA9ADFC9CF3DBF2CFEF0AF7ECA9B6828C89A0FE42CD2292AEF7F6FB0B8BC61EAE635CE3ACAADACBB0609666266D28B2760483F169C05E672C5C88D2B5B0F66C6474AA7E75A3D526EFBD865D4CD8457DD8F9D31C4B095827C6B3AD";
        static final String primeP = "D19916EC3E718F393467AD608813306B58F763EF6F1A8FE1251AAAE720D1A6F0E552F95DE53C0FECDFFE0ED9E541FC00F83393C9E1B26789D3A779ACA9A5C905";
        static final String primeQ = "E0ACED5548DFF0A24147FEDE87B22505DC11FBC4F080C3E17A11BA588AE2A40AFCFDF352F9031F8F344E909C2ECCD912E2BA6B864C2DE6CFB4F50E03C17F0F2F";
        static final String coeff = "9EC636117E558F3A1C9E03E54A1FADD9F0A6728F34C5842B6F557D58C92BCB243FDB62AA9751B5AA24B4B5129B253ED97D3A69818C7AD2AA6483C2473C1E52F7";
        static final String pExpP = "9D165DC5C5AF1AA6C70E05355A06F7BD1CBA9D5DB0297A3845B4CCEDD8FD085F77A04E60FF139AE3EFA4DBC0974072FCCF08E8F4DF80F474A9FAD50881454D79";
        static final String pExpQ = "7332D781EA1AC0A4413AAC08E7A4C4ECEB38E151CA4B0BA499D56B29A914AA2DE42845D1DE51E6A5A39940F683DC8ED4EB21D0AE0C7360AC5149710525FA830B";

        private RSATestKey() {
        }

        public static Key getPrivateCRTKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(new BigInteger(modulus, 16), new BigInteger(pExponent, 16), new BigInteger(sExponent, 16), new BigInteger(primeP, 16), new BigInteger(primeQ, 16), new BigInteger(pExpP, 16), new BigInteger(pExpQ, 16), new BigInteger(coeff, 16));
            return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
        }

        public static Key getPrivateKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger(modulus, 16), new BigInteger(sExponent, 16));
            return keyFactory.generatePrivate(rSAPrivateKeySpec);
        }

        public static Key getPublicKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(pExponent, 16));
            return keyFactory.generatePublic(rSAPublicKeySpec);
        }
    }
}

