/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerJCE.CryptoServerProvider;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Date;

public class bench_RSA {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE - bench_RSA ---\n");
        byte[] byArray = "+++ data to be signed +++".getBytes();
        int[] nArray = new int[]{1024, 2048, 4096};
        int n = 1000;
        String string = "RSA Bench";
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = new CryptoServerProvider(stringArray.length > 0 ? stringArray[0] : "CryptoServer.cfg");
            System.out.println("Device  : " + cryptoServerProvider.getCryptoServer().getDevice());
            cryptoServerProvider.loginPassword("JCE", "12345678");
            KeyStore keyStore = KeyStore.getInstance("CryptoServer", cryptoServerProvider);
            keyStore.load(null, null);
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                System.out.println("\nKey size: " + n2);
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", cryptoServerProvider);
                keyPairGenerator.initialize(n2, null);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                PublicKey publicKey = keyPair.getPublic();
                keyStore.setKeyEntry(string, privateKey, null, cryptoServerProvider.getDumyCertificateChain());
                privateKey = (PrivateKey)keyStore.getKey(string, null);
                Signature signature = Signature.getInstance("SHA1withRSA", cryptoServerProvider);
                signature.initSign(privateKey);
                byte[] byArray2 = null;
                Date date = new Date();
                for (int j = 0; j < n; ++j) {
                    signature.update(byArray);
                    byArray2 = signature.sign();
                }
                Date date2 = new Date();
                long l = date2.getTime() - date.getTime();
                System.out.println("  Duration: " + l + " ms");
                long l2 = (long)(n * 1000) / l;
                System.out.println("  Speed: " + l2 + " op/second");
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (signature.verify(byArray2)) continue;
                throw new Exception("Verification failed");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.logoff();
            }
        }
        System.out.println("Done");
    }
}

