/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.Log;
import java.security.Key;
import sun.security.util.Length;

public class CryptoServerKey
implements Key,
Length {
    final String algorithm;
    final String format = "CryptoServerKey";
    final CryptoServerProvider provider;
    final CryptoServerCXI.Key key;
    private int keyLength = 0;

    CryptoServerKey(CryptoServerProvider cryptoServerProvider, String string, CryptoServerCXI.Key key) {
        Log.log("T: enter...");
        this.provider = cryptoServerProvider;
        this.algorithm = string;
        this.key = key;
        try {
            this.keyLength = key.getAttributes().getSize();
        }
        catch (CryptoServerException cryptoServerException) {
            Log.log("E: " + cryptoServerException.getMessage());
            cryptoServerException.printStackTrace();
        }
        this.getKeyLength();
    }

    @Override
    public String getAlgorithm() {
        Log.log("T: enter...");
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        Log.log("T: enter...");
        return "CryptoServerKey";
    }

    @Override
    public byte[] getEncoded() {
        Log.log("T: enter...");
        return null;
    }

    @Override
    public int length() {
        return this.getKeyLength();
    }

    private int getKeyLength() {
        if (this.keyLength == 0) {
            try {
                CryptoServerCXI.KeyAttributes keyAttributes = this.provider.cs.getKeyAttributes(this.key, false);
                this.keyLength = keyAttributes.getSize();
            }
            catch (Exception exception) {
                Log.log("E: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return this.keyLength;
    }
}

