/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.ByteFifo;
import CryptoServerJCE.CryptoServerCCMParameterSpec;
import CryptoServerJCE.CryptoServerGCMParameterSpec;
import CryptoServerJCE.CryptoServerKey;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.CryptoServerSecretKey;
import CryptoServerJCE.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;

public class CryptoServerCipher
extends CipherSpi {
    private final CryptoServerProvider provider;
    private final int algo;
    private final int blockSize;
    private int mech_mode;
    private int mech_chain;
    private int mech_pad;
    private CryptoServerCXI.MechanismParameter mech_param;
    private byte[] aad;
    private boolean isFirstUpdate;
    private int tagLen;
    private int dataLen;
    private boolean isISO10126PAD;
    private CryptoServerCXI.Key key;
    private byte[] iv_init;
    private CryptoServerCXI.ByteArray iv;
    private CryptoServerCXI.ByteArray tag;
    private ByteFifo buff;
    private SecureRandom rng;
    private String kek_algo;

    CryptoServerCipher(Provider provider, String string, int n) throws NoSuchAlgorithmException {
        Log.log("T: enter...");
        this.provider = (CryptoServerProvider)provider;
        this.algo = n;
        this.mech_mode = 0;
        this.mech_chain = 0;
        this.mech_pad = 0;
        this.mech_param = null;
        this.aad = null;
        this.isFirstUpdate = true;
        this.iv = null;
        this.tag = null;
        this.isISO10126PAD = false;
        switch (n) {
            case 20: {
                this.blockSize = 8;
                break;
            }
            case 21: {
                this.blockSize = 16;
                break;
            }
            case 1: {
                this.blockSize = 0;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        Log.log("T: enter...");
        switch (this.algo) {
            case 20: 
            case 21: {
                if (string.equalsIgnoreCase("ECB")) {
                    this.mech_chain = 0;
                    return;
                }
                if (string.equalsIgnoreCase("CBC")) {
                    this.mech_chain = 0x100000;
                    return;
                }
                if (string.equalsIgnoreCase("GCM")) {
                    this.mech_chain = 0x600000;
                    return;
                }
                if (string.equalsIgnoreCase("CCM")) {
                    this.mech_chain = 0x800000;
                    return;
                }
                if (!string.equalsIgnoreCase("OFB") && !string.equalsIgnoreCase("OFB128")) break;
                this.mech_chain = 0x700000;
                return;
            }
            case 1: {
                if (!string.equals("ECB") && !string.equalsIgnoreCase("None")) break;
                this.mech_chain = 0;
                return;
            }
        }
        throw new NoSuchAlgorithmException();
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        Log.log("T: enter...");
        if (string.equalsIgnoreCase("NoPadding")) {
            this.mech_pad = 0;
            return;
        }
        switch (this.algo) {
            case 20: 
            case 21: {
                if (string.equalsIgnoreCase("PKCS5Padding")) {
                    this.mech_pad = 4096;
                    return;
                }
                if (!string.equalsIgnoreCase("ISO10126Padding")) break;
                this.isISO10126PAD = true;
                this.mech_pad = 0;
                return;
            }
            case 1: {
                if (string.equalsIgnoreCase("PKCS1Padding")) {
                    this.mech_pad = 16384;
                    return;
                }
                if (!string.equalsIgnoreCase("OAEPPadding")) break;
                this.mech_pad = 20480;
                return;
            }
        }
        throw new NoSuchPaddingException();
    }

    @Override
    protected int engineGetBlockSize() {
        Log.log("T: enter...");
        return this.blockSize;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        Log.log("T: enter...");
        return null;
    }

    @Override
    protected byte[] engineGetIV() {
        Log.log("T: enter...");
        return this.iv_init;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        Log.log("T: enter...");
        int n2 = 0;
        switch (this.algo) {
            case 20: 
            case 21: {
                n2 = n + this.buff.getSize();
                if (this.mech_mode != 0x2000000) break;
                if (this.mech_chain == 0x800000 || this.mech_chain == 0x600000) {
                    n2 += this.blockSize;
                    break;
                }
                if (this.mech_pad == 0) break;
                n2 += this.blockSize - n2 % this.blockSize;
                break;
            }
        }
        return n2;
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Log.log("T: enter...");
        this.buff = new ByteFifo();
        this.iv = null;
        this.iv_init = null;
        this.mech_param = null;
        this.aad = null;
        this.isFirstUpdate = true;
        this.tag = null;
        this.rng = secureRandom;
        this.kek_algo = key.getAlgorithm();
        switch (n) {
            case 1: 
            case 3: {
                this.mech_mode = 0x2000000;
                break;
            }
            case 2: 
            case 4: {
                this.mech_mode = 0x3000000;
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid opmode: " + n);
            }
        }
        switch (this.algo) {
            case 20: 
            case 21: {
                Object object;
                if (!key.getAlgorithm().startsWith("DES") && !key.getAlgorithm().equals("AES")) {
                    throw new InvalidKeyException("Invalid key algorithm: " + key.getAlgorithm());
                }
                if (key instanceof CryptoServerSecretKey) {
                    object = (CryptoServerSecretKey)key;
                    this.key = ((CryptoServerSecretKey)object).key;
                } else if (key instanceof SecretKeySpec) {
                    object = (SecretKeySpec)key;
                    byte[] byArray = ((SecretKeySpec)object).getEncoded();
                    CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
                    keyAttributes.setExport(this.provider.export);
                    keyAttributes.setUsage(this.provider.usage);
                    if (this.algo == 20) {
                        keyAttributes.setAlgo(1);
                        keyAttributes.setSize(byArray.length * 7);
                    } else {
                        keyAttributes.setAlgo(2);
                        keyAttributes.setSize(byArray.length * 8);
                    }
                    try {
                        this.key = this.provider.cs.importClearKey(3, 65536, keyAttributes, new CryptoServerCXI.KeyComponents(byArray));
                    }
                    catch (Exception exception) {
                        InvalidKeyException invalidKeyException = new InvalidKeyException(exception.toString());
                        invalidKeyException.initCause(exception);
                        throw invalidKeyException;
                    }
                } else {
                    throw new InvalidKeyException("Invalid key class: " + key.toString());
                }
                if (algorithmParameterSpec == null) break;
                if (algorithmParameterSpec instanceof IvParameterSpec) {
                    object = (IvParameterSpec)algorithmParameterSpec;
                    this.iv_init = ((IvParameterSpec)object).getIV();
                    if (this.iv_init.length != this.blockSize) {
                        throw new InvalidAlgorithmParameterException("Invalid IV length");
                    }
                    this.iv = new CryptoServerCXI.ByteArray(this.iv_init);
                    break;
                }
                if (algorithmParameterSpec instanceof CryptoServerGCMParameterSpec) {
                    object = (CryptoServerGCMParameterSpec)algorithmParameterSpec;
                    this.iv_init = ((CryptoServerGCMParameterSpec)object).getIV();
                    this.aad = ((CryptoServerGCMParameterSpec)object).getAad();
                    this.tagLen = ((CryptoServerGCMParameterSpec)object).getTLen() / 8;
                    this.mech_param = this.createGCMMechanism(0);
                    this.iv = new CryptoServerCXI.ByteArray();
                    this.tag = new CryptoServerCXI.ByteArray();
                    break;
                }
                if (algorithmParameterSpec instanceof CryptoServerCCMParameterSpec) {
                    object = (CryptoServerCCMParameterSpec)algorithmParameterSpec;
                    this.iv_init = ((CryptoServerCCMParameterSpec)object).getNonce();
                    this.aad = ((CryptoServerCCMParameterSpec)object).getAad();
                    this.tagLen = ((CryptoServerCCMParameterSpec)object).getMacLen();
                    this.dataLen = ((CryptoServerCCMParameterSpec)object).getDataLen();
                    this.mech_param = this.createGCMMechanism(0);
                    this.iv = new CryptoServerCXI.ByteArray();
                    this.tag = new CryptoServerCXI.ByteArray();
                    break;
                }
                throw new InvalidAlgorithmParameterException("Invalid mechanism parameter: " + algorithmParameterSpec.toString());
            }
            case 1: {
                if (key instanceof CryptoServerPrivateKey) {
                    CryptoServerPrivateKey cryptoServerPrivateKey = (CryptoServerPrivateKey)key;
                    this.key = cryptoServerPrivateKey.key;
                } else if (key instanceof CryptoServerPublicKey) {
                    CryptoServerPublicKey cryptoServerPublicKey = (CryptoServerPublicKey)key;
                    this.key = cryptoServerPublicKey.key;
                } else {
                    throw new InvalidKeyException("Invalid key class: " + key.toString());
                }
                if (algorithmParameterSpec != null) {
                    if (algorithmParameterSpec instanceof OAEPParameterSpec) {
                        this.mech_param = this.createOAEPMechanism((OAEPParameterSpec)algorithmParameterSpec);
                        break;
                    }
                    throw new InvalidAlgorithmParameterException("Invalid AlgorithmParameterSpec: " + algorithmParameterSpec.toString());
                }
                if (this.mech_pad != 20480) break;
                this.mech_param = this.createOAEPMechanism(OAEPParameterSpec.DEFAULT);
                break;
            }
            default: {
                throw new InvalidKeyException();
            }
        }
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Log.log("T: enter...");
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException();
        }
        this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        Log.log("T: enter...");
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Log.log("E: " + invalidAlgorithmParameterException.getMessage());
            invalidAlgorithmParameterException.printStackTrace();
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        Log.log("T: enter...");
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (n2 == 0) {
            return null;
        }
        this.buff.put(byArray, n, n2);
        int n3 = this.buff.getSize();
        switch (this.algo) {
            case 20: 
            case 21: {
                int n4 = n3 % this.blockSize;
                int n5 = n3 - n4;
                if (n5 > 0 && this.mech_mode == 0x3000000 && (this.mech_chain == 0x800000 || this.mech_chain == 0x600000 || (this.mech_pad != 0 || this.isISO10126PAD) && n4 == 0)) {
                    n4 += this.blockSize;
                    n5 -= this.blockSize;
                }
                if (n5 == 0) {
                    return null;
                }
                byArray2 = this.buff.get(n5);
                byArray3 = this.cryptUpdate(byArray2);
            }
        }
        this.isFirstUpdate = false;
        return byArray3;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        Log.log("T: enter...");
        byte[] byArray3 = this.engineUpdate(byArray, n, n2);
        if (byArray3 == null) {
            return 0;
        }
        if (byArray3.length > byArray2.length - n3) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        Log.log("T: enter...");
        byte[] byArray2 = null;
        int n3 = 0;
        int n4 = 0;
        if (n2 > 0) {
            this.buff.put(byArray, n, n2);
        }
        n3 = this.buff.getSize();
        switch (this.algo) {
            case 20: 
            case 21: {
                n4 = n3 % this.blockSize;
                if (n4 == 0) break;
                n4 = this.blockSize - n4;
            }
        }
        if (n3 == 0 && this.mech_chain != 0x600000 && this.mech_chain != 0x800000 && this.mech_pad == 0 && !this.isISO10126PAD) {
            return null;
        }
        if (this.mech_mode == 0x3000000 && this.mech_chain != 0x600000 && this.mech_chain != 0x800000 && this.mech_chain != 0x700000 && n4 != 0) {
            throw new IllegalBlockSizeException();
        }
        if (this.mech_mode == 0x2000000 && this.isISO10126PAD) {
            if (n4 == 0) {
                n4 = this.blockSize;
            }
            this.buff.expand(n4);
            if (n4 > 1) {
                try {
                    byte[] byArray3 = new byte[n4 - 1];
                    if (this.rng == null) {
                        this.rng = SecureRandom.getInstance("SHA1PRNG", CryptoServerProvider.PROVIDER_RNG);
                    }
                    this.rng.nextBytes(byArray3);
                    this.buff.put(byArray3);
                }
                catch (Exception exception) {
                    BadPaddingException badPaddingException = new BadPaddingException("No SecureRandom" + exception.toString());
                    badPaddingException.initCause(exception);
                    throw badPaddingException;
                }
            }
            this.buff.fill((byte)n4, 1);
            n3 = this.buff.getSize();
        }
        byte[] byArray4 = this.buff.get(n3);
        byArray2 = this.cryptFinal(byArray4);
        if (this.mech_mode == 0x3000000 && this.isISO10126PAD) {
            byte by = byArray2[byArray2.length - 1];
            if (by <= 0 || by > this.blockSize) {
                throw new BadPaddingException();
            }
            byArray4 = new byte[byArray2.length - by];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray4.length);
            byArray2 = byArray4;
        }
        return byArray2;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        Log.log("T: enter...");
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        if (byArray3 == null) {
            return 0;
        }
        if (byArray3.length > byArray2.length - n3) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    protected byte[] setFipsUsageWrap(CryptoServerCXI.Key key, int n) throws IOException, CryptoServerException {
        try {
            return this.provider.cs.exportKey(key, n, this.key);
        }
        catch (CryptoServerException cryptoServerException) {
            if (cryptoServerException.ErrorCode == -1335361264) {
                CryptoServerKey cryptoServerKey = this.provider.setFipsUsage(new CryptoServerKey(this.provider, this.kek_algo, this.key), CryptoServerProvider.FipsUsage.USAGE_OTHER, 0);
                this.key = cryptoServerKey.key;
                return this.provider.cs.exportKey(key, n, this.key);
            }
            throw cryptoServerException;
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray;
        int n;
        CryptoServerCXI.Key key2;
        CryptoServerKey cryptoServerKey;
        Log.log("T: enter...");
        if (key instanceof CryptoServerSecretKey) {
            cryptoServerKey = (CryptoServerSecretKey)key;
            key2 = cryptoServerKey.key;
            n = 8;
        } else if (key instanceof CryptoServerPrivateKey) {
            cryptoServerKey = (CryptoServerPrivateKey)key;
            key2 = ((CryptoServerPrivateKey)cryptoServerKey).key;
            n = 3;
        } else if (key instanceof CryptoServerPublicKey) {
            cryptoServerKey = (CryptoServerPublicKey)key;
            key2 = ((CryptoServerPublicKey)cryptoServerKey).key;
            n = 1;
        } else {
            throw new InvalidKeyException("Invalid key class: " + key.toString());
        }
        try {
            byArray = this.setFipsUsageWrap(key2, n);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            InvalidKeyException invalidKeyException = new InvalidKeyException(exception.toString());
            invalidKeyException.initCause(exception);
            throw invalidKeyException;
        }
        return byArray;
    }

    protected CryptoServerCXI.Key setFipsUsageUnwrap(int n, int n2, CryptoServerCXI.KeyAttributes keyAttributes, byte[] byArray) throws IOException, CryptoServerException {
        try {
            return this.provider.cs.importKey(n, n2, keyAttributes, byArray, this.key);
        }
        catch (CryptoServerException cryptoServerException) {
            if (cryptoServerException.ErrorCode == -1335361264) {
                CryptoServerKey cryptoServerKey = this.provider.setFipsUsage(new CryptoServerKey(this.provider, this.kek_algo, this.key), CryptoServerProvider.FipsUsage.USAGE_OTHER, 0);
                return this.provider.cs.importKey(n, n2, keyAttributes, byArray, cryptoServerKey.key);
            }
            throw cryptoServerException;
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        CryptoServerCXI.Key key;
        Log.log("T: enter...");
        try {
            CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
            keyAttributes.setExport(this.provider.export);
            keyAttributes.setUsage(this.provider.usage);
            key = this.setFipsUsageUnwrap(3, 65536, keyAttributes, byArray);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            InvalidKeyException invalidKeyException = new InvalidKeyException(exception.toString());
            invalidKeyException.initCause(exception);
            throw invalidKeyException;
        }
        switch (n) {
            case 3: {
                return new CryptoServerSecretKey(this.provider, string, key);
            }
            case 2: {
                return new CryptoServerPrivateKey(this.provider, string, key);
            }
            case 1: {
                return new CryptoServerPublicKey(this.provider, string, key);
            }
        }
        throw new InvalidKeyException("Invalid key type: " + n);
    }

    protected void engineUpdateAAD(byte[] byArray) {
        Log.log("T: enter...");
        this.aad = byArray;
    }

    @Override
    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        Log.log("T: enter...");
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.engineUpdateAAD(byArray2);
    }

    protected void updateAAD(ByteBuffer byteBuffer) {
        Log.log("T: enter...");
        this.engineUpdateAAD(byteBuffer != null ? byteBuffer.array() : null);
    }

    private CryptoServerCXI.MechanismParameter createOAEPMechanism(OAEPParameterSpec oAEPParameterSpec) throws InvalidAlgorithmParameterException {
        String string = oAEPParameterSpec.getDigestAlgorithm();
        int n = 0;
        int n2 = 0;
        CryptoServerCXI.MechanismParameter mechanismParameter = new CryptoServerCXI.MechanismParameter();
        try {
            n = CryptoServerCipher.selectHashAlgoCXI(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidAlgorithmParameterException("Unsupported digest algorithm: " + string);
        }
        AlgorithmParameterSpec algorithmParameterSpec = oAEPParameterSpec.getMGFParameters();
        if (!oAEPParameterSpec.getMGFAlgorithm().equals("MGF1") || !(algorithmParameterSpec instanceof MGF1ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid MGF algorithm");
        }
        MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)algorithmParameterSpec;
        String string2 = mGF1ParameterSpec.getDigestAlgorithm();
        try {
            n2 = CryptoServerCipher.selectHashAlgoCXI(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidAlgorithmParameterException("unsupported mgf1 digest algorithm: " + string2);
        }
        PSource pSource = oAEPParameterSpec.getPSource();
        byte[] byArray = ((PSource.PSpecified)pSource).getValue();
        mechanismParameter.setOAEP(n, n2, byArray);
        return mechanismParameter;
    }

    private CryptoServerCXI.MechanismParameter createGCMMechanism(int n) {
        CryptoServerCXI.MechanismParameter mechanismParameter = new CryptoServerCXI.MechanismParameter();
        if (this.isFirstUpdate) {
            mechanismParameter.setGCM(this.iv_init, this.aad, this.tagLen * 8);
        } else if (n == 512) {
            mechanismParameter.setGCM(null, null, this.tagLen * 8);
        } else {
            mechanismParameter.setGCM(null, null, 0);
        }
        return mechanismParameter;
    }

    private CryptoServerCXI.MechanismParameter createCCMMechanism(int n) {
        CryptoServerCXI.MechanismParameter mechanismParameter = new CryptoServerCXI.MechanismParameter();
        if (this.isFirstUpdate) {
            mechanismParameter.setCCM(this.iv_init, this.aad, this.dataLen, this.tagLen);
        } else if (n == 512) {
            mechanismParameter.setCCM(null, null, 0, this.tagLen);
        } else {
            mechanismParameter.setCCM(null, null, 0, 0);
        }
        return mechanismParameter;
    }

    private byte[] cryptUpdate(byte[] byArray) {
        byte[] byArray2 = null;
        switch (this.mech_chain) {
            case 0x600000: {
                this.mech_param = this.createGCMMechanism(0);
                break;
            }
            case 0x800000: {
                this.mech_param = this.createCCMMechanism(0);
            }
        }
        try {
            byArray2 = this.provider.cs.crypt(this.isFirstUpdate ? 256 : 0, this.key, this.mech_mode | this.mech_chain, this.mech_param != null ? this.mech_param.getEncoded() : null, byArray, this.iv, this.tag, null);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
        return byArray2;
    }

    private byte[] cryptFinal(byte[] byArray) throws BadPaddingException, IllegalBlockSizeException {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (this.mech_mode == 0x3000000 && (this.mech_chain == 0x800000 || this.mech_chain == 0x600000)) {
            byArray3 = new byte[this.tagLen];
            byArray4 = new byte[byArray.length - this.tagLen];
            System.arraycopy(byArray, byArray.length - this.tagLen, byArray3, 0, this.tagLen);
            System.arraycopy(byArray, 0, byArray4, 0, byArray.length - this.tagLen);
        } else {
            byArray4 = byArray;
        }
        switch (this.mech_chain) {
            case 0x600000: {
                this.mech_param = this.createGCMMechanism(512);
                break;
            }
            case 0x800000: {
                this.mech_param = this.createCCMMechanism(512);
            }
        }
        try {
            byArray2 = this.provider.cs.crypt(0x200 | (this.isFirstUpdate ? 256 : 0), this.key, this.mech_mode | this.mech_chain | this.mech_pad, this.mech_param != null ? this.mech_param.getEncoded() : null, byArray4, this.iv, this.tag, byArray3);
        }
        catch (CryptoServerException cryptoServerException) {
            Log.log("E: " + cryptoServerException.getMessage());
            switch (cryptoServerException.ErrorCode) {
                case -1335361488: {
                    BadPaddingException badPaddingException = new BadPaddingException(cryptoServerException.toString());
                    badPaddingException.initCause(cryptoServerException);
                    throw badPaddingException;
                }
                case -1333067762: {
                    Log.log("E: GCM tag mismatch.");
                    throw new AEADBadTagException("GCM tag mismatch");
                }
            }
            IllegalBlockSizeException illegalBlockSizeException = new IllegalBlockSizeException(cryptoServerException.toString());
            illegalBlockSizeException.initCause(cryptoServerException);
            throw illegalBlockSizeException;
        }
        catch (IOException iOException) {
            Log.log("E: " + iOException.getMessage());
            IllegalBlockSizeException illegalBlockSizeException = new IllegalBlockSizeException(iOException.toString());
            illegalBlockSizeException.initCause(iOException);
            throw illegalBlockSizeException;
        }
        if (this.mech_mode == 0x2000000 && (this.mech_chain == 0x800000 || this.mech_chain == 0x600000)) {
            byte[] byArray5 = Arrays.copyOf(byArray2, byArray2.length + this.tagLen);
            System.arraycopy(this.tag.getBytes(), 0, byArray5, byArray2.length, this.tagLen);
            byArray2 = byArray5;
        }
        this.iv = null;
        this.tag = null;
        return byArray2;
    }

    private static int selectHashAlgoCXI(String string) throws NoSuchAlgorithmException {
        switch (string) {
            case "MD5": {
                return 80;
            }
            case "RMD-160": {
                return 32;
            }
            case "SHA-1": {
                return 16;
            }
            case "SHA-224": {
                return 48;
            }
            case "SHA3-224": {
                return 128;
            }
            case "SHA-256": {
                return 64;
            }
            case "SHA3-256": {
                return 144;
            }
            case "SHA-384": {
                return 96;
            }
            case "SHA3-384": {
                return 160;
            }
            case "SHA-512": {
                return 112;
            }
            case "SHA3-512": {
                return 176;
            }
        }
        throw new NoSuchAlgorithmException();
    }
}

